/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.inte.api.EnabledLang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class CommonVariableValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"delete")) {
            this.checkDelete(dataEntityArr);
        } else if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.checkSave(dataEntityArr);
        }
    }

    private void checkSave(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            String formNumber = this.getOption().getVariableValue("saveParam", "");
            HashMap langMap = Maps.newHashMapWithExpectedSize((int)16);
            List enabledLangs = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : enabledLangs) {
                langMap.put(enabledLang.getNumber(), enabledLang.getName());
            }
            DynamicObject dy = extendedDataEntity.getDataEntity();
            ILocaleString name = dy.getLocaleString("name");
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_commonvariable");
            ArrayList result = Lists.newArrayListWithCapacity((int)16);
            for (Map.Entry entry : name.entrySet()) {
                DynamicObject[] query;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if ("GLang".equals(key)) continue;
                for (DynamicObject dynamicObject : query = serviceHelper.query(new QFilter[]{new QFilter("mainentity", "=", (Object)formNumber), new QFilter("id", "not in", dy.getPkValue())})) {
                    ILocaleString nameLocale = dynamicObject.getLocaleString("name");
                    for (Map.Entry entryLocale : nameLocale.entrySet()) {
                        String localeKey = (String)entryLocale.getKey();
                        String localeValue = (String)entryLocale.getValue();
                        if ("GLang".equals(localeKey) || !value.equals(localeValue) || !key.equals(localeKey)) continue;
                        HashMap objectObjectHashMap = Maps.newHashMapWithExpectedSize((int)16);
                        objectObjectHashMap.put("lang", key);
                        objectObjectHashMap.put("value", value);
                        result.add(objectObjectHashMap);
                    }
                }
            }
            String preText = ResManager.loadKDString((String)"\u201c\u53d8\u91cf\u540d\u79f0\u201d \u503c ", (String)"CommonVariablePlugin_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            ArrayList valueStrs = Lists.newArrayListWithCapacity((int)16);
            if (result.size() == 0) {
                return;
            }
            for (HashMap stringStringHashMap : result) {
                String lang = (String)stringStringHashMap.get("lang");
                String value = (String)stringStringHashMap.get("value");
                String langName = (String)langMap.get(lang);
                valueStrs.add(langName + " " + value);
            }
            String join = String.join((CharSequence)"\uff0c", valueStrs);
            String suffixText = ResManager.loadKDString((String)"\u201d \u5df2\u5b58\u5728\uff0c\u8bf7\u8f93\u5165\u5176\u4ed6\u503c\u3002", (String)"CommonVariablePlugin_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]);
            String tips = preText + join + suffixText;
            this.addErrorMessage(extendedDataEntity, tips);
        }
    }

    private void checkDelete(ExtendedDataEntity[] dataEntityArr) {
        String formNumber = this.getOption().getVariableValue("deleteParam", "");
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(formNumber);
        HRBaseServiceHelper keyMappingHelp = new HRBaseServiceHelper("hrcs_keywordmapping");
        DynamicObject[] query = keyMappingHelp.query("contempid,entryentity,entryentity.wordfield,entryentity.relateentityid,entryentity.variableid", new QFilter[0]);
        ArrayList resultList = Lists.newArrayListWithCapacity((int)16);
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            DynamicObject dy = extendedDataEntity.getDataEntity();
            Long pkValue = (Long)dy.getPkValue();
            String name = dy.getLocaleString("name").getLocaleValue();
            if (HRStringUtils.isEmpty((String)name)) {
                name = dy.getString("name");
            }
            HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
            HashSet contempIdSet = Sets.newHashSetWithExpectedSize((int)16);
            block1: for (DynamicObject dynamicObject : query) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                long contempId = dynamicObject.getLong("contempid");
                for (DynamicObject object : dynamicObjectCollection) {
                    long variableId;
                    DynamicObject variableid = object.getDynamicObject("variableid");
                    if (variableid == null || (variableId = ((Long)object.getDynamicObject("variableid").getPkValue()).longValue()) != pkValue) continue;
                    contempIdSet.add(contempId);
                    continue block1;
                }
            }
            if (CollectionUtils.isEmpty((Collection)contempIdSet)) continue;
            resultMap.put(name, contempIdSet);
            resultList.add(resultMap);
            DynamicObject[] contempSet = serviceHelper.query("vid", new QFilter[]{new QFilter("vid", "in", (Object)contempIdSet)});
            ArrayList tempNameList = Lists.newArrayListWithCapacity((int)16);
            for (DynamicObject dynamicObject : contempSet) {
                String tempName = dynamicObject.getLocaleString("name").getLocaleValue();
                tempNameList.add("\u201d" + tempName + "\u201d");
            }
            if (CollectionUtils.isEmpty((Collection)resultList)) continue;
            String join = String.join((CharSequence)"\u3001", tempNameList);
            this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\uff1a\u5220\u9664\u5931\u8d25\uff0c\u5df2\u88ab\u5408\u540c\u6a21\u677f%2$s\u8bbe\u7f6e\u4e86\u53d6\u503c\u5173\u7cfb\u3002", (String)"TplVariableConfigValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), name, join));
        }
    }
}

