/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class DimensionSaveValidator
extends HRDataBaseValidator {
    private static final String ENUM = "enum";
    private static final String ENTRY = "entry";

    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(dataEntityArr);
        }
    }

    private void canSave(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity dataEntity : dataEntityArr) {
            String showType = (String)dataEntity.getValue("showtype");
            if (!Objects.nonNull(showType) || !HRStringUtils.equals((String)ENUM, (String)showType)) continue;
            DynamicObjectCollection coll = (DynamicObjectCollection)dataEntity.getValue(ENTRY);
            if (CollectionUtils.isEmpty((Collection)coll)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7ef4\u5ea6\u679a\u4e3e\u503c\u3002", (String)"DimensionSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                continue;
            }
            int rowNum = 1;
            for (DynamicObject enumRow : coll) {
                Object value = enumRow.get("value");
                String displayvalue = ((OrmLocaleValue)enumRow.get("displayvalue")).getLocaleValue();
                Object entryindex = enumRow.get("entryindex");
                if (HRStringUtils.isEmpty((String)value.toString())) {
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u503c\u4e0d\u80fd\u4e3a\u7a7a ", (String)"DimensionSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), rowNum));
                }
                if (HRStringUtils.isEmpty((String)displayvalue)) {
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u7ef4\u5ea6\u663e\u793a\u503c\u4e0d\u80fd\u4e3a\u7a7a ", (String)"DimensionSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), rowNum));
                }
                if (Objects.isNull(entryindex)) {
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a ", (String)"DimensionSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), rowNum));
                }
                ++rowNum;
            }
        }
    }
}

