/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class EntityMappingSaveValidator
extends HRDataBaseValidator {
    private static String ENTRYENTITY = "entryentity";
    private static String ENTITY_MAPPING_CONFIG = "entitymappingconfig";
    private static String MAIN_ENTITY = "parententity";
    private static String ENTITY = "entity";
    private static String ENTITYNAME = "entityname";
    private static String ENTITY_FIELD = "parententityfield";
    private static String MAPPING_ENTITY_FIELD = "entityfield";
    private static String SUBENTRYENTITY = "subentryentity";

    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.checkData(dataEntityArr);
        }
    }

    private void checkData(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity extendedDataEntity : dataEntityArr) {
            String saveParam = this.getOption().getVariableValue("saveParam", "");
            Long contempid = 0L;
            String formNumber = "";
            String formName = "";
            Map param = (Map)SerializationUtils.fromJsonString((String)saveParam, Map.class);
            for (Map.Entry entry : param.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if ("contempid".equals(key)) {
                    contempid = (Long)value;
                    continue;
                }
                formNumber = key;
                formName = (String)value;
            }
            DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)extendedDataEntity.getValue(ENTITY_MAPPING_CONFIG);
            ArrayList rightEntity = Lists.newArrayListWithCapacity((int)16);
            ArrayList leftEntity = Lists.newArrayListWithCapacity((int)16);
            for (DynamicObject dynamicObject : dynamicObjects) {
                DynamicObjectCollection dynamicObjectCollection;
                if (dynamicObject.getDynamicObject(ENTITY) == null && dynamicObject.getDynamicObject(MAIN_ENTITY) == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u4f53\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u3002", (String)"EntityMappingSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dynamicObject.getLong("seq")));
                    this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u4f53\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u3002", (String)"EntityMappingSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dynamicObject.getLong("seq")));
                } else if (dynamicObject.getDynamicObject(ENTITY) == null || dynamicObject.getDynamicObject(MAIN_ENTITY) == null) {
                    this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u4f53\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u201d\u7b2c%s\u884c\u3002", (String)"EntityMappingSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dynamicObject.getLong("seq")));
                } else {
                    leftEntity.add(dynamicObject.getDynamicObject(MAIN_ENTITY).getString("number"));
                    rightEntity.add(dynamicObject.getDynamicObject(ENTITY).getString("number"));
                    dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
                    if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                        String relaName = dynamicObject.getDynamicObject(ENTITY).getString("name");
                        String name = dynamicObject.getDynamicObject(MAIN_ENTITY).getString("name");
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u672a\u8bbe\u7f6e\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u3002", (String)"CorrelationEntityPlugin_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), name, relaName));
                    }
                }
                dynamicObjectCollection = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
                for (DynamicObject object : dynamicObjectCollection) {
                    if (HRStringUtils.isEmpty((String)((String)object.get(ENTITY_FIELD)))) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b9e\u4f53\u5b57\u6bb5\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u201d\u7b2c%1$s\u884c\uff0c\u201c\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u8bbe\u7f6e\u201d\u7b2c%2$s\u884c\u3002", (String)"EntityMappingSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dynamicObject.get("seq"), object.get("seq")));
                    }
                    if (!HRStringUtils.isEmpty((String)((String)object.get(MAPPING_ENTITY_FIELD)))) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5173\u8054\u5b9e\u4f53\u5b57\u6bb5\u201d\uff1a\u201c\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u201d\u7b2c%1$s\u884c\uff0c\u201c\u5b9e\u4f53\u5173\u8054\u6761\u4ef6\u8bbe\u7f6e\u201d\u7b2c%2$s\u884c\u3002", (String)"EntityMappingSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dynamicObject.get("seq"), object.get("seq")));
                }
            }
            DynamicObjectCollection relationEntitys = (DynamicObjectCollection)extendedDataEntity.getValue(ENTRYENTITY);
            if (CollectionUtils.isEmpty((Collection)relationEntitys)) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u5173\u8054\u5b9e\u4f53\u3002", (String)"CorrelationEntityPlugin_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
            if (!leftEntity.contains(formNumber)) {
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u4e3b\u5b9e\u4f53\u201c%s\u201d\u7684\u5b9e\u4f53\u5173\u7cfb\u3002", (String)"CorrelationEntityPlugin_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), formName));
            }
            if (rightEntity.contains(formNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u4e0d\u5141\u8bb8\u51fa\u73b0\u5728\u53f3\u4fa7\u3002", (String)"CorrelationEntityPlugin_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
            for (DynamicObject relationEntity : relationEntitys) {
                if (rightEntity.contains(relationEntity.getDynamicObject(ENTITYNAME).getString("number")) || leftEntity.contains(relationEntity.getDynamicObject(ENTITYNAME).getString("number"))) continue;
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u8bf7\u914d\u7f6e\u201c%s\u201d\u7684\u5b9e\u4f53\u5173\u7cfb\u3002", (String)"CorrelationEntityPlugin_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), relationEntity.getDynamicObject(ENTITYNAME).getString("name")));
            }
            for (String leftEntityStr : leftEntity) {
                if (rightEntity.contains(leftEntityStr) || leftEntityStr.equals(formNumber)) continue;
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)leftEntityStr);
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u4e3b\u5b9e\u4f53\u201c%1$s\u201d\u4e0e\u201c%2$s\u201d\u7684\u5b9e\u4f53\u5173\u7cfb\u51fa\u73b0\u65ad\u70b9\uff0c\u8bf7\u4fee\u6539\u5b9e\u4f53\u5173\u8054\u8bbe\u7f6e\u3002", (String)"CorrelationEntityPlugin_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), formName, mainEntityType.getDisplayName().getLocaleValue()));
            }
        }
    }
}

