/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class HRDataRuleSaveValidator
extends HRDataBaseValidator {
    private String fieldRule = "rule";

    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(dataEntityArr);
        }
    }

    private void canSave(ExtendedDataEntity[] dataEntityArr) {
        for (ExtendedDataEntity dataEntity : dataEntityArr) {
            DynamicObject dataRuleDyo = dataEntity.getDataEntity();
            boolean dataRuleCheckRst = this.checkDataRule(dataRuleDyo.getString(this.fieldRule));
            if (dataRuleCheckRst) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"HRDataRuleSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkDataRule(String ruleStr) {
        boolean checkRst = true;
        if (HRStringUtils.isEmpty((String)ruleStr)) {
            checkRst = false;
        }
        try {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleStr, FilterCondition.class);
            List filterRow = filterCondition.getFilterRow();
            if (Objects.isNull(filterCondition) || CollectionUtils.isEmpty((Collection)filterRow)) {
                checkRst = false;
            }
        }
        catch (RuntimeException exception) {
            checkRst = false;
        }
        return checkRst;
    }
}

