/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import org.apache.commons.lang3.StringUtils;

public class MsgPublishSaveValidator
extends HRDataBaseValidator {
    private static final Pattern CHINESE_WORD_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static final String PUB_STATUS = "pubstatus";

    public void validate() {
        String operationKey;
        ExtendedDataEntity[] data = this.getDataEntities();
        switch (operationKey = this.getOperateKey()) {
            case "stoppub": {
                this.validatePubStatus(data);
                break;
            }
            case "delete": {
                this.validateDeleteStatus(data);
                break;
            }
            case "save": {
                DynamicObject dy = data[0].getDataEntity();
                String number = dy.getString("number");
                if (this.regexNumberContainChan(number)) {
                    this.addFatalErrorMessage(data[0], ResManager.loadKDString((String)"\u53d1\u5e03\u7f16\u7801\u53ea\u80fd\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u6216\u7279\u6b8a\u5b57\u7b26\u3002", (String)"MsgPublishSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
                this.checkPubErNotNull(data[0]);
                break;
            }
            case "pubmsg": {
                this.validatePubOp(data);
                break;
            }
        }
    }

    private void validatePubOp(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity extendedDataEntity : datas) {
            DynamicObject dy = extendedDataEntity.getDataEntity();
            if (!StringUtils.equals((CharSequence)dy.getString(PUB_STATUS), (CharSequence)"P")) continue;
            this.addFatalErrorMessage(extendedDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u6d88\u606f\u201c%1$s\u201d\u5df2\u53d1\u5e03\u3002", (String)"MsgPublishSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dy.getString("name")));
        }
    }

    private boolean regexNumberContainChan(String str) {
        Matcher isNum = CHINESE_WORD_PATTERN.matcher(str);
        return isNum.find();
    }

    private void validatePubStatus(ExtendedDataEntity[] data) {
        for (ExtendedDataEntity dataEntity : data) {
            DynamicObject dy = dataEntity.getDataEntity();
            if ("N".equals(dy.getString(PUB_STATUS))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u505c\u7528\u5df2\u53d1\u5e03\u7684\u6570\u636e\u3002", (String)"MsgPublishSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"S".equals(dy.getString(PUB_STATUS))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u5df2\u505c\u7528\uff0c\u65e0\u9700\u518d\u6b21\u542f\u7528\u3002", (String)"MsgPublishSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateDeleteStatus(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject dy = dataEntity.getDataEntity();
            if ("N".equals(dy.getString(PUB_STATUS))) continue;
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4ec5\u5141\u8bb8\u5220\u9664\u5f85\u53d1\u5e03\u7684\u6570\u636e\u3002", (String)"MsgPublishSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkPubErNotNull(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        if (!"N".equals(dy.getString(PUB_STATUS)) && Objects.isNull(dy.get("puber"))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6d88\u606f\u53d1\u5e03\u72b6\u6001\u4e0d\u662f\u5f85\u53d1\u5e03\u65f6\uff0c\u201c\u53d1\u5e03\u4eba\u201d\u5b57\u6bb5\u5fc5\u987b\u586b\u5199\u3002", (String)"MsgPublishSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }
}

