/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class MsgSubSaveValidator
extends AbstractValidator {
    private static final Pattern CHINESE_WORD_PATTERN = Pattern.compile("[\\u4e00-\\u9fa5]");
    private static String SUBSCRIBED_ID = "subscribebd.id";
    private static String MSG_PUBLISHER_ID = "msgpublisher.id";

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        DynamicObject dy = datas[0].getDataEntity();
        String number = dy.getString("number");
        switch (operationKey) {
            case "save": {
                if (this.regexNumberContainChan(number)) {
                    this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u8ba2\u9605\u7f16\u7801\u4ec5\u652f\u6301\u8f93\u5165\u82f1\u6587\u3001\u6570\u5b57\u6216\u7279\u6b8a\u5b57\u7b26\u3002", (String)"MsgSubSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
                this.validatePubMsg(datas);
                this.validateSubMsgReName(datas);
                break;
            }
            case "sub": {
                this.validateSubMsgReName(datas);
                break;
            }
        }
    }

    private void validatePubMsg(ExtendedDataEntity[] datas) {
        DynamicObject dy = datas[0].getDataEntity();
        String subscribeBD = dy.getString(SUBSCRIBED_ID);
        Long id = dy.getLong(MSG_PUBLISHER_ID);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select fbasedataid as \"basedataid\" ").append(" from t_hrcs_subbsifield").append(" where fid = (").append(id).append(')');
        List ids = (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql.toString(), null, (ResultSetHandler)new ResultSetHandler<List<String>>(){

            public List<String> handle(ResultSet rs) throws SQLException {
                ArrayList<String> extendDatalist = new ArrayList<String>(16);
                while (rs.next()) {
                    extendDatalist.add(rs.getString("basedataid"));
                }
                return extendDatalist;
            }
        });
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("id", "=", (Object)dy.getLong("id"));
        DynamicObject[] result = subServiceHelper.query(new QFilter[]{subQfFilter});
        if (result.length == 0) {
            HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
            QFilter pubQfFilter = new QFilter("id", "=", (Object)dy.getLong(MSG_PUBLISHER_ID));
            DynamicObject pubDy = pubServiceHelper.queryOne("pubstatus", new QFilter[]{pubQfFilter});
            if (StringUtils.equals((CharSequence)pubDy.getString("pubstatus"), (CharSequence)"S")) {
                this.addFatalErrorMessage(datas[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u9605\u6d88\u606f\u201c%1$s\u201d\u5df2\u505c\u7528\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u5df2\u53d1\u5e03\u6d88\u606f\u3002", (String)"MsgSubSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dy.getString("msgpublisher.name")));
            }
            if (!CollectionUtils.isEmpty((Collection)ids) && !ids.contains(subscribeBD)) {
                this.addFatalErrorMessage(datas[0], String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u8ba2\u9605\u65b9\u4e1a\u52a1\u7c7b\u578b\u201c%1$s\u201d\u4e0d\u80fd\u8ba2\u9605\u6b64\u6d88\u606f\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u4e1a\u52a1\u7c7b\u578b\u6216\u8054\u7cfb\u53d1\u5e03\u4eba\u6dfb\u52a0\u6b64\u4e1a\u52a1\u7c7b\u578b\u3002", (String)"MsgSubSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), dy.getString("subscribebd.name")));
            }
        }
    }

    private boolean regexNumberContainChan(String str) {
        Matcher isNum = CHINESE_WORD_PATTERN.matcher(str);
        return isNum.find();
    }

    private void validateSubMsgReName(ExtendedDataEntity[] datas) {
        DynamicObject[] list;
        DynamicObject dy = datas[0].getDataEntity();
        for (DynamicObject dynamicObject : list = MsgCenterServiceHelper.getPubInfoByBusinessType((long)dy.getLong(MSG_PUBLISHER_ID), (String)dy.getString("consumercloud.id"), (String)dy.getString("consumerapp.id"), (String)dy.getString("consumerService"), (String)dy.getString("consumerMethod"))) {
            if (dynamicObject.getLong("id") == dy.getLong("id")) continue;
            this.addFatalErrorMessage(datas[0], ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u5df2\u8ba2\u9605\u8fc7\u8be5\u6d88\u606f\uff0c\u5982\u9700\u4fee\u8ba2\u8bf7\u5728\u67e5\u770b\u5df2\u8ba2\u9605\u4e2d\u64cd\u4f5c\u3002", (String)"MsgSubSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

