/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class PermFilesSaveValidator
extends HRDataBaseValidator {
    private static String USER_NAME = "user.name";

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if ("enable".equals(operationKey)) {
            this.canEnable(datas);
        } else if (HRStringUtils.equals((String)operationKey, (String)"disable_new")) {
            this.canDisable(datas);
        } else if (HRStringUtils.equals((String)operationKey, (String)"delete")) {
            this.canDelete(datas);
        } else if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(datas);
        }
    }

    private void canEnable(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject permFile = dataEntity.getDataEntity();
            String enable = permFile.getString("enable");
            if (!HRStringUtils.equals((String)enable, (String)"1")) continue;
            String name = this.getUerNameFromPermFile(permFile.getLong("id"));
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u542f\u7528\u3002", (String)"PermFilesSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
        }
    }

    private void canSave(ExtendedDataEntity[] datas) {
        ExtendedDataEntity[] extendedDataEntityArray = datas;
        int n = extendedDataEntityArray.length;
        for (int i = 0; i < n; ++i) {
            Long permId;
            Long dycId;
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
            ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
            DynamicObject permFile = dataEntity.getDataEntity();
            Long personId = permFile.getLong("user.id");
            QFilter idFilter = new QFilter("user", "=", (Object)personId);
            DynamicObject permFileDyc = serviceHelper.queryOne(new QFilter[]{idFilter});
            if (permFileDyc == null || (dycId = (Long)permFileDyc.getPkValue()).equals(permId = (Long)permFile.getPkValue())) continue;
            String name = permFile.getString(USER_NAME);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\u8be5\u7528\u6237\u5df2\u62e5\u6709\u76f8\u5e94\u7684\u6743\u9650\u6863\u6848\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"PermFilesSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
        }
    }

    private void canDisable(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity dataEntity : datas) {
            String name;
            DynamicObject permFile = dataEntity.getDataEntity();
            String enable = permFile.getString("enable");
            if (HRStringUtils.equals((String)enable, (String)"0")) {
                name = this.getUerNameFromPermFile(permFile.getLong("id"));
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7981\u7528\u3002", (String)"PermFilesSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
                continue;
            }
            if (!HRStringUtils.equals((String)enable, (String)"2")) continue;
            name = this.getUerNameFromPermFile(permFile.getLong("id"));
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5904\u4e8e\u5f85\u542f\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u7981\u7528\u3002", (String)"PermFilesSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
        }
    }

    private void canDelete(ExtendedDataEntity[] datas) {
        ExtendedDataEntity[] extendedDataEntityArray = datas;
        int n = extendedDataEntityArray.length;
        for (int i = 0; i < n; ++i) {
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
            ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
            DynamicObject permFile = dataEntity.getDataEntity();
            DynamicObject permFileDyc = serviceHelper.queryOne("enable", permFile.getPkValue());
            String enable = permFileDyc.getString("enable");
            if (HRStringUtils.equals((String)enable, (String)"2")) continue;
            String name = this.getUerNameFromPermFile(permFile.getLong("id"));
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"%s\uff1a\u53ea\u80fd\u5220\u9664\u5f85\u542f\u7528\u7684\u6570\u636e\u3002", (String)"PermFilesSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{name}));
        }
    }

    private String getUerNameFromPermFile(Long id) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_permfiles");
        DynamicObject permFile = serviceHelper.queryOne(USER_NAME, (Object)id);
        String name = permFile.getString(USER_NAME);
        return name;
    }
}

