/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.servicehelper.prompt.PromptServiceHelper;

@ExcludeFromJacocoGeneratedReport
public class PromptRuleImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] data = this.getDataEntities();
        HRBaseServiceHelper ruleHelper = new HRBaseServiceHelper("hrcs_promptrule");
        Map<String, Map<String, Object>> existFormControlMap = this.assembleValidateControlMap(data, ruleHelper);
        Arrays.stream(data).forEach(ruleDataEntity -> {
            DynamicObject ruleDy = ruleDataEntity.getDataEntity();
            DynamicObject formDy = ruleDy.getDynamicObject("businessobject");
            this.validateControlNumber((ExtendedDataEntity)ruleDataEntity, ruleDy, formDy);
            this.validatePromptInEntity((ExtendedDataEntity)ruleDataEntity, ruleDy, formDy);
            this.validateMultiControl(existFormControlMap, (ExtendedDataEntity)ruleDataEntity, ruleDy);
            this.validateBindRule((ExtendedDataEntity)ruleDataEntity, ruleDy, formDy);
        });
    }

    private void validateBindRule(ExtendedDataEntity ruleDataEntity, DynamicObject ruleDy, DynamicObject formDy) {
        boolean existRule = false;
        DynamicObjectCollection entryDyColl = ruleDy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryDy : entryDyColl) {
            FilterCondition filterCondition;
            String ruleStr = entryDy.getString("entryrule");
            if (!HRStringUtils.isNotEmpty((String)ruleStr) || !(filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)ruleStr, FilterCondition.class)).getFilterRow().isEmpty()) continue;
            existRule = true;
            break;
        }
        boolean isError = false;
        if (existRule) {
            if (Objects.nonNull(formDy)) {
                MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)formDy.getString("number"));
                isError = HRStringUtils.isEmpty((String)entityType.getAlias());
            } else {
                isError = true;
            }
        }
        if (isError) {
            this.addErrorMessage(ruleDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u4e0d\u652f\u6301\u8bbe\u7f6e\u89c4\u5219\u3002", (String)"PromptRuleImportValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<String, Map<String, Object>> assembleValidateControlMap(ExtendedDataEntity[] data, HRBaseServiceHelper ruleHelper) {
        List formStr = Arrays.stream(data).map(dy -> dy.getDataEntity().getDynamicObject("businessobject").getPkValue()).collect(Collectors.toList());
        DynamicObject[] formControlAndIdDy = ruleHelper.queryOriginalArray("businessobject,controlnumber,id", new QFilter[]{new QFilter("businessobject", "in", formStr)});
        HashMap existFormControlMap = Maps.newHashMapWithExpectedSize((int)formControlAndIdDy.length);
        for (DynamicObject existDy : formControlAndIdDy) {
            String existForm = existDy.getString("businessobject");
            Map controlAndId = existFormControlMap.getOrDefault(existForm, Maps.newHashMapWithExpectedSize((int)2));
            controlAndId.put(existDy.getString("controlnumber"), existDy.get("id"));
            existFormControlMap.put(existForm, controlAndId);
        }
        return existFormControlMap;
    }

    private void validateMultiControl(Map<String, Map<String, Object>> formAndControlAndId, ExtendedDataEntity ruleDataEntity, DynamicObject ruleDy) {
        Map<String, Object> existControlAndId = formAndControlAndId.get(ruleDy.getString("businessobject.id"));
        if (CollectionUtils.isEmpty(existControlAndId)) {
            HashMap existFormControl = Maps.newHashMapWithExpectedSize((int)16);
            existFormControl.put(ruleDy.getString("controlnumber"), ruleDy.getPkValue());
            formAndControlAndId.put(ruleDy.getString("businessobject.id"), existFormControl);
            return;
        }
        if (existControlAndId.containsKey(ruleDy.getString("controlnumber"))) {
            if (!ruleDy.getPkValue().equals(existControlAndId.get(ruleDy.getString("controlnumber")))) {
                this.addErrorMessage(ruleDataEntity, ResManager.loadKDString((String)"\u5173\u8054\u63a7\u4ef6\u5b58\u5728\u591a\u6761\u8bb0\u5f55\uff0c\u91cd\u590d\u6570\u636e\u3002", (String)"PromptRuleImportValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            }
        } else {
            existControlAndId.put(ruleDy.getString("controlnumber"), ruleDy.getPkValue());
        }
    }

    private void validatePromptInEntity(ExtendedDataEntity ruleDataEntity, DynamicObject ruleDy, DynamicObject formDy) {
        DynamicObject[] promptDys;
        DynamicObjectCollection ruleEntry = ruleDy.getDynamicObjectCollection("entryentity");
        HRBaseServiceHelper promptHelper = new HRBaseServiceHelper("hrcs_prompt");
        for (DynamicObject promptDy : promptDys = promptHelper.query("name,cloud,app,businessobject,categorizeid,enable,app.masterid", new QFilter[]{new QFilter("id", "in", ruleEntry.stream().map(entry -> entry.getDynamicObject("entryprompt").getPkValue()).collect(Collectors.toList()))})) {
            if (HRStringUtils.equals((String)"0", (String)promptDy.getString("enable"))) {
                this.addErrorMessage(ruleDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u63d0\u793a\u8bed\u672a\u542f\u7528", (String)"PromptRuleImportValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), promptDy.getLocaleString("name").getLocaleValue()));
            }
            if (this.judgeContainPrompt(formDy, promptDy)) continue;
            this.addErrorMessage(ruleDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%s \u63d0\u793a\u8bed\u4e0d\u80fd\u5173\u8054\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61", (String)"PromptRuleImportValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), promptDy.getLocaleString("name").getLocaleValue()));
        }
    }

    private void validateControlNumber(ExtendedDataEntity ruleDataEntity, DynamicObject ruleDy, DynamicObject formDy) {
        String extEntityId;
        MetadataReader reader;
        FormMetadata formMeta;
        String controlNumber = ruleDy.getString("controlnumber");
        if (HRStringUtils.isNotEmpty((String)controlNumber) && (formMeta = (FormMetadata)(reader = new MetadataReader(false)).readMeta(extEntityId = PromptServiceHelper.getExtEntityId((String)formDy.getString("dentityid")), OrmUtils.getDataEntityType(DesignFormMeta.class))).getItems().stream().noneMatch(item -> HRStringUtils.equals((String)item.getKey(), (String)controlNumber))) {
            this.addErrorMessage(ruleDataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s \u4e1a\u52a1\u5bf9\u8c61\u4e2d\u4e0d\u5b58\u5728 %2$s \u63a7\u4ef6", (String)"PromptRuleImportValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), formDy.getLocaleString("name").getLocaleValue(), controlNumber));
        }
    }

    private boolean judgeContainPrompt(DynamicObject entityDy, DynamicObject promptDy) {
        return this.judgeEntity(promptDy, entityDy) && this.judgeApp(promptDy, entityDy) && this.judgeCloud(promptDy, entityDy) || HRStringUtils.isEmpty((String)promptDy.getString("cloud"));
    }

    private boolean judgeCloud(DynamicObject promptDy, DynamicObject entityDy) {
        String cloudId = promptDy.getString("cloud.id");
        DynamicObject bizCloudDy = BizCloudServiceHelp.getBizCloudByFormID((String)entityDy.getString("dentityid"));
        return Objects.isNull(cloudId) || HRStringUtils.equals((String)cloudId, (String)bizCloudDy.getString("id"));
    }

    private boolean judgeApp(DynamicObject promptDy, DynamicObject entityDy) {
        String appId;
        String ruleAppId;
        String appMasterId = promptDy.getString("app.masterid");
        DynamicObject bizAppDy = BizAppServiceHelp.getBizAppByFormID((String)entityDy.getString("dentityid"));
        String string = ruleAppId = StringUtils.isEmpty((CharSequence)bizAppDy.getString("masterid")) ? bizAppDy.getString("id") : bizAppDy.getString("masterid");
        boolean isPass = StringUtils.isEmpty((CharSequence)appMasterId) ? StringUtils.isEmpty((CharSequence)(appId = promptDy.getString("app.id"))) || HRStringUtils.equals((String)appId, (String)ruleAppId) : HRStringUtils.equals((String)appMasterId, (String)ruleAppId);
        return isPass;
    }

    private boolean judgeEntity(DynamicObject promptDy, DynamicObject entityDy) {
        String promptEntityId = promptDy.getString("businessobject.id");
        return Objects.isNull(promptEntityId) || HRStringUtils.equals((String)promptEntityId, (String)entityDy.getString("id"));
    }
}

