/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

@ExcludeFromJacocoGeneratedReport
public class UserPermFilesSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if (datas == null || datas.length == 0) {
            return;
        }
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            this.canSave(datas);
            ExtendedDataEntity data = datas[0];
            if ("isPersonalizeData".equals(data.getDataEntity().getString("importflag"))) {
                Arrays.stream(datas).forEach(da -> {
                    DynamicObject entity = da.getDataEntity();
                    if (HRStringUtils.isEmpty((String)entity.getString("username"))) {
                        entity.set("username", entity.get("user.name"));
                    }
                });
                this.getOption().setVariableValue("isPersonalizeData", "0");
            }
        }
    }

    private void canSave(ExtendedDataEntity[] datas) {
        List<String> importUnique = this.getImportUnique(datas);
        QFilter filter = null;
        Set<Long> forbiddenUsers = this.queryAllForbiddenUser();
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject permFile = dataEntity.getDataEntity();
            String importFlag = permFile.getString("importflag");
            long userId = permFile.getLong("user.id");
            if (importUnique.contains(this.fetchKey(permFile))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u7528\u6237\u548c\u4e1a\u52a1\u5355\u5143\uff0c\u8bf7\u4fee\u6539\u540e\u518d\u5bfc\u5165\u3002", (String)"UserPermFilesSaveValidator_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                continue;
            }
            if (HRStringUtils.equals((String)"isPersonalizeData", (String)importFlag) && forbiddenUsers.contains(userId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7528\u6237\u5904\u4e8e\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u5bfc\u5165\u6570\u636e\u3002", (String)"UserPermFilesSaveValidator_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]));
                continue;
            }
            QFilter qFilter = new QFilter("user", "=", (Object)userId);
            qFilter.and(new QFilter("org", "=", (Object)permFile.getLong("org.id")));
            if (filter == null) {
                filter = qFilter;
                continue;
            }
            filter.or(qFilter);
        }
        if (filter != null) {
            this.validateUnique(datas, filter);
        }
    }

    private Set<Long> queryAllForbiddenUser() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_user");
        return serviceHelper.queryOriginalCollection("id", new QFilter[]{new QFilter("isforbidden", "=", (Object)"1")}).stream().map(it -> it.getLong("id")).collect(Collectors.toSet());
    }

    private void validateUnique(ExtendedDataEntity[] datas, QFilter filter) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_userpermfile");
        DynamicObject[] permFiles = serviceHelper.query("id,permfileenable,user,org", new QFilter[]{filter});
        if (permFiles.length == 0) {
            return;
        }
        Map exists = Arrays.stream(permFiles).collect(Collectors.toMap(this::fetchKey, Function.identity(), (k1, k2) -> k1));
        for (ExtendedDataEntity dataEntity : datas) {
            DynamicObject permFile = dataEntity.getDataEntity();
            DynamicObject permFileDyc = (DynamicObject)exists.get(this.fetchKey(permFile));
            if (permFileDyc == null || permFileDyc.getLong("id") == permFile.getLong("id")) continue;
            this.setMsg(dataEntity, permFileDyc);
        }
    }

    private void setMsg(ExtendedDataEntity dataEntity, DynamicObject permFile) {
        String name = permFile.getString("user.name");
        String org = permFile.getString("org.name");
        String msg = HRStringUtils.equals((String)permFile.getString("permfileenable"), (String)"1") ? String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u5728%2$s\u5df2\u5b58\u5728\u6743\u9650\u6863\u6848\uff0c\u72b6\u6001\u4e3a\u751f\u6548\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u521b\u5efa\u3002", (String)"UserPermFilesSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), name, org) : String.format(Locale.ROOT, ResManager.loadKDString((String)"\u201c%1$s\u201d\u5728\u201c%2$s\u201d\u5df2\u5b58\u5728\u6743\u9650\u6863\u6848\uff0c\u72b6\u6001\u4e3a\u5df2\u5931\u6548\u3002\u8bf7\u5728\u5217\u8868\u4e2d\u627e\u5230\u8be5\u6743\u9650\u6863\u6848\uff0c\u5e76\u70b9\u51fb\u201c\u751f\u6548\u201d\u6309\u94ae\u3002", (String)"UserPermFilesSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), name, org);
        this.addErrorMessage(dataEntity, msg);
    }

    private List<String> getImportUnique(ExtendedDataEntity[] datas) {
        return Arrays.stream(datas).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toMap(this::fetchKey, en -> 1, Integer::sum)).entrySet().stream().filter(en -> (Integer)en.getValue() > 1 && HRStringUtils.isNotEmpty((String)((String)en.getKey()))).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    private String fetchKey(DynamicObject entry) {
        return HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)"user") + "#" + HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)entry, (String)"org");
    }
}

