/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.function;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.service.formula.cal.FormulaAnalysis;
import kd.hr.hbp.business.service.formula.cal.template.FormulaParse;
import kd.hr.hbp.business.service.formula.utils.FormulaUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.common.util.XSSCheckUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hbp.opplugin.validator.HRDataGradeValidator;
import kd.hr.hrcs.common.constants.function.FunctionConstants;
import kd.hr.hrcs.common.util.CodeUtils;
import kd.hr.hrcs.common.util.function.FunctionCodeCheckUtils;
import org.apache.commons.lang3.StringUtils;

@ExcludeFromJacocoGeneratedReport
public class FunctionValidator
extends HRDataBaseValidator
implements FunctionConstants {
    private static final Log LOGGER = LogFactory.getLog(HRDataGradeValidator.class);

    public void validate() {
        block3: {
            ExtendedDataEntity[] dataEntities;
            String operateKey;
            block2: {
                super.validate();
                operateKey = this.getOperateKey();
                dataEntities = this.getDataEntities();
                if (!"save".equals(operateKey) && !"onlinetestfunc".equals(operateKey)) break block2;
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.checkXSSValidate(dataEntity);
                    this.checkFuncExp(dataEntity);
                    this.checkFunKey(dataEntity);
                }
                break block3;
            }
            if (!"delete".equals(operateKey)) break block3;
            List childHelpers = FormulaUtils.getFormulaTplAllChildMetaServiceHelper();
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.checkFunctionQuote(dataEntity, childHelpers);
            }
        }
    }

    private void checkFunKey(ExtendedDataEntity dataEntity) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_function");
        DynamicObject data = dataEntity.getDataEntity();
        QFilter funKey = new QFilter("define", "=", (Object)data.getString("define"));
        DynamicObject[] funcs = hrBaseServiceHelper.query("id", new QFilter[]{funKey});
        if (funcs == null || funcs.length == 0) {
            return;
        }
        if (!Arrays.stream(funcs).allMatch(fun -> fun.getString("id").equalsIgnoreCase(data.getString("id")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u5b9a\u4e49\u503c\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u540e\u91cd\u8bd5\u3002", (String)"FunctionSaveValidator_18", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkFuncExp(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection params = data.getDynamicObjectCollection("params");
        String number = data.getString("number");
        if (HRStringUtils.isContainJavaVariableForbidChar((String)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3001\u7a7a\u683c\u3002", (String)"FunctionSaveValidator_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String name = data.getString("name");
        if (HRStringUtils.isContainSpecialChar((String)name)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e2d\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c\u3002", (String)"FunctionSaveValidator_19", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String define = data.getString("define");
        if (!HRStringUtils.isEnglishChar((String)define)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u5b9a\u4e49\u53ea\u80fd\u7ef4\u62a4\u82f1\u6587\u5b57\u7b26\u3002", (String)"FunctionSaveValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String funcExp = data.getString("funcexp");
        if (HRStringUtils.isEmpty((String)funcExp)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5b8c\u5584\u51fd\u6570\u4f53\u3002", (String)"FunctionSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String[] expArray = funcExp.split("\n");
        boolean isHasReturn = false;
        for (int i = 0; i < expArray.length; ++i) {
            if (HRStringUtils.isEmpty((String)expArray[i])) continue;
            if (i == 0) {
                this.checkFuncHead(dataEntity, expArray[i], params);
                continue;
            }
            if (FunctionCodeCheckUtils.checkDBKey((String)expArray[i])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u80fd\u7ef4\u62a4query\u3001drop\u548cdelete\u7b49\u5173\u952e\u5b57\u3002", (String)"FunctionSaveValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (FunctionCodeCheckUtils.checkJavaKeyMethod((String)expArray[i])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u80fd\u7ef4\u62a4\u5173\u952e\u65b9\u6cd5System.exit\u3002", (String)"FunctionSaveValidator_20", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (FunctionCodeCheckUtils.checkIsLinuxExecProcess((String)expArray[i])) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u80fd\u7ef4\u62a4\u6267\u884c\u811a\u672c\u76f8\u5173\u7684\u5173\u952e\u8bcd", (String)"FunctionSaveValidator_21", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (expArray[i].contains("public")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u51fd\u6570\u3002", (String)"FunctionSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (expArray[i].contains("return")) {
                isHasReturn = true;
            }
            if (i != expArray.length - 1 || expArray[i].endsWith("}")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u7ef4\u62a4\u9519\u8bef\uff0c\u5fc5\u987b\u4ee5\u201c}\u201d\u7ed3\u5c3e\u3002", (String)"FunctionSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!isHasReturn) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5185\u7f3a\u5c11\u8fd4\u56de\u503c\u3002", (String)"FunctionSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        try {
            CodeUtils.checkJavaFunctionCode(FormulaParse.class, (String)funcExp, this.getImportPackageSet(dataEntity));
        }
        catch (Exception e) {
            this.addErrorMessage(dataEntity, e.getMessage());
        }
    }

    private void checkFuncHead(ExtendedDataEntity dataEntity, String firstLine, DynamicObjectCollection entryList) {
        if (!firstLine.startsWith("public")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5e94\u8be5\u4ee5public\u5f00\u59cb\u3002", (String)"FunctionSaveValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (firstLine.indexOf(40) < 0 || firstLine.indexOf(41) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u7b2c\u4e00\u884c\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FunctionSaveValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String head = firstLine.substring(6, firstLine.indexOf(40)).trim();
        String[] headArray = head.split(" ");
        if (headArray.length != 2) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u6b63\u786e", (String)"FunctionSaveValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject data = dataEntity.getDataEntity();
        String funcDefine = data.getString("define");
        String funcDataType = data.getString("funcdatatype");
        if ("DateTime".equalsIgnoreCase(funcDataType)) {
            funcDataType = "Date";
        }
        if (!HRStringUtils.equals((String)funcDataType, (String)headArray[0].trim())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u8fd4\u56de\u503c\u7c7b\u578b\u4e0e\u5355\u636e\u5934\u4e2d\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FunctionSaveValidator_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!HRStringUtils.equals((String)funcDefine.trim(), (String)headArray[1].trim())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u51fd\u6570\u5b9a\u4e49\u540d\u4e0e\u5355\u636e\u5934\u4e2d\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FunctionSaveValidator_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        this.checkParam(dataEntity, entryList, firstLine);
    }

    private void checkParam(ExtendedDataEntity dataEntity, DynamicObjectCollection params, String firstLine) {
        String param = firstLine.substring(firstLine.indexOf(40) + 1, firstLine.indexOf(41));
        if (param.length() == 0 && params.size() == 0) {
            return;
        }
        String[] paramArray = param.split(",");
        if (paramArray.length != params.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u53c2\u6570\u4e2a\u6570\u4e0e\u53c2\u6570\u5217\u8868\u4e2d\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FunctionSaveValidator_12", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
            return;
        }
        String paramDataType = null;
        int seq = 0;
        String paramType = null;
        for (DynamicObject paramData : params) {
            paramDataType = paramData.getString("paramdatatype");
            paramType = this.getParamType(paramArray[seq].trim());
            if (paramType == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u7b2c%s\u4e2a\u53c2\u6570\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"FunctionSaveValidator_13", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), seq + 1));
                return;
            }
            if ("DateTime".equalsIgnoreCase(paramDataType)) {
                paramDataType = "Date";
            }
            if (!HRStringUtils.equals((String)paramDataType, (String)paramType)) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u7b2c%s\u4e2a\u53c2\u6570\u7c7b\u578b\u4e0e\u53c2\u6570\u5217\u8868\u4e2d\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FunctionSaveValidator_14", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), seq + 1));
                return;
            }
            ++seq;
        }
    }

    private String getParamType(String param) {
        if (HRStringUtils.isEmpty((String)param)) {
            return null;
        }
        String[] array = param.trim().split(" ");
        if (array.length != 2) {
            return null;
        }
        return array[0].trim();
    }

    private Set<String> getImportPackageSet(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        HashSet<String> importCodes = new HashSet<String>();
        DynamicObjectCollection parameterList = data.getDynamicObjectCollection("params");
        if (parameterList != null && parameterList.size() > 0) {
            for (DynamicObject parameter : parameterList) {
                String parameterType = parameter.getString("paramdatatype");
                CodeUtils.getImportCodeByClassType((String)parameterType).ifPresent(importCodes::add);
            }
        }
        CodeUtils.getImportCodeByClassType((String)data.getString("funcdatatype")).ifPresent(importCodes::add);
        DynamicObjectCollection custImportJarCodes = data.getDynamicObjectCollection("importentry");
        if (custImportJarCodes != null && custImportJarCodes.size() > 0) {
            for (DynamicObject custImport : custImportJarCodes) {
                String importJarCode = custImport.getString("importcode");
                if (!HRStringUtils.isNotEmpty((String)importJarCode)) continue;
                importCodes.add(importJarCode.trim());
            }
        }
        importCodes.addAll(FormulaAnalysis.getFormulaImportPackage());
        return importCodes;
    }

    private void checkFunctionQuote(ExtendedDataEntity dataEntity, List<HRBaseServiceHelper> helpers) {
        DynamicObject data = dataEntity.getDataEntity();
        String uniqueCode = data.getString("uniquecode");
        if (HRStringUtils.isEmpty((String)uniqueCode) || CollectionUtils.isEmpty(helpers)) {
            return;
        }
        QFilter uniqueCodeFilter = new QFilter("dependentfunc", "like", (Object)("%" + uniqueCode + ",%"));
        QFilter isCurrentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        QFilter[] queryFilter = new QFilter[]{uniqueCodeFilter, isCurrentFilter};
        for (HRBaseServiceHelper helper : helpers) {
            DynamicObject[] formulaNames;
            try {
                formulaNames = helper.queryOriginalArray("id,name", queryFilter);
            }
            catch (Exception e) {
                LOGGER.error("query_formula_obj_error:", (Throwable)e);
                continue;
            }
            if (!Objects.nonNull(formulaNames) || formulaNames.length <= 0) continue;
            List names = Stream.of(formulaNames).map(dy -> dy.getString("name")).distinct().collect(Collectors.toList());
            MainEntityType type = EntityMetadataCache.getDataEntityType((String)helper.getEntityName());
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8be5\u51fd\u6570\u5728\u201c%1$s\u201d\u4e2d\u88ab\u516c\u5f0f%2$s\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FunctionSaveValidator_15", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), type.getDisplayName().getLocaleValue(), StringUtils.join(names, (String)",")));
            return;
        }
    }

    private void checkXSSValidate(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        for (String field : XSS_CHECK_FIELDS) {
            IDataEntityProperty property = (IDataEntityProperty)data.getDataEntityType().getProperties().get((Object)field);
            String fieldValue = data.getString(property);
            if (!XSSCheckUtils.checkXSS((String)fieldValue)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"[%1$s]\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5XSS\u653b\u51fb\u6587\u672c\u8bf7\u4fee\u6539", (String)"FunctionSaveValidator_16", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), property.getDisplayName().getLocaleValue()));
            return;
        }
        for (String field : XSS_CHECK_ENTITY_FIELDS) {
            DynamicObjectCollection params = data.getDynamicObjectCollection("params");
            for (int index = 0; index < params.size(); ++index) {
                IDataEntityProperty property;
                DynamicObject param = (DynamicObject)params.get(index);
                String fieldValue = param.getString(property = (IDataEntityProperty)param.getDataEntityType().getProperties().get((Object)field));
                if (!XSSCheckUtils.checkXSS((String)fieldValue)) continue;
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7b2c[%1$s]\u884c\u7684[%2$s]\u5b57\u6bb5\u5b58\u5728\u975e\u6cd5XSS\u653b\u51fb\u6587\u672c\u8bf7\u4fee\u6539", (String)"FunctionSaveValidator_17", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), index + 1, property.getDisplayName().getLocaleValue()));
                return;
            }
        }
    }
}

