/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.msgcenter;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class MsgCenterValidator
extends HRDataBaseValidator {
    public void validate() {
        String operateKey = this.getOperateKey();
        if ("ignore".equals(operateKey)) {
            this.validateIgnore();
        }
    }

    private void validateIgnore() {
        if (this.dataEntities.length == 1) {
            DynamicObjectCollection entry = this.dataEntities[0].getDataEntity().getDynamicObjectCollection("entryentity");
            String warningMsg = this.getWarningMsg(entry, null);
            if (!HRStringUtils.isEmpty((String)warningMsg)) {
                this.addErrorMessage(this.dataEntities[0], warningMsg);
            }
        } else {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                DynamicObject dyn = dataEntity.getDataEntity();
                DynamicObjectCollection entry = dyn.getDynamicObjectCollection("entryentity");
                String warningMsg = this.getWarningMsg(entry, dyn.getString("number"));
                if (HRStringUtils.isEmpty((String)warningMsg)) continue;
                ValidationErrorInfo errorInfo = new ValidationErrorInfo("", dyn.getPkValue(), dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "errorcode_001", this.getOperationName(), warningMsg, ErrorLevel.Error);
                errorInfo.setSubRowIndex(dataEntity.getSubRowIndex());
                errorInfo.setEntityKey(this.getEntityKey());
                this.validateResult.addErrorInfo((OperateErrorInfo)errorInfo);
                this.getFalseDataEntities().add(dataEntity);
            }
        }
    }

    private String getWarningMsg(DynamicObjectCollection entry, String number) {
        int successCount = 0;
        int feedbackCount = 0;
        for (DynamicObject row : entry) {
            String feedback = row.getString("exceptionfeedback");
            String handleStatus = row.getString("handlestatus");
            if (Objects.equals("1", handleStatus) || HRStringUtils.isEmpty((String)handleStatus)) {
                ++successCount;
                continue;
            }
            if (HRStringUtils.isEmpty((String)feedback)) continue;
            ++feedbackCount;
        }
        String warningMsg = null;
        if (successCount + feedbackCount == entry.size()) {
            warningMsg = feedbackCount == 0 ? (HRStringUtils.isEmpty((String)number) ? ResManager.loadKDString((String)"\u4e1a\u52a1\u5904\u7406\u72b6\u6001\u6b63\u5e38\u3002", (String)"MsgCenterValidator_1", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"%s\uff1a\u4e1a\u52a1\u5904\u7406\u72b6\u6001\u65e0\u5f02\u5e38", (String)"MsgCenterValidator_3", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{number})) : (HRStringUtils.isEmpty((String)number) ? ResManager.loadKDString((String)"\u5df2\u6267\u884c\u76f8\u5173\u64cd\u4f5c\uff0c\u65e0\u9700\u518d\u6267\u884c\u3002", (String)"MsgCenterValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"%s\uff1a\u5df2\u6267\u884c\u76f8\u5173\u64cd\u4f5c\uff0c\u65e0\u9700\u518d\u6267\u884c\u3002", (String)"MsgCenterValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{number}));
        }
        return warningMsg;
    }
}

