/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.validator.perm;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.hr.hrcs.bussiness.service.perm.ChoiceFieldPageCustomQueryService;
import kd.hr.hrcs.bussiness.servicehelper.perm.HRBuCaServiceHelper;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlEntryRowModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityControlSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        String importType = this.getOption().getVariableValue("importtype", null);
        String operateKey = this.getOperateKey();
        if (HRStringUtils.equals((String)"save", (String)operateKey) && HRStringUtils.isNotEmpty((String)importType)) {
            this.importValidate(this.getDataEntities(), importType);
        }
    }

    private void importValidate(ExtendedDataEntity[] dataEntities, String importType) {
        List<String> disableDimensions = this.queryDisableDimension();
        List<String> entityNumbers = Arrays.stream(dataEntities).map(it -> it.getDataEntity().getDynamicObject("entitytype").getString("number")).collect(Collectors.toList());
        HashMap<String, List<String>> entityProps = new HashMap<String, List<String>>(16);
        Map<String, Map<String, String>> existEntityCtrl = this.queryExistEntityCtrl(entityNumbers, entityProps);
        Map<String, Boolean> entityModelTypes = this.queryEntityModelType(entityNumbers);
        Map<String, List<String>> allDynaFormCtrl = this.queryAllDynaFormCtrl(entityNumbers);
        ChoiceFieldPageCustomQueryService customQuery = new ChoiceFieldPageCustomQueryService();
        HashMap<String, Object> customParams = new HashMap<String, Object>(0);
        HashMap<String, Long> entityBuCaMap = new HashMap<String, Long>(16);
        HashMap<Long, Map<String, List<String>>> syncMustDims = new HashMap<Long, Map<String, List<String>>>(16);
        HashMap<Long, Map<String, List<String>>> syncUnMustDims = new HashMap<Long, Map<String, List<String>>>(16);
        ArrayList<String> entityIds = new ArrayList<String>(dataEntities.length);
        ArrayList entityCtrlModels = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity extDataEntity : dataEntities) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            DynamicObject entityType = dataEntity.getDynamicObject("entitytype");
            String entity = entityType.getString("number");
            String appId = entityType.getString("bizappid.id");
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
            ArrayList<String> allProps = new ArrayList<String>(10);
            ArrayList<String> noDBProps = new ArrayList<String>(10);
            this.getEntityFields(entity, entityModelTypes.get(entity), allDynaFormCtrl, customQuery, customParams, extDataEntity, allProps, noDBProps);
            if (CollectionUtils.isEmpty(allProps)) continue;
            ArrayList<String> propKeys = new ArrayList<String>(entryEntity.size());
            boolean errorFlag = false;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append(ResManager.loadKDString((String)"\u3010%s\u3011", (String)"EntityControlSaveValidator_12", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{entity}));
            ArrayList beforeOpData = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            ArrayList afterOpData = Lists.newArrayListWithExpectedSize((int)entryEntity.size());
            long logType = 4010L;
            for (DynamicObject entryRow : entryEntity) {
                String entityEntryKey;
                Map<String, String> existRow;
                long entryId = entryRow.getLong("id");
                DynamicObject dimension = entryRow.getDynamicObject("dimension");
                String dimNumber = dimension.getString("number");
                String propKey = entryRow.getString("propkey");
                String authRange = entryRow.getString("authrange");
                if (disableDimensions.contains(dimNumber)) {
                    errorFlag = true;
                    errMsg.append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u7f16\u7801\u201c%s\u201d\u5df2\u7981\u7528\uff0c\u4e0d\u5141\u8bb8\u5bfc\u5165\u3002", (String)"EntityControlSaveValidator_10", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{dimNumber}));
                }
                if (!allProps.contains(propKey)) {
                    errorFlag = true;
                    errMsg.append(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5b58\u5728\u3002", (String)"EntityControlSaveValidator_2", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{propKey}));
                }
                List props = (List)entityProps.get(entity);
                if (propKeys.contains(propKey) || HRStringUtils.equals((String)importType, (String)"new") && CollectionUtils.isNotEmpty((Collection)props) && props.contains(propKey)) {
                    errorFlag = true;
                    errMsg.append(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u4e1a\u52a1\u5bf9\u8c61\u5b57\u6bb5\u201c%s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EntityControlSaveValidator_11", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{propKey}));
                }
                if (noDBProps.contains(propKey) && !HRStringUtils.equals((String)authRange, (String)"2")) {
                    errorFlag = true;
                    errMsg.append(ResManager.loadKDString((String)"\u201c%s\u201d\u5b57\u6bb5\u7684\u63a7\u6743\u8303\u56f4\u5e94\u8bbe\u7f6e\u4e3a\u201c\u57fa\u7840\u8d44\u6599\u9009\u62e9\u8303\u56f4\u201d\u3002", (String)"EntityControlSaveValidator_7", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{propKey}));
                }
                propKeys.add(propKey);
                EntityCtrlEntryRowModel afterOpRow = new EntityCtrlEntryRowModel(propKey, dimension.getString("name"), authRange, entryRow.getBoolean("ismust"));
                afterOpData.add(afterOpRow);
                if (0L == entryId || !MapUtils.isNotEmpty(existRow = existEntityCtrl.get(entityEntryKey = entity + "#" + entryId))) continue;
                logType = 4015L;
                StringBuilder fields = new StringBuilder();
                if (!HRStringUtils.equals((String)propKey, (String)existRow.get("propkey"))) {
                    errorFlag = true;
                    fields.append(ResManager.loadKDString((String)"\u5b57\u6bb5\u3001", (String)"EntityControlSaveValidator_13", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
                if (!HRStringUtils.equals((String)dimNumber, (String)existRow.get("dimension"))) {
                    errorFlag = true;
                    fields.append(ResManager.loadKDString((String)"\u7ef4\u5ea6\u3001", (String)"EntityControlSaveValidator_14", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
                if (fields.length() > 0) {
                    errMsg.append(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u66f4\u65b0\u5185\u7801\u201c%1$s\u201d\u7684%2$s\u3002\u5982\u9700\u66f4\u6539\uff0c\u8bf7\u5728\u7cfb\u7edf\u5220\u9664\u8bb0\u5f55\u540e\u518d\u66f4\u65b0\u3002\n", (String)"EntityControlSaveValidator_4", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]), entryId, fields.deleteCharAt(fields.length() - 1)));
                }
                EntityCtrlEntryRowModel beforeOpRow = new EntityCtrlEntryRowModel(existRow.get("propkey"), existRow.get("dimensionName"), existRow.get("authrange"), (HRStringUtils.equals((String)"true", (String)existRow.get("ismust")) ? Boolean.TRUE : Boolean.FALSE).booleanValue());
                beforeOpData.add(beforeOpRow);
            }
            if (errorFlag) {
                this.addErrorMessage(extDataEntity, errMsg.toString());
                continue;
            }
            Long buId = Long.valueOf(HRBuCaServiceHelper.getBuCaFunc((String)entity, (String)appId));
            entityBuCaMap.put(entity, buId);
            entityIds.add(entity);
            if (!CollectionUtils.isEqualCollection((Collection)beforeOpData, (Collection)afterOpData)) {
                EntityCtrlModel entityCtrlModel = new EntityCtrlModel(entity);
                entityCtrlModel.setBeforeEntryRows((List)beforeOpData);
                entityCtrlModel.setAfterEntryRows((List)afterOpData);
                entityCtrlModel.setLogType(Long.valueOf(logType));
                entityCtrlModels.add(entityCtrlModel);
            }
            Set mustDimIds = entryEntity.stream().filter(it -> it.getBoolean("ismust")).map(it -> it.getLong("dimension.id")).collect(Collectors.toSet());
            for (DynamicObject entryRow : entryEntity) {
                boolean isMust = entryRow.getBoolean("ismust");
                long dimId = entryRow.getLong("dimension.id");
                String propKey = entryRow.getString("propkey");
                if (isMust) {
                    this.addSyncInfo(syncMustDims, dimId, entity, appId, propKey);
                    continue;
                }
                if (mustDimIds.contains(dimId)) {
                    this.addSyncInfo(syncMustDims, dimId, entity, appId, propKey);
                    continue;
                }
                this.addSyncInfo(syncUnMustDims, dimId, entity, appId, propKey);
            }
        }
        this.getOption().setVariableValue("entityIds", SerializationUtils.toJsonString(entityIds));
        this.getOption().setVariableValue("syncMustDims", SerializationUtils.toJsonString(syncMustDims));
        this.getOption().setVariableValue("syncUnMustDims", SerializationUtils.toJsonString(syncUnMustDims));
        this.getOption().setVariableValue("entityBuCaMap", SerializationUtils.toJsonString(entityBuCaMap));
        this.getOption().setVariableValue("entityCtrlModels", JSONArray.toJSONString((Object)entityCtrlModels));
    }

    private void addSyncInfo(Map<Long, Map<String, List<String>>> toSyncMap, long dimId, String entity, String appId, String propKey) {
        Map entityProps = toSyncMap.computeIfAbsent(dimId, key -> new HashMap(16));
        List properties = entityProps.computeIfAbsent(entity + "#" + appId, key -> new ArrayList(10));
        properties.add(propKey);
    }

    private void getEntityFields(String entity, Boolean modelType, Map<String, List<String>> allDynaFormCtrl, ChoiceFieldPageCustomQueryService customQuery, Map<String, Object> customParams, ExtendedDataEntity extDataEntity, List<String> allProps, List<String> noDBProps) {
        if (modelType.booleanValue()) {
            List<String> props = allDynaFormCtrl.get(entity);
            if (CollectionUtils.isEmpty(props)) {
                this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u8bf7\u5728\u52a8\u6001\u8868\u5355\u63a7\u6743\u914d\u7f6e\u4e2d\u7ef4\u62a4\u76f8\u5173\u6570\u636e\uff0c\u4ee5\u914d\u7f6e\u5c5e\u6027\u3002", (String)"EntityControlSaveValidator_5", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{entity}));
                return;
            }
            allProps.addAll(props);
            return;
        }
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        if (ObjectUtils.isEmpty((Object)dataEntityType)) {
            this.addErrorMessage(extDataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u4e1a\u52a1\u5bf9\u8c61.\u7f16\u7801=?\u7684\u4e1a\u52a1\u5bf9\u8c61\u3002", (String)"EntityControlSaveValidator_6", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{entity}));
            return;
        }
        List list = customQuery.parsePropertySub((IDataEntityType)dataEntityType, null, customParams, "1=1", noDBProps).stream().map(it -> (String)it.get("field_id")).collect(Collectors.toList());
        allProps.addAll(list);
    }

    private Map<String, Map<String, String>> queryExistEntityCtrl(List<String> entityNumbers, Map<String, List<String>> entityProps) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_entityctrl");
        DynamicObject[] entityCtrls = serviceHelper.query("entitytype,entryentity.id,entryentity.ismust,entryentity.dimension,entryentity.propkey,entryentity.authrange,entryentity.desc,entryentity.issyspreset", new QFilter[]{new QFilter("entitytype", "in", entityNumbers)});
        HashMap<String, Map<String, String>> existEntityCtrl = new HashMap<String, Map<String, String>>(entityCtrls.length);
        HashMap<String, List> entityPropsTemp = new HashMap<String, List>(16);
        for (DynamicObject entityCtrl : entityCtrls) {
            String entity = entityCtrl.getString("entitytype.id");
            List props = entityPropsTemp.computeIfAbsent(entity, key -> new ArrayList(10));
            for (DynamicObject row : entityCtrl.getDynamicObjectCollection("entryentity")) {
                String entryId = row.getString("id");
                String propKey = row.getString("propkey");
                HashMap<String, String> rowInfo = new HashMap<String, String>(5);
                props.add(propKey);
                rowInfo.put("propkey", propKey);
                rowInfo.put("dimension", row.getString("dimension.number"));
                rowInfo.put("dimensionName", row.getString("dimension.name"));
                rowInfo.put("authrange", row.getString("authrange"));
                rowInfo.put("ismust", row.getString("ismust"));
                existEntityCtrl.put(entity + "#" + entryId, rowInfo);
            }
        }
        entityProps.putAll(entityPropsTemp);
        return existEntityCtrl;
    }

    private Map<String, Boolean> queryEntityModelType(List<String> entityNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("bos_entityobject");
        return serviceHelper.queryOriginalCollection("id,number,modeltype", new QFilter[]{new QFilter("id", "in", entityNumbers)}).stream().collect(Collectors.toMap(it -> it.getString("id"), it -> HRStringUtils.equals((String)it.getString("modeltype"), (String)"DynamicFormModel") || HRStringUtils.equals((String)it.getString("modeltype"), (String)"ReportFormModel"), (newVal, oldVal) -> oldVal));
    }

    private Map<String, List<String>> queryAllDynaFormCtrl(List<String> entityNumbers) {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dynaformctrl");
        DynamicObject[] dynaForms = serviceHelper.query("entitytype.id,entryentity.propkey", new QFilter[]{new QFilter("entitytype", "in", entityNumbers)});
        return Arrays.stream(dynaForms).collect(Collectors.toMap(it -> it.getString("entitytype.id"), it -> it.getDynamicObjectCollection("entryentity").stream().map(rs -> rs.getString("propkey")).collect(Collectors.toList()), (newVal, oldVal) -> oldVal));
    }

    private List<String> queryDisableDimension() {
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_dimension");
        DynamicObjectCollection dimensionCol = serviceHelper.queryOriginalCollection("number,enable", new QFilter[]{new QFilter("enable", "=", (Object)"0")});
        return dimensionCol.stream().map(it -> it.getString("number")).collect(Collectors.toList());
    }
}

