/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.HRMsgBaseConstants;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import kd.hr.hrcs.opplugin.validator.MsgSubSaveValidator;
import org.apache.commons.lang3.StringUtils;

public class MsgSubSaveOp
extends HRDataBaseOp
implements HRMsgBaseConstants {
    private static final String FIELD_MSGPUBLISHER_ID = "msgpublisher.id";
    private static final String FIELD_SUBTYPE = "subtype";
    private Map<String, String> subStatusMap = Maps.newHashMap();
    private static final String MSG_PUBLISHER = "msgpublisher";
    private static final String SUBSCRIBED = "subscribebd";
    private static final String PUB_DATE = "pubdate";
    private static final String PUBER = "puber";
    private static final String SUBER = "suber";
    private static final String SUB_STATUS = "substatus";
    private static final String API_ENTRY_ENTITY = "apientryentity";
    private static final String API_SUB_STATUS = "apisubstatus";
    private static final String SUB_MSG_LOG = "submsglog";
    private static final String SUB_DATE = "subdate";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(MSG_PUBLISHER);
        fieldKeys.add(SUBSCRIBED);
        fieldKeys.add(PUB_DATE);
        fieldKeys.add(PUBER);
        fieldKeys.add("msgdomain");
        fieldKeys.add("msgactiontype");
        fieldKeys.add("apientryentity.apisource");
        fieldKeys.add("apientryentity.apinumber");
        fieldKeys.add("apientryentity.apiname");
        fieldKeys.add("apientryentity.apidescription");
        fieldKeys.add("consumercloud");
        fieldKeys.add("consumerapp");
        fieldKeys.add("consumerService");
        fieldKeys.add("consumerMethod");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new MsgSubSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        DynamicObject dy = dys[0];
        String operationKey = args.getOperationKey().toLowerCase(Locale.ROOT);
        if ("save".equals(operationKey)) {
            dy.set("msgsubno", (Object)dy.getString("number"));
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
            QFilter orgFilter = new QFilter("id", "=", dy.get("id"));
            DynamicObject[] updateDys = serviceHelper.query("apientryentity,apientryentity.apisubstatus,consumermethod,description,consumerservice,", new QFilter[]{orgFilter});
            if (updateDys.length > 0) {
                this.subStatusMap.put("opModify", "2");
                Date now = new Date();
                boolean changed = this.dataIsChanged(dy, updateDys[0]);
                if (changed) {
                    Long pkId = this.saveSublog(dys, now, Integer.parseInt("2"));
                    DynamicObjectCollection dynamicObjectCollection = this.getModifiedApiList(dy, updateDys[0]);
                    this.saveSubApiLog(dynamicObjectCollection, now, Integer.parseInt("2"), pkId);
                }
            }
        }
    }

    private boolean dataIsChanged(DynamicObject newDy, DynamicObject oldDy) {
        boolean result = false;
        DynamicObjectCollection newApiEntryEntity = newDy.getDynamicObjectCollection(API_ENTRY_ENTITY);
        DynamicObjectCollection oldApiEntryEntity = oldDy.getDynamicObjectCollection(API_ENTRY_ENTITY);
        for (int i = 0; i < newApiEntryEntity.size(); ++i) {
            String oldApiSubStatus;
            String newApiSubStatus = ((DynamicObject)newApiEntryEntity.get(i)).getString(API_SUB_STATUS);
            if (StringUtils.equals((CharSequence)newApiSubStatus, (CharSequence)(oldApiSubStatus = ((DynamicObject)oldApiEntryEntity.get(i)).getString(API_SUB_STATUS)))) continue;
            result = true;
        }
        String consumerService = newDy.getString("consumerservice");
        String consumerMethod = newDy.getString("consumermethod");
        String description = newDy.get("description").toString();
        String oldConsumerService = oldDy.getString("consumerservice");
        String oldConsumerMethod = oldDy.getString("consumermethod");
        String oldDescription = oldDy.get("description").toString();
        result = !StringUtils.equals((CharSequence)consumerService, (CharSequence)oldConsumerService) || !StringUtils.equals((CharSequence)consumerMethod, (CharSequence)oldConsumerMethod) || !StringUtils.equals((CharSequence)description, (CharSequence)oldDescription);
        return result;
    }

    private DynamicObjectCollection getModifiedApiList(DynamicObject newDy, DynamicObject oldDy) {
        DynamicObjectCollection subLogApiDys = new DynamicObjectCollection();
        DynamicObjectCollection newApiEntryEntity = newDy.getDynamicObjectCollection(API_ENTRY_ENTITY);
        DynamicObjectCollection oldApiEntryEntity = oldDy.getDynamicObjectCollection(API_ENTRY_ENTITY);
        for (int i = 0; i < newApiEntryEntity.size(); ++i) {
            String oldApiSubStatus;
            String newApiSubStatus = ((DynamicObject)newApiEntryEntity.get(i)).getString(API_SUB_STATUS);
            if (StringUtils.equals((CharSequence)newApiSubStatus, (CharSequence)(oldApiSubStatus = ((DynamicObject)oldApiEntryEntity.get(i)).getString(API_SUB_STATUS)))) continue;
            subLogApiDys.add(newApiEntryEntity.get(i));
        }
        return subLogApiDys;
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dys = args.getDataEntities();
        DynamicObjectCollection apiEntryEntity = dys[0].getDynamicObjectCollection(API_ENTRY_ENTITY);
        String operationKey = args.getOperationKey().toLowerCase(Locale.ROOT);
        if ("save".equals(operationKey) && Objects.isNull(this.subStatusMap.get("opModify"))) {
            Date now = new Date();
            Long pkId = this.saveSublog(dys, now, Integer.parseInt("1"));
            this.saveSubApiLog(apiEntryEntity, now, Integer.parseInt("1"), pkId);
            this.updatePubTableStatus(dys[0].getLong(FIELD_MSGPUBLISHER_ID), true);
        } else if ("statusconvert".equals(operationKey)) {
            this.synSubLogDy(dys);
            this.updatePubTableStatus(dys[0].getLong(FIELD_MSGPUBLISHER_ID), false);
            MsgCenterServiceHelper.updateEnable((Long)dys[0].getLong("id"), (String)"0");
        }
    }

    private void updatePubTableStatus(Long id, boolean status) {
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        if (status) {
            QFilter pubQfFilter = new QFilter("id", "=", (Object)id);
            DynamicObject pubDy = pubServiceHelper.queryOne(SUB_STATUS, new QFilter[]{pubQfFilter});
            pubDy.set(SUB_STATUS, (Object)"1");
            pubServiceHelper.saveOne(pubDy);
        } else {
            HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
            QFilter subQfFilter = new QFilter(MSG_PUBLISHER, "=", (Object)id);
            subQfFilter.and(new QFilter(SUB_STATUS, "=", (Object)"1"));
            DynamicObject[] result = subServiceHelper.query("suber.id", new QFilter[]{subQfFilter});
            if (result.length == 0) {
                QFilter pubQfFilter = new QFilter("id", "=", (Object)id);
                DynamicObject pubDy = pubServiceHelper.queryOne(SUB_STATUS, new QFilter[]{pubQfFilter});
                pubDy.set(SUB_STATUS, (Object)"0");
                pubServiceHelper.saveOne(pubDy);
            }
        }
    }

    private void synSubLogDy(DynamicObject[] dys) {
        Date now = new Date();
        DynamicObject dy = dys[0];
        Long pkId = (Long)dy.getPkValue();
        HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
        QFilter subQfFilter = new QFilter("id", "=", (Object)pkId);
        DynamicObject result = subServiceHelper.queryOne("msgpublisher.id,subscribebd.id,apientryentity,apientryentity.number,apientryentity.name", new QFilter[]{subQfFilter});
        HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
        QFilter pubQfFilter = new QFilter("id", "=", result.get(FIELD_MSGPUBLISHER_ID));
        DynamicObject msgDy = pubServiceHelper.queryOne("puber.id,subbusfield.id,actiontype.id,publishdate,publishbd.id,msgtag,number", new QFilter[]{pubQfFilter});
        DynamicObjectCollection subLogDys = new DynamicObjectCollection();
        DynamicObject subMsgLog = BusinessDataServiceHelper.newDynamicObject((String)"hrcs_submgslog");
        Long logPkId = ORM.create().genLongId("hrcs_submgslog");
        subMsgLog.set("id", (Object)logPkId);
        subMsgLog.set("number", dy.get("number"));
        subMsgLog.set("publisher", msgDy.get(PUBER));
        subMsgLog.set(PUB_DATE, msgDy.get("publishdate"));
        subMsgLog.set("msgsender", (Object)RequestContext.get().getCurrUserId());
        subMsgLog.set(SUB_DATE, (Object)now);
        subMsgLog.set(FIELD_SUBTYPE, (Object)"0");
        subMsgLog.set("consumer", result.get("subscribebd.id"));
        subMsgLog.set("pubdomain", msgDy.get("publishbd.id"));
        subMsgLog.set("actiontype", msgDy.get("actiontype.id"));
        subMsgLog.set("status", (Object)"C");
        subMsgLog.set("enable", (Object)"1");
        subMsgLog.set("createtime", (Object)now);
        subMsgLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        subMsgLog.set(PUBER, dy.get(MSG_PUBLISHER));
        subMsgLog.set(SUBER, dy.get("id"));
        subLogDys.add((Object)subMsgLog);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_submgslog");
        serviceHelper.save(subLogDys);
    }

    private void saveSubApiLog(DynamicObjectCollection apiEntryEntity, Date date, int substatus, Long pkid) {
        DynamicObjectCollection subLogApiDys = new DynamicObjectCollection();
        if (!apiEntryEntity.isEmpty()) {
            long[] pkIds = DBServiceHelper.genLongIds((String)"hrcs_pubmsglog", (int)apiEntryEntity.size());
            for (int i = 0; i < apiEntryEntity.size(); ++i) {
                DynamicObject apiDy = (DynamicObject)apiEntryEntity.get(i);
                Long pkId = pkIds[i];
                DynamicObject subMsgApiLog = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"hrcs_subapilog"));
                subMsgApiLog.set("id", (Object)pkId);
                subMsgApiLog.set(SUB_DATE, (Object)date);
                if (StringUtils.equals((CharSequence)"1", (CharSequence)apiDy.getString(API_SUB_STATUS))) {
                    subMsgApiLog.set(FIELD_SUBTYPE, (Object)"1");
                } else {
                    subMsgApiLog.set(FIELD_SUBTYPE, (Object)"0");
                }
                subMsgApiLog.set("status", (Object)"C");
                subMsgApiLog.set("enable", (Object)"1");
                subMsgApiLog.set("createtime", (Object)date);
                subMsgApiLog.set("creator", (Object)RequestContext.get().getCurrUserId());
                subMsgApiLog.set("subscriber", (Object)RequestContext.get().getCurrUserId());
                subMsgApiLog.set("number", (Object)apiDy.getString("apinumber"));
                subMsgApiLog.set("name", (Object)apiDy.getString("apiname"));
                subMsgApiLog.set(SUB_MSG_LOG, (Object)pkid);
                subLogApiDys.add((Object)subMsgApiLog);
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_subapilog");
            serviceHelper.save(subLogApiDys);
        }
    }

    private Long saveSublog(DynamicObject[] dys, Date date, int substatus) {
        DynamicObjectCollection subLogDys = new DynamicObjectCollection();
        DynamicObject dy = dys[0];
        DynamicObject subMsgLog = BusinessDataServiceHelper.newDynamicObject((String)"hrcs_submgslog");
        Long pkId = ORM.create().genLongId("hrcs_submgslog");
        subMsgLog.set("id", (Object)pkId);
        subMsgLog.set("number", dy.get("number"));
        subMsgLog.set("publisher", dy.get(PUBER));
        subMsgLog.set(PUB_DATE, dy.get(PUB_DATE));
        subMsgLog.set("msgsender", (Object)RequestContext.get().getCurrUserId());
        subMsgLog.set(SUB_DATE, (Object)date);
        subMsgLog.set(FIELD_SUBTYPE, (Object)substatus);
        subMsgLog.set("consumer", dy.get(SUBSCRIBED));
        subMsgLog.set("pubdomain", dy.get("msgdomain"));
        subMsgLog.set("actiontype", dy.get("msgactiontype"));
        subMsgLog.set("status", (Object)"C");
        subMsgLog.set("enable", (Object)"1");
        if (substatus == Integer.parseInt("2")) {
            subMsgLog.set("modifytime", (Object)date);
            subMsgLog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        } else {
            subMsgLog.set("createtime", (Object)date);
            subMsgLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        }
        subMsgLog.set(PUBER, dy.get(MSG_PUBLISHER));
        subMsgLog.set(SUBER, dy.get("id"));
        subLogDys.add((Object)subMsgLog);
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_submgslog");
        serviceHelper.save(subLogDys);
        return pkId;
    }
}

