/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.service.InteServiceImpl;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.common.util.RemoveHtmlUtil;
import kd.hr.hrcs.opplugin.web.validator.PromptSaveValidator;

@ExcludeFromJacocoGeneratedReport
public class PromptSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PromptSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        String richText = (String)this.getOption().getVariables().get("richText");
        Map richTextMap = null;
        if (HRStringUtils.isNotEmpty((String)richText)) {
            richTextMap = (Map)SerializationUtils.fromJsonString((String)richText, Map.class);
        }
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            String langType = dataEntity.getString("langtype");
            if ("1".equals(langType)) {
                dataEntity.set("promptlangcontent", null);
                continue;
            }
            if (richTextMap == null) continue;
            String number = dataEntity.getString("number");
            Map richTextValueMap = (Map)richTextMap.get(number);
            richTextValueMap.replaceAll((k, v) -> null);
        }
        if (richTextMap != null) {
            this.getOption().setVariableValue("richText", SerializationUtils.toJsonString((Object)richTextMap));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        DynamicObject[] promptDys = args.getDataEntities();
        String richText = (String)this.getOption().getVariables().get("richText");
        Map richTextMap = null;
        if (HRStringUtils.isNotEmpty((String)richText)) {
            richTextMap = (Map)SerializationUtils.fromJsonString((String)richText, Map.class);
        }
        if (richTextMap != null) {
            this.saveByImport(promptDys, richTextMap);
        } else {
            this.saveByPage(promptDys[0]);
        }
    }

    private void saveByImport(DynamicObject[] promptDys, Map<String, Map<String, String>> richTextMap) {
        HashMap newRichTextMap = Maps.newHashMapWithExpectedSize((int)richTextMap.size());
        Map<Long, DynamicObject> promptMap = Arrays.stream(promptDys).collect(Collectors.toMap(pd -> pd.getLong("id"), dy -> dy));
        for (DynamicObject promptDy : promptDys) {
            long promptId = promptDy.getLong("id");
            promptMap.put(promptId, promptDy);
            Map<String, String> richTextValueMap = richTextMap.get(promptDy.getString("number"));
            newRichTextMap.put(promptId, richTextValueMap);
        }
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Map<String, EnabledLang> enabledLangMap = enabledLangList.stream().collect(Collectors.toMap(EnabledLang::getNumber, el -> el));
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        DynamicObject[] promptContent = contentHelper.query("promptcontent,contenttext,locale,prompt", new QFilter[]{new QFilter("prompt", "in", promptMap.keySet())});
        Map<Long, List<DynamicObject>> promptContentGroup = Arrays.stream(promptContent).collect(Collectors.groupingBy(pc -> pc.getLong("prompt")));
        DynamicObjectCollection newDynCol = new DynamicObjectCollection();
        for (Map.Entry entry : newRichTextMap.entrySet()) {
            EnabledLang enabledLang;
            DynamicObject dynamicObject;
            Long promptId = (Long)entry.getKey();
            Map richTextValueMap = (Map)entry.getValue();
            List<DynamicObject> contents = promptContentGroup.get(promptId);
            String langType = promptMap.get(promptId).getString("langtype");
            ILocaleString promptLangContent = promptMap.get(promptId).getLocaleString("promptlangcontent");
            if (contents == null) {
                if ("2".equals(langType)) {
                    for (Map.Entry entry2 : promptLangContent.entrySet()) {
                        EnabledLang enabledLang2 = enabledLangMap.get(entry2.getKey());
                        if (enabledLang2 == null) continue;
                        DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
                        contentDy.set("contenttext", entry2.getValue());
                        contentDy.set("locale", (Object)enabledLangMap.get(entry2.getKey()).getId());
                        contentDy.set("prompt", (Object)promptId);
                        newDynCol.add((Object)contentDy);
                    }
                    continue;
                }
                for (Map.Entry entry3 : richTextValueMap.entrySet()) {
                    EnabledLang enabledLang3 = enabledLangMap.get(entry3.getKey());
                    DynamicObject newDyn = this.buildPromptContentDy(promptMap.get(promptId), enabledLang3, (String)entry3.getValue(), contentHelper);
                    newDynCol.add((Object)newDyn);
                }
                continue;
            }
            Map<String, DynamicObject> localeMap = contents.stream().collect(Collectors.toMap(ct -> ct.getString("locale.number"), ct -> ct));
            if ("2".equals(langType)) {
                for (Map.Entry entry4 : promptLangContent.entrySet()) {
                    dynamicObject = localeMap.get(entry4.getKey());
                    enabledLang = enabledLangMap.get(entry4.getKey());
                    if (dynamicObject != null || enabledLang == null) continue;
                    DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
                    contentDy.set("contenttext", entry4.getValue());
                    contentDy.set("locale", (Object)enabledLang.getId());
                    contentDy.set("prompt", (Object)promptId);
                    newDynCol.add((Object)contentDy);
                }
            } else {
                for (Map.Entry entry5 : richTextValueMap.entrySet()) {
                    dynamicObject = localeMap.get(entry5.getKey());
                    if (dynamicObject != null) continue;
                    enabledLang = enabledLangMap.get(entry5.getKey());
                    DynamicObject newDyn = this.buildPromptContentDy(promptMap.get(promptId), enabledLang, (String)entry5.getValue(), contentHelper);
                    newDynCol.add((Object)newDyn);
                }
            }
            for (DynamicObject dynamicObject2 : contents) {
                String localNum = dynamicObject2.getString("locale.number");
                String value = (String)richTextValueMap.get(localNum);
                dynamicObject2.set("promptcontent", (Object)value);
                if ("1".equals(langType)) {
                    dynamicObject2.set("contenttext", (Object)RemoveHtmlUtil.delHTMLTag((String)value));
                    continue;
                }
                dynamicObject2.set("contenttext", promptLangContent.get((Object)localNum));
            }
        }
        contentHelper.save(newDynCol);
        contentHelper.update(promptContent);
    }

    private void saveByPage(DynamicObject prompt) {
        String cacheContent = (String)this.getOption().getVariables().get("LocaleContent");
        String langType = prompt.getString("langtype");
        HRBaseServiceHelper contentHelper = new HRBaseServiceHelper("hrcs_promptcontent");
        ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
        Long promptId = prompt.getLong("id");
        DynamicObject[] promptContent = contentHelper.query("promptcontent,contenttext,locale", new QFilter[]{new QFilter("prompt", "=", (Object)promptId)});
        if (Objects.nonNull(cacheContent)) {
            Map localeContent = (Map)SerializationUtils.fromJsonString((String)cacheContent, Map.class);
            ArrayList newDys = Lists.newArrayListWithCapacity((int)localeContent.size());
            HashSet dBLocaleIdSet = Sets.newHashSetWithExpectedSize((int)promptContent.length);
            Arrays.stream(promptContent).forEach(dy -> {
                Map contentMap = (Map)localeContent.get(dy.getString("locale.id"));
                if (contentMap != null) {
                    dy.set("promptcontent", contentMap.get("2"));
                    if ("1".equals(langType)) {
                        dy.set("contenttext", (Object)RemoveHtmlUtil.delHTMLTag((String)((String)contentMap.get("2"))));
                    } else {
                        dy.set("contenttext", promptLangContent.get((Object)dy.getString("locale.number")));
                    }
                }
                dBLocaleIdSet.add(dy.getString("locale.id"));
                localeContent.remove(dy.getString("locale.id"));
            });
            this.buildNewPromptContentDy(localeContent, prompt, contentHelper, newDys, dBLocaleIdSet);
            contentHelper.save(newDys.toArray(new DynamicObject[0]));
            contentHelper.update(promptContent);
        } else if ("2".equals(langType)) {
            DynamicObjectCollection col = new DynamicObjectCollection();
            InteServiceImpl intService = new InteServiceImpl();
            List enabledLangList = intService.getEnabledLang();
            Map<String, String> enabledLangMap = enabledLangList.stream().collect(Collectors.toMap(EnabledLang::getNumber, EnabledLang::getId));
            HashSet dBLocaleNumSet = Sets.newHashSetWithExpectedSize((int)promptContent.length);
            Arrays.stream(promptContent).forEach(dy -> {
                String context = (String)promptLangContent.get((Object)dy.getString("locale.number"));
                dy.set("contenttext", (Object)context);
                dBLocaleNumSet.add(dy.getString("locale.number"));
            });
            for (Map.Entry entry : promptLangContent.entrySet()) {
                String localeId = enabledLangMap.get(entry.getKey());
                if (HRStringUtils.isEmpty((String)localeId) || dBLocaleNumSet.contains(entry.getKey())) continue;
                DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
                contentDy.set("contenttext", entry.getValue());
                contentDy.set("locale", (Object)localeId);
                contentDy.set("prompt", (Object)promptId);
                col.add((Object)contentDy);
            }
            contentHelper.save(col);
            contentHelper.update(promptContent);
        }
    }

    private void buildNewPromptContentDy(Map<String, Map<String, Object>> localeContent, DynamicObject prompt, HRBaseServiceHelper contentHelper, List<DynamicObject> newDys, Set<String> dBLocaleIdSet) {
        Long promptId = prompt.getLong("id");
        String langType = prompt.getString("langtype");
        ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
        InteServiceImpl intService = new InteServiceImpl();
        List enabledLangList = intService.getEnabledLang();
        Map<String, String> enabledLangMap = enabledLangList.stream().collect(Collectors.toMap(EnabledLang::getId, EnabledLang::getNumber));
        localeContent.forEach((key, value) -> {
            DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
            contentDy.set("promptcontent", value.get("2"));
            if ("1".equals(langType)) {
                contentDy.set("contenttext", (Object)RemoveHtmlUtil.delHTMLTag((String)((String)value.get("2"))));
            } else {
                contentDy.set("contenttext", promptLangContent.get(enabledLangMap.get(key)));
            }
            contentDy.set("locale", key);
            contentDy.set("prompt", (Object)promptId);
            newDys.add(contentDy);
        });
        Map<String, String> enabledLangMap2 = enabledLangList.stream().collect(Collectors.toMap(EnabledLang::getNumber, EnabledLang::getId));
        for (Map.Entry entry : promptLangContent.entrySet()) {
            String localeId = enabledLangMap2.get(entry.getKey());
            if (localeContent.containsKey(localeId) || HRStringUtils.isEmpty((String)localeId) || dBLocaleIdSet.contains(localeId)) continue;
            DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
            contentDy.set("contenttext", entry.getValue());
            contentDy.set("locale", (Object)localeId);
            contentDy.set("prompt", (Object)promptId);
            newDys.add(contentDy);
        }
    }

    private DynamicObject buildPromptContentDy(DynamicObject prompt, EnabledLang enabledLang, String promptContent, HRBaseServiceHelper contentHelper) {
        DynamicObject contentDy = contentHelper.generateEmptyDynamicObject();
        contentDy.set("promptcontent", (Object)promptContent);
        String langType = prompt.getString("langtype");
        ILocaleString promptLangContent = prompt.getLocaleString("promptlangcontent");
        if ("1".equals(langType)) {
            contentDy.set("contenttext", (Object)RemoveHtmlUtil.delHTMLTag((String)promptContent));
        } else {
            contentDy.set("contenttext", promptLangContent.get((Object)enabledLang.getNumber()));
        }
        contentDy.set("locale", (Object)enabledLang.getId());
        long promptId = prompt.getLong("id");
        contentDy.set("prompt", (Object)promptId);
        return contentDy;
    }
}

