/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.api;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRListUtils;
import kd.hr.hbp.opplugin.validator.HRAPISourceSaveValidator;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.servicehelper.MsgCenterServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class HRAPISourceSaveOp
extends HRDataBaseOp {
    private static final String ENTITYKEY_APISOURCE = "hbp_apisourcetpl";
    private static final String ENTITY_KEY = "entityKey";
    private static final String ENTITY = "entity";
    private static final String API_FIELDS = "apiFields";
    private static final String T_THREE_TIMES = "\t\t\t";
    private static final String T_FOUR_TIMES = "\t\t\t\t";
    private static final String T_FIVE_TIMES = "\t\t\t\t\t";
    private static final String API_TYPE_COMMON = "1";

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        DynamicObject[] dys = args.getDataEntities();
        if (dys == null || dys.length < 1) {
            return;
        }
        String opKey = args.getOperationKey();
        if (!"save".equals(opKey)) {
            return;
        }
        long id = dys[0].getLong("id");
        this.setAPIXML(dys[0]);
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_apideploy");
        QFilter qfFilter = new QFilter("id", "=", (Object)id);
        DynamicObject[] dbObj = helper.query(new QFilter[]{qfFilter});
        if (dbObj.length > 0) {
            this.updateMsgApi(dys[0]);
        }
    }

    private void setDyCols(DynamicObject dyApi, DynamicObjectCollection dyCols) {
        for (DynamicObject dy : dyCols) {
            if (!StringUtils.equals((CharSequence)dy.getString("apinumber"), (CharSequence)dyApi.getString("number"))) continue;
            dy.set("apiname", dyApi.get("name"));
            dy.set("apidescription", dyApi.get("description"));
            dy.set("apiservice", dyApi.get("service"));
            dy.set("apimethod", dyApi.get("method"));
            dy.set("apipubcloud", dyApi.get("bizcloud"));
            dy.set("apipubapp", dyApi.get("bizapp"));
            if (StringUtils.equals((CharSequence)dy.getString("apitype"), (CharSequence)API_TYPE_COMMON)) {
                dy.set("params", dyApi.get("param"));
                continue;
            }
            dy.set("inputparam", dyApi.get("inputparam"));
            dy.set("outputtype", dyApi.get("outputtype"));
            dy.set("outputparam", dyApi.get("outputparam"));
        }
    }

    private void updateMsgApi(DynamicObject dyApi) {
        String selectSql = "select fid as \"id\"  from  t_hrcs_msgpublishapi where fapisourceid = ?";
        List pubIds = (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)selectSql, (Object[])new Object[]{dyApi.getPkValue()}, rs -> {
            ArrayList<Long> longIds = new ArrayList<Long>(16);
            while (rs.next()) {
                longIds.add(rs.getLong("id"));
            }
            return longIds;
        });
        List listIds = HRListUtils.splitList((List)pubIds, (int)1000);
        for (List ids : listIds) {
            HRBaseServiceHelper pubServiceHelper = new HRBaseServiceHelper("hrcs_msgpublisher");
            QFilter idQFilter = new QFilter("id", "in", (Object)ids);
            DynamicObject[] pubDys = pubServiceHelper.query("apientryentity,apientryentity.apiname,apientryentity.apinumber,apientryentity.apipubcloud,apientryentity.apipubapp,apientryentity.apidescription,apientryentity.params,apientryentity.apitype,apientryentity.apiservice,apientryentity.apimethod,apientryentity.inputparam,apientryentity.outputtype,apientryentity.outputparam", new QFilter[]{idQFilter});
            this.updateApiEntity(dyApi, pubServiceHelper, pubDys);
            HRBaseServiceHelper subServiceHelper = new HRBaseServiceHelper("hrcs_msgsubscriber");
            QFilter pubIdQFilter = new QFilter("msgpublisher.id", "in", (Object)ids);
            DynamicObject[] subDys = subServiceHelper.query("apientryentity,apientryentity.apiname,apientryentity.apinumber,apientryentity.apipubcloud,apientryentity.apipubapp,apientryentity.apidescription,apientryentity.params,apientryentity.apitype,apientryentity.apiservice,apientryentity.apimethod,apientryentity.inputparam,apientryentity.outputtype,apientryentity.outputparam", new QFilter[]{pubIdQFilter});
            this.updateApiEntity(dyApi, subServiceHelper, subDys);
        }
    }

    private void updateApiEntity(DynamicObject dyApi, HRBaseServiceHelper baseServiceHelper, DynamicObject[] subDys) {
        if (Objects.nonNull(subDys) && subDys.length > 0) {
            for (DynamicObject dynamicObject : subDys) {
                DynamicObjectCollection dyCols = (DynamicObjectCollection)dynamicObject.get("apientryentity");
                this.setDyCols(dyApi, dyCols);
            }
            baseServiceHelper.updateDatas(subDys);
        }
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new HRAPISourceSaveValidator());
    }

    private void setAPIXML(DynamicObject dy) {
        String apiXML = this.genAPISourceXML(dy);
        dy.set("apixml", (Object)apiXML);
    }

    private String genAPISourceXML(DynamicObject dy) {
        boolean isCommonApi = API_TYPE_COMMON.equalsIgnoreCase(dy.getString("type"));
        String bizCloudId = dy.getString("bizcloud.id");
        String bizAppId = dy.getString("bizapp.id");
        String isoriginal = dy.getString("isnonoriginal");
        long id = dy.getLong("id");
        long version = System.currentTimeMillis();
        String number = dy.getString("number");
        String key = dy.getString("key");
        String name = dy.getLocaleString("name").getLocaleValue();
        String description = dy.getLocaleString("description").getLocaleValue();
        String type = dy.getString("type");
        String enable = dy.getString("enable");
        String service = dy.getString("service");
        String method = dy.getString("method");
        StringBuilder apiSource = new StringBuilder();
        apiSource.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n').append('\n');
        apiSource.append("<APIMetadata>").append('\n');
        apiSource.append("\t").append("<BizCloudId>").append(bizCloudId).append("</BizCloudId>").append('\n');
        apiSource.append("\t").append("<BizAppId>").append(bizAppId).append("</BizAppId>").append('\n');
        apiSource.append("\t").append("<IsvId>").append(MsgCenterServiceHelper.getISV((String)isoriginal)).append("</IsvId>").append('\n');
        apiSource.append("\t").append("<Id>").append(id).append("</Id>").append('\n');
        apiSource.append("\t").append("<Version>").append(version).append("</Version>").append('\n');
        apiSource.append("\t").append("<Number>").append(number).append("</Number>").append('\n');
        apiSource.append("\t").append("<Key>").append(key).append("</Key>").append('\n');
        apiSource.append("\t").append("<Name>").append(name).append("</Name>").append('\n');
        apiSource.append("\t").append("<Description>").append(description).append("</Description>").append('\n');
        apiSource.append("\t").append("<ApiType>").append(type).append("</ApiType>").append('\n');
        apiSource.append("\t").append("<Service>").append(service).append("</Service>").append('\n');
        apiSource.append("\t").append("<Method>").append(method).append("</Method>").append('\n');
        this.processParam(apiSource, dy, isCommonApi);
        apiSource.append("\t").append("<Enable>").append(enable).append("</Enable>").append('\n');
        this.processApiInputDataXml(apiSource, dy, isCommonApi);
        apiSource.append("\t").append("<APIDataXml>").append('\n');
        apiSource.append(this.genAPIDataXml(dy));
        apiSource.append("\t").append("</APIDataXml>").append('\n');
        apiSource.append("</APIMetadata>");
        return apiSource.toString();
    }

    private void processParam(StringBuilder stringBuilder, DynamicObject dy, boolean isCommonApi) {
        String param = dy.getString("param");
        String inputParam = dy.getString("inputparam");
        String outputParam = dy.getString("outputparam");
        if (!isCommonApi) {
            param = inputParam;
            stringBuilder.append("\t").append("<InputParam>").append(inputParam).append("</InputParam>").append('\n');
            stringBuilder.append("\t").append("<OutputParam>").append(outputParam).append("</OutputParam>").append('\n');
        }
        stringBuilder.append("\t").append("<Param>").append(param).append("</Param>").append('\n');
    }

    private void processApiInputDataXml(StringBuilder stringBuilder, DynamicObject dy, boolean isCommonApi) {
        if (!isCommonApi) {
            stringBuilder.append("\t").append("<APIInputDataXml>").append('\n');
            List<Map<String, String>> inputApiEntitySource = this.getInputParamAPIEntitySource(dy);
            this.buildCustomApiDataSource(stringBuilder, inputApiEntitySource);
            stringBuilder.append("\t").append("</APIInputDataXml>").append('\n');
        }
    }

    private String genAPIDataXml(DynamicObject dy) {
        boolean isCommonApi = API_TYPE_COMMON.equalsIgnoreCase(dy.getString("type"));
        StringBuilder apiDataSource = new StringBuilder();
        if (isCommonApi) {
            List<Map<String, Object>> apiEntitySource = this.getAPIEntitySource(dy);
            for (Map<String, Object> apiEntity : apiEntitySource) {
                this.buildApiDataSource(apiDataSource, apiEntity);
            }
        } else {
            List<Map<String, String>> inputApiEntitySource = this.getOutputParamAPIEntitySource(dy);
            this.buildCustomApiDataSource(apiDataSource, inputApiEntitySource);
        }
        return apiDataSource.toString();
    }

    private void buildApiDataSource(StringBuilder apiDataSource, Map<String, Object> apiEntity) {
        apiDataSource.append("\t\t").append("<APIEntity>").append('\n');
        apiDataSource.append(T_THREE_TIMES).append("<Entity>").append(apiEntity.get(ENTITY_KEY)).append("</Entity>").append('\n');
        apiDataSource.append(T_THREE_TIMES).append("<Description>").append(apiEntity.get(ENTITY)).append("</Description>").append('\n');
        apiDataSource.append(T_THREE_TIMES).append("<APIFields>").append('\n');
        List apiFieldsSource = (List)apiEntity.get(API_FIELDS);
        if (apiFieldsSource != null) {
            for (Map apiField : apiFieldsSource) {
                apiDataSource.append(T_FOUR_TIMES).append("<APIField>").append('\n');
                this.apiDataSourceAppendFiveTimes(apiDataSource, apiField);
                apiDataSource.append(T_FOUR_TIMES).append("</APIField>").append('\n');
            }
        }
        apiDataSource.append(T_THREE_TIMES).append("</APIFields>").append('\n');
        apiDataSource.append("\t\t").append("</APIEntity>").append('\n');
    }

    private void buildCustomApiDataSource(StringBuilder customApiDataSource, List<Map<String, String>> apiFieldsSource) {
        customApiDataSource.append("\t\t").append("<APIEntity>").append('\n');
        customApiDataSource.append(T_THREE_TIMES).append("<APIFields>").append('\n');
        if (apiFieldsSource != null) {
            for (Map<String, String> apiField : apiFieldsSource) {
                customApiDataSource.append(T_FOUR_TIMES).append("<APIField>").append('\n');
                this.customApiDataSourceAppendFiveTimes(customApiDataSource, apiField);
                customApiDataSource.append(T_FOUR_TIMES).append("</APIField>").append('\n');
            }
        }
        customApiDataSource.append(T_THREE_TIMES).append("</APIFields>").append('\n');
        customApiDataSource.append("\t\t").append("</APIEntity>").append('\n');
    }

    private void apiDataSourceAppendFiveTimes(StringBuilder apiDataSource, Map<String, Object> apiField) {
        apiDataSource.append(T_FIVE_TIMES).append("<Key>").append(apiField.get("apiFieldKey")).append("</Key>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<Name>").append(apiField.get("apiFieldName")).append("</Name>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<Type>").append(apiField.get("apiFieldType")).append("</Type>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<QueryField>").append(apiField.get("queryField")).append("</QueryField>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<QueryFieldName>").append(apiField.get("queryFieldName")).append("</QueryFieldName>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<QueryFieldRelEntity>").append(apiField.get("queryFieldEntity")).append("</QueryFieldRelEntity>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<BaseEntityName>").append(apiField.get("baseEntityName")).append("</BaseEntityName>").append('\n');
        apiDataSource.append(T_FIVE_TIMES).append("<Enable>").append(apiField.get("enable")).append("</Enable>").append('\n');
    }

    private void customApiDataSourceAppendFiveTimes(StringBuilder customApiDataSource, Map<String, String> customApiField) {
        customApiDataSource.append(T_FIVE_TIMES).append("<Key>").append(customApiField.get("Key")).append("</Key>").append('\n');
        customApiDataSource.append(T_FIVE_TIMES).append("<Name>").append(customApiField.get("Name")).append("</Name>").append('\n');
        customApiDataSource.append(T_FIVE_TIMES).append("<Type>").append(customApiField.get("Type")).append("</Type>").append('\n');
        if (StringUtils.isNotEmpty((CharSequence)customApiField.get("Desc"))) {
            customApiDataSource.append(T_FIVE_TIMES).append("<Desc>").append(customApiField.get("Desc")).append("</Desc>").append('\n');
        }
        if (StringUtils.isNotEmpty((CharSequence)customApiField.get("Default"))) {
            customApiDataSource.append(T_FIVE_TIMES).append("<Default>").append(customApiField.get("Default")).append("</Default>").append('\n');
        }
    }

    private List<Map<String, Object>> getAPIEntitySource(DynamicObject dy) {
        DynamicObjectCollection entityEntryColl = dy.getDynamicObjectCollection("entryentity1");
        Map<String, List<Map<String, Object>>> apiFieldsSource = this.getAPIFieldsSource(dy);
        ArrayList<Map<String, Object>> entitySourceList = new ArrayList<Map<String, Object>>(entityEntryColl.size() + 1);
        for (DynamicObject entityDy : entityEntryColl) {
            HashMap<String, Object> entityInfo = new HashMap<String, Object>(6);
            String entityKey = entityDy.getString("entitykey1");
            String entity = entityDy.getLocaleString("entity1").getLocaleValue();
            entityInfo.put(ENTITY_KEY, entityKey);
            entityInfo.put(ENTITY, entity);
            entityInfo.put(API_FIELDS, apiFieldsSource.get(entityKey));
            entitySourceList.add(entityInfo);
        }
        return entitySourceList;
    }

    private List<Map<String, String>> getInputParamAPIEntitySource(DynamicObject dy) {
        return dy.getDynamicObjectCollection("inputentryentity").stream().map(it -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("Key", it.getString("inputfieldkey"));
            map.put("Name", it.getString("inputfieldname"));
            map.put("Type", it.getString("inputfieldtype"));
            map.put("Desc", it.getString("inputfielddesc"));
            map.put("Default", it.getString("inputfielddefault"));
            return map;
        }).collect(Collectors.toList());
    }

    private List<Map<String, String>> getOutputParamAPIEntitySource(DynamicObject dy) {
        return dy.getDynamicObjectCollection("outputentryentity").stream().map(it -> {
            HashMap map = Maps.newHashMapWithExpectedSize((int)16);
            map.put("Key", it.getString("outputfieldkey"));
            map.put("Name", it.getString("outputfieldname"));
            map.put("Type", it.getString("outputfieldtype"));
            map.put("Desc", it.getString("outputfielddesc"));
            map.put("Field", it.getString("basedatafield"));
            return map;
        }).collect(Collectors.toList());
    }

    private Map<String, Object> getMainEntitySource(DynamicObject dy, Map<String, List<Map<String, Object>>> apiFieldsSource) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        DynamicObject queryEntityDy = dy.getDynamicObject("mainentity");
        String queryEntity = queryEntityDy.getString("number");
        QueryEntityType queryEntityTpe = (QueryEntityType)EntityMetadataCache.getDataEntityType((String)queryEntity);
        String mainEntityKey = queryEntityTpe.getMainEntityType().getName();
        String mainEntity = queryEntityTpe.getMainEntityType().getDisplayName().getLocaleValue();
        map.put(ENTITY_KEY, mainEntityKey);
        map.put(ENTITY, mainEntity);
        map.put(API_FIELDS, apiFieldsSource.get(mainEntityKey));
        return map;
    }

    private Map<String, List<Map<String, Object>>> getAPIFieldsSource(DynamicObject dy) {
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        DynamicObjectCollection fieldEntryColl = dy.getDynamicObjectCollection("entryfield1");
        for (DynamicObject fieldDy : fieldEntryColl) {
            HashMap<String, String> fieldInfo = new HashMap<String, String>(6);
            String queryField = fieldDy.getString("queryfield1");
            String queryFieldName = fieldDy.getString("queryfieldname1");
            String queryFieldEntity = fieldDy.getString("queryfieldentity1");
            String apiFieldKey = fieldDy.getString("apifieldkey1");
            String apiFieldName = fieldDy.getString("apifieldname1");
            String apiFieldType = fieldDy.getString("apifieldtype1");
            String enable = fieldDy.getString("enablefield1");
            String baseEntityName = fieldDy.getString("baseentityname");
            fieldInfo.put("queryField", queryField);
            fieldInfo.put("queryFieldName", queryFieldName);
            fieldInfo.put("queryFieldEntity", queryFieldEntity);
            fieldInfo.put("apiFieldKey", apiFieldKey);
            fieldInfo.put("apiFieldName", apiFieldName);
            fieldInfo.put("apiFieldType", apiFieldType);
            fieldInfo.put("enable", enable);
            fieldInfo.put("baseEntityName", baseEntityName);
            if (map.containsKey(queryFieldEntity)) {
                ((List)map.get(queryFieldEntity)).add(fieldInfo);
                continue;
            }
            ArrayList<HashMap<String, String>> fieldInfoList = new ArrayList<HashMap<String, String>>();
            fieldInfoList.add(fieldInfo);
            map.put(queryFieldEntity, fieldInfoList);
        }
        return map;
    }
}

