/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.esign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealCUD;
import kd.hr.hrcs.bussiness.service.esign.bo.SealInfo;
import kd.hr.hrcs.bussiness.service.esign.constant.ESignCOSealEditPage;
import kd.hr.hrcs.bussiness.service.esign.factory.ESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.factory.ServiceRouter;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu.SealTypeMappingEnum;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.ResponseUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.opplugin.validator.esign.ESignCOSealValidator;
import org.apache.commons.collections4.CollectionUtils;

public class ESignCOSealOp
extends HRDataBaseOp
implements ESignCOSealEditPage {
    private static final Log LOGGER = LogFactory.getLog(ESignCOSealOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("corporate");
        fieldKeys.add("esignapp");
        fieldKeys.add("esignsp");
        fieldKeys.add("sealid");
        fieldKeys.add("enable");
        fieldKeys.add("thirdauditstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        ESignCOSealValidator validator = new ESignCOSealValidator();
        args.addValidator((AbstractValidator)validator);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities;
        DynamicObject dataDyn;
        super.beforeExecuteOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"delete") || HRStringUtils.equals((String)operationKey, (String)"disable") || HRStringUtils.equals((String)operationKey, (String)"enable")) {
            List validExtDataEntities = e.getValidExtDataEntities();
            int dataSize = validExtDataEntities.size();
            ArrayList<ExtendedDataEntity> sucValidExtDataEntities = new ArrayList<ExtendedDataEntity>(dataSize);
            HashSet<Object> sucessPkIdSets = new HashSet<Object>(dataSize);
            OperationResult operationResult = this.getOperationResult();
            ValidateResultCollection validateResults = operationResult.getValidateResult();
            for (ExtendedDataEntity dataEntity : validExtDataEntities) {
                DynamicObject dataDyn2 = dataEntity.getDataEntity();
                Object pkValue = dataDyn2.getPkValue();
                String thirdAuditStatus = dataDyn2.getString("thirdauditstatus");
                if (!"1".equals(thirdAuditStatus)) {
                    sucessPkIdSets.add(pkValue);
                    LOGGER.info("\u975e\u5ba1\u6838\u901a\u8fc7\u7684\u6570\u636e\uff0c\u4e0d\u8fdb\u884c\u8c03\u7528\u7b2c\u4e09\u65b9\u5220\u9664\u548c\u4fee\u6539\u72b6\u6001\u64cd\u4f5c");
                    LOGGER.info("suc pkValue:{} sucessPkIdSets.size:{}", pkValue, (Object)sucessPkIdSets.size());
                    continue;
                }
                try {
                    if (HRStringUtils.equals((String)operationKey, (String)"delete")) {
                        this.deleteSeal(dataDyn2);
                    } else {
                        this.setSealStatus(dataDyn2, operationKey);
                    }
                    sucessPkIdSets.add(pkValue);
                    LOGGER.info("suc pkValue:{} sucessPkIdSets.size:{}", pkValue, (Object)sucessPkIdSets.size());
                    sucValidExtDataEntities.add(dataEntity);
                }
                catch (Exception e2) {
                    String msg = dataDyn2.getString("number") + "\uff1a" + e2.getMessage();
                    ValidateResult validateResult = new ValidateResult();
                    ValidationErrorInfo info = new ValidationErrorInfo("", pkValue, dataEntity.getDataEntityIndex(), dataEntity.getRowIndex(), "invokeesigntrd_fail", "", msg, ErrorLevel.Error);
                    validateResult.addErrorInfo((OperateErrorInfo)info);
                    validateResult.setSuccess(false);
                    validateResults.addValidateError(operationKey, validateResult);
                }
            }
            operationResult.setSuccessPkIds(new ArrayList(sucessPkIdSets));
            if (dataSize != sucessPkIdSets.size()) {
                validExtDataEntities.clear();
                validExtDataEntities.addAll(sucValidExtDataEntities);
            }
            if (HRStringUtils.equals((String)operationKey, (String)"delete") && CollectionUtils.isNotEmpty((Collection)validExtDataEntities)) {
                Set delSealIds = validExtDataEntities.stream().map(item -> item.getDataEntity().getString("sealid")).collect(Collectors.toSet());
                LOGGER.info("delSealIds:{} delSealIds.size:{}", delSealIds, (Object)delSealIds.size());
                ESignDBServiceUtil.eSignSealAuthService.deleteByFilter(new QFilter[]{new QFilter("seal.sealid", "in", delSealIds)});
            }
        } else if (HRStringUtils.equals((String)operationKey, (String)"save") && (dataDyn = (dataEntities = e.getDataEntities())[0]).getDataEntityState().getFromDatabase() && "2".equals(dataDyn.getString("thirdauditstatus"))) {
            dataDyn.set("thirdauditstatus", (Object)"0");
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        String operationKey = e.getOperationKey();
        if (HRStringUtils.equals((String)operationKey, (String)"save")) {
            DynamicObject[] dys = e.getDataEntities();
            DynamicObject dataDyn = dys[0];
            if (dataDyn.getDataEntityState().getFromDatabase() && "1".equals(dataDyn.getString("thirdauditstatus"))) {
                this.modifySeal(dataDyn);
            } else {
                this.addSeal(dataDyn);
            }
        }
    }

    private boolean addSeal(DynamicObject dataDyn) {
        SealInfo sealInfo = new SealInfo();
        sealInfo.setOpenCorpId(this.getOwnerOpenCorpId(dataDyn));
        OrmLocaleValue sealNameOrm = (OrmLocaleValue)dataDyn.get("name");
        sealInfo.setSealName(sealNameOrm.getLocaleValue_zh_CN());
        sealInfo.setPicFileUrl(dataDyn.getString("sealpic"));
        String sealSort = dataDyn.getString("sealsortradiogrp");
        if ("larseal".equals(sealSort)) {
            sealInfo.setSealType("1060_S");
            dataDyn.set("sealtype", (Object)SealTypeMappingEnum.getSealTypeId((String)sealInfo.getSealType()));
        } else {
            DynamicObject sealTypeDyn = dataDyn.getDynamicObject("sealtype");
            sealInfo.setSealType(sealTypeDyn.getString("orinumber"));
        }
        sealInfo.setRelDataId(Long.valueOf(dataDyn.getLong("id")));
        CorporateSealCUD corporateSealCUD = this.getESignSrvFactory(dataDyn).getCorporateSealCUD();
        ResponseData responseData = corporateSealCUD.createSeal(sealInfo);
        if (ResponseUtil.invokeFail((ResponseData)responseData)) {
            LOGGER.warn("CorporateSealCUD.createSeal(sealInfo) fail, sealInfo={}", (Object)SerializationUtils.toJsonString((Object)sealInfo));
            throw new KDBizException(responseData.getMsg());
        }
        return true;
    }

    private boolean modifySeal(DynamicObject dataDyn) {
        SealInfo sealInfo = new SealInfo();
        sealInfo.setOpenCorpId(this.getOwnerOpenCorpId(dataDyn));
        OrmLocaleValue sealNameOrm = (OrmLocaleValue)dataDyn.get("name");
        sealInfo.setSealName(sealNameOrm.getLocaleValue_zh_CN());
        String sealId = dataDyn.getString("sealid");
        sealInfo.setSealId(Long.valueOf(Long.parseLong(sealId)));
        CorporateSealCUD corporateSealCUD = this.getESignSrvFactory(dataDyn).getCorporateSealCUD();
        ResponseData responseData = corporateSealCUD.modifySeal(sealInfo);
        if (ResponseUtil.invokeFail((ResponseData)responseData)) {
            LOGGER.warn("CorporateSealCUD.modifySeal(sealInfo) fail, sealInfo={}", (Object)SerializationUtils.toJsonString((Object)sealInfo));
            throw new KDBizException(responseData.getMsg());
        }
        return true;
    }

    private boolean deleteSeal(DynamicObject dataDyn) {
        SealInfo sealInfo = new SealInfo();
        sealInfo.setOpenCorpId(this.getOwnerOpenCorpId(dataDyn));
        String sealId = dataDyn.getString("sealid");
        sealInfo.setSealId(Long.valueOf(Long.parseLong(sealId)));
        CorporateSealCUD corporateSealCUD = this.getESignSrvFactory(dataDyn).getCorporateSealCUD();
        ResponseData responseData = corporateSealCUD.deleteSeal(sealInfo);
        if (ResponseUtil.invokeFail((ResponseData)responseData)) {
            LOGGER.warn("CorporateSealCUD.deleteSeal(sealInfo) fail, sealInfo={}", (Object)SerializationUtils.toJsonString((Object)sealInfo));
            throw new KDBizException(responseData.getMsg());
        }
        return true;
    }

    private boolean setSealStatus(DynamicObject dataDyn, String sealStatus) {
        SealInfo sealInfo = new SealInfo();
        sealInfo.setOpenCorpId(this.getOwnerOpenCorpId(dataDyn));
        String sealId = dataDyn.getString("sealid");
        sealInfo.setSealId(Long.valueOf(Long.parseLong(sealId)));
        sealInfo.setSealStatus(sealStatus);
        CorporateSealCUD corporateSealCUD = this.getESignSrvFactory(dataDyn).getCorporateSealCUD();
        ResponseData responseData = corporateSealCUD.setSealStatus(sealInfo);
        if (ResponseUtil.invokeFail((ResponseData)responseData)) {
            LOGGER.warn("CorporateSealCUD.setSealStatus(sealInfo) fail, sealInfo={}", (Object)SerializationUtils.toJsonString((Object)sealInfo));
            throw new KDBizException(responseData.getMsg());
        }
        return true;
    }

    private ESignSrvFactory getESignSrvFactory(DynamicObject dataDyn) {
        Long spId = dataDyn.getLong("esignsp_id");
        long appId = dataDyn.getLong("esignapp_id");
        Long mainCorporateId = ESignAppCfgUtil.getCorporateId((Long)appId);
        return ServiceRouter.getSrvFactory((Long)spId, (Long)mainCorporateId);
    }

    private String getOwnerOpenCorpId(DynamicObject dataDyn) {
        return ESignAppCfgUtil.getOwnerOpenCorpId((Long)dataDyn.getLong("esignsp_id"), (Long)dataDyn.getLong("corporate_id"));
    }
}

