/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.hismodel;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.servicehelper.hismodel.HisEntityDependentServiceHelper;
import kd.hr.hrcs.common.constants.hismodel.HisEntityDependentConstants;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityConditionVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityRelVO;
import kd.hr.hrcs.common.model.hismodel.HisEDEntityVO;
import kd.hr.hrcs.common.model.hismodel.HisEntityDependentVO;
import kd.hr.hrcs.opplugin.web.hismodel.validate.HisEntityDependentValidator;

public class HisEntityDependentOp
extends HRDataBaseOp
implements HisEntityDependentConstants {
    private static final Log LOGGER = LogFactory.getLog(HisEntityDependentOp.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new HisEntityDependentValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("delete".equals(e.getOperationKey())) {
            this.deleteOthers(dataEntities);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        try (TXHandle txHandle = TX.requiresNew();){
            try {
                if ("save".equals(e.getOperationKey())) {
                    this.saveOthers(dataEntities);
                }
            }
            catch (Exception exception) {
                LOGGER.error("HisEntityDependentOp_afterExecuteOperationTransactionError:{}", (Object)exception.getMessage());
                txHandle.markRollback();
            }
        }
    }

    private void deleteOthers(DynamicObject[] dataEntities) {
        HashSet edIdSet = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dyn : dataEntities) {
            long edId = dyn.getLong("id");
            edIdSet.add(edId);
        }
        DynamicObject[] entities = HisEntityDependentServiceHelper.getEntities((QFilter[])new QFilter[]{new QFilter("ed.id", "in", (Object)edIdSet)});
        DynamicObject[] entityRel = HisEntityDependentServiceHelper.getEntityRel((QFilter[])new QFilter[]{new QFilter("ed.id", "in", (Object)edIdSet)});
        Object[] edEntityRelIds = Arrays.stream(entityRel).map(rel -> rel.getLong("id")).toArray();
        Object[] edEntityIds = Arrays.stream(entities).map(entity -> entity.getLong("id")).toArray();
        HisEntityDependentServiceHelper.edEntityRelHelper.delete(edEntityRelIds);
        HisEntityDependentServiceHelper.edEntityHelper.delete(edEntityIds);
    }

    private void saveOthers(DynamicObject[] dataEntities) {
        DynamicObject dyn = dataEntities[0];
        long edId = dyn.getLong("id");
        DynamicObject[] entities = HisEntityDependentServiceHelper.getEntities((long)edId);
        Map<Long, DynamicObject> entityMap = Arrays.stream(entities).collect(Collectors.toMap(entity -> entity.getLong("id"), entity -> entity));
        DynamicObject[] entityRel = HisEntityDependentServiceHelper.getEntityRel((long)edId);
        Map<Long, DynamicObject> relMap = Arrays.stream(entityRel).collect(Collectors.toMap(rel -> rel.getLong("id"), rel -> rel));
        String saveData = (String)this.getOption().getVariables().get("saveData");
        List hisEntityDependentVOList = JSON.parseArray((String)saveData, HisEntityDependentVO.class);
        this.saveEntityDependent(hisEntityDependentVOList, edId, entityMap, relMap);
    }

    private void saveEntityDependent(List<HisEntityDependentVO> hisEntityDependentVOList, long edId, Map<Long, DynamicObject> entityMap, Map<Long, DynamicObject> relMap) {
        DynamicObjectCollection insertEdEntity = new DynamicObjectCollection();
        DynamicObjectCollection updateEdEntity = new DynamicObjectCollection();
        DynamicObjectCollection insertEdEntityRel = new DynamicObjectCollection();
        DynamicObjectCollection updateEdEntityRel = new DynamicObjectCollection();
        int size = 0;
        for (HisEntityDependentVO hisEntityDependentVO : hisEntityDependentVOList) {
            List edEntityList = hisEntityDependentVO.getEdEntityList();
            size += edEntityList.size();
        }
        long[] edEntityIds = ORM.create().genLongIds("hrcs_edentity", size);
        for (HisEntityDependentVO hisEntityDependentVO : hisEntityDependentVOList) {
            List edEntityList = hisEntityDependentVO.getEdEntityList();
            int i = 0;
            for (HisEDEntityVO hisEDEntityVO : edEntityList) {
                DynamicObject edEntity;
                String edEntityIdStr = hisEDEntityVO.getEdEntityId();
                if (HRStringUtils.isEmpty((String)edEntityIdStr)) {
                    edEntity = this.getNewEdEntity(edEntityIds, size, edId, hisEDEntityVO, i);
                    insertEdEntity.add((Object)edEntity);
                    --size;
                } else {
                    long edEntityId = Long.parseLong(edEntityIdStr);
                    edEntity = entityMap.remove(edEntityId);
                    updateEdEntity.add((Object)edEntity);
                }
                edEntity.set("entity", (Object)hisEDEntityVO.getEntity());
                HisEDEntityRelVO edEntityRel = hisEDEntityVO.getEdEntityRel();
                if (edEntityRel != null) {
                    DynamicObject rel;
                    String relIdStr = edEntityRel.getRelId();
                    if (HRStringUtils.isEmpty((String)relIdStr)) {
                        rel = HisEntityDependentServiceHelper.edEntityRelHelper.generateEmptyDynamicObject();
                        rel.set("ed", (Object)edId);
                        insertEdEntityRel.add((Object)rel);
                    } else {
                        long relId = Long.parseLong(relIdStr);
                        rel = relMap.remove(relId);
                        updateEdEntityRel.add((Object)rel);
                    }
                    if (HRStringUtils.isEmpty((String)edEntityRel.getEdEntityId()) || HRStringUtils.isEmpty((String)edEntityRel.getEdJoinEntityId())) {
                        HisEDEntityVO hisEDEntityVOLast = (HisEDEntityVO)edEntityList.get(i - 1);
                        rel.set("edentity", (Object)Long.parseLong(hisEDEntityVOLast.getEdEntityId()));
                        rel.set("edjoinentity", (Object)edEntity.getLong("id"));
                    }
                    this.handleConditions(rel, edEntityRel.getConditionList());
                }
                ++i;
            }
        }
        Object[] objectArray = entityMap.keySet().toArray();
        Object[] delEdEntityRelIds = relMap.keySet().toArray();
        this.executeDB(insertEdEntity, insertEdEntityRel, updateEdEntity, updateEdEntityRel, objectArray, delEdEntityRelIds);
    }

    private DynamicObject getNewEdEntity(long[] edEntityIds, int size, long edId, HisEDEntityVO hisEDEntityVO, int index) {
        long edEntityId = edEntityIds[size - 1];
        DynamicObject edEntity = HisEntityDependentServiceHelper.edEntityHelper.generateEmptyDynamicObject();
        edEntity.set("id", (Object)edEntityId);
        hisEDEntityVO.setEdEntityId(edEntityId + "");
        edEntity.set("ed", (Object)edId);
        edEntity.set("row", (Object)hisEDEntityVO.getRow());
        edEntity.set("index", (Object)index);
        return edEntity;
    }

    private void handleConditions(DynamicObject rel, List<HisEDEntityConditionVO> conditionList) {
        DynamicObjectCollection conditions = rel.getDynamicObjectCollection("entryentity");
        Map<Long, DynamicObject> conditionMap = conditions.stream().collect(Collectors.toMap(condition -> condition.getLong("id"), condition -> condition));
        for (HisEDEntityConditionVO hisEDEntityConditionVO : conditionList) {
            DynamicObject condition2;
            String conditionIdStr = hisEDEntityConditionVO.getConditionId();
            if (HRStringUtils.isEmpty((String)conditionIdStr)) {
                condition2 = conditions.addNew();
                condition2.set("comparetype", (Object)"=");
            } else {
                long conditionId = Long.parseLong(conditionIdStr);
                condition2 = conditionMap.remove(conditionId);
            }
            condition2.set("leftprop", (Object)hisEDEntityConditionVO.getLeftProp());
            condition2.set("rightprop", (Object)hisEDEntityConditionVO.getRightProp());
        }
        conditions.removeAll(conditionMap.values());
    }

    private void executeDB(DynamicObjectCollection insertEdEntity, DynamicObjectCollection insertEdEntityRel, DynamicObjectCollection updateEdEntity, DynamicObjectCollection updateEdEntityRel, Object[] delEdEntityIds, Object[] delEdEntityRelIds) {
        HisEntityDependentServiceHelper.edEntityRelHelper.delete(delEdEntityRelIds);
        HisEntityDependentServiceHelper.edEntityHelper.delete(delEdEntityIds);
        HisEntityDependentServiceHelper.edEntityHelper.save(insertEdEntity);
        HisEntityDependentServiceHelper.edEntityRelHelper.save(insertEdEntityRel);
        HisEntityDependentServiceHelper.edEntityHelper.save(updateEdEntity);
        HisEntityDependentServiceHelper.edEntityRelHelper.save(updateEdEntityRel);
    }
}

