/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.perm;

import com.alibaba.fastjson.JSONArray;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.bussiness.service.perm.HRPermCacheMgr;
import kd.hr.hrcs.bussiness.service.perm.log.EntityCtrlLogService;
import kd.hr.hrcs.common.constants.perm.log.DimRoleInfoModel;
import kd.hr.hrcs.common.constants.perm.log.EntityCtrlModel;
import kd.hr.hrcs.opplugin.validator.perm.EntityControlSaveValidator;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

@ExcludeFromJacocoGeneratedReport
public class EntityControlSaveOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new EntityControlSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        String importType = this.getOption().getVariableValue("importtype", null);
        if (HRStringUtils.equals((String)"save", (String)operationKey) && HRStringUtils.isNotEmpty((String)importType) && !HRStringUtils.equals((String)"override", (String)importType)) {
            DynamicObject[] dataEntities;
            for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
                DynamicObject biaAppDB = dataEntity.getDynamicObject("bizapp");
                DynamicObject bizApp = dataEntity.getDynamicObject("entitytype").getDynamicObject("bizappid");
                if (null != biaAppDB || null == bizApp) continue;
                dataEntity.set("bizapp", (Object)bizApp);
            }
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        String importType = this.getOption().getVariableValue("importtype", null);
        if (HRStringUtils.equals((String)"save", (String)operationKey) && HRStringUtils.isNotEmpty((String)importType) && !HRStringUtils.equals((String)"override", (String)importType)) {
            DynamicObject[] dataEntities = args.getDataEntities();
            Map variables = this.getOption().getVariables();
            List entityCtrlModels = JSONArray.parseArray((String)((String)variables.get("entityCtrlModels")), EntityCtrlModel.class);
            Map<String, EntityCtrlModel> entityCtrlModelMap = entityCtrlModels.stream().collect(Collectors.toMap(EntityCtrlModel::getEntityType, it -> it));
            List entityIds = (List)SerializationUtils.fromJsonString((String)((String)variables.get("entityIds")), List.class);
            Map syncMustDims = (Map)SerializationUtils.fromJsonString((String)((String)variables.get("syncMustDims")), Map.class);
            Map syncUnMustDims = (Map)SerializationUtils.fromJsonString((String)((String)variables.get("syncUnMustDims")), Map.class);
            Map entityBuCaMap = (Map)SerializationUtils.fromJsonString((String)((String)variables.get("entityBuCaMap")), Map.class);
            HashMap<String, Set<String>> entityRolesMap = new HashMap<String, Set<String>>(16);
            Map<String, Set<DynamicObject>> entityRoleDims = this.assembleEntityRoleDim(entityIds, entityRolesMap);
            if (MapUtils.isEmpty(entityRolesMap) || MapUtils.isEmpty(entityRoleDims)) {
                return;
            }
            this.syncMustDimToRoleDim(syncMustDims, entityRoleDims, entityRolesMap, entityBuCaMap, entityCtrlModelMap);
            this.syncUnMustDimToRoleDim(syncUnMustDims, entityRoleDims, entityBuCaMap, entityCtrlModelMap);
            if (MapUtils.isNotEmpty((Map)syncMustDims) || MapUtils.isNotEmpty((Map)syncUnMustDims)) {
                EntityCtrlLogService.resolveLog((List)Lists.newArrayList(entityCtrlModelMap.values()));
                HRPermCacheMgr.clearAllCache();
            }
        }
    }

    private void syncUnMustDimToRoleDim(Map<String, Map<String, List<String>>> syncUnMustDims, Map<String, Set<DynamicObject>> entityRoleDims, Map<String, Integer> entityBuCaMap, Map<String, EntityCtrlModel> entityCtrlModelMap) {
        if (MapUtils.isEmpty(syncUnMustDims)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        ArrayList<DynamicObject> toUpdateRoleDimList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, Map<String, List<String>>> toSyncEntry : syncUnMustDims.entrySet()) {
            long dimId = Long.parseLong(toSyncEntry.getKey());
            Map<String, List<String>> entityPropMap = toSyncEntry.getValue();
            for (Map.Entry<String, List<String>> entityPropEntry : entityPropMap.entrySet()) {
                String[] entityInfo = entityPropEntry.getKey().split("#");
                String entityId = entityInfo[0];
                String appId = entityInfo[1];
                List<String> toSyncProps = entityPropEntry.getValue();
                Set<DynamicObject> roleDims = entityRoleDims.get(entityId);
                if (CollectionUtils.isEmpty(roleDims)) continue;
                Integer buCaFunc = entityBuCaMap.get(entityId);
                ArrayList effectDimRoleInfoModelList = Lists.newArrayListWithExpectedSize((int)10);
                for (DynamicObject roleDim : roleDims) {
                    String roleId = roleDim.getString("role.id");
                    if (HRStringUtils.isEmpty((String)roleId)) continue;
                    boolean changed = false;
                    long dimensionId = roleDim.getLong("dimension.id");
                    long buCaFuncId = roleDim.getLong("bucafunc.id");
                    DynamicObjectCollection collection = roleDim.getDynamicObjectCollection("entry");
                    boolean enable = collection.stream().anyMatch(it -> it.getBoolean("enable"));
                    if (dimensionId != dimId || buCaFuncId != (long)buCaFunc.intValue() || !enable) continue;
                    Set existRowKeys = collection.stream().map(it -> it.getString("app.id") + "#" + it.getString("entitytype.id") + "#" + it.getString("propkey")).collect(Collectors.toSet());
                    for (String prop : toSyncProps) {
                        String rowKey = appId + "#" + entityId + "#" + prop;
                        if (existRowKeys.contains(rowKey)) continue;
                        DynamicObject rowInfo = collection.addNew();
                        rowInfo.set("app", (Object)appId);
                        rowInfo.set("entitytype", (Object)entityId);
                        rowInfo.set("propkey", (Object)prop);
                        rowInfo.set("enable", (Object)"1");
                        changed = true;
                    }
                    if (!changed) continue;
                    toUpdateRoleDimList.add(roleDim);
                    DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel(roleId, buCaFuncId, dimId, "add");
                    effectDimRoleInfoModelList.add(dimRoleInfoModel);
                }
                if (!entityCtrlModelMap.containsKey(entityId)) continue;
                EntityCtrlModel entityCtrlModel = entityCtrlModelMap.get(entityId);
                entityCtrlModel.getEffectDimRoleList().addAll(effectDimRoleInfoModelList);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                serviceHelper.save(toUpdateRoleDimList.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                tx.markRollback();
            }
        }
    }

    private void syncMustDimToRoleDim(Map<String, Map<String, List<String>>> syncMustDims, Map<String, Set<DynamicObject>> entityRoleDims, Map<String, Set<String>> entityRolesMap, Map<String, Integer> entityBuCaMap, Map<String, EntityCtrlModel> entityCtrlModelMap) {
        if (MapUtils.isEmpty(syncMustDims) || MapUtils.isEmpty(entityRoleDims)) {
            return;
        }
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
        ArrayList<DynamicObject> toUpdateRoleDimList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<String, Map<String, List<String>>> toSyncMustDimEntry : syncMustDims.entrySet()) {
            long dimId = Long.parseLong(toSyncMustDimEntry.getKey());
            Map<String, List<String>> entityPropMap = toSyncMustDimEntry.getValue();
            for (Map.Entry<String, List<String>> entityPropEntry : entityPropMap.entrySet()) {
                String[] entityInfo = entityPropEntry.getKey().split("#");
                String entityId = entityInfo[0];
                Integer buCaFuncId = entityBuCaMap.get(entityId);
                String appId = entityInfo[1];
                List<String> toSyncProps = entityPropEntry.getValue();
                Set<DynamicObject> roleDims = entityRoleDims.get(entityId);
                if (CollectionUtils.isEmpty(roleDims)) continue;
                HashSet toUpdateRoleDims = Sets.newHashSetWithExpectedSize((int)roleDims.size());
                ArrayList<String> hasSyncRoles = new ArrayList<String>(10);
                ArrayList effectDimRoleInfoModelList = Lists.newArrayListWithExpectedSize((int)10);
                for (DynamicObject dynamicObject : roleDims) {
                    long dimensionId = dynamicObject.getLong("dimension.id");
                    if (dimensionId != dimId) continue;
                    boolean changed = false;
                    String roleId = dynamicObject.getString("role.id");
                    hasSyncRoles.add(roleId);
                    DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entry");
                    ArrayList<String> hasSyncedProps = new ArrayList<String>(10);
                    String opType = "";
                    for (DynamicObject row : collection) {
                        String prop = row.getString("propkey");
                        if (!HRStringUtils.equals((String)entityId, (String)row.getString("entitytype.id")) || !toSyncProps.contains(prop)) continue;
                        if (!row.getBoolean("enable")) {
                            row.set("enable", (Object)"1");
                            changed = true;
                            opType = "modify";
                        }
                        hasSyncedProps.add(prop);
                    }
                    for (String prop : toSyncProps) {
                        if (hasSyncedProps.contains(prop)) continue;
                        DynamicObject rowInfo = collection.addNew();
                        rowInfo.set("app", (Object)appId);
                        rowInfo.set("entitytype", (Object)entityId);
                        rowInfo.set("propkey", (Object)prop);
                        rowInfo.set("enable", (Object)"1");
                        changed = true;
                        opType = "add";
                    }
                    if (!changed) continue;
                    toUpdateRoleDims.add(dynamicObject);
                    DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel(roleId, (long)buCaFuncId.intValue(), dimId, opType);
                    effectDimRoleInfoModelList.add(dimRoleInfoModel);
                }
                toUpdateRoleDimList.addAll(toUpdateRoleDims);
                Set<String> toAddRoles = entityRolesMap.get(entityId);
                toAddRoles.removeAll(hasSyncRoles);
                for (String roleId : toAddRoles) {
                    if (HRStringUtils.isEmpty((String)roleId) || CollectionUtils.isEmpty(toSyncProps)) continue;
                    DynamicObject roleDimTemp = serviceHelper.generateEmptyDynamicObject();
                    roleDimTemp.set("role", (Object)roleId);
                    roleDimTemp.set("dimension", (Object)dimId);
                    roleDimTemp.set("bucafunc", (Object)buCaFuncId);
                    DynamicObjectCollection collection = serviceHelper.generateEmptyEntryCollection(roleDimTemp, "entry");
                    for (String toSyncProp : toSyncProps) {
                        DynamicObject rowInfo = collection.addNew();
                        rowInfo.set("app", (Object)appId);
                        rowInfo.set("entitytype", (Object)entityId);
                        rowInfo.set("propkey", (Object)toSyncProp);
                        rowInfo.set("enable", (Object)"1");
                    }
                    toUpdateRoleDimList.add(roleDimTemp);
                    DimRoleInfoModel dimRoleInfoModel = new DimRoleInfoModel(roleId, (long)buCaFuncId.intValue(), dimId, "add");
                    effectDimRoleInfoModelList.add(dimRoleInfoModel);
                }
                if (!entityCtrlModelMap.containsKey(entityId)) continue;
                EntityCtrlModel entityCtrlModel = entityCtrlModelMap.get(entityId);
                entityCtrlModel.getEffectDimRoleList().addAll(effectDimRoleInfoModelList);
            }
        }
        try (TXHandle tx = TX.requiresNew();){
            try {
                serviceHelper.save(toUpdateRoleDimList.toArray(new DynamicObject[0]));
            }
            catch (Exception ex) {
                tx.markRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Set<DynamicObject>> assembleEntityRoleDim(List<String> entityIds, Map<String, Set<String>> entityRolesMapRet) {
        if (CollectionUtils.isEmpty(entityIds)) {
            return new HashMap<String, Set<DynamicObject>>(16);
        }
        DataSet ds = null;
        try {
            DynamicObject[] roleDimArr;
            String algoKey = "EntityControlSaveValidator.assembleRoleRefEntity";
            String entityIdStr = entityIds.stream().map(it -> "'" + it + "'").collect(Collectors.joining(","));
            ds = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"sys"), (String)("select fentitytypeid,froleid from t_perm_rolepermdetial where fentitytypeid in ( " + entityIdStr + ")"));
            HashMap<String, Set> entityRolesMap = new HashMap<String, Set>(16);
            ArrayList<String> roleIds = new ArrayList<String>(10);
            while (ds.hasNext()) {
                Row next = ds.next();
                String entityId = next.getString("fentitytypeid");
                String roleId = next.getString("froleid");
                DynamicObject[] roles = entityRolesMap.computeIfAbsent(entityId, key -> new HashSet(16));
                roles.add(roleId);
                roleIds.add(roleId);
            }
            entityRolesMapRet.putAll(entityRolesMap);
            HashMap<String, List> roleDynaMap = new HashMap<String, List>(16);
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_roledimension");
            for (DynamicObject roleDim : roleDimArr = serviceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("role", "in", roleIds)})) {
                String roleId = roleDim.getString("role.id");
                if (HRStringUtils.isEmpty((String)roleId)) continue;
                List roleDimList = roleDynaMap.computeIfAbsent(roleId, key -> new ArrayList(10));
                roleDimList.add(roleDim);
            }
            HashMap entityRoleDimMap = new HashMap(16);
            for (Map.Entry entityRoles : entityRolesMap.entrySet()) {
                String entity = (String)entityRoles.getKey();
                Set roles = (Set)entityRoles.getValue();
                HashSet roleDims = new HashSet(16);
                roles.stream().filter(roleDynaMap::containsKey).forEach(role -> roleDims.addAll((Collection)roleDynaMap.get(role)));
                entityRoleDimMap.put(entity, roleDims);
            }
            HashMap hashMap = entityRoleDimMap;
            return hashMap;
        }
        finally {
            if (null != ds) {
                ds.close();
            }
        }
    }
}

