/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.perm;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.opplugin.validator.UserPermFilesSaveValidator;

@ExcludeFromJacocoGeneratedReport
public class UserPermfileSaveOp
extends HRDataBaseOp {
    private static final String PERM_FILE_GRP = "permfilegrp";
    private static final String PERM_FILE = "permfile";
    private static final Log LOGGER = LogFactory.getLog(UserPermfileSaveOp.class);

    public void onAddValidators(AddValidatorsEventArgs args) {
        this.getOption().setVariableValue("ignorerefentityids", "hrcs_permorgentry");
        args.addValidator((AbstractValidator)new UserPermFilesSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("importflag");
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        super.endOperationTransaction(args);
        for (DynamicObject userPermfile : args.getDataEntities()) {
            DynamicObject permfilegrp = userPermfile.getDynamicObject(PERM_FILE_GRP);
            DynamicObject member = userPermfile.getDynamicObject("permfilegrpmember");
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_permfilegrpmember");
            if (Objects.nonNull(member) && Objects.nonNull(permfilegrp)) {
                LOGGER.info("modify endOperationTransaction infos : permfilegrpmemberId = {}, userPermfileId = {}, permfilegrpId = {}", new Object[]{member.getLong("id"), userPermfile.getLong("id"), permfilegrp.getLong("id")});
                DynamicObject dynamicObject = helper.queryOne("id,permfile,permfilegrp", member.get("id"));
                dynamicObject.set(PERM_FILE, (Object)userPermfile.getLong("id"));
                dynamicObject.set(PERM_FILE_GRP, (Object)permfilegrp.getLong("id"));
                helper.updateOne(dynamicObject);
                return;
            }
            if (Objects.isNull(member) && Objects.nonNull(permfilegrp)) {
                LOGGER.info("add endOperationTransaction infos : permfileId = {}, permfilegrpId = {}", (Object)userPermfile.getLong("id"), (Object)permfilegrp.getLong("id"));
                DynamicObject permfilegrpmember = helper.generateEmptyDynamicObject();
                permfilegrpmember.set(PERM_FILE, (Object)userPermfile.getLong("id"));
                permfilegrpmember.set(PERM_FILE_GRP, (Object)permfilegrp.getLong("id"));
                helper.save(new DynamicObject[]{permfilegrpmember});
            }
            if (!Objects.isNull(permfilegrp) || !Objects.nonNull(member)) continue;
            QFilter qfilter = new QFilter(PERM_FILE, "=", (Object)userPermfile.getLong("id"));
            helper.deleteByFilter(new QFilter[]{qfilter});
        }
    }
}

