/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.privacy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;

@ExcludeFromJacocoGeneratedReport
public class DataRoleConfigSaveOp
extends HRDataBaseOp {
    private static final String ROLE_ID = "role.id";
    private static final String ROLE_SORT_ID = "rolesort.id";

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        DynamicObject[] dataEntities = args.getDataEntities();
        List roleIdList = Stream.of(dataEntities).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_retentionconfig");
        DynamicObject[] retentionPeriods = serviceHelper.query("id,role,entryentity,entryentity.rolesort,entryentity.retentionperiod", new QFilter[]{new QFilter("role", "in", roleIdList)});
        if (retentionPeriods.length != 0) {
            Map<Long, List<DynamicObject>> retentionPeriodGroup = Arrays.stream(retentionPeriods).collect(Collectors.groupingBy(retentionPeriod -> retentionPeriod.getLong(ROLE_ID)));
            DynamicObjectCollection saveRetentionPeriod = new DynamicObjectCollection();
            DynamicObject[] dynamicObjectArray = dataEntities;
            int n = dynamicObjectArray.length;
            for (int i = 0; i < n; ++i) {
                DynamicObject dataEntity2 = dynamicObjectArray[i];
                List<DynamicObject> dynamicObjectList = retentionPeriodGroup.get(dataEntity2.getLong("id"));
                if (CollectionUtils.isEmpty(dynamicObjectList)) continue;
                DynamicObjectCollection entry = dataEntity2.getDynamicObjectCollection("entryentity");
                Set newSortIdSet = entry.stream().map(row -> row.getLong("id")).collect(Collectors.toSet());
                dynamicObjectList.forEach(dyn -> {
                    DynamicObjectCollection oldEntry = dyn.getDynamicObjectCollection("entryentity");
                    Set oldSortIdSet = dyn.getDynamicObjectCollection("entryentity").stream().map(row -> row.getLong(ROLE_SORT_ID)).collect(Collectors.toSet());
                    if (!newSortIdSet.containsAll(oldSortIdSet) || newSortIdSet.size() != oldSortIdSet.size()) {
                        oldSortIdSet.stream().filter(oldSortId -> !newSortIdSet.contains(oldSortId)).forEach(oldSortId -> oldEntry.removeIf(oldRow -> Objects.equals(oldSortId, oldRow.getLong(ROLE_SORT_ID))));
                        newSortIdSet.stream().filter(newSortId -> !oldSortIdSet.contains(newSortId)).forEach(newSortId -> {
                            DynamicObject newRow = oldEntry.addNew();
                            newRow.set("rolesort", newSortId);
                        });
                        saveRetentionPeriod.add(dyn);
                    }
                });
            }
            serviceHelper.save(saveRetentionPeriod);
        }
        DataEntityCacheManager cacheManager = new DataEntityCacheManager("t_hrcs_datasortentry");
        for (DynamicObject dataEntity3 : dataEntities) {
            DynamicObjectCollection entry = dataEntity3.getDynamicObjectCollection("entryentity");
            entry.forEach(row -> cacheManager.removeByPrimaryKey(new Object[]{row.getLong("id")}));
        }
    }
}

