/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.privacy;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.hr.hrcs.opplugin.validator.privacy.RetentionConfigValidator;

@ExcludeFromJacocoGeneratedReport
public class RetentionConfigSaveOp
extends HRDataBaseOp {
    private static final String BASE_DATA_ID = "fbasedataid";

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new RetentionConfigValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] results;
        HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("hrcs_retentionconfig");
        DynamicObject[] dataEntities = args.getDataEntities();
        List idList = Stream.of(dataEntities).filter(dataEntity -> dataEntity.get("id") != null).map(dataEntity -> dataEntity.getLong("id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> group = Stream.of(dataEntities).collect(Collectors.groupingBy(dataEntity -> dataEntity.getLong("role.id")));
        for (DynamicObject result : results = serviceHelper.query("id,role,bizappid", new QFilter[]{new QFilter("role.id", "in", group.keySet()), new QFilter("id", "not in", idList)})) {
            List<DynamicObject> dynamicObjectList = group.get(result.getLong("role.id"));
            if (dynamicObjectList == null) continue;
            HashSet appIdSet = Sets.newHashSetWithExpectedSize((int)dynamicObjectList.size());
            dynamicObjectList.forEach(dynamicObject -> {
                DynamicObjectCollection apps = dynamicObject.getDynamicObjectCollection("bizappid");
                appIdSet.addAll(apps.stream().map(app -> app.getDynamicObject(BASE_DATA_ID).getString("id")).collect(Collectors.toSet()));
            });
            DynamicObjectCollection apps = result.getDynamicObjectCollection("bizappid");
            StringBuilder stringBuilder = new StringBuilder();
            apps.forEach(app -> {
                DynamicObject appDyn = app.getDynamicObject(BASE_DATA_ID);
                if (appDyn != null && appIdSet.contains(appDyn.getString("id"))) {
                    stringBuilder.append(app.getDynamicObject(BASE_DATA_ID).getString("name")).append(',');
                }
            });
            if (stringBuilder.length() == 0) continue;
            args.setCancelMessage(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u7528\u5df2\u7ecf\u7ef4\u62a4\u4e86\u201c%2$s\u201d\u6570\u636e\u4e3b\u4f53\u7684\u7559\u5b58\u671f\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"RetentionConfigSaveOp_0", (String)"hrmp-hrcs-opplugin", (Object[])new Object[]{stringBuilder.substring(0, stringBuilder.length() - 1), result.getString("role.name")}));
            args.setCancel(true);
        }
    }
}

