/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.opplugin.web.validator;

import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class PromptSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        String operationKey = this.getOperateKey();
        if ("save".equals(operationKey)) {
            this.validateAppAndCloud(datas);
        }
    }

    private void validateAppAndCloud(ExtendedDataEntity[] datas) {
        for (ExtendedDataEntity extendedDataEntity : datas) {
            DynamicObject prompt = extendedDataEntity.getDataEntity();
            DynamicObject buDy = prompt.getDynamicObject("businessobject");
            DynamicObject appDy = prompt.getDynamicObject("app");
            DynamicObject cloudDy = prompt.getDynamicObject("cloud");
            Optional.ofNullable(buDy).ifPresent(dy -> {
                if (!Objects.equals(dy.getString("bizappid.id"), Objects.nonNull(appDy) ? appDy.getPkValue() : null)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u5bf9\u8c61\u4e0e\u5e94\u7528\u4e0d\u5339\u914d\u3002", (String)"PromptSaveValidator_8", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
            });
            Optional.ofNullable(appDy).ifPresent(dy -> {
                if (!Objects.equals(dy.getString("bizcloud.id"), Objects.nonNull(cloudDy) ? cloudDy.getPkValue() : null)) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5e94\u7528\u4e0e\u4e91\u4e0d\u5339\u914d\u3002", (String)"PromptSaveValidator_9", (String)"hrmp-hrcs-opplugin", (Object[])new Object[0]));
                }
            });
        }
    }
}

