/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.demo;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.enums.AnonymousTypeEnum;
import kd.hr.hbp.common.util.HRDateTimeUtils;

public class MsgConsumer
implements MessageConsumer {
    private static Log logger = LogFactory.getLog(MsgConsumer.class);

    public void onMessage(Object obj, String msgId, boolean resend, MessageAcker acker) {
        List dataSubjectIds;
        String dataSubjectIdType;
        String bizAppId;
        try {
            Map body = (Map)obj;
            logger.info("body:{}", (Object)body.toString());
            bizAppId = (String)body.get("bizAppId");
            dataSubjectIdType = (String)body.get("dataSubjectIdType");
            dataSubjectIds = (List)body.get("dataSubjectIds");
            if (StringUtils.isEmpty((CharSequence)bizAppId) || StringUtils.isEmpty((CharSequence)dataSubjectIdType) || CollectionUtils.isEmpty((Collection)dataSubjectIds)) {
                return;
            }
            DynamicObject[] rc = RequestContext.get();
            logger.info("TenantId:{},AccountId:{}", (Object)rc.getTenantId(), (Object)rc.getAccountId());
            logger.info("msgId:{}", (Object)msgId);
            logger.info("resend:{}", (Object)resend);
            acker.ack(msgId);
        }
        catch (Throwable e) {
            acker.deny(msgId);
            logger.error("Consumption_Message_Exception\uff1a", e);
            return;
        }
        DynamicObject[] colls = (DynamicObject[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"getPrivacyRelation", (Object[])new Object[]{bizAppId, dataSubjectIdType});
        if (null == colls || colls.length == 0) {
            return;
        }
        for (DynamicObject privacySaveConfigDy : colls) {
            DynamicObject anonymousRuleDy = privacySaveConfigDy.getDynamicObject("anonymousid");
            String anonymousType = anonymousRuleDy.getString("anonymoustype");
            String params = anonymousRuleDy.getString("params");
            String handleClass = anonymousRuleDy.getString("handleclass");
            if (AnonymousTypeEnum.CUSTOM.getName().equals(anonymousType)) continue;
            Object result = MsgConsumer.invoke(handleClass, "getPrivacyRuleResult", params, null);
            DynamicObjectCollection entryColls = privacySaveConfigDy.getDynamicObjectCollection("entityentry");
            if (null == entryColls || entryColls.isEmpty()) {
                return;
            }
            HashMap ormMap = Maps.newHashMapWithExpectedSize((int)16);
            HashMap sqlMap = Maps.newHashMapWithExpectedSize((int)16);
            for (DynamicObject entryDy : entryColls) {
                Set fieldSet;
                String key;
                DynamicObject entityDy = entryDy.getDynamicObject("entity");
                String table = entryDy.getString("table");
                String privacyField = entryDy.getString("privacyfield");
                String personField = entryDy.getString("personfield");
                String personFieldIdType = entryDy.getString("personfieldtype");
                if (entityDy != null && StringUtils.isNotEmpty((CharSequence)table) && StringUtils.isNotEmpty((CharSequence)privacyField) && StringUtils.isNotEmpty((CharSequence)personField) && StringUtils.isNotEmpty((CharSequence)personFieldIdType)) {
                    key = this.getMapKey(entityDy.getString("number"), personField, personFieldIdType);
                    fieldSet = ormMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)4));
                    fieldSet.add(privacyField);
                    ormMap.put(key, fieldSet);
                    continue;
                }
                if (!StringUtils.isNotEmpty((CharSequence)table) || !StringUtils.isNotEmpty((CharSequence)privacyField) || !StringUtils.isNotEmpty((CharSequence)personField) || !StringUtils.isNotEmpty((CharSequence)personFieldIdType)) continue;
                key = this.getMapKey(table, personField, personFieldIdType);
                fieldSet = sqlMap.getOrDefault(key, Sets.newHashSetWithExpectedSize((int)4));
                fieldSet.add(privacyField);
                sqlMap.put(key, fieldSet);
            }
            logger.info("ormMap:{}", (Object)((Object)ormMap).toString());
            for (Map.Entry entry : ormMap.entrySet()) {
                DynamicObject[] datas;
                String[] keys = ((String)entry.getKey()).split(",");
                HRBaseServiceHelper helper = new HRBaseServiceHelper(keys[0]);
                List<Object> ids = this.idTransformation(dataSubjectIds, dataSubjectIdType, keys[2]);
                QFilter filter = new QFilter(keys[1], "in", ids);
                for (DynamicObject data : datas = helper.loadDynamicObjectArray(new QFilter[]{filter})) {
                    IDataEntityType basedataEntityType = data.getDataEntityType();
                    for (String field : (Set)entry.getValue()) {
                        String type = ((IDataEntityProperty)basedataEntityType.getProperties().get((Object)field)).getPropertyType().getTypeName();
                        if ("java.util.Date".equals(type)) {
                            try {
                                Date date = result == null ? null : HRDateTimeUtils.parseDate((String)result.toString());
                                data.set(field, (Object)date);
                            }
                            catch (ParseException exc) {
                                logger.error("setField error:filed={},value={}", (Object)field, result);
                            }
                            continue;
                        }
                        try {
                            data.set(field, result);
                        }
                        catch (Exception exc) {
                            logger.error("setField error:filed={},value={}", (Object)field, result);
                        }
                    }
                }
                helper.save(datas);
            }
            logger.info("sqlMap:{}", (Object)((Object)sqlMap).toString());
            for (Map.Entry entry : sqlMap.entrySet()) {
                ArrayList results = Lists.newArrayListWithExpectedSize((int)((Set)entry.getValue()).size());
                String[] keys = ((String)entry.getKey()).split(",");
                StringBuilder sb = new StringBuilder();
                sb.append(" update ").append(keys[0]).append(" set ");
                for (String field : (Set)entry.getValue()) {
                    sb.append(field).append("=?,");
                    results.add(result);
                }
                sb.deleteCharAt(sb.length() - 1);
                List<Object> ids = this.idTransformation(dataSubjectIds, dataSubjectIdType, keys[2]);
                sb.append(" where ").append(keys[1]).append(" in( ").append(this.genQuestionMark(ids.size())).append(")");
                results.addAll(ids);
                logger.info("sql:{}", (Object)sb.toString());
                logger.info("param:{}", results.toArray());
            }
        }
        Object[] pk = (Object[])HRMServiceHelper.invokeHRMPService((String)"hrcs", (String)"IHRCSPrivacyService", (String)"setExecStatueCompletedBatch", (Object[])new Object[]{bizAppId, dataSubjectIdType, dataSubjectIds, new Date()});
        if (null != pk && pk.length == dataSubjectIds.size()) {
            logger.info("setExecStatueCompleted_success!");
        } else if (null == pk || 0 == pk.length) {
            logger.error("setExecStatueCompleted_fail!");
        } else {
            logger.error("setExecStatueCompleted_Partial_success!hrcs_retaineddueperson_pk:{}", (Object)Arrays.toString(pk));
        }
    }

    private String genQuestionMark(int size) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            sb.append("?,");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    private List<Object> idTransformation(List<Object> dataSubjectIds, String dataSubjectIdType, String personFieldIdType) {
        if (dataSubjectIdType.equals(personFieldIdType)) {
            return dataSubjectIds;
        }
        return dataSubjectIds;
    }

    private String getPrivacyRelationKey(String bizAppId, String dataSubjectIdType) {
        return String.format(Locale.ROOT, "%s_%s_%s", "privacyRelation", bizAppId, dataSubjectIdType);
    }

    private String getMapKey(Object ... args) {
        return String.format(Locale.ROOT, "%s,%s,%s", args);
    }

    protected static Object invoke(String clazzName, String methodName, String params, Object data) {
        String errMsg = "MsgConsumer invoke Class error :";
        try {
            Class<?> clazz = Class.forName(clazzName);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod(methodName, String.class, Object.class);
            return method.invoke(instance, params, data);
        }
        catch (ClassNotFoundException e) {
            logger.error("ClassNotFoundException:", (Throwable)e);
        }
        catch (InstantiationException e) {
            logger.error("InstantiationException:", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            logger.error("IllegalAccessException:", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            logger.error("NoSuchMethodException:", (Throwable)e);
        }
        catch (SecurityException e) {
            logger.error("SecurityException:", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            logger.error("IllegalArgumentException:", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            logger.error("InvocationTargetException:", (Throwable)e);
        }
        return null;
    }
}

