/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.domain.service.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.hr.hrcs.bussiness.domain.repository.hismodel.EventEntityRepository;
import kd.hr.hrcs.bussiness.service.hismodel.model.constant.HisSystemConstants;

public class HisAppDefultEventService
implements HisSystemConstants {
    private static volatile HisAppDefultEventService service = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HisAppDefultEventService getInstance() {
        if (service != null) return service;
        Class<HisAppDefultEventService> clazz = HisAppDefultEventService.class;
        synchronized (HisAppDefultEventService.class) {
            if (service != null) return service;
            service = new HisAppDefultEventService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return service;
        }
    }

    public boolean checkRepeat(Long id, DynamicObject actionApp) {
        QFilter qFilter = new QFilter("id", "!=", (Object)id);
        DynamicObject[] result = EventEntityRepository.getOriginalDynamicObjects("hrcs_appdefaultevent", qFilter, "actionapp,evententity");
        List appIdList = Arrays.stream(result).map(dy -> dy.getString("actionapp")).collect(Collectors.toList());
        return appIdList.contains(actionApp.getString("id"));
    }

    public boolean checkModify(boolean fromDatabase, DynamicObject actionApp) {
        if (fromDatabase) {
            return HisAppDefultEventService.checkHasData(actionApp);
        }
        return false;
    }

    private static boolean checkHasData(DynamicObject actionApp) {
        QFilter dataFilter;
        String appId = actionApp.getString("id");
        QFilter qFilter = new QFilter("bizappid", "=", (Object)appId);
        DynamicObject[] result = EventEntityRepository.getOriginalDynamicObjects("bos_entityobject", qFilter, "id");
        List entitys = Arrays.stream(result).map(dy -> dy.getString("id")).collect(Collectors.toList());
        QFilter noFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        DynamicObject[] entityDys = EventEntityRepository.getOriginalDynamicObjects("hrcs_entityevent", noFilter, "entity");
        List customEntitys = Arrays.stream(entityDys).map(dy -> dy.getString("entity")).collect(Collectors.toList());
        List noAllocateEntitys = entitys.stream().filter(id -> !customEntitys.contains(id)).collect(Collectors.toList());
        String actionAppId = actionApp.getString("id");
        QFilter appDefaultEventFilter = new QFilter("actionapp", "=", (Object)actionAppId);
        DynamicObject appDefaultEventDy = EventEntityRepository.getOriginalDynamicObject("hrcs_appdefaultevent", appDefaultEventFilter, "evententity");
        Long eventEntityId = appDefaultEventDy.getLong("evententity");
        QFilter eventEntityFilter = new QFilter("id", "=", (Object)eventEntityId);
        DynamicObject eventEntityDy = EventEntityRepository.getOriginalDynamicObject("hrcs_evententityreg", eventEntityFilter, "busevententity");
        String buseventEntity = eventEntityDy.getString("busevententity");
        DynamicObject[] dataResult = EventEntityRepository.getOriginalDynamicObjects(buseventEntity, dataFilter = new QFilter("sourceentity", "in", noAllocateEntitys), "sourceentity");
        return dataResult.length > 0;
    }

    public String checkDelete(DynamicObject actionApp, DynamicObject eventEntity) {
        String msg = null;
        boolean hasData = this.checkHasData(actionApp, eventEntity);
        if (hasData) {
            msg = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff0c\u201c%s\u201d\u5e94\u7528\u4e0b\u7684\u5b9e\u4f53\u5728\u8be5\u4e8b\u52a1\u7ec4\u4e2d\u5df2\u5b58\u5728\u6570\u636e\u3002", (String)"HisAppDefultEventService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), actionApp.getString("name"));
        }
        return msg;
    }

    private boolean checkHasData(DynamicObject actionApp, DynamicObject eventEntity) {
        QFilter dataFilter;
        String appId = actionApp.getString("id");
        QFilter qFilter = new QFilter("bizappid", "=", (Object)appId);
        DynamicObject[] result = EventEntityRepository.getOriginalDynamicObjects("bos_entityobject", qFilter, "id");
        List entitys = Arrays.stream(result).map(dy -> dy.getString("id")).collect(Collectors.toList());
        QFilter noFilter = QFilter.of((String)"1==1", (Object[])new Object[0]);
        DynamicObject[] entityDys = EventEntityRepository.getOriginalDynamicObjects("hrcs_entityevent", noFilter, "entity");
        List customEntitys = Arrays.stream(entityDys).map(dy -> dy.getString("entity")).collect(Collectors.toList());
        List noAllocateEntitys = entitys.stream().filter(id -> !customEntitys.contains(id)).collect(Collectors.toList());
        if (eventEntity == null) {
            return false;
        }
        String entityId = eventEntity.getString("id");
        QFilter eventEntityFilter = new QFilter("id", "=", (Object)Long.parseLong(entityId));
        DynamicObject eventEntityDy = EventEntityRepository.getOriginalDynamicObject("hrcs_evententityreg", eventEntityFilter, "busevententity");
        String buseventEntity = eventEntityDy.getString("busevententity");
        DynamicObject[] dataResult = EventEntityRepository.getOriginalDynamicObjects(buseventEntity, dataFilter = new QFilter("sourceentity", "in", noAllocateEntitys), "sourceentity");
        return dataResult.length > 0;
    }
}

