/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.formula.function;

import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRStringUtils;

public class FuncDefineSplitHelper {
    private static final String LEFTBRACE = "{";
    private static final String RIGHTBRACE = "}";
    private static final char EMPTY = ' ';
    private static final String EMPTYSTRING = " ";
    private static final String COMMA = ",";
    private static final Character LPARENTHESES = Character.valueOf('(');
    private static final String RPARENTHESES = ")";

    public static String createMethodExp(String funcExp) {
        funcExp = funcExp.replace("\\t", "    ");
        String[] lines = funcExp.split("\\r?\\n");
        String lineText = null;
        StringBuilder methodStr = new StringBuilder();
        boolean firstLeftBrace = false;
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            int index;
            lineText = lines[i].trim();
            if (HRStringUtils.isEmpty((String)lineText)) continue;
            if (firstLeftBrace) {
                if (methodStr.length() == 0) {
                    methodStr.append(lineText);
                    continue;
                }
                methodStr.append('\n').append(lineText);
                continue;
            }
            int len = lineText.length();
            for (index = 0; index < len; ++index) {
                String ch = String.valueOf(lineText.charAt(index));
                if (!HRStringUtils.equals((String)ch, (String)LEFTBRACE)) continue;
                firstLeftBrace = true;
                break;
            }
            if (index >= len - 1) continue;
            methodStr.append(lineText.substring(index + 1, len));
        }
        return methodStr.toString();
    }

    public static String formatMethodExp(String funcExp) {
        funcExp = funcExp.replace("\\t", "    ");
        String[] lines = funcExp.split("\\r?\\n");
        String lineText = null;
        StringBuilder methodStr = new StringBuilder();
        Stack<String> leftBraceStack = new Stack<String>();
        for (String line : lines) {
            lineText = line.trim();
            if (HRStringUtils.isEmpty((String)lineText)) continue;
            FuncDefineSplitHelper.parseLineText(methodStr, lineText, leftBraceStack);
        }
        if (!leftBraceStack.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5b58\u5728\u9519\u8bef\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u5927\u62ec\u53f7{", (String)"FuncDefineSplitHelper_0", (String)"swc-hsbs-business", (Object[])new Object[0]));
        }
        return methodStr.toString().trim();
    }

    private static void parseLineText(StringBuilder methodStr, String lineText, Stack<String> leftBraceStack) {
        int len = lineText.length();
        int index = 0;
        int fromIndex = 0;
        int toIndex = 0;
        while (index < len) {
            String ch = String.valueOf(lineText.charAt(index));
            if (HRStringUtils.equals((String)ch, (String)LEFTBRACE)) {
                leftBraceStack.push(ch);
                toIndex = index;
                FuncDefineSplitHelper.addCodeStr(ch, methodStr, lineText, fromIndex, toIndex, leftBraceStack);
                fromIndex = index + 1;
                ++index;
                continue;
            }
            if (HRStringUtils.equals((String)ch, (String)RIGHTBRACE)) {
                if (leftBraceStack.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5b58\u5728\u9519\u8bef\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u5927\u62ec\u53f7}", (String)"FuncDefineSplitHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]));
                }
                leftBraceStack.pop();
                if (methodStr.length() != 0 && '\t' == methodStr.charAt(methodStr.length() - 1)) {
                    methodStr.deleteCharAt(methodStr.length() - 1);
                }
                toIndex = index;
                FuncDefineSplitHelper.addCodeStr(ch, methodStr, lineText, fromIndex, toIndex, leftBraceStack);
                fromIndex = index + 1;
                ++index;
                continue;
            }
            if (HRStringUtils.equals((String)ch, (String)String.valueOf(LPARENTHESES)) || HRStringUtils.equals((String)ch, (String)RPARENTHESES) || HRStringUtils.equals((String)ch, (String)COMMA) || HRStringUtils.equals((String)ch, (String)";")) {
                toIndex = index;
                FuncDefineSplitHelper.addCodeStr(ch, methodStr, lineText, fromIndex, toIndex, leftBraceStack);
                fromIndex = index + 1;
                ++index;
                continue;
            }
            if (HRStringUtils.equals((String)ch, (String)EMPTYSTRING)) {
                if (fromIndex < index) {
                    toIndex = index;
                    FuncDefineSplitHelper.addCodeStr(ch, methodStr, lineText, fromIndex, toIndex, leftBraceStack);
                    fromIndex = index + 1;
                } else {
                    methodStr.append(' ');
                    fromIndex = index + 1;
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (fromIndex < len) {
            if (toIndex < len) {
                toIndex = len;
            }
            methodStr.append(lineText, fromIndex, toIndex);
        }
    }

    private static void addCodeStr(String key, StringBuilder methodStr, String lineText, int fromIndex, int toIndex, Stack<String> leftBraceStack) {
        methodStr.append(lineText, fromIndex, toIndex);
        if (!(RIGHTBRACE.equals(key) || ";".equals(key) || String.valueOf(LPARENTHESES).equals(key) || RPARENTHESES.equals(key) || COMMA.equals(key) || methodStr.length() == 0 || LPARENTHESES.equals(Character.valueOf(methodStr.charAt(methodStr.length() - 1))) || ' ' == methodStr.charAt(methodStr.length() - 1))) {
            methodStr.append(' ');
        }
        if (!HRStringUtils.equals((String)key, (String)EMPTYSTRING)) {
            methodStr.append(key);
        }
        if ((LEFTBRACE.equals(key) || RIGHTBRACE.equals(key) || ";".equals(key)) && lineText.length() - 1 == toIndex) {
            methodStr.append('\n');
            for (int i = 0; i < leftBraceStack.size(); ++i) {
                methodStr.append('\t');
            }
        }
    }
}

