/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.formula.function;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.service.formula.entity.item.FunctionItem;
import kd.hr.hbp.business.service.formula.entity.item.TreeNodeItem;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hrcs.bussiness.service.formula.FuctionTypeHelper;
import org.apache.commons.collections4.CollectionUtils;

public class FunctionDataHelper {
    private static final Log logger = LogFactory.getLog(FunctionDataHelper.class);
    private static final HRBaseServiceHelper APP_HELPER = new HRBaseServiceHelper("bos_devportal_bizapp");

    public static DynamicObject[] getFunctionArrayByAppNumber(String appNumber, boolean isShowAllFunction, Set<String> extFuncTypeNumbers, Set<String> extFuncTypeNames) {
        logger.info("appNumber:{}", (Object)appNumber);
        FuctionTypeHelper.dealHistoryData();
        ArrayList hrComFunctionTypeIds = FuctionTypeHelper.queryHRComFunctionTypeIds();
        ArrayList functionTypeIds = CollectionUtils.isNotEmpty(hrComFunctionTypeIds) ? hrComFunctionTypeIds : Lists.newArrayListWithExpectedSize((int)16);
        DynamicObject appId = APP_HELPER.queryOne("id", new QFilter("number", "=", (Object)appNumber));
        if (Objects.nonNull(appId)) {
            String id = appId.getString("id");
            functionTypeIds.addAll((Collection)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)"select fid as \"id\" from t_hrcs_fttypeappscope where fbasedataid = ?", (Object[])new Object[]{id}, rs -> {
                ArrayList<Long> arrayList = new ArrayList<Long>(16);
                while (rs.next()) {
                    arrayList.add(rs.getLong("id"));
                }
                return arrayList;
            }));
        }
        if (CollectionUtils.isNotEmpty(extFuncTypeNumbers) || CollectionUtils.isNotEmpty(extFuncTypeNames)) {
            StringBuilder querySql = new StringBuilder("select fid as \"id\" from t_hrcs_functiontype where ");
            if (CollectionUtils.isNotEmpty(extFuncTypeNumbers)) {
                querySql.append("fnumber in ('").append(extFuncTypeNumbers.stream().collect(Collectors.joining("','"))).append("') ");
            }
            if (CollectionUtils.isNotEmpty(extFuncTypeNumbers) && CollectionUtils.isNotEmpty(extFuncTypeNames)) {
                querySql.append(" or ");
            }
            if (CollectionUtils.isNotEmpty(extFuncTypeNames)) {
                querySql.append("fname in ('").append(extFuncTypeNames.stream().collect(Collectors.joining("','"))).append("') ");
            }
            List extFuncTypeIds = (List)HRDBUtil.query((DBRoute)new DBRoute("hmp"), (String)querySql.toString(), (Object[])new Object[0], rs -> {
                ArrayList<Long> arrayList = new ArrayList<Long>(16);
                while (rs.next()) {
                    arrayList.add(rs.getLong("id"));
                }
                return arrayList;
            });
            functionTypeIds.removeAll(extFuncTypeIds);
        }
        functionTypeIds.remove(1636421427953413120L);
        ArrayList filters = Lists.newArrayListWithExpectedSize((int)4);
        if (!isShowAllFunction) {
            filters.add(new QFilter("enable", "=", (Object)"1"));
            filters.add(new QFilter("status", "=", (Object)"C"));
        }
        filters.add(new QFilter("group.id", "in", new HashSet(functionTypeIds)));
        return FunctionDataHelper.getFunctionArrayByFilters(filters.toArray(new QFilter[0]));
    }

    public static DynamicObject[] getFunctionArrayByFilters(QFilter[] qFilters) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_function");
        String queryField = "id,name,uniqueCode,define,group.number,group.name,enable,status,funcdatatype,params.paramdatatype,params.paramname,params.paramdesc,description,example,funcexp,importentry.importcode";
        return helper.query(queryField, qFilters, "group.id asc,group.number asc,number asc");
    }

    public static List<TreeNodeItem> getAllFunctionTreeItemByAppNumber(String appNumber, Set<String> extFuncTypeNumbers, Set<String> extFuncTypeNames) {
        return FunctionDataHelper.changeDyArrayToTreeItemList(FunctionDataHelper.getFunctionArrayByAppNumber(appNumber, true, extFuncTypeNumbers, extFuncTypeNames));
    }

    public static List<TreeNodeItem> getFunctionTreeItemByFilters(QFilter[] qFilters) {
        return FunctionDataHelper.changeDyArrayToTreeItemList(FunctionDataHelper.getFunctionArrayByFilters(qFilters));
    }

    private static List<TreeNodeItem> changeDyArrayToTreeItemList(DynamicObject[] functionDys) {
        HashMap funcTypeMap = Maps.newHashMapWithExpectedSize((int)functionDys.length);
        ArrayList nodeItems = Lists.newArrayListWithExpectedSize((int)(functionDys.length * 2));
        for (DynamicObject func : functionDys) {
            nodeItems.add(FunctionItem.getFunctionItem((DynamicObject)func));
            funcTypeMap.put(func.getString("group.number"), func.getString("group.name"));
        }
        for (Map.Entry entry : funcTypeMap.entrySet()) {
            TreeNodeItem nodeItem = new TreeNodeItem("FC", "FC_" + (String)entry.getKey(), "FC", (String)entry.getValue());
            nodeItems.add(nodeItem);
        }
        return nodeItems;
    }
}

