/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.param.AppParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class OrgResetRootEventServicePlugin
implements IEventServicePlugin {
    private static final Log LOGGER = LogFactory.getLog(OrgResetRootEventServicePlugin.class);

    public Object handleEvent(KDBizEvent evt) {
        LOGGER.info("hrcs handleEventAndReturnCheckReport start.KDBizEvent={}", (Object)evt);
        String variableStr = evt.getVariables();
        JSONObject variables = (JSONObject)SerializationUtils.fromJsonString((String)variableStr, JSONObject.class);
        JSONObject operationParams = variables.getJSONObject("base_orgchange_resetroot");
        JSONArray synViewArray = operationParams.getJSONArray("synviews");
        long oldRootId = 0L;
        long newRootId = 0L;
        for (int i = 0; i < synViewArray.size(); ++i) {
            JSONObject jsonObject = synViewArray.getJSONObject(i);
            if (!Objects.equals(jsonObject.getLong("viewid"), 15L)) continue;
            oldRootId = jsonObject.getLong("oldrootid");
            newRootId = jsonObject.getLong("newrootid");
            break;
        }
        if (Objects.equals(oldRootId, 0L) || Objects.equals(newRootId, 0L)) {
            LOGGER.error("hrcs handleEventAndReturnCheckReport param error,oldRootId={},newRootId={}", (Object)oldRootId, (Object)newRootId);
            return evt.getEventId();
        }
        this.saveOldRootId(oldRootId, newRootId, "customentitydim");
        this.saveOldRootId(oldRootId, newRootId, "limitassigndimrange");
        return evt.getEventId();
    }

    private void saveOldRootId(long oldRootId, long newRootId, String paramType) {
        AppParam apm = new AppParam();
        apm.setAppId("15NPDX/GJFOO");
        apm.setViewType("15");
        apm.setOrgId(Long.valueOf(oldRootId));
        Object paramValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)apm, (String)paramType);
        LOGGER.error("hrcs handleEventAndReturnCheckReport get param from oldRootId:{} is {}.", (Object)oldRootId, paramValue);
        apm.setOrgId(Long.valueOf(newRootId));
        HashMap params = Maps.newHashMapWithExpectedSize((int)16);
        params.put(paramType, paramValue);
        SystemParamServiceHelper.saveAppParameter((AppParam)apm, (Map)params);
        LOGGER.info("hrcs handleEventAndReturnCheckReport end.oldRootId={},newRootId={},customentitydim paramValue={}", new Object[]{oldRootId, newRootId, paramValue});
    }
}

