/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;

@ExcludeFromJacocoGeneratedReport
public class PrivacyServiceHelper {
    private static final String ENTITY_RETAINED_DUE_PERSON = "hrcs_retaineddueperson";
    private static final String BIZ_APP_ID = "bizappid";
    private static final String DATA_SUBJECT_ID = "datasubjectid";
    private static final String DATA_SUBJECT_ID_TYPE = "datasubjecttype";
    private static final String EXEC_STATUS = "execstatus";
    private static final String ACTUAL_EXEC_DATE = "actualexecdate";
    private static final String COMPLETED = "B";
    private static final String ENTITY_DATA_ROLE = "hrcs_dataroleconfig";
    private static final String ENTITY_DATA_RETENTION_PERIOD = "hrcs_retentionconfig";

    public static Object setExecStatueCompleted(String bizAppId, String dataSubjectIdType, String dataSubjectId, Date actualExecDate) {
        if (StringUtils.isEmpty((CharSequence)bizAppId) || StringUtils.isEmpty((CharSequence)dataSubjectId)) {
            return null;
        }
        if (actualExecDate == null) {
            actualExecDate = new Date();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_RETAINED_DUE_PERSON);
        QFilter bizAppIdFilter = new QFilter(BIZ_APP_ID, "=", (Object)bizAppId);
        QFilter dataSubjectIdTypeFilter = new QFilter(DATA_SUBJECT_ID_TYPE, "=", (Object)dataSubjectIdType);
        QFilter dataSubjectIdFilter = new QFilter(DATA_SUBJECT_ID, "=", (Object)dataSubjectId);
        DynamicObject dy = helper.loadDynamicObject(new QFilter[]{bizAppIdFilter, dataSubjectIdTypeFilter, dataSubjectIdFilter});
        dy.set(EXEC_STATUS, (Object)COMPLETED);
        dy.set(ACTUAL_EXEC_DATE, (Object)actualExecDate);
        return helper.updateOne(dy);
    }

    public static Object[] setExecStatueCompletedBatch(String bizAppId, String dataSubjectIdType, List<String> dataSubjectIds, Date actualExecDate) {
        if (StringUtils.isEmpty((CharSequence)bizAppId) || null == dataSubjectIds || dataSubjectIds.isEmpty()) {
            return null;
        }
        if (actualExecDate == null) {
            actualExecDate = new Date();
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_RETAINED_DUE_PERSON);
        QFilter bizAppIdFilter = new QFilter(BIZ_APP_ID, "=", (Object)bizAppId);
        QFilter dataSubjectIdTypeFilter = new QFilter(DATA_SUBJECT_ID_TYPE, "=", (Object)dataSubjectIdType);
        ArrayList pkList = Lists.newArrayListWithExpectedSize((int)1000);
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)1000);
        for (String id : dataSubjectIds) {
            idSet.add(id.toString());
            if (idSet.size() != 1000) continue;
            Object[] pks = PrivacyServiceHelper.updateExecStatus(helper, bizAppIdFilter, dataSubjectIdTypeFilter, idSet, actualExecDate);
            pkList.addAll(Arrays.asList(pks));
        }
        if (idSet.size() > 0) {
            Object[] pks = PrivacyServiceHelper.updateExecStatus(helper, bizAppIdFilter, dataSubjectIdTypeFilter, idSet, actualExecDate);
            pkList.addAll(Arrays.asList(pks));
        }
        return pkList.toArray();
    }

    private static Object[] updateExecStatus(HRBaseServiceHelper helper, QFilter bizAppIdFilter, QFilter dataSubjectIdTypeFilter, Set<String> idSet, Date actualExecDate) {
        DynamicObject[] dys;
        QFilter dataSubjectIdFilter = new QFilter(DATA_SUBJECT_ID, "in", idSet);
        QFilter[] filters = new QFilter[]{bizAppIdFilter, dataSubjectIdTypeFilter, dataSubjectIdFilter};
        for (DynamicObject dy : dys = helper.loadDynamicObjectArray(filters)) {
            dy.set(EXEC_STATUS, (Object)COMPLETED);
            dy.set(ACTUAL_EXEC_DATE, (Object)actualExecDate);
        }
        idSet.clear();
        return helper.update(dys);
    }

    public static DynamicObject getPrivacyObjectRole(String dataRoleNumber) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_DATA_ROLE);
        QFilter filter = new QFilter("number", "=", (Object)dataRoleNumber);
        return helper.queryOne("startdatefield, beforedays, businessobject, entryentity.condition", new QFilter[]{filter});
    }

    public static DynamicObject[] getRetentionPeriod(String privacyObjectRole) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_DATA_RETENTION_PERIOD);
        QFilter filter = new QFilter("role.number", "=", (Object)privacyObjectRole);
        return helper.query("role, bizappid, entryentity.retentionperiod, entryentity.rolesort", new QFilter[]{filter}, "entryentity.retentionperiod");
    }

    public static void saveRetainedDuePerson(DynamicObjectCollection retainedColls) {
        HRBaseServiceHelper retainedHelper = new HRBaseServiceHelper(ENTITY_RETAINED_DUE_PERSON);
        retainedHelper.save(retainedColls);
    }

    public static DynamicObjectCollection queryDataSubject(String entityNumber, String startDateField, QFilter[] qFilters) {
        if (entityNumber.equals("hrpi_employee")) {
            HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
            return helper.queryOriginalCollection("id,person," + startDateField, qFilters);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(entityNumber);
        return helper.queryOriginalCollection("id," + startDateField, qFilters);
    }

    public static List<String> getRetainedDuePersonKeys() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper(ENTITY_RETAINED_DUE_PERSON);
        DataSet retainedDuePerson = helper.queryDataSet(ENTITY_RETAINED_DUE_PERSON, "datasubjectid,bizappid");
        ArrayList keys = Lists.newArrayListWithExpectedSize((int)500);
        while (retainedDuePerson.hasNext()) {
            Row row = retainedDuePerson.next();
            keys.add(PrivacyServiceHelper.getKey(row.getString(BIZ_APP_ID), row.getString(DATA_SUBJECT_ID)));
        }
        return keys;
    }

    private static String getKey(String bizAppId, String dataSubjectId) {
        return String.format(Locale.ROOT, "%s_%s", bizAppId, dataSubjectId);
    }

    public static DynamicObject[] getPrivacyRelation(String bizAppId, String dataSubjectIdType) {
        StringBuilder sb = new StringBuilder();
        sb.append(" select privacyobject.fid id,");
        sb.append(" privacyobject.fnumber number,");
        sb.append(" anony.fid anonymousid,");
        sb.append(" anony.fanonymoustype anonymoustype,");
        sb.append(" anony.fparams params,");
        sb.append(" anony.fhandleclass handleclass,");
        sb.append(" objentry.fentryid entryid,");
        sb.append(" objentry.fbizappid bizappid,");
        sb.append(" objentry.fentity entity,");
        sb.append(" objentry.ftable tablename,");
        sb.append(" objentry.fprimarykey primarykey,");
        sb.append(" objentry.fprivacyfield privacyfield,");
        sb.append(" objentry.fpersonfield personfield,");
        sb.append(" personref.fnumber personfieldtype,");
        sb.append(" objentry.fdatasubjecttype datasubjecttype");
        sb.append(" from t_hrcs_privacyobject privacyobject");
        sb.append(" left join t_hrcs_privacyobjentry objentry on privacyobject.fid = objentry.fid");
        sb.append(" left join t_hrcs_personreffieldtype personref on objentry.fpersonfieldtypeid = personref.fid");
        sb.append(" left join t_hrcs_anonymousconfig anony on privacyobject.fanonymousid = anony.fid");
        sb.append(" where objentry.fbizappid = ?");
        sb.append(" and objentry.fdatasubjecttype = ?");
        sb.append(" and privacyobject.fenable = '1'");
        sb.append(" order by privacyobject.fid");
        HRBaseServiceHelper objectTypeHelper = new HRBaseServiceHelper("bos_objecttype");
        QFilter bizAppFilter = new QFilter(BIZ_APP_ID, "=", (Object)bizAppId);
        QFilter modelTypeFilter = new QFilter("modeltype", "in", (Object)new String[]{"BaseFormModel", "BillFormModel"});
        DynamicObject[] objectTypeDy = objectTypeHelper.query("id", new QFilter[]{bizAppFilter, modelTypeFilter});
        Map objectTypeMap = Arrays.stream(objectTypeDy).collect(Collectors.toMap(dy -> dy.getString("id"), Function.identity(), (x1, y1) -> y1));
        return (DynamicObject[])DB.query((DBRoute)new DBRoute("hmp"), (String)sb.toString(), (Object[])new Object[]{bizAppId, dataSubjectIdType}, rs -> {
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_privacysaveconfig");
            HRBaseServiceHelper anonymousRuleHelper = new HRBaseServiceHelper("hrcs_anonymousrule");
            HashMap map = Maps.newHashMapWithExpectedSize((int)500);
            DynamicObjectCollection colls = new DynamicObjectCollection();
            while (rs.next()) {
                DynamicObjectCollection entryColls;
                DynamicObject dy;
                Long id = rs.getLong("id");
                if (map.get(id) != null) {
                    dy = (DynamicObject)map.get(id);
                    entryColls = dy.getDynamicObjectCollection("entityentry");
                } else {
                    dy = helper.generateEmptyDynamicObject();
                    dy.set("id", (Object)id);
                    dy.set("number", (Object)rs.getString("number"));
                    DynamicObject anonymousRuleDy = anonymousRuleHelper.generateEmptyDynamicObject();
                    anonymousRuleDy.set("id", (Object)rs.getLong("anonymousid"));
                    anonymousRuleDy.set("anonymoustype", (Object)rs.getString("anonymoustype"));
                    anonymousRuleDy.set("params", (Object)rs.getString("params"));
                    anonymousRuleDy.set("handleclass", (Object)rs.getString("handleclass"));
                    dy.set("anonymousid", (Object)anonymousRuleDy);
                    entryColls = helper.generateEmptyEntryCollection(dy, "entityentry");
                }
                DynamicObject entryObject = helper.generateEmptyEntryDynamicObject("entityentry");
                entryObject.set("id", (Object)rs.getLong("entryid"));
                entryObject.set(BIZ_APP_ID, (Object)rs.getString(BIZ_APP_ID));
                entryObject.set("entity", objectTypeMap.get(rs.getString("entity")));
                entryObject.set("table", (Object)rs.getString("tablename"));
                entryObject.set("primarykey", (Object)rs.getString("primarykey"));
                entryObject.set("privacyfield", (Object)rs.getString("privacyfield"));
                entryObject.set("personfield", (Object)rs.getString("personfield"));
                entryObject.set("personfieldtype", (Object)rs.getString("personfieldtype"));
                entryObject.set(DATA_SUBJECT_ID_TYPE, (Object)rs.getString(DATA_SUBJECT_ID_TYPE));
                entryColls.add((Object)entryObject);
                dy.set("entityentry", (Object)entryColls);
                if (map.get(id) != null) continue;
                map.put(id, dy);
                colls.add((Object)dy);
            }
            return (DynamicObject[])colls.toArray((Object[])new DynamicObject[0]);
        });
    }
}

