/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.StrategyChangeInfo;
import kd.hr.hrcs.bussiness.service.StrategyLogServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyProp;
import kd.hr.hrcs.bussiness.strategy.InitStrategyServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyApiServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyChangeServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import kd.hr.hrcs.common.strategy.InitStrategyOrgModel;
import kd.hr.hrcs.common.strategy.ModifyProjStrategyModel;
import org.springframework.util.LinkedMultiValueMap;

public class ProjStrategyServiceHelper {
    private static final HRBaseServiceHelper PROJ_EMP_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_projempstrategy");
    private static final HRBaseServiceHelper PROJ_ORG_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_projorgstrategy");
    private static final HRBaseServiceHelper PROJ_EMP_ENTRYSTRATEGY_HELPER = new HRBaseServiceHelper("hrcs_projempstrentry");
    private static final HRBaseServiceHelper PROJ_ORG_ENTRYSTRATEGY_HELPER = new HRBaseServiceHelper("hrcs_projorgstrentry");
    private static final HRBaseServiceHelper ORG_TEAM_HELPER = new HRBaseServiceHelper("haos_adminorgteamnoperm");
    private static final Log LOGGER = LogFactory.getLog(ProjStrategyServiceHelper.class);

    public static void enableStrategyByProjectTeamIds(List<Long> projectTeamIds) {
        ProjStrategyServiceHelper.enableStrategyByProjectTeamIds(projectTeamIds, PROJ_EMP_STRATEGY_HELPER);
        ProjStrategyServiceHelper.enableStrategyByProjectTeamIds(projectTeamIds, PROJ_ORG_STRATEGY_HELPER);
    }

    private static void enableStrategyByProjectTeamIds(List<Long> projectTeamIds, HRBaseServiceHelper serviceHelper) {
        QFilter filter = new QFilter("orgteam.id", "in", projectTeamIds);
        filter.and("enable", "=", (Object)"0");
        DynamicObject[] hasSetEmpStrategyList = serviceHelper.query("id,orgteam,enable,modifytime,entryentity,entryenable,entrychangetype,bussinessfield", new QFilter[]{filter});
        if (hasSetEmpStrategyList.length > 0) {
            Date modifytime = new Date();
            Stream.of(hasSetEmpStrategyList).forEach(dy -> {
                dy.set("enable", (Object)"1");
                dy.set("modifytime", (Object)modifytime);
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set("entryenable", (Object)"1");
                    dynamicObject.set("entrychangetype", (Object)"0");
                }
            });
            serviceHelper.save(hasSetEmpStrategyList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper.enableStrategyByProjectTeamIds", () -> StrategyLogServiceHelper.writeLog(hasSetEmpStrategyList, hasSetEmpStrategyList, StrategyLogServiceHelper.StrategyLogEnum.ORG_ENABLE, false, new DynamicObjectType[0]));
        }
    }

    public static void disableStrategyByProjectTeamIds(List<Long> projectTeamIds) {
        ProjStrategyServiceHelper.disableStrategyByProjectTeamIds(projectTeamIds, PROJ_EMP_STRATEGY_HELPER);
        ProjStrategyServiceHelper.disableStrategyByProjectTeamIds(projectTeamIds, PROJ_ORG_STRATEGY_HELPER);
    }

    private static void disableStrategyByProjectTeamIds(List<Long> projectTeamIds, HRBaseServiceHelper serviceHelper) {
        QFilter filter = new QFilter("orgteam.id", "in", projectTeamIds);
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] hasSetStrategyList = serviceHelper.query("id,orgteam,enable,modifytime,entryentity,entryenable,entrychangetype,bussinessfield", new QFilter[]{filter});
        if (hasSetStrategyList.length > 0) {
            Date modifytime = new Date();
            Stream.of(hasSetStrategyList).forEach(dy -> {
                dy.set("enable", (Object)"0");
                dy.set("modifytime", (Object)modifytime);
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set("entryenable", (Object)"0");
                    dynamicObject.set("entrychangetype", (Object)"0");
                }
            });
            serviceHelper.save(hasSetStrategyList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper.disableStrategyByProjectTeamIds", () -> StrategyLogServiceHelper.writeLog(hasSetStrategyList, hasSetStrategyList, StrategyLogServiceHelper.StrategyLogEnum.ORG_DISABLE, false, new DynamicObjectType[0]));
        }
    }

    public static void addStrategyByProjectTeam(List<Long> projectTeamIds, String EntityNumber, boolean isNew) {
        LOGGER.info("ProjStrategyServiceHelper-addStrategyByProjectTeam() projectTeamList size:{}, EntityNumber:{},isNew:{}", new Object[]{projectTeamIds, EntityNumber, isNew});
        if (projectTeamIds.size() == 0) {
            return;
        }
        ArrayList projectTeamStrategyDynList = Lists.newArrayListWithExpectedSize((int)projectTeamIds.size());
        List<DynamicObject> projectTeamList = InitStrategyServiceHelper.getProjectTeamDynamicObject(projectTeamIds);
        projectTeamList = ProjStrategyServiceHelper.sortedProjectTeam(projectTeamList);
        long[] ids = ORM.create().genLongIds(EntityNumber, projectTeamList.size());
        Date date = new Date();
        int index = 0;
        StrategyProp strategyProp = ProjStrategyServiceHelper.getStrategyProp(EntityNumber);
        Map<String, DynamicObject> strategyTypeMap = ProjStrategyServiceHelper.getHeadStrategyTypeMap(strategyProp.getBusinessObjectId());
        LinkedMultiValueMap<Long, DynamicObject> strategyTypeEntryMap = ProjStrategyServiceHelper.getEntryStrategyTypeMap(strategyProp.getBusinessObjectId());
        DynamicObject[] allBusinessTypeReals = InitStrategyServiceHelper.getAllBusinessTypeReal(strategyProp.getOrgTypeId(), strategyProp.getBusinessObjectId());
        HRBaseServiceHelper serviceHelper = strategyProp.getServiceHelper();
        List<Long> parentProjectTeamIds = projectTeamList.stream().map(obj -> obj.getLong("parentorg.id")).distinct().collect(Collectors.toList());
        Map<Long, Map<Long, DynamicObject>> hrBuMaps = InitStrategyServiceHelper.getParentStrategy(parentProjectTeamIds, EntityNumber, "entryhrbu");
        Map<Long, Map<Long, DynamicObject>> hrBuMaps2 = InitStrategyServiceHelper.getParentStrategy(parentProjectTeamIds, strategyProp.getParentStrategyEntity(), "entryhrbu");
        hrBuMaps.putAll(hrBuMaps2);
        for (DynamicObject projTeam : projectTeamList) {
            DynamicObject strategyDyn = isNew ? ProjStrategyServiceHelper.createStrategyHeaderDyn(projTeam, serviceHelper, ids[index], date, strategyTypeMap) : ProjStrategyServiceHelper.modifyStrategyHeaderDyn(projTeam, serviceHelper, date);
            ProjStrategyServiceHelper.createStrategyEntryDyn(isNew, allBusinessTypeReals, serviceHelper, strategyDyn, projTeam, hrBuMaps, strategyTypeEntryMap);
            projectTeamStrategyDynList.add(strategyDyn);
            ++index;
        }
        LOGGER.info("ProjStrategyServiceHelper-projectTeamStrategyDynList:{}", (Object)projectTeamStrategyDynList.size());
        InitStrategyServiceHelper.notEmptyExecute(projectTeamStrategyDynList, param -> serviceHelper.save(param.toArray(new DynamicObject[0])));
    }

    private static DynamicObject createStrategyHeaderDyn(DynamicObject projTeam, HRBaseServiceHelper serviceHelper, long id, Date date, Map<String, DynamicObject> strategyTypeMap) {
        DynamicObject strategyDyn = serviceHelper.generateEmptyDynamicObject();
        DynamicObject defStrategyType = strategyTypeMap.get("1");
        DynamicObject parentOrgTeam = projTeam.getDynamicObject("parentorg");
        if (Objects.nonNull(parentOrgTeam) && ManageStrategyConstants.LONG_ORGTEAM_ADMINORG.equals(parentOrgTeam.getLong("otclassify.id"))) {
            defStrategyType = strategyTypeMap.get("2");
            parentOrgTeam = projTeam.getDynamicObject("belongadminorg");
        }
        strategyDyn.set("id", (Object)id);
        strategyDyn.set("orgteam", (Object)projTeam);
        strategyDyn.set("sourceorg", (Object)projTeam);
        strategyDyn.set("inheritedorg", (Object)parentOrgTeam);
        strategyDyn.set("defstrategytype", (Object)defStrategyType);
        strategyDyn.set("effdt", projTeam.get("establishmentdate"));
        InitStrategyServiceHelper.setCommonField(strategyDyn, date, projTeam.get("enable"));
        strategyDyn.set("changetype", (Object)"0");
        strategyDyn.set("belongadminorg", (Object)projTeam.getDynamicObject("belongadminorg"));
        return strategyDyn;
    }

    private static void createStrategyEntryDyn(boolean isNew, DynamicObject[] allBusinessTypeReals, HRBaseServiceHelper serviceHelper, DynamicObject strategyDyn, DynamicObject projTeam, Map<Long, Map<Long, DynamicObject>> hrBuMaps, LinkedMultiValueMap<Long, DynamicObject> strategyTypeEntryMap) {
        LOGGER.info("ProjStrategyServiceHelper-begin to createStrategyEntryDyn,allBusinessTypeReals size:{}", (Object)allBusinessTypeReals.length);
        DynamicObjectCollection entryColl = !isNew ? strategyDyn.getDynamicObjectCollection("entryentity") : serviceHelper.generateEmptyEntryCollection(strategyDyn, "entryentity");
        for (DynamicObject businessTypeReal : allBusinessTypeReals) {
            Optional<DynamicObject> bussinessfieldOp = entryColl.stream().filter(entryDyn -> entryDyn.getLong("bussinessfield.id") == businessTypeReal.getLong("id")).findFirst();
            if (bussinessfieldOp.isPresent()) continue;
            DynamicObject entry = serviceHelper.generateEmptyEntryDynamicObject("entryentity");
            entry.set("entryorgteam", (Object)projTeam);
            entry.set("bussinessfield", (Object)businessTypeReal);
            String strategyType = strategyDyn.getDynamicObject("defstrategytype").getString("strategytype");
            List dynamicObjects = strategyTypeEntryMap.get(businessTypeReal.get("id"));
            if (null != dynamicObjects) {
                entry.set("entrydefstrategy", (Object)dynamicObjects.stream().filter(dy -> dy.getString("strategytype").equals(strategyType)).findAny().get());
            }
            entry.set("entryinheritedorg", strategyDyn.get("inheritedorg"));
            Map<Long, DynamicObject> tempMap = hrBuMaps.get(projTeam.getLong("parentorg.id"));
            if (tempMap != null) {
                entry.set("entryhrbu", (Object)tempMap.get(businessTypeReal.getLong("bussinesstype.id")));
                hrBuMaps.put(projTeam.getLong("id"), tempMap);
            }
            entry.set("entryeffdt", strategyDyn.get("effdt"));
            entry.set("entryenable", strategyDyn.get("enable"));
            entry.set("strategyentrytype", (Object)"0");
            entry.set("entrysourceorg", strategyDyn.get("inheritedorg"));
            entryColl.add((Object)entry);
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static DynamicObject modifyStrategyHeaderDyn(DynamicObject projTeam, HRBaseServiceHelper serviceHelper, Date date) {
        LOGGER.info("ProjStrategyServiceHelper-modifyStrategyHeaderDyn,projTeam:{}", (Object)projTeam.getLong("id"));
        DynamicObject strategyDyn = serviceHelper.loadDynamicObject(new QFilter("orgteam.id", "=", (Object)projTeam.getLong("id")));
        strategyDyn.set("modifytime", (Object)date);
        strategyDyn.set("modifier", (Object)RequestContext.get().getCurrUserId());
        return strategyDyn;
    }

    @ExcludeFromJacocoGeneratedReport
    private static List<DynamicObject> sortedProjectTeam(List<DynamicObject> projectTeamList) {
        HashMap levelMap = Maps.newHashMapWithExpectedSize((int)projectTeamList.size());
        String sql = "select forgteamid,flevel from t_haos_orgteamstruct where fiscurrentversion = '1' and fstructprojectid in (1010,1020) and forgteamid in (" + StringUtils.join((Object[])projectTeamList.stream().map(obj -> obj.getLong("id")).toArray(), (String)",") + ") ";
        try (DataSet dataSet = HRDBUtil.queryDataSet((String)"ProjStrategyServiceHelper.sortedProjectTeam", (DBRoute)new DBRoute("haos"), (String)sql, (Object[])new Object[0]);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                levelMap.put(row.getLong(0), row.getInteger(1));
            }
        }
        return projectTeamList.stream().sorted(Comparator.comparing(obj -> levelMap.get(obj.getLong("id")) == null ? Integer.valueOf(99) : (Integer)levelMap.get(obj.getLong("id")))).collect(Collectors.toList());
    }

    public static Map<String, DynamicObject> getHeadStrategyTypeMap(Long businessObjectId) {
        LOGGER.info("ProjStrategyServiceHelper-getHeadStrategyTypeMap,businessObjectId:{}", (Object)businessObjectId);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter qFilter = new QFilter("bussinessfield.bussinessobject.id", "=", (Object)businessObjectId);
        qFilter.and("bussinessfield.isallfield", "=", (Object)"1");
        DynamicObject[] strategyType = hrBaseServiceHelper.query("bussinessfield,strategytype", new QFilter[]{qFilter});
        return Arrays.stream(strategyType).collect(Collectors.toMap(dy -> dy.getString("strategytype"), Function.identity()));
    }

    @ExcludeFromJacocoGeneratedReport
    public static LinkedMultiValueMap<Long, DynamicObject> getEntryStrategyTypeMap(Long businessObjectId) {
        LOGGER.info("ProjStrategyServiceHelper-getEntryStrategyTypeMap,businessObjectId:{}", (Object)businessObjectId);
        LinkedMultiValueMap linkedMultiValueMap = new LinkedMultiValueMap();
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter qFilter = new QFilter("bussinessfield.bussinessobject.id", "=", (Object)businessObjectId);
        qFilter.and("bussinessfield.isallfield", "=", (Object)"0");
        DynamicObject[] strategyTypeDy = hrBaseServiceHelper.query("bussinessfield,strategytype", new QFilter[]{qFilter});
        Arrays.stream(strategyTypeDy).forEach(dy -> linkedMultiValueMap.add((Object)dy.getLong("bussinessfield.id"), dy));
        return linkedMultiValueMap;
    }

    public static Map<Long, DynamicObject> getEntryStrategyTypeMap(Long businessObjectId, String strategyType) {
        LOGGER.info("ProjStrategyServiceHelper-getEntryStrategyTypeMap,businessObjectId:{},strategyType:{}", (Object)businessObjectId, (Object)strategyType);
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter qFilter = new QFilter("bussinessfield.bussinessobject.id", "=", (Object)businessObjectId);
        qFilter.and("bussinessfield.isallfield", "=", (Object)"0");
        qFilter.and("strategytype", "=", (Object)strategyType);
        DynamicObject[] strategyTypeDy = hrBaseServiceHelper.query("bussinessfield,strategytype", new QFilter[]{qFilter});
        return Arrays.stream(strategyTypeDy).collect(Collectors.toMap(dy -> dy.getLong("bussinessfield.id"), Function.identity()));
    }

    private static StrategyProp getStrategyProp(String EntityNumber) {
        StrategyProp strategyProp = new StrategyProp();
        switch (EntityNumber) {
            case "hrcs_projempstrategy": {
                strategyProp.setServiceHelper(PROJ_EMP_STRATEGY_HELPER);
                strategyProp.setOrgTypeId(ManageStrategyConstants.LONG_ORGTYPE_PROJECT);
                strategyProp.setBusinessObjectId(ManageStrategyConstants.LONG_PROJ_BUSSINESSOBJECTID_ID_EMP);
                strategyProp.setParentStrategyEntity("hrcs_empstrategy");
                break;
            }
            case "hrcs_projorgstrategy": {
                strategyProp.setServiceHelper(PROJ_ORG_STRATEGY_HELPER);
                strategyProp.setOrgTypeId(ManageStrategyConstants.LONG_ORGTYPE_PROJECT);
                strategyProp.setBusinessObjectId(ManageStrategyConstants.LONG_PROJ_BUSSINESSOBJECTID_ID_ORG);
                strategyProp.setParentStrategyEntity("hrcs_orgstrategy");
                break;
            }
        }
        return strategyProp;
    }

    public static List<Map<String, Long>> getHrBuByBusinessType(Map<Long, Set<Long>> projTeamIds2BusinessType, Long businessObjectId) {
        if (CollectionUtils.isEmpty(projTeamIds2BusinessType)) {
            LOGGER.info("getHrBuByBusinessType() projTeamIds2BusinessType is empty.");
            return Collections.emptyList();
        }
        LOGGER.info("getHrBuByBusinessType()  projTeamIds2BusinessType:{},businessObjectId:{}", projTeamIds2BusinessType, (Object)businessObjectId);
        HRBaseServiceHelper strategyEntryHelper = ManageStrategyConstants.LONG_PROJ_BUSSINESSOBJECTID_ID_EMP.equals(businessObjectId) ? PROJ_EMP_ENTRYSTRATEGY_HELPER : PROJ_ORG_ENTRYSTRATEGY_HELPER;
        QFilter dataFilter = null;
        for (Map.Entry<Long, Set<Long>> entry2 : projTeamIds2BusinessType.entrySet()) {
            Long projectTeamId = entry2.getKey();
            Set<Long> businessTypeIds = entry2.getValue();
            QFilter tempFilter = new QFilter("orgteam.id", "=", (Object)projectTeamId);
            tempFilter.and(new QFilter("bussinessfield.bussinesstype.id", "in", businessTypeIds));
            if (null == dataFilter) {
                dataFilter = tempFilter;
                continue;
            }
            dataFilter.or(tempFilter);
        }
        Object[] strategyEntry = strategyEntryHelper.queryOriginalArray("orgteam.id,bussinessfield.bussinesstype.id,hrbu.id", new QFilter[]{dataFilter});
        ArrayList result = Lists.newArrayListWithExpectedSize((int)projTeamIds2BusinessType.size());
        if (ObjectUtils.isEmpty((Object[])strategyEntry)) {
            LOGGER.info("getHrBuByBusinessType() result is null");
            return Collections.emptyList();
        }
        Arrays.stream(strategyEntry).forEach(entry -> {
            LinkedHashMap tempMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
            tempMap.put("projectTeamId", entry.getLong("orgteam.id"));
            tempMap.put("businessTypeId", entry.getLong("bussinessfield.bussinesstype.id"));
            tempMap.put("hrBuId", entry.getLong("hrbu.id"));
            result.add(tempMap);
        });
        LOGGER.info("getHrBuByBusinessType() result:{}", (Object)result);
        return result;
    }

    public static void batchModifyProjStrategyByOrg(List<Map<String, Object>> params) {
        ArrayList models = Lists.newArrayListWithExpectedSize((int)params.size());
        HashSet currentOrgTeamIds = Sets.newHashSetWithExpectedSize((int)params.size());
        HashSet parentIds = Sets.newHashSetWithExpectedSize((int)params.size());
        params.forEach(param -> {
            ModifyProjStrategyModel model = new ModifyProjStrategyModel(param);
            models.add(model);
            currentOrgTeamIds.add(model.getId());
            parentIds.add(model.getParentId());
        });
        Map<Long, List<InitStrategyOrgModel>> childOrgModel = ProjStrategyServiceHelper.getSubOrgIdIncludeGrand(currentOrgTeamIds);
        HashSet allOrgTeamIds = Sets.newHashSetWithExpectedSize((int)16);
        allOrgTeamIds.addAll(currentOrgTeamIds);
        allOrgTeamIds.addAll(parentIds);
        Set collect = childOrgModel.values().stream().flatMap(Collection::stream).map(InitStrategyOrgModel::getId).collect(Collectors.toSet());
        allOrgTeamIds.addAll(collect);
        ArrayList bussinessObjectIds = Lists.newArrayListWithExpectedSize((int)16);
        bussinessObjectIds.add(ManageStrategyConstants.LONG_PROJ_BUSSINESSOBJECTID_ID_EMP);
        bussinessObjectIds.add(ManageStrategyConstants.LONG_PROJ_BUSSINESSOBJECTID_ID_ORG);
        QFilter qFilter = new QFilter("bussinessfield.bussinessobject.id", "in", (Object)bussinessObjectIds);
        DynamicObject[] strategyTypes = new HRBaseServiceHelper("hrcs_strategy").query("strategytype,bussinessfield.id", new QFilter[]{qFilter});
        Map<Long, DynamicObject> empStrategies = ProjStrategyServiceHelper.getStrategies(allOrgTeamIds, PROJ_EMP_STRATEGY_HELPER);
        HashMap empBeModify = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, Map<Long, DynamicObject>> empHrbu = InitStrategyServiceHelper.getParentStrategy(ProjStrategyServiceHelper.getProjStrategies(empStrategies), "hrcs_empstrategy", "entryhrbu");
        Map<Long, DynamicObject> orgStrategies = ProjStrategyServiceHelper.getStrategies(allOrgTeamIds, PROJ_ORG_STRATEGY_HELPER);
        HashMap orgBeModify = Maps.newHashMapWithExpectedSize((int)16);
        Map<Long, Map<Long, DynamicObject>> orgHrbu = InitStrategyServiceHelper.getParentStrategy(ProjStrategyServiceHelper.getProjStrategies(orgStrategies), "hrcs_orgstrategy", "entryhrbu");
        models.forEach(model -> {
            ProjStrategyServiceHelper.setStrategy(empBeModify, (List)childOrgModel.get(model.getId()), empStrategies, model, empHrbu, strategyTypes);
            ProjStrategyServiceHelper.setStrategy(orgBeModify, (List)childOrgModel.get(model.getId()), orgStrategies, model, orgHrbu, strategyTypes);
        });
        String selectProperties = "entryentity,bussinessfield,entrydefstrategy,entryhrbu,entryinheritedorg,entryeffdt";
        QFilter[] logQFilter = new QFilter[]{new QFilter("orgteam", "in", (Object)allOrgTeamIds)};
        DynamicObject[] tempEmpStrategies = PROJ_EMP_STRATEGY_HELPER.query(selectProperties, logQFilter);
        DynamicObject[] tempOrgStrategies = PROJ_ORG_STRATEGY_HELPER.query(selectProperties, logQFilter);
        if (!CollectionUtils.isEmpty(empBeModify.values())) {
            PROJ_EMP_STRATEGY_HELPER.save(empBeModify.values().toArray(new DynamicObject[0]));
            ThreadPools.executeOnce((String)"ProjStrategyServiceHelper.batchModifyProjStrategyByOrg.writeModifyLog.emp", () -> StrategyLogServiceHelper.writeModifyLog(empBeModify, tempEmpStrategies));
            ThreadPools.executeOnce((String)"ProjStrategyServiceHelper.batchModifyProjStrategyByOrg.publishMsg.emp", () -> StrategyChangeServiceHelper.publishMsg("emp", empBeModify, tempEmpStrategies));
        }
        if (!CollectionUtils.isEmpty(orgBeModify.values())) {
            PROJ_ORG_STRATEGY_HELPER.save(orgBeModify.values().toArray(new DynamicObject[0]));
            ThreadPools.executeOnce((String)"ProjStrategyServiceHelper.batchModifyProjStrategyByOrg.writeModifyLog.org", () -> StrategyLogServiceHelper.writeModifyLog(orgBeModify, tempOrgStrategies));
            ThreadPools.executeOnce((String)"ProjStrategyServiceHelper.batchModifyProjStrategyByOrg.publishMsg.org", () -> StrategyChangeServiceHelper.publishMsg("org", orgBeModify, tempOrgStrategies));
        }
    }

    private static Set<Long> getProjStrategies(Map<Long, DynamicObject> projStrategies) {
        HashSet<Long> projSet = new HashSet<Long>(16);
        for (Map.Entry<Long, DynamicObject> entry : projStrategies.entrySet()) {
            projSet.add(entry.getValue().getLong("orgteam.belongadminorg.id"));
        }
        return projSet;
    }

    @ExcludeFromJacocoGeneratedReport
    private static void setStrategy(Map<Long, DynamicObject> toBeModify, List<InitStrategyOrgModel> subOrgIdIncludeGrand, Map<Long, DynamicObject> orgTeam2Strategies, ModifyProjStrategyModel param, Map<Long, Map<Long, DynamicObject>> hrbu, DynamicObject[] strategyTypes) {
        DynamicObject currentStrategy = orgTeam2Strategies.get(param.getId());
        DynamicObject parentStrategy = toBeModify.getOrDefault(param.getParentId(), orgTeam2Strategies.get(param.getParentId()));
        if (null == currentStrategy) {
            LOGGER.info("setStrategy() currentStrategy  is null");
            return;
        }
        ProjStrategyServiceHelper.updateStrategy(toBeModify, currentStrategy, parentStrategy, hrbu, strategyTypes);
        if (null == subOrgIdIncludeGrand) {
            LOGGER.info("setStrategy() subOrgIdIncludeGrand is null");
            return;
        }
        subOrgIdIncludeGrand.forEach(sub -> ProjStrategyServiceHelper.updateStrategy(toBeModify, (DynamicObject)orgTeam2Strategies.get(sub.getId()), (DynamicObject)toBeModify.get(sub.getParentId()), hrbu, strategyTypes));
    }

    private static void updateStrategy(Map<Long, DynamicObject> toBeModify, DynamicObject currentStrategy, DynamicObject parentStrategy, Map<Long, Map<Long, DynamicObject>> hrbu, DynamicObject[] strategyTypes) {
        Date date = new Date();
        currentStrategy.set("modifytime", (Object)date);
        currentStrategy.set("effdt", (Object)date);
        String strategyType = currentStrategy.getString("defstrategytype.strategytype");
        currentStrategy.set("inheritedorg", (Object)ORG_TEAM_HELPER.queryOne(ProjStrategyServiceHelper.getInheritedorgByBussinessType(strategyType, currentStrategy, "inheritedorg.id")));
        currentStrategy.set("belongadminorg", currentStrategy.get("orgteam.belongadminorg.id"));
        ProjStrategyServiceHelper.handleHeadStrategyType(currentStrategy, strategyType);
        DynamicObjectCollection currentEntries = currentStrategy.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : currentEntries) {
            String entryDefstrategyType = entry.getString("entrydefstrategy.strategytype");
            if (!"4".equals(entryDefstrategyType)) {
                entry.set("entryinheritedorg", (Object)ORG_TEAM_HELPER.queryOne(ProjStrategyServiceHelper.getInheritedorgByBussinessType(entryDefstrategyType, currentStrategy, "entryinheritedorg.id")));
                ProjStrategyServiceHelper.handleEntryStrategyType(strategyTypes, entry, entryDefstrategyType);
            }
            if (!"3".equals(entryDefstrategyType) && !"4".equals(entryDefstrategyType)) {
                entry.set("entryhrbu", ProjStrategyServiceHelper.getOrgTeam(entry, currentStrategy, parentStrategy, hrbu));
            }
            entry.set("entryeffdt", (Object)date);
        }
        if (HRStringUtils.isEmpty((String)currentStrategy.getString("changetype"))) {
            currentStrategy.set("changetype", (Object)"0");
        }
        toBeModify.put(currentStrategy.getLong("orgteam.id"), currentStrategy);
    }

    @ExcludeFromJacocoGeneratedReport
    private static void handleHeadStrategyType(DynamicObject currentStrategy, String strategyType) {
        if ("1".equals(strategyType) && currentStrategy.getLong("inheritedorg.id") == currentStrategy.getLong("orgteam.belongadminorg.id")) {
            long bussinessTypeReal = currentStrategy.getDynamicObject("defstrategytype").getLong("bussinessfield.id");
            if (ManageStrategyConstants.ALLAREAL_EMP == bussinessTypeReal) {
                currentStrategy.set("defstrategytype", (Object)ManageStrategyConstants.ALLAREAL_EMP_SAME_PROJECTTEAM);
            } else {
                currentStrategy.set("defstrategytype", (Object)ManageStrategyConstants.ALLAREAL_ORG_SAME_PROJECTTEAM);
            }
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static void handleEntryStrategyType(DynamicObject[] strategyTypes, DynamicObject currentStrategy, String strategyType) {
        if ("1".equals(strategyType) && currentStrategy.getLong("entryinheritedorg.id") == currentStrategy.getLong("entryorgteam.belongadminorg.id")) {
            long bussinessTypeReal = currentStrategy.getLong("bussinessfield.id");
            Optional<DynamicObject> strategytype = Arrays.stream(strategyTypes).filter(dy -> "2".equals(dy.getString("strategytype")) && dy.getLong("bussinessfield.id") == bussinessTypeReal).findFirst();
            strategytype.ifPresent(dynamicObject -> currentStrategy.set("entrydefstrategy", dynamicObject));
        }
    }

    @ExcludeFromJacocoGeneratedReport
    private static Object getInheritedorgByBussinessType(String key, DynamicObject currentStrategy, String inheritedorgKey) {
        switch (key) {
            case "1": {
                return currentStrategy.get("orgteam.parentorg.id");
            }
            case "2": {
                return currentStrategy.get("orgteam.belongadminorg.id");
            }
            case "3": {
                return currentStrategy.get("orgteam.id");
            }
        }
        return currentStrategy.get(inheritedorgKey);
    }

    @ExcludeFromJacocoGeneratedReport
    private static DynamicObject getBussinessTypeHr(DynamicObject parentStrategy, Long bussinessType) {
        if (null != parentStrategy) {
            DynamicObjectCollection currentEntries = parentStrategy.getDynamicObjectCollection("entryentity");
            for (DynamicObject dy : currentEntries) {
                if (null == dy.get("entryhrbu") || dy.getLong("bussinessfield.id") != bussinessType.longValue()) continue;
                return dy.getDynamicObject("entryhrbu");
            }
        }
        return null;
    }

    @ExcludeFromJacocoGeneratedReport
    public static Object getOrgTeam(DynamicObject entry, DynamicObject currentStrategy, DynamicObject parentStrategy, Map<Long, Map<Long, DynamicObject>> hrbu) {
        String key;
        switch (key = entry.getString("entrydefstrategy.strategytype")) {
            case "1": {
                return ProjStrategyServiceHelper.getBussinessTypeHr(parentStrategy, entry.getLong("bussinessfield.id"));
            }
            case "2": {
                Map<Long, DynamicObject> hrMap = hrbu.get(currentStrategy.getLong("orgteam.belongadminorg.id"));
                return null == hrMap ? null : hrMap.get(entry.getLong("bussinessfield.bussinesstype.id"));
            }
        }
        return null;
    }

    public static Map<Long, DynamicObject> getStrategies(Set<Long> allOrgTeamIds, HRBaseServiceHelper hrBaseServiceHelper) {
        HashMap business2Strategies = Maps.newHashMapWithExpectedSize((int)8);
        QFilter filter = new QFilter("orgteam", "in", allOrgTeamIds);
        DynamicObject[] empStrategies = hrBaseServiceHelper.loadDynamicObjectArray(new QFilter[]{filter});
        business2Strategies.putAll(Arrays.stream(empStrategies).collect(Collectors.toMap(dy -> dy.getLong("orgteam.id"), Function.identity())));
        return business2Strategies;
    }

    @ExcludeFromJacocoGeneratedReport
    private static Map<Long, List<InitStrategyOrgModel>> getSubOrgIdIncludeGrand(Set<Long> orgIds) {
        QFilter orgIdFilter = new QFilter("orgteam.id", "in", orgIds);
        QFilter currentVersionFilter = InitStrategyServiceHelper.getHisDataFilter();
        currentVersionFilter.and("structproject", "in", (Object)Lists.newArrayList((Object[])new Long[]{1010L, 1020L}));
        Object[] orgStructs = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure").query("id,orgteam,structlongnumber", new QFilter[]{orgIdFilter, currentVersionFilter});
        if (ObjectUtils.isEmpty((Object[])orgStructs)) {
            return Maps.newHashMapWithExpectedSize((int)16);
        }
        QFilter longNumberFilter = null;
        for (Object orgStruct : orgStructs) {
            String longNumber = orgStruct.getString("structlongnumber");
            QFilter tempFilter = new QFilter("structlongnumber", "like", (Object)(longNumber + "!" + "%"));
            if (longNumberFilter == null) {
                longNumberFilter = tempFilter;
                continue;
            }
            longNumberFilter.or(tempFilter);
        }
        QFilter[] filters = new QFilter[]{longNumberFilter, currentVersionFilter};
        String select = "orgteam.id,orgteam,parentorgteam,structlongnumber";
        DynamicObjectCollection dyColl = HRBaseDaoFactory.getInstance((String)"haos_adminorgstructure").queryColl(select, filters, null);
        return StrategyApiServiceHelper.getAdminOrg((DynamicObject[])orgStructs, dyColl, "orgteam", "parentorgteam");
    }

    @ExcludeFromJacocoGeneratedReport
    public static Long getHrBuByInheritedorg(Long inheritedorgId, Long bussinessTypeId, Long bussinessTypeRealId, String entryEntityNumber) {
        DynamicObject dynamicObject;
        LOGGER.info("ProjStrategyServiceHelper-getHrBuByInheritedorg,inheritedorgId:{},bussinessTypeId:{},bussinessTypeRealId:{},entryEntityNumber:{}", new Object[]{inheritedorgId, bussinessTypeId, bussinessTypeRealId, entryEntityNumber});
        QFilter qFilter = new QFilter("orgteam.id", "=", (Object)inheritedorgId);
        if (bussinessTypeId == 0L) {
            DynamicObject temp = new HRBaseServiceHelper("hrcs_bussinesstype").queryOriginalOne("bussinesstype.id", (Object)bussinessTypeRealId);
            bussinessTypeId = Objects.nonNull(temp) ? temp.getLong("bussinesstype.id") : 0L;
        }
        QFilter bussinessTypeFilter = new QFilter("bussinessfield.bussinesstype.id", "=", (Object)bussinessTypeId);
        String selectFields = "hrbu";
        if ("hrcs_projempstrentry".equals(entryEntityNumber)) {
            dynamicObject = PROJ_EMP_ENTRYSTRATEGY_HELPER.queryOriginalOne(selectFields, new QFilter[]{qFilter, bussinessTypeFilter});
            if (null == dynamicObject) {
                dynamicObject = new HRBaseServiceHelper("hrcs_empstrentry").queryOriginalOne(selectFields, new QFilter[]{qFilter, bussinessTypeFilter});
            }
        } else {
            dynamicObject = PROJ_ORG_ENTRYSTRATEGY_HELPER.queryOriginalOne(selectFields, new QFilter[]{qFilter, bussinessTypeFilter});
            if (null == dynamicObject) {
                dynamicObject = new HRBaseServiceHelper("hrcs_orgstrentry").queryOriginalOne(selectFields, new QFilter[]{qFilter, bussinessTypeFilter});
            }
        }
        return null == dynamicObject ? 0L : dynamicObject.getLong("hrbu");
    }

    public static void getChildStrategyEntrysDys(Long bussinessFieldRealId, Long bussinessFieldId, List<Long> projTeamIds, Object hrbuId, List<DynamicObject> childStrategyEntrysDys, HRBaseServiceHelper hrBaseServiceHelper, String strategyTye, List<StrategyChangeInfo> changeInfoList) {
        QFilter qFilter = new QFilter("inheritedorg.id", "in", projTeamIds);
        if (bussinessFieldId != 0L) {
            qFilter.and("bussinessfield.bussinesstype.id", "=", (Object)bussinessFieldId);
        } else {
            qFilter.and("bussinessfield.id", "=", (Object)bussinessFieldRealId);
        }
        qFilter.and("strategy.strategytype", "!=", (Object)"3");
        DynamicObject[] query = hrBaseServiceHelper.query("parent,strategy,inheritedorg,orgteam,effdt,hrbu,bussinessfield", new QFilter[]{qFilter});
        if (query.length > 0) {
            Date date = new Date();
            Arrays.stream(query).forEach(dy -> {
                if (hrbuId instanceof DynamicObject) {
                    changeInfoList.add(new StrategyChangeInfo(strategyTye, dy.getLong("orgteam.id"), dy.getLong("bussinessfield.bussinesstype.id"), dy.getLong("hrbu.id"), ((DynamicObject)hrbuId).getLong("id")));
                } else {
                    changeInfoList.add(new StrategyChangeInfo(strategyTye, dy.getLong("orgteam.id"), dy.getLong("bussinessfield.bussinesstype.id"), dy.getLong("hrbu.id"), (Long)hrbuId));
                }
                dy.set("effdt", (Object)date);
                dy.set("hrbu", hrbuId);
            });
            childStrategyEntrysDys.addAll(Arrays.asList(query));
            ProjStrategyServiceHelper.getChildStrategyEntrysDys(bussinessFieldRealId, bussinessFieldId, Arrays.stream(query).map(dy -> dy.getLong("orgteam.id")).collect(Collectors.toList()), hrbuId, childStrategyEntrysDys, hrBaseServiceHelper, strategyTye, changeInfoList);
        }
    }
}

