/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.history.util.HistoryEntityUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.md.StrategyChangeInfo;
import kd.hr.hrcs.bussiness.service.StrategyLogServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;

@ExcludeFromJacocoGeneratedReport
public class StrategyHandleServiceHelper {
    public static final HRBaseServiceHelper EMP_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_empstrategy");
    public static final HRBaseServiceHelper ORG_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_orgstrategy");
    private static final HRBaseServiceHelper ORG_LEVEL_HELPER = new HRBaseServiceHelper("haos_adminorgstructure");
    private static final Log LOGGER = LogFactory.getLog(StrategyHandleServiceHelper.class);
    private static final String FIELD_PARENT = "parent";
    private static final String FIELD_ADMINORG = "adminorg";
    private static final String FIELD_COMPANY = "company";
    private static final String FIELD_EFFECT_DATE = "effectdate";
    private static final String FIELD_BUSSINESSFIELD_ID = "bussinessfield.id";
    private static final String FIELD_ENTRY_ENABLE = "entryenable";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_ENTRY_CHANGE_TYPE = "entrychangetype";
    private static final String FIELD_ORGTEAM_ID = "orgteam.id";

    protected static void handleMainByStrageType(DynamicObject dynamicObject, DynamicObject curStrategyDy, DynamicObject newOrgDy) {
        DynamicObject strategy = curStrategyDy.getDynamicObject("defstrategytype");
        switch (strategy.getString("strategytype")) {
            case "0": {
                curStrategyDy.set("inheritedorg", newOrgDy.get(FIELD_PARENT));
                break;
            }
            case "1": {
                curStrategyDy.set("inheritedorg", newOrgDy.get(FIELD_ADMINORG));
                DynamicObject groupDy = (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSService", (String)"getCompanyByAdminOrgId", (Object[])new Object[]{HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_PARENT), true});
                if (groupDy == null) break;
                curStrategyDy.set("inheritedorg", groupDy.get("id"));
                break;
            }
            case "2": {
                curStrategyDy.set("inheritedorg", newOrgDy.get(FIELD_COMPANY));
                break;
            }
            case "3": {
                curStrategyDy.set("inheritedorg", newOrgDy.get(FIELD_ADMINORG));
                break;
            }
            case "4": {
                DynamicObject oldStragyDy = curStrategyDy.getDynamicObject("defstrategytype");
                DynamicObject stragyDy = StrategyServiceHelper.getStrategyTypeByBussinessfieldAndNumber(oldStragyDy.getLong(FIELD_BUSSINESSFIELD_ID), "3");
                curStrategyDy.set("defstrategytype", (Object)stragyDy);
                curStrategyDy.set("inheritedorg", dynamicObject.get(FIELD_ORGTEAM_ID));
                break;
            }
        }
    }

    protected static void disableStrategyCrossByOrg(Map<Long, DynamicObject> map) {
        Object[] empStrategyByOrgList;
        ArrayList<Long> orgIdList = new ArrayList<Long>(map.keySet());
        Object[] orgStrategyByOrgList = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
        if (!ObjectUtils.isEmpty((Object[])orgStrategyByOrgList)) {
            Stream.of(orgStrategyByOrgList).forEach(dyo -> StrategyHandleServiceHelper.disableStrategy(map, dyo));
            ORG_STRATEGY_HELPER.save((DynamicObject[])orgStrategyByOrgList);
        }
        if (!ObjectUtils.isEmpty((Object[])(empStrategyByOrgList = StrategyServiceHelper.getEmpStrategyByOrgList(orgIdList)))) {
            Stream.of(empStrategyByOrgList).forEach(dy -> StrategyHandleServiceHelper.disableStrategy(map, dy));
            EMP_STRATEGY_HELPER.save((DynamicObject[])empStrategyByOrgList);
        }
    }

    private static void disableStrategy(Map<Long, DynamicObject> map, DynamicObject dyo) {
        DynamicObject newOrgDyo = map.get(dyo.get(FIELD_ORGTEAM_ID));
        Date date = newOrgDyo.getDate(FIELD_EFFECT_DATE);
        dyo.set("effdt", (Object)date);
        dyo.set("status", (Object)"C");
        dyo.set("enable", (Object)"0");
        DynamicObjectCollection dynamicObjectCollection = dyo.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            dynamicObject.set("entryeffdt", (Object)date);
            dynamicObject.set(FIELD_ENTRY_ENABLE, (Object)"0");
            dynamicObject.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
        }
        dyo.set(FIELD_ENTRYENTITY, (Object)dynamicObjectCollection);
    }

    protected static void batchUpdateEmpStrategy(List<DynamicObject> empStrategyUpList, Long orgTeamId) {
        if (ObjectUtils.isEmpty(empStrategyUpList)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("batchUpdateEmpStrategy log:assignEmpStrategyUpList is empty,orgTeamId=" + orgTeamId);
            }
            return;
        }
        DynamicObject[] queryStrategyDyList = StrategyServiceHelper.getEmpStrategyByOrg(new Long[]{orgTeamId});
        EMP_STRATEGY_HELPER.save(empStrategyUpList.toArray(new DynamicObject[0]));
        StrategyServiceHelper.sysnSubOrgStrategy(queryStrategyDyList[0], empStrategyUpList.get(0), "emp");
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.batchUpdateEmpStrategy", () -> StrategyLogServiceHelper.writeLog(new DynamicObject[]{(DynamicObject)empStrategyUpList.get(0)}, queryStrategyDyList, StrategyLogServiceHelper.StrategyLogEnum.INHERITEDORG_MODIFY, false, new DynamicObjectType[0]));
    }

    protected static void batchUpdateOrgStrategy(List<DynamicObject> orgStrategyUpList, Long orgTeamId) {
        if (ObjectUtils.isEmpty(orgStrategyUpList)) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("batchUpdateOrgStrategy assignOrgStrategyUpList is empty,orgTeamId=" + orgTeamId);
            }
            return;
        }
        DynamicObject[] queryStrategyDyList = StrategyServiceHelper.getOrgStrategyListByOrgIds(new Long[]{orgTeamId});
        ORG_STRATEGY_HELPER.save(orgStrategyUpList.toArray(new DynamicObject[orgStrategyUpList.size()]));
        StrategyServiceHelper.sysnSubOrgStrategy(queryStrategyDyList[0], orgStrategyUpList.get(0), "org");
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.batchUpdateOrgStrategy", () -> StrategyLogServiceHelper.writeLog(new DynamicObject[]{(DynamicObject)orgStrategyUpList.get(0)}, queryStrategyDyList, StrategyLogServiceHelper.StrategyLogEnum.INHERITEDORG_MODIFY, false, new DynamicObjectType[0]));
    }

    protected static void copyEmpStrategyByOrg(Map<Long, DynamicObject> map) {
        ArrayList<Object> beforeBillOfOrgList = new ArrayList<Object>(map.keySet());
        DynamicObject[] oldEmpStrategyByOrgList = StrategyServiceHelper.getEmpStrategyAllFieldsByOrgList(beforeBillOfOrgList);
        DynamicObjectCollection strategyColl = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : oldEmpStrategyByOrgList) {
            DynamicObject curStrategyDy = new DynamicObject(dynamicObject.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)curStrategyDy);
            long strategyId = DBServiceHelper.genGlobalLongId();
            curStrategyDy.set("id", (Object)strategyId);
            DynamicObject newOrgDynamicObj = map.get(dynamicObject.get(FIELD_ORGTEAM_ID));
            Date date = newOrgDynamicObj.getDate(FIELD_EFFECT_DATE);
            curStrategyDy.set("orgteam", newOrgDynamicObj.get(FIELD_ADMINORG));
            curStrategyDy.set("effdt", (Object)date);
            StrategyHandleServiceHelper.handleMainByStrageType(dynamicObject, curStrategyDy, newOrgDynamicObj);
            DynamicObjectCollection dynamicObjectCollection = curStrategyDy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject strategyEntryDy : dynamicObjectCollection) {
                long entryId = DBServiceHelper.genGlobalLongId();
                Long strategyDyId = curStrategyDy.getLong("id");
                strategyEntryDy.set("id", (Object)entryId);
                strategyEntryDy.set("sourceentry", (Object)strategyDyId);
                strategyEntryDy.set("entryorgteam", newOrgDynamicObj.get(FIELD_ADMINORG));
                strategyEntryDy.set("entryorgteam_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDynamicObj, (String)FIELD_ADMINORG));
                strategyEntryDy.set("entryeffdt", (Object)date);
                StrategyHandleServiceHelper.handleEntryByStragyType(newOrgDynamicObj, strategyEntryDy);
            }
            curStrategyDy.set(FIELD_ENTRYENTITY, (Object)dynamicObjectCollection);
            strategyColl.add((Object)curStrategyDy);
        }
        if (strategyColl.size() > 0) {
            StrategyServiceHelper.addEmpStrategyHisByList((DynamicObject[])strategyColl.toArray((Object[])new DynamicObject[0]), "0");
        }
    }

    private static void handleEntryByStragyType(DynamicObject newOrgDy, DynamicObject strategyEntryDy) {
        DynamicObject entryStrategy = strategyEntryDy.getDynamicObject("entrydefstrategy");
        switch (entryStrategy.getString("strategytype")) {
            case "0": {
                StrategyHandleServiceHelper.handleSameParentStrategy(newOrgDy, strategyEntryDy);
                break;
            }
            case "1": {
                StrategyHandleServiceHelper.handlSaveGroupOrgStrategy(newOrgDy, strategyEntryDy);
                break;
            }
            case "2": {
                StrategyHandleServiceHelper.handlSameCompanyOrgStrategy(newOrgDy, strategyEntryDy);
                break;
            }
            case "3": {
                StrategyHandleServiceHelper.handlSameBizUnitStrategy(newOrgDy, strategyEntryDy);
                break;
            }
            case "4": {
                StrategyHandleServiceHelper.handleSameSpecBizUnit(newOrgDy, strategyEntryDy, entryStrategy);
                break;
            }
        }
    }

    private static void handleSameParentStrategy(DynamicObject newOrgDy, DynamicObject strategyEntryDy) {
        strategyEntryDy.set("entryinheritedorg", newOrgDy.get(FIELD_PARENT));
        strategyEntryDy.set("entrysourceorg", newOrgDy.get(FIELD_PARENT));
        strategyEntryDy.set("entryinheritedorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_PARENT));
        strategyEntryDy.set("entrysourceorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_PARENT));
    }

    private static void handlSaveGroupOrgStrategy(DynamicObject newOrgDy, DynamicObject strategyEntryDy) {
        StrategyHandleServiceHelper.handlSameBizUnitStrategy(newOrgDy, strategyEntryDy);
        DynamicObject groupDy = (DynamicObject)HRMServiceHelper.invokeHRMPService((String)"haos", (String)"IHAOSService", (String)"getCompanyByAdminOrgId", (Object[])new Object[]{HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_PARENT), true});
        if (groupDy != null) {
            strategyEntryDy.set("entryinheritedorg", groupDy.get("id"));
            strategyEntryDy.set("entrysourceorg", groupDy.get("id"));
            strategyEntryDy.set("entryinheritedorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)groupDy, (String)"id"));
            strategyEntryDy.set("entrysourceorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)groupDy, (String)"id"));
        }
    }

    private static void handlSameCompanyOrgStrategy(DynamicObject newOrgDy, DynamicObject strategyEntryDy) {
        strategyEntryDy.set("entryinheritedorg", newOrgDy.get(FIELD_COMPANY));
        strategyEntryDy.set("entrysourceorg", newOrgDy.get(FIELD_COMPANY));
        strategyEntryDy.set("entryinheritedorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_COMPANY));
        strategyEntryDy.set("entrysourceorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_COMPANY));
    }

    private static void handlSameBizUnitStrategy(DynamicObject newOrgDy, DynamicObject strategyEntryDy) {
        strategyEntryDy.set("entryinheritedorg", newOrgDy.get(FIELD_ADMINORG));
        strategyEntryDy.set("entrysourceorg", newOrgDy.get(FIELD_ADMINORG));
        strategyEntryDy.set("entryinheritedorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_ADMINORG));
        strategyEntryDy.set("entrysourceorg_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_ADMINORG));
    }

    private static void handleSameSpecBizUnit(DynamicObject newOrgDy, DynamicObject strategyEntryDy, DynamicObject entryStrategy) {
        DynamicObject stragyDy = StrategyServiceHelper.getStrategyTypeByBussinessfieldAndNumber(entryStrategy.getLong(FIELD_BUSSINESSFIELD_ID), "3");
        strategyEntryDy.set("entrydefstrategy", (Object)stragyDy);
        strategyEntryDy.set("entrydefstrategy_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)stragyDy, (String)"id"));
        StrategyHandleServiceHelper.handlSameBizUnitStrategy(newOrgDy, strategyEntryDy);
    }

    protected static void copyOrgStrategyByOrg(Map<Long, DynamicObject> map) {
        ArrayList<Object> beforeBillOfOrgList = new ArrayList<Object>(map.keySet());
        DynamicObject[] oldOrgStrategyByOrgList = StrategyServiceHelper.getOrgStrategyAllFieldsByOrgList(beforeBillOfOrgList);
        DynamicObjectCollection strategyColl = new DynamicObjectCollection();
        for (DynamicObject dynamicObject : oldOrgStrategyByOrgList) {
            DynamicObject curStrategyDy = new DynamicObject(dynamicObject.getDynamicObjectType());
            HRDynamicObjectUtils.copy((DynamicObject)dynamicObject, (DynamicObject)curStrategyDy);
            long strategyId = DBServiceHelper.genGlobalLongId();
            DynamicObject newOrgDy = map.get(dynamicObject.get(FIELD_ORGTEAM_ID));
            Date date = newOrgDy.getDate(FIELD_EFFECT_DATE);
            curStrategyDy.set("id", (Object)strategyId);
            curStrategyDy.set("orgteam", newOrgDy.get(FIELD_ADMINORG));
            curStrategyDy.set("effdt", (Object)date);
            StrategyHandleServiceHelper.handleMainByStrageType(dynamicObject, curStrategyDy, newOrgDy);
            DynamicObjectCollection dynamicObjectCollection = curStrategyDy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject strategyEntryDy : dynamicObjectCollection) {
                long entryId = DBServiceHelper.genGlobalLongId();
                Long strategyDyId = curStrategyDy.getLong("id");
                strategyEntryDy.set("id", (Object)entryId);
                strategyEntryDy.set("sourceentry", (Object)strategyDyId);
                strategyEntryDy.set("entryorgteam", newOrgDy.get(FIELD_ADMINORG));
                strategyEntryDy.set("entryorgteam_id", (Object)HistoryEntityUtils.getDynamicObjectFieldId((DynamicObject)newOrgDy, (String)FIELD_ADMINORG));
                strategyEntryDy.set("entryeffdt", (Object)date);
                StrategyHandleServiceHelper.handleEntryByStragyType(newOrgDy, strategyEntryDy);
            }
            curStrategyDy.set(FIELD_ENTRYENTITY, (Object)dynamicObjectCollection);
            strategyColl.add((Object)curStrategyDy);
        }
        if (strategyColl.size() > 0) {
            StrategyServiceHelper.addOrgStrategyHisByList((DynamicObject[])strategyColl.toArray((Object[])new DynamicObject[0]), "0");
        }
    }

    protected static void copyStrategyByOrg(Map<Long, DynamicObject> map) {
        StrategyHandleServiceHelper.copyOrgStrategyByOrg(map);
        StrategyHandleServiceHelper.copyEmpStrategyByOrg(map);
    }

    protected static void enableOrgStrategy(List<DynamicObject> hasAdminOrgList) {
        if (ObjectUtils.isEmpty(hasAdminOrgList)) {
            return;
        }
        Set<Long> adminOrgIds = hasAdminOrgList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        StrategyHandleServiceHelper.doEnableOrgStrategy(adminOrgIds);
    }

    public static void doEnableOrgStrategy(Set<Long> adminOrgIds) {
        DynamicObject[] hasSetEmpStrategyList;
        QFilter filter1 = new QFilter(FIELD_ORGTEAM_ID, "in", adminOrgIds);
        QFilter filter2 = new QFilter("enable", "=", (Object)"0");
        DynamicObject[] hasSetOrgStrategyList = ORG_STRATEGY_HELPER.query("id, orgteam, inheritedorg, hrbu, sourceorg, strategytype, status, enable,effdt, effectivedate,changetype, modifytime, modifier, entryentity.id,entryentity.entryhrbu,entryentity.entryinheritedorg, entryentity.entryenable,entryentity.entryorgteam,entryentity.bussinessfield, entryentity.strategyentrytype,entryentity.entrysourceorg, entryeffdt, entryentity.entrydefstrategy, defstrategytype,entryentity.entrychangetype", new QFilter[]{filter1, filter2});
        if (hasSetOrgStrategyList.length > 0) {
            Stream.of(hasSetOrgStrategyList).forEach(dy -> {
                dy.set("status", (Object)"C");
                dy.set("enable", (Object)"1");
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set(FIELD_ENTRY_ENABLE, (Object)"1");
                    dynamicObject.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
                }
            });
            ORG_STRATEGY_HELPER.save(hasSetOrgStrategyList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyHandleServiceHelper.doEnableOrgStrategy.org", () -> StrategyLogServiceHelper.writeLog(hasSetOrgStrategyList, hasSetOrgStrategyList, StrategyLogServiceHelper.StrategyLogEnum.ORG_ENABLE, false, new DynamicObjectType[0]));
        }
        if ((hasSetEmpStrategyList = EMP_STRATEGY_HELPER.query("id, orgteam, inheritedorg, hrbu, sourceorg, strategytype, status, enable,effdt, effectivedate,changetype, modifytime, modifier, entryentity.id,entryentity.entryhrbu,entryentity.entryinheritedorg, entryentity.entryenable,entryentity.entryorgteam,entryentity.bussinessfield, entryentity.strategyentrytype,entryentity.entrysourceorg, entryeffdt, entryentity.entrydefstrategy, defstrategytype,entryentity.entrychangetype", new QFilter[]{filter1, filter2})).length > 0) {
            Stream.of(hasSetEmpStrategyList).forEach(dy -> {
                dy.set("enable", (Object)"1");
                dy.set("status", (Object)"C");
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set(FIELD_ENTRY_ENABLE, (Object)"1");
                    dynamicObject.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
                }
            });
            EMP_STRATEGY_HELPER.save(hasSetEmpStrategyList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyHandleServiceHelper.doEnableOrgStrategy.emp", () -> StrategyLogServiceHelper.writeLog(hasSetEmpStrategyList, hasSetEmpStrategyList, StrategyLogServiceHelper.StrategyLogEnum.ORG_ENABLE, false, new DynamicObjectType[0]));
        }
    }

    protected static List<DynamicObject> getChildStrategyEntrysDys(String strategyTye, DynamicObject strategyEntryEntity, Long oldBussinessFieldId) {
        ArrayList childStrategyEntrysDys = Lists.newArrayListWithExpectedSize((int)16);
        if (StrategyHandleServiceHelper.isSourceOrg(strategyEntryEntity)) {
            Long oldSourceOrgId = strategyEntryEntity.getLong("entrysourceorg.id");
            LOGGER.info("StrategyHandleServiceHelper.getChildStrategyEntrysDys(),isSourceOrg oldSourceOrgId:{}", (Object)oldSourceOrgId);
            DynamicObject[] childStrategyEntrysDysHolder = strategyTye.equals("emp") ? StrategyServiceHelper.getEmpStrategyEntryBySourceOrgListAndBussinessField(oldSourceOrgId, oldBussinessFieldId) : StrategyServiceHelper.getOrgStrategyEntryBySourceOrgListAndBussinessField(oldSourceOrgId, oldBussinessFieldId);
            childStrategyEntrysDys.addAll(Arrays.asList(childStrategyEntrysDysHolder));
        } else {
            HRBaseServiceHelper serviceHelper = "org".equals(strategyTye) ? new HRBaseServiceHelper("hrcs_orgstrentry") : new HRBaseServiceHelper("hrcs_empstrentry");
            StrategyHandleServiceHelper.getStrategyEntryByInheritedOrg(serviceHelper, strategyEntryEntity.getLong("entryorgteam.id"), strategyEntryEntity.getLong("bussinessfield.bussinesstype.id"), childStrategyEntrysDys);
        }
        return childStrategyEntrysDys;
    }

    protected static void getStrategyEntryByInheritedOrg(HRBaseServiceHelper serviceHelper, Long inheritedOrgId, Long bussinessFieldId, List<DynamicObject> childStrategyEntrysDys) {
        QFilter entryInhFilter = new QFilter("inheritedorg.id", "=", (Object)inheritedOrgId);
        QFilter bussinessFieldFilter = new QFilter("bussinessfield.bussinesstype.id", "=", (Object)bussinessFieldId);
        Object[] inhStrategies = serviceHelper.loadDynamicObjectArray(new QFilter[]{entryInhFilter, bussinessFieldFilter});
        if (!ObjectUtils.isEmpty((Object[])inhStrategies)) {
            Map id2Dy = childStrategyEntrysDys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity()));
            Set<Long> ids = id2Dy.keySet();
            List<DynamicObject> collect = Arrays.stream(inhStrategies).filter(dy -> !ids.contains(dy.getLong("id"))).collect(Collectors.toList());
            childStrategyEntrysDys.addAll(collect);
            if (collect.size() > 0) {
                collect.forEach(dy -> StrategyHandleServiceHelper.getStrategyEntryByInheritedOrg(serviceHelper, dy.getLong(FIELD_ORGTEAM_ID), bussinessFieldId, childStrategyEntrysDys));
            }
        }
    }

    private static boolean isSourceOrg(DynamicObject stratgyEntry) {
        return stratgyEntry.getLong("entryorgteam.id") == stratgyEntry.getLong("entrysourceorg.id");
    }

    protected static DynamicObjectCollection setEntryByColl(DynamicObject orgDy, String type, HRBaseServiceHelper serviceHelper, DynamicObject strategyDy, DynamicObject parentStrategy, Map<Long, List<Long>> bussType2HROrgMap, Map<Long, Long> businessTypeRelaMap, Map<String, List<DynamicObject>> allFieldDys, Map<Long, Map<String, List<DynamicObject>>> strategyTypeList, boolean isRootOrg) {
        HashSet<String> flag = new HashSet<String>(2);
        boolean flag2 = "1".equals(type);
        int seq = 1;
        String strategyTypeKey = flag2 ? "empCurRelatedHROrg" : "orgCurRelatedHROrg";
        String strategyTypeKey2 = flag2 ? "empSameParent" : "orgSameParent";
        DynamicObjectCollection entryColl = serviceHelper.generateEmptyEntryCollection(strategyDy, FIELD_ENTRYENTITY);
        Map<Long, List<DynamicObject>> parentEntryCollectMap = null;
        if (parentStrategy != null) {
            DynamicObjectCollection parentEntryColl = parentStrategy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            parentEntryCollectMap = parentEntryColl.stream().collect(Collectors.groupingBy(dy -> dy.getLong(FIELD_BUSSINESSFIELD_ID) == 0L ? dy.getLong("bussinessfield") : dy.getLong(FIELD_BUSSINESSFIELD_ID)));
        }
        for (Map.Entry<Long, Map<String, List<DynamicObject>>> entry : strategyTypeList.entrySet()) {
            Long businessTypeRelaId = entry.getKey();
            DynamicObject strategyEntryDy = serviceHelper.generateEmptyEntryDynamicObject(FIELD_ENTRYENTITY);
            strategyEntryDy.set("id", (Object)DBServiceHelper.genGlobalLongId());
            strategyEntryDy.set("entryorgteam", (Object)orgDy);
            strategyEntryDy.set("entryeffdt", (Object)new Date());
            strategyEntryDy.set("strategyentrytype", (Object)"0");
            strategyEntryDy.set(FIELD_ENTRY_ENABLE, strategyDy.get("enable"));
            strategyEntryDy.set("bussinessfield", (Object)businessTypeRelaId);
            strategyEntryDy.set("seq", (Object)seq);
            List<Long> hrOrgIds = bussType2HROrgMap.get(businessTypeRelaMap.get(businessTypeRelaId));
            if (isRootOrg || hrOrgIds != null && hrOrgIds.contains(orgDy.getLong("id"))) {
                flag.add("1");
                strategyEntryDy.set("entryhrbu", (Object)orgDy);
                strategyEntryDy.set("entrysourceorg", (Object)orgDy);
                strategyEntryDy.set("entryinheritedorg", (Object)orgDy);
                strategyEntryDy.set("entrydefstrategy", (Object)entry.getValue().get(strategyTypeKey).get(0));
            } else {
                flag.add("2");
                if (parentEntryCollectMap != null) {
                    List<DynamicObject> dynamicObjects = parentEntryCollectMap.get(businessTypeRelaId);
                    if (Objects.isNull(dynamicObjects)) {
                        LOGGER.error("StrategyHandleServiceHelper.setEntryByColl() parentEntryCollectMap:{},businessTypeRelaId:{}", parentEntryCollectMap, (Object)businessTypeRelaId);
                    } else {
                        DynamicObject parentDy = dynamicObjects.get(0);
                        strategyEntryDy.set("entryhrbu", parentDy.get("entryhrbu"));
                        strategyEntryDy.set("entrysourceorg", parentDy.get("entryhrbu"));
                        strategyEntryDy.set("entryinheritedorg", parentDy.get("entryorgteam"));
                    }
                }
                strategyEntryDy.set("entrydefstrategy", (Object)entry.getValue().get(strategyTypeKey2).get(0));
            }
            entryColl.add((Object)strategyEntryDy);
        }
        if (flag.size() == 1 && flag.contains("1")) {
            strategyDy.set("hrbu", (Object)orgDy);
            strategyDy.set("sourceorg", (Object)orgDy);
            strategyDy.set("inheritedorg", (Object)orgDy);
            strategyDy.set("defstrategytype", (Object)allFieldDys.get(strategyTypeKey).get(0));
        } else {
            if (parentStrategy != null) {
                strategyDy.set("hrbu", (Object)parentStrategy.getLong("hrbu.id"));
                strategyDy.set("sourceorg", (Object)parentStrategy.getDynamicObject("sourceorg"));
            }
            if (flag.size() == 1) {
                strategyDy.set("inheritedorg", (Object)orgDy.getDynamicObject(FIELD_PARENT));
                strategyDy.set("defstrategytype", (Object)allFieldDys.get(strategyTypeKey2).get(0));
            }
        }
        return entryColl;
    }

    protected static DynamicObject setCommonFieldStrategyByNewOrg(DynamicObject orgDy, HRBaseServiceHelper serviceHelper, long userId, Map<Long, String> orgIdToEnableMap) {
        DynamicObject strategyDy = serviceHelper.generateEmptyDynamicObject();
        Date nowDate = new Date();
        long id = DBServiceHelper.genGlobalLongId();
        strategyDy.set("id", (Object)id);
        strategyDy.set("masterid", (Object)id);
        strategyDy.set("createtime", (Object)nowDate);
        strategyDy.set("creator", (Object)userId);
        strategyDy.set("modifytime", (Object)nowDate);
        strategyDy.set("modifier", (Object)userId);
        strategyDy.set("enable", (Object)orgIdToEnableMap.getOrDefault(orgDy.getLong("id"), "1"));
        strategyDy.set("status", (Object)"C");
        strategyDy.set("orgteam", (Object)orgDy);
        return strategyDy;
    }

    protected static void getChangeStrategyEntitys(Map<Long, DynamicObject> oldStrategyEntityMap, Map<Long, DynamicObject> newStrategyEntityMap, Map<Long, List<String>> businessFieldChangeListMap, List<DynamicObject> hrbuChangedStrategyEntities, String strategyTye, Map<Long, List<StrategyChangeInfo>> changeInfoList) {
        for (Map.Entry<Long, DynamicObject> entry : oldStrategyEntityMap.entrySet()) {
            ArrayList changeFieldList = Lists.newArrayListWithExpectedSize((int)2);
            DynamicObject oldDynamicObject = oldStrategyEntityMap.get(entry.getKey());
            DynamicObject newDynamicObject = newStrategyEntityMap.get(entry.getKey());
            long oldHrbuId = oldDynamicObject.getLong("entryhrbu.id");
            long oldSourceOrgId = oldDynamicObject.getLong("entrysourceorg.id");
            long newHrbuId = newDynamicObject.getLong("entryhrbu.id");
            long newSourceOrgId = newDynamicObject.getLong("entrysourceorg.id");
            if (oldHrbuId != newHrbuId) {
                changeFieldList.add("entryhrbu");
                hrbuChangedStrategyEntities.add(newStrategyEntityMap.get(entry.getKey()));
                ArrayList list = Lists.newArrayListWithExpectedSize((int)16);
                long bussinessFieldId = oldDynamicObject.getLong("bussinessfield.bussinesstype.id");
                list.add(new StrategyChangeInfo(strategyTye, oldDynamicObject.getLong("entryorgteam.id"), bussinessFieldId, oldHrbuId, newHrbuId));
                changeInfoList.put(bussinessFieldId, list);
            }
            if (oldSourceOrgId != newSourceOrgId) {
                changeFieldList.add("entrysourceorg");
            }
            businessFieldChangeListMap.put(oldStrategyEntityMap.get(entry.getKey()).getLong(FIELD_BUSSINESSFIELD_ID), changeFieldList);
        }
    }

    protected static void setStrategyDyUpList(DynamicObject dyc, DynamicObject parentDyc, List<DynamicObject> list) {
        Date date = new Date();
        DynamicObjectCollection dycCollection = dyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        DynamicObjectCollection parentDycCollection = parentDyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        boolean flag = false;
        for (DynamicObject dy : dycCollection) {
            String strategyType;
            Long parentBizTypeId;
            DynamicObject parentDy;
            Long bussinessTypeId = dy.getLong(FIELD_BUSSINESSFIELD_ID);
            Long strategyId = dy.getLong("entrydefstrategy.id");
            Iterator iterator = parentDycCollection.iterator();
            while (iterator.hasNext() && !StrategyHandleServiceHelper.isSuccessSetStrategyUpFileldDy(date, dy, bussinessTypeId, strategyId, parentDy = (DynamicObject)iterator.next(), parentBizTypeId = Long.valueOf(parentDy.getLong(FIELD_BUSSINESSFIELD_ID)))) {
            }
            DynamicObject strategyDy = dy.getDynamicObject("entrydefstrategy");
            if (ObjectUtils.isEmpty((Object)strategyDy) || HRStringUtils.equals((String)(strategyType = strategyDy.getString("strategytype")), (String)"3") || HRStringUtils.equals((String)strategyType, (String)"5")) continue;
            Long entryinheritedorgId = parentDyc.getLong(FIELD_ORGTEAM_ID);
            dy.set("entryinheritedorg", (Object)entryinheritedorgId);
            flag = true;
        }
        if (flag) {
            list.add(dyc);
        }
    }

    private static boolean isSuccessSetStrategyUpFileldDy(Date date, DynamicObject dy, Long bussinessTypeId, Long strategyId, DynamicObject parentDy, Long parentBizTypeId) {
        if (parentBizTypeId.compareTo(bussinessTypeId) == 0 && StrategyServiceHelper.ORG_STRATEGY_BIZ_TYPE_LIST.contains(strategyId)) {
            dy.set("entryhrbu", parentDy.get("entryhrbu"));
            dy.set("entrysourceorg", parentDy.get("entrysourceorg"));
            dy.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
            dy.set("entryeffdt", (Object)date);
            return true;
        }
        return false;
    }

    protected static Map<Long, Map<String, Object>> invokeStrategyType(String clazzName, DynamicObject strategyTypeDy, List<Long> orgIdList, String objectType, Boolean isAllField) {
        String errMsg = "StrategyServiceHelper invoke Class error :";
        try {
            Class<?> clazz = Class.forName(clazzName);
            Object instance = clazz.newInstance();
            Method method = clazz.getMethod("setResultMap", DynamicObject.class, List.class, String.class, Boolean.class);
            return (Map)method.invoke(instance, strategyTypeDy, orgIdList, objectType, isAllField);
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("ClassNotFoundException:" + errMsg + e);
        }
        catch (InstantiationException e) {
            LOGGER.error("InstantiationException:" + errMsg + e);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("IllegalAccessException:" + errMsg + e);
        }
        catch (NoSuchMethodException e) {
            LOGGER.error("NoSuchMethodException:" + errMsg + e);
        }
        catch (SecurityException e) {
            LOGGER.error("SecurityException:" + errMsg + e);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("IllegalArgumentException:" + errMsg + e);
        }
        catch (InvocationTargetException e) {
            LOGGER.error("InvocationTargetException:" + errMsg + e);
        }
        return null;
    }

    protected static Map<String, Object> getHrbuReturnMap(DynamicObject[] StrategyEntryDys, Long bussinessField) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> defResult = new HashMap<String, Object>();
        if (null == StrategyEntryDys) {
            return result;
        }
        for (DynamicObject dy : StrategyEntryDys) {
            Long bussinessFieldId = dy.getLong(FIELD_BUSSINESSFIELD_ID);
            if (bussinessField.compareTo(bussinessFieldId) == 0) {
                result.put("type", "sourceentry");
                result.put("id", dy.getLong("id"));
                result.put("hrbu", dy.getDynamicObject("hrbu"));
                break;
            }
            defResult.put("type", "defStrategy");
            defResult.put("id", dy.getLong("id"));
            defResult.put("hrbu", dy.getDynamicObject("hrbu"));
        }
        if (result.size() == 0) {
            return defResult;
        }
        return result;
    }

    protected static List<DynamicObject> getStrategyUpList(DynamicObject[] strategyList, DynamicObject[] parentStrategyList) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(1);
        if (!ObjectUtils.isEmpty((Object[])strategyList) && !ObjectUtils.isEmpty((Object[])parentStrategyList)) {
            DynamicObject dyc = strategyList[0];
            DynamicObject parentDyc = parentStrategyList[0];
            dyc.set("inheritedorg", parentDyc.get(FIELD_ORGTEAM_ID));
            dyc.set("changetype", (Object)"0");
            StrategyHandleServiceHelper.setStrategyDyUpList(dyc, parentDyc, list);
        }
        return list;
    }

    protected static QFilter queryEnableAndDefEntryByBussinessField(Long orgId, Long bussinessField) {
        QFilter orgFilter = new QFilter("orgteam", "=", (Object)orgId);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", (Object)bussinessField);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        bussinessFieldFilter.and(enableFilter);
        orgFilter.and(bussinessFieldFilter);
        return orgFilter;
    }

    protected static List<Long> initBussinessObjectIdList() {
        ArrayList<Long> bussinessObjectIds = new ArrayList<Long>();
        bussinessObjectIds.add(ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_EMP);
        bussinessObjectIds.add(ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_ORG);
        return bussinessObjectIds;
    }

    public static HashMap<Long, Integer> getOrgLevelMap(Set<Long> ids) {
        HashMap levelMap = Maps.newHashMapWithExpectedSize((int)16);
        QFilter qFilter = new QFilter(FIELD_ORGTEAM_ID, "in", ids);
        QFilter hisDataFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        hisDataFilter.and("iscurrentversion", "=", (Object)Character.valueOf('1'));
        hisDataFilter.and("structproject", "in", (Object)Lists.newArrayList((Object[])new Long[]{1010L, 1020L}));
        DataSet dataSet = ORG_LEVEL_HELPER.queryDataSet("StrategyServiceHelper.getOrgLevelMap", "orgteam.id,level", new QFilter[]{qFilter, hisDataFilter});
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            levelMap.put(next.getLong(FIELD_ORGTEAM_ID), next.getInteger("level"));
        }
        return levelMap;
    }
}

