/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.promptenum.MultiLangEnumBridge;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntryType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.log.api.ILogService;
import kd.bos.log.api.OpLogAppInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.dao.factory.HRBaseDaoFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.business.util.ExcludeFromJacocoGeneratedReport;
import kd.hr.hbp.common.mservice.HRMServiceResult;
import kd.hr.hbp.common.util.HRDBUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyHandleServiceHelper;
import kd.hr.hrcs.bussiness.service.StrategyLogServiceHelper;
import kd.hr.hrcs.bussiness.servicehelper.HRBUExtServiceHelper;
import kd.hr.hrcs.bussiness.strategy.InitStrategyService;
import kd.hr.hrcs.bussiness.strategy.StrategyApiServiceHelper;
import kd.hr.hrcs.bussiness.strategy.StrategyChangeServiceHelper;
import kd.hr.hrcs.common.constants.ManageStrategyConstants;
import org.apache.commons.collections.CollectionUtils;

@ExcludeFromJacocoGeneratedReport
public class StrategyServiceHelper {
    public static final HRBaseServiceHelper EMP_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_empstrategy");
    public static final HRBaseServiceHelper ORG_STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_orgstrategy");
    public static final String STRATEGYBYORGS_QUERY_STR = "id, orgteam, inheritedorg, hrbu, sourceorg, strategytype, status, enable,effdt, effectivedate,changetype, modifytime, modifier, entryentity.id,entryentity.entryhrbu,entryentity.entryinheritedorg, entryentity.entryenable,entryentity.entryorgteam,entryentity.bussinessfield, entryentity.strategyentrytype,entryentity.entrysourceorg, entryeffdt, entryentity.entrydefstrategy, defstrategytype,entryentity.entrychangetype";
    public static final String STRATEGYENTRY_QUERY_STR = "orgteam, strategy, inheritedorg, hrbu, classname,sourceorg, strategytype, enable, effdt, modifytime, modifier, bussinessfield, strategyentrytype";
    public static final String STRATEGYBYORGS_ALL_FEILDS = "id, number,name,status,creator,modifier,enable,createtime,modifytime,masterid,disabler,disabledate,index,issyspreset,simplename,description,inheritedorg,effdt,defstrategytype,leffdt,sourceorg,hrbu,orgteam,inittype,changetype,effectivedate,entryentity.id,entryentity.entryhrbu,entryentity.entryinheritedorg,entryentity.entryenable,entryentity.entryorgteam,entryentity.bussinessfield,entryentity.strategyentrytype,entryentity.entrysourceorg, entryentity.entryeffdt,entryentity.entrydefstrategy, entryentity.defstrategytype,entryentity.entrychangetype,entryentity.entryleffdt,entryentity.sourceentry,entryentity.entrystrategy";
    protected static final List<Long> ORG_STRATEGY_BIZ_TYPE_LIST = Arrays.asList(1050L, 1010L, 1020L, 1030L, 1040L, 1380L, 1390L, 1400L, 1410L, 1420L, 1430L, 1440L, 1450L, 1460L, 1980L, 1060L, 1120L, 1180L, 1240L, 1300L, 1360L, 1070L, 1080L, 1090L, 1100L, 1110L, 1120L, 1470L, 1480L, 1490L, 1500L, 1510L, 1520L, 1530L, 1540L, 1550L, 1560L, 1130L, 1140L, 1150L, 1160L, 1170L, 1180L, 1570L, 1580L, 1590L, 1600L, 1610L, 1620L, 1630L, 1640L, 1650L, 1660L);
    private static final Log LOGGER = LogFactory.getLog(StrategyServiceHelper.class);
    private static final HRBaseServiceHelper EMP_STRATEGY_ENTRY_HELPER = new HRBaseServiceHelper("hrcs_empstrentry");
    private static final HRBaseServiceHelper ORG_STRATEGY_ENTRY_HELPER = new HRBaseServiceHelper("hrcs_orgstrentry");
    private static final HRBaseServiceHelper ADMIN_ORG_STRUCT_HELPER = new HRBaseServiceHelper("haos_adminorgstruct");
    private static final HRBaseServiceHelper ADMIN_ORG_HELPER = new HRBaseServiceHelper("haos_adminorghr");
    private static final HRBaseServiceHelper STRATEGY_HELPER = new HRBaseServiceHelper("hrcs_strategy");
    private static final DBRoute DB_ROUTE_HAOS = new DBRoute("hr");
    private static final String FIELD_BUSSINESSFIELD_ID = "bussinessfield.id";
    private static final String FIELD_ORGTEAM_ID = "orgteam.id";
    private static final String FIELD_ENTRYENTITY = "entryentity";
    private static final String FIELD_ENTRY_ENABLE = "entryenable";
    private static final String FIELD_ENTRY_CHANGE_TYPE = "entrychangetype";

    public static DynamicObject getEmpStrategyByOrg(Object orgId) {
        QFilter orgFilter = new QFilter("orgteam", "=", orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_HELPER.queryOne(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getEmpStrategyByOrg(Object[] orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", (Object)orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject getOrgStrategyByOrg(Object orgId) {
        QFilter orgFilter = new QFilter("orgteam", "=", orgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_HELPER.queryOne(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getOrgStrategyListByOrgIds(Object[] orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", (Object)orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getOrgStrategyEntryByOrgAndBussinessField(Object orgId, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("orgteam", "=", orgId);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter, enableFilter});
    }

    public static DynamicObject[] getEmpStrategyEntryByOrgAndBussinessField(Object orgId, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("orgteam", "=", orgId);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter, enableFilter});
    }

    public static DynamicObject[] getEmpStrategyByOrgList(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getOrgStrategyByEntryId(List<Long> entryIds) {
        QFilter orgFilter = new QFilter("entryentity.id", "in", entryIds);
        return ORG_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter});
    }

    public static DynamicObject[] getEmpStrategyByEntryId(List<Long> entryIds) {
        QFilter orgFilter = new QFilter("entryentity.id", "in", entryIds);
        return EMP_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter});
    }

    public static DynamicObject[] getOrgStrategyByOrgList(List<Long> orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_HELPER.query(STRATEGYBYORGS_QUERY_STR, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getEmpStrategyEntryByOrgListAndBussinessField(List<Long> orgIds, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter, enableFilter});
    }

    public static DynamicObject[] getOrgStrategyEntryByOrgListAndBussinessField(List<Long> orgIds, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter, enableFilter});
    }

    public static DynamicObject[] getStructOrgByOrgIdList(List<Long> adminOrgIdList) {
        QFilter orgFilter = new QFilter("adminorg", "in", adminOrgIdList);
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        currentFilter.and("structproject", "=", (Object)ManageStrategyConstants.ADMINORG_STRUCT_PROJECT);
        return ADMIN_ORG_STRUCT_HELPER.query("adminorg,parentorg,structlongnumber,level", new QFilter[]{orgFilter, currentFilter});
    }

    public static DynamicObject[] getAdminOrgByAdminorgType(Long adminorgTypeId, Integer level) {
        QFilter orgFilter = new QFilter("orgtype.adminorgtypestd", "=", (Object)adminorgTypeId);
        if (level != null) {
            if (level == 1) {
                orgFilter.and("level", "=", (Object)level);
            } else {
                orgFilter.and("level", "<", (Object)level);
            }
        }
        QFilter currentFilter = new QFilter("iscurrentversion", "=", (Object)"1");
        return ADMIN_ORG_HELPER.query("id,name,number,masterid,structnumber", new QFilter[]{orgFilter, currentFilter});
    }

    public static DynamicObject getCompanyByAdminOrgId(long adminOrgId, final boolean onlyGroup) {
        String sql = "select adminorgstruct.fid,adminorgstructtypestd.fid from t_haos_adminorg adminorg inner join t_haos_adminstruct adminstruct on adminorg.fid = adminstruct.fadminorgid inner join t_haos_adminstruct struct on (charindex(concat(struct.fstructlongnumber,'!'), adminstruct.fstructlongnumber) = 1  or struct.fstructlongnumber = adminstruct.fstructlongnumber) inner join t_haos_adminorg adminorgstruct on struct.fadminorgid = adminorgstruct.fid inner join t_haos_adminorgtype adminorgstructtype on adminorgstruct.fadminorgtypeid = adminorgstructtype.fid inner join t_haos_adminorgtypestd adminorgstructtypestd on TO_INTEGER(adminorgstructtype.fadminorgtypestdid) = adminorgstructtypestd.fid where adminorg.fid = ? and (adminorgstructtypestd.fid = 1020 or adminorgstructtypestd.fid = 1010) and adminorg.fiscurrentversion = '1' and struct.fiscurrentversion = '1' and adminstruct.fiscurrentversion = '1' and struct.fstructprojectid = 1010 and adminstruct.fstructprojectid = 1010 order by struct.flevel desc ";
        List companyList = (List)HRDBUtil.query((DBRoute)DB_ROUTE_HAOS, (String)sql, (Object[])new Object[]{adminOrgId}, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> list = new ArrayList<Long>();
                while (rs.next() && !this.addIdToList(onlyGroup, rs, list)) {
                }
                return list;
            }

            private boolean addIdToList(boolean onlyGroup2, ResultSet rs, List<Long> list) throws SQLException {
                boolean result = false;
                if (onlyGroup2) {
                    if (rs.getLong(2) == 1010L) {
                        list.add(rs.getLong(1));
                        result = true;
                    }
                } else if (rs.getLong(2) == 1020L || rs.getLong(2) == 1010L) {
                    list.add(rs.getLong(1));
                    result = true;
                }
                return result;
            }
        });
        if (companyList.size() == 0) {
            LOGGER.error("getCompanyByAdminOrgId() result is empty.");
            return null;
        }
        long companyId = (Long)companyList.get(0);
        DynamicObject companyDy = HRBaseDaoFactory.getInstance((String)"haos_adminorghr").queryOne((Object)companyId);
        LOGGER.info("getCompanyByAdminOrgId() companyDy:{},companyId:{},adminOrgId:{},onlyGroup:{}", new Object[]{companyDy == null ? null : Long.valueOf(companyDy.getLong("id")), companyId, adminOrgId, onlyGroup});
        return companyDy;
    }

    public static DynamicObject getOnlyCompanyByAdminOrgId(long adminOrgId, boolean includeOwn) {
        String sql = "select adminorgstruct.fid,adminorgstructtypestd.fid from t_haos_adminorg adminorg inner join t_haos_adminstruct adminstruct on adminorg.fid = adminstruct.fadminorgid inner join t_haos_adminstruct struct on (charindex(concat(struct.fstructlongnumber,'!'), adminstruct.fstructlongnumber) = 1  or struct.fstructlongnumber = adminstruct.fstructlongnumber) inner join t_haos_adminorg adminorgstruct on struct.fadminorgid = adminorgstruct.fid inner join t_haos_adminorgtype adminorgstructtype on adminorgstruct.fadminorgtypeid = adminorgstructtype.fid inner join t_haos_adminorgtypestd adminorgstructtypestd on adminorgstructtype.fadminorgtypestdid = adminorgstructtypestd.fid and adminorg.fiscurrentversion = '1' and struct.fiscurrentversion = '1' and adminstruct.fiscurrentversion = '1' and struct.fstructprojectid = 1010 and adminstruct.fstructprojectid = 1010 where adminorg.fid = ? and adminorgstructtypestd.fid = 1020 order by struct.flevel desc ";
        List companyList = (List)HRDBUtil.query((DBRoute)DB_ROUTE_HAOS, (String)sql, (Object[])new Object[]{adminOrgId}, rs -> {
            ArrayList<Long> list = new ArrayList<Long>();
            while (rs.next()) {
                if (rs.getLong(2) != 1020L || !includeOwn && rs.getLong(1) == adminOrgId) continue;
                list.add(rs.getLong(1));
                break;
            }
            return list;
        });
        if (companyList.size() == 0) {
            LOGGER.error("getOnlyCompanyByAdminOrgId() result is empty.");
            return null;
        }
        long companyId = (Long)companyList.get(0);
        DynamicObject companyDy = HRBaseDaoFactory.getInstance((String)"haos_adminorghr").queryOne((Object)companyId);
        LOGGER.info("getOnlyCompanyByAdminOrgId() companyDy:{},companyId:{},adminOrgId:{}", new Object[]{companyDy == null ? null : Long.valueOf(companyDy.getLong("id")), companyId, adminOrgId});
        return companyDy;
    }

    public static Map<Long, Map<String, Object>> getHrbuByStrategyType(DynamicObject strategyTypeDy, List<Long> orgIdList, String objectType, boolean isAllField) {
        Map<Long, Map<String, Object>> resultMap = new HashMap<Long, Map<String, Object>>();
        String clazzNameStr = strategyTypeDy.getString("classname");
        if (HRStringUtils.isEmpty((String)clazzNameStr)) {
            return resultMap;
        }
        resultMap = StrategyHandleServiceHelper.invokeStrategyType(clazzNameStr, strategyTypeDy, orgIdList, objectType, isAllField);
        LOGGER.info("============= getHrbuByStrategyType() resultMap:{}", resultMap);
        return resultMap;
    }

    public static void addOrgStrategyHisByList(DynamicObject[] strategyDys, String hisChangeType) {
        for (DynamicObject dyc : strategyDys) {
            DynamicObjectCollection dynamicObjectCollection = dyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject entDy : dynamicObjectCollection) {
                entDy.set(FIELD_ENTRY_CHANGE_TYPE, (Object)hisChangeType);
            }
        }
        ORG_STRATEGY_HELPER.save(strategyDys);
    }

    public static void saveOrgStrategyHisByList(DynamicObject[] strategyDys, String hisChangeType) {
        for (DynamicObject dyc : strategyDys) {
            DynamicObjectCollection dynamicObjectCollection = dyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject entDy : dynamicObjectCollection) {
                entDy.set(FIELD_ENTRY_CHANGE_TYPE, (Object)hisChangeType);
            }
        }
        ORG_STRATEGY_HELPER.save(strategyDys);
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper.saveOrgStrategyHisByList", () -> StrategyLogServiceHelper.writeLog(strategyDys, strategyDys, StrategyLogServiceHelper.StrategyLogEnum.USER_NEW, false, new DynamicObjectType[0]));
    }

    public static void addEmpStrategyHisByList(DynamicObject[] strategyDys, String hisChangeType) {
        for (DynamicObject dyc : strategyDys) {
            DynamicObjectCollection dynamicObjectCollection = dyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject entDy : dynamicObjectCollection) {
                entDy.set(FIELD_ENTRY_CHANGE_TYPE, (Object)hisChangeType);
            }
        }
        EMP_STRATEGY_HELPER.save(strategyDys);
    }

    public static void saveEmpStrategyHisByList(DynamicObject[] strategyDys, String hisChangeType) {
        for (DynamicObject dyc : strategyDys) {
            DynamicObjectCollection dynamicObjectCollection = dyc.getDynamicObjectCollection(FIELD_ENTRYENTITY);
            for (DynamicObject entDy : dynamicObjectCollection) {
                entDy.set(FIELD_ENTRY_CHANGE_TYPE, (Object)hisChangeType);
            }
        }
        EMP_STRATEGY_HELPER.save(strategyDys);
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.ProjStrategyServiceHelper.saveEmpStrategyHisByList", () -> StrategyLogServiceHelper.writeLog(strategyDys, strategyDys, StrategyLogServiceHelper.StrategyLogEnum.USER_NEW, false, new DynamicObjectType[0]));
    }

    public static Map<String, Object> getHrbuFromManageEmpStrategy(Long orgId, Long personId, Long bussinessField, Long perGroupId) {
        QFilter filter = StrategyHandleServiceHelper.queryEnableAndDefEntryByBussinessField(orgId, bussinessField);
        DynamicObject[] strategyEntryDys = EMP_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{filter});
        return StrategyHandleServiceHelper.getHrbuReturnMap(strategyEntryDys, bussinessField);
    }

    public static Map<String, Object> getHRBUFromManageOrgStrategy(Long orgId, Long bussinessField) {
        QFilter filter = StrategyHandleServiceHelper.queryEnableAndDefEntryByBussinessField(orgId, bussinessField);
        DynamicObject[] strategyEntryDys = ORG_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{filter});
        return StrategyHandleServiceHelper.getHrbuReturnMap(strategyEntryDys, bussinessField);
    }

    public static DynamicObject[] getStrategyByBussinessFieldAndStrategyType(List<Long> bussinessFieldIds, String strategyType) {
        QFilter bussinessFieldFilter = new QFilter("bussinessfield", "in", bussinessFieldIds);
        QFilter strategyTypeFilter = new QFilter("strategytype", "=", (Object)strategyType);
        return STRATEGY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{bussinessFieldFilter, strategyTypeFilter});
    }

    public static DynamicObject[] getOrgStrategyEntryById(List<Object> Ids) {
        QFilter orgFilter = new QFilter("id", "in", Ids);
        return ORG_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter});
    }

    public static DynamicObject[] getEmpStrategyEntryById(List<Object> Ids) {
        QFilter orgFilter = new QFilter("id", "in", Ids);
        return EMP_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter});
    }

    public static void saveOrgStrategyEntry(DynamicObject[] strategyEntrys) {
        ORG_STRATEGY_ENTRY_HELPER.save(strategyEntrys);
    }

    public static void saveEmpStrategyEntry(DynamicObject[] strategyEntrys) {
        EMP_STRATEGY_ENTRY_HELPER.save(strategyEntrys);
    }

    public static DynamicObject[] getEmpStrategyEntryBySourceOrgListAndBussinessField(Object orgIds, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("sourceorg", "=", orgIds);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        return EMP_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter});
    }

    public static DynamicObject[] getOrgStrategyEntryBySourceOrgListAndBussinessField(Object orgIds, Object bussinessFieldId) {
        QFilter orgFilter = new QFilter("sourceorg", "=", orgIds);
        QFilter bussinessFieldFilter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", bussinessFieldId);
        return ORG_STRATEGY_ENTRY_HELPER.query(STRATEGYENTRY_QUERY_STR, new QFilter[]{orgFilter, bussinessFieldFilter});
    }

    public static DynamicObject[] getAllOrgStrategyType(List<Long> bussinessObjectIds, List<String> strategyTypes) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter filter = new QFilter("bussinessfield.bussinessobject.id", "in", bussinessObjectIds);
        QFilter strategyTypeFilter = new QFilter("strategytype", "in", strategyTypes);
        return helper.query("bussinessfield,strategytype", new QFilter[]{filter, strategyTypeFilter});
    }

    public static HRMServiceResult enableOrgStrategyByOrg(List<DynamicObject> orgDyList) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(orgDyList)) {
            result.setSuccess(false);
            result.setMessage("StrategyServiceHelper.enableOrgStrategyByOrg() orgDyList is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        try (TXHandle txHandle = TX.required();){
            List adminOrgIds = orgDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
            LOGGER.info("StrategyServiceHelper.enableOrgStrategyByOrg(),adminOrgIds:{}", adminOrgIds);
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_orgstrategy");
            QFilter filter = new QFilter(FIELD_ORGTEAM_ID, "in", adminOrgIds);
            DynamicObject[] hasSetOrgStrategyList = helper.query("id,orgteam,enable", new QFilter[]{filter});
            if (!CollectionUtils.isEmpty(Arrays.asList(hasSetOrgStrategyList))) {
                Set hasSetStrategyAdminOrgIdys = Stream.of(hasSetOrgStrategyList).map(dy -> dy.getLong(FIELD_ORGTEAM_ID)).collect(Collectors.toSet());
                LOGGER.info("StrategyServiceHelper.enableOrgStrategyByOrg(),hasSetStrategyAdminOrgIdys:{}", hasSetStrategyAdminOrgIdys);
                List<DynamicObject> hasAdminOrgList = orgDyList.stream().filter(dy -> hasSetStrategyAdminOrgIdys.contains(dy.getLong("id"))).collect(Collectors.toList());
                StrategyHandleServiceHelper.enableOrgStrategy(hasAdminOrgList);
                orgDyList = orgDyList.stream().filter(dy -> !hasSetStrategyAdminOrgIdys.contains(dy.getLong("id"))).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty(orgDyList)) {
                LOGGER.info("StrategyServiceHelper.enableOrgStrategyByOrg() need to add new StrategyList:{}", orgDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()));
                int size = orgDyList.size() % 500 == 0 ? orgDyList.size() / 500 : orgDyList.size() / 500 + 1;
                for (int index = 0; index < size; ++index) {
                    StrategyServiceHelper.addStrategyByNewOrg(orgDyList.stream().skip(index * 500).limit(500L).collect(Collectors.toList()));
                }
            }
        }
        return result;
    }

    public static HRMServiceResult enableOrgStrategyByOrgTwice(List<Long> adminOrgIds) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(adminOrgIds)) {
            result.setSuccess(false);
            result.setMessage("enableOrgStrategyByOrgTwice() adminOrgIds is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("enableOrgStrategyByOrgTwice() adminOrgIds:{}", adminOrgIds);
        try (TXHandle txHandle = TX.required();){
            HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_orgstrategy");
            QFilter filter = new QFilter(FIELD_ORGTEAM_ID, "in", adminOrgIds);
            Object[] hasSetOrgStrategyList = helper.query("id,orgteam,enable", new QFilter[]{filter});
            if (!ObjectUtils.isEmpty((Object[])hasSetOrgStrategyList)) {
                Set<Long> hasSetStrategyAdminOrgIdys = Arrays.stream(hasSetOrgStrategyList).map(dy -> dy.getLong(FIELD_ORGTEAM_ID)).collect(Collectors.toSet());
                StrategyHandleServiceHelper.doEnableOrgStrategy(hasSetStrategyAdminOrgIdys);
            } else {
                result.setMessage("enableOrgStrategyByOrgTwice() hasSetOrgStrategyList is empty.");
            }
        }
        LOGGER.info("enableOrgStrategyByOrgTwice() result:{}", (Object)result.getMessage());
        return result;
    }

    public static void addStrategyByNewOrg(List<DynamicObject> orgDyList) {
        LOGGER.info("StrategyServiceHelper.addStrategyByNewOrg(),orgDyList size:{}", (Object)orgDyList.size());
        List<Long> bussinessObjectIds = StrategyHandleServiceHelper.initBussinessObjectIdList();
        ArrayList<String> strategyTypes = new ArrayList<String>();
        strategyTypes.add("0");
        strategyTypes.add("4");
        DynamicObject[] allStrategyType = StrategyServiceHelper.getAllOrgStrategyType(bussinessObjectIds, strategyTypes);
        ArrayList empStrategyTypeList = Lists.newArrayListWithCapacity((int)allStrategyType.length);
        ArrayList orgStrategyTypeList = Lists.newArrayListWithCapacity((int)allStrategyType.length);
        for (DynamicObject strategyTypeDy : allStrategyType) {
            long businessObId = strategyTypeDy.getLong("bussinessfield.bussinessobject.id");
            if (ManageStrategyConstants.LONG_BUSSINESSOBJECTID_ID_EMP == businessObId) {
                empStrategyTypeList.add(strategyTypeDy);
                continue;
            }
            orgStrategyTypeList.add(strategyTypeDy);
        }
        Map<Long, Map<String, List<DynamicObject>>> empStrategyTypeMap = empStrategyTypeList.stream().collect(Collectors.groupingBy(dy -> dy.getLong(FIELD_BUSSINESSFIELD_ID), Collectors.groupingBy(dy2 -> "4".equals(dy2.getString("strategytype")) ? "empCurRelatedHROrg" : "empSameParent")));
        Map<Long, Map<String, List<DynamicObject>>> orgStrategyTypeMap = orgStrategyTypeList.stream().collect(Collectors.groupingBy(dy -> dy.getLong(FIELD_BUSSINESSFIELD_ID), Collectors.groupingBy(dy2 -> "4".equals(dy2.getString("strategytype")) ? "orgCurRelatedHROrg" : "orgSameParent")));
        ArrayList<Long> parentOrgIdList = new ArrayList<Long>(orgDyList.size());
        ArrayList<Object> OrgIdList = new ArrayList<Object>(orgDyList.size());
        orgDyList.forEach(dy -> {
            OrgIdList.add(dy.getLong("id"));
            parentOrgIdList.add(dy.getLong("parent.id"));
        });
        DynamicObject rootHROrg = HRBUExtServiceHelper.getRootHROrg();
        Long rootHROrgId = 0L;
        if (rootHROrg != null) {
            rootHROrgId = rootHROrg.getLong("id");
            parentOrgIdList.add(rootHROrgId);
        }
        Map<Long, List<Long>> bussType2HROrgMap = HRBUExtServiceHelper.getHROrgByIds(OrgIdList);
        LOGGER.info("StrategyServiceHelper.addStrategyByNewOrg(),bussType2HROrgMap:{}", bussType2HROrgMap);
        QFilter filter2 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] businessTypeRela = new HRBaseServiceHelper("hrcs_bussinesstype").query("id,bussinesstype.id", new QFilter[]{filter2});
        Map<Long, Long> businessTypeRelaMap = Arrays.stream(businessTypeRela).collect(Collectors.toMap(dy -> dy.getLong("id"), dy2 -> dy2.getLong("bussinesstype.id")));
        StrategyServiceHelper.saveStrategyOfNew("1", orgDyList, parentOrgIdList, rootHROrgId, bussType2HROrgMap, businessTypeRelaMap, empStrategyTypeMap);
        StrategyServiceHelper.saveStrategyOfNew("2", orgDyList, parentOrgIdList, rootHROrgId, bussType2HROrgMap, businessTypeRelaMap, orgStrategyTypeMap);
    }

    public static void saveStrategyOfNew(String type, List<DynamicObject> orgDyList, List<Long> parentOrgList, Long rootHROrgId, Map<Long, List<Long>> bussType2HROrgMap, Map<Long, Long> businessTypeRelaMap, Map<Long, Map<String, List<DynamicObject>>> strategyTypeList) {
        boolean flag = "1".equals(type);
        HRBaseServiceHelper serviceHelper = flag ? EMP_STRATEGY_HELPER : ORG_STRATEGY_HELPER;
        DynamicObject[] strategyDys = flag ? StrategyServiceHelper.getEmpStrategyByOrgList(parentOrgList) : StrategyServiceHelper.getOrgStrategyByOrgList(parentOrgList);
        Map parentStrategyMap = Arrays.stream(strategyDys).collect(Collectors.toMap(dy -> dy.getLong(FIELD_ORGTEAM_ID), Function.identity()));
        LOGGER.info("StrategyServiceHelper.saveStrategyOfNew(),parentStrategyOrgId:{},type:{}", parentStrategyMap.keySet(), (Object)type);
        Long strategyType = flag ? ManageStrategyConstants.LONG_ALLFIELD_BUSSTYPE_ID_EMP : ManageStrategyConstants.LONG_ALLFIELD_BUSSTYPE_ID_ORG;
        Map<String, List<DynamicObject>> allFieldDys = strategyTypeList.remove(strategyType);
        DynamicObjectCollection strategyColl = new DynamicObjectCollection();
        DataSet dataSet = new HRBaseServiceHelper("haos_adminorghr").queryDataSet("StrategyServiceHelper.saveStrategyOfNew", "id,enable", new QFilter[]{new QFilter("id", "in", orgDyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList()))});
        HashMap orgIdToEnableMap = Maps.newHashMapWithExpectedSize((int)orgDyList.size());
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            orgIdToEnableMap.put(row.getLong(0), row.getString(1));
        }
        HashMap orgToDyMap = Maps.newHashMapWithExpectedSize((int)orgDyList.size());
        for (DynamicObject orgDy : orgDyList) {
            DynamicObject parentStrategy;
            Long orgId = orgDy.getLong("id");
            boolean isRootOrg = orgId.equals(rootHROrgId);
            Long parentOrgId = orgDy.getLong("parent.id");
            DynamicObject dynamicObject = parentStrategy = null == parentStrategyMap.get(parentOrgId) ? (DynamicObject)orgToDyMap.get(parentOrgId) : (DynamicObject)parentStrategyMap.get(parentOrgId);
            if (null == parentStrategy) {
                LOGGER.info("StrategyHandleServiceHelper--saveParentNotInHrbuStrategy(),parentStrategy is null,orgId:{}", (Object)orgId);
                parentStrategy = (DynamicObject)parentStrategyMap.get(rootHROrgId);
            }
            DynamicObject strategyDy = StrategyHandleServiceHelper.setCommonFieldStrategyByNewOrg(orgDy, serviceHelper, UserServiceHelper.getCurrentUserId(), orgIdToEnableMap);
            StrategyHandleServiceHelper.setEntryByColl(orgDy, type, serviceHelper, strategyDy, parentStrategy, bussType2HROrgMap, businessTypeRelaMap, allFieldDys, strategyTypeList, isRootOrg);
            strategyColl.add((Object)strategyDy);
            orgToDyMap.put(orgId, strategyDy);
        }
        DynamicObject[] dys = new DynamicObject[strategyColl.size()];
        int index = 0;
        for (DynamicObject dynamicObject : strategyColl) {
            dys[index++] = dynamicObject;
        }
        serviceHelper.save(dys);
    }

    public static DynamicObject getEmpStrategyByStrategyId(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return EMP_STRATEGY_HELPER.queryOne(STRATEGYBYORGS_QUERY_STR, new QFilter[]{filter});
    }

    public static DynamicObject getOrgStrategyByStrategyId(Long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        return ORG_STRATEGY_HELPER.queryOne(STRATEGYBYORGS_QUERY_STR, new QFilter[]{filter});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRMServiceResult handleJuniorAdminOrgStragyByParentOrgId(Long orgTeamId, Long parentOrgteamId) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        LOGGER.info("handleJuniorAdminOrgStragyByParentOrgId() orgTeamId:{},parentOrgteamId:{}", (Object)orgTeamId, (Object)parentOrgteamId);
        try (TXHandle txHandle = TX.required();){
            DynamicObject[] orgstrategyList = StrategyServiceHelper.getOrgStrategyByOrgList(Collections.singletonList(orgTeamId));
            DynamicObject[] parentOrgStrategyList = StrategyServiceHelper.getOrgStrategyByOrgList(Collections.singletonList(parentOrgteamId));
            List<DynamicObject> keepOrgStrategyUpList = StrategyHandleServiceHelper.getStrategyUpList(orgstrategyList, parentOrgStrategyList);
            StrategyHandleServiceHelper.batchUpdateOrgStrategy(keepOrgStrategyUpList, orgTeamId);
            DynamicObject[] parentEmpStrategyByOrgList = StrategyServiceHelper.getEmpStrategyByOrgList(Collections.singletonList(parentOrgteamId));
            DynamicObject[] empStrategyList = StrategyServiceHelper.getEmpStrategyByOrgList(Collections.singletonList(orgTeamId));
            List<DynamicObject> empStrategyUpList = StrategyHandleServiceHelper.getStrategyUpList(empStrategyList, parentEmpStrategyByOrgList);
            StrategyHandleServiceHelper.batchUpdateEmpStrategy(empStrategyUpList, orgTeamId);
        }
        return result;
    }

    public static DynamicObject[] loadOrgStrategyByOrgTeamIdList(Set<Long> orgTeamIdSet) {
        QFilter filter = new QFilter("orgteam", "in", orgTeamIdSet);
        return ORG_STRATEGY_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static DynamicObject[] loadEmpStrategyByOrgTeamIdList(Set<Long> orgTeamIdSet) {
        QFilter filter = new QFilter("orgteam", "in", orgTeamIdSet);
        return EMP_STRATEGY_HELPER.loadDynamicObjectArray(new QFilter[]{filter});
    }

    public static HRMServiceResult disableStrategyByOrg(List<Long> orgIdList) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(orgIdList)) {
            result.setMessage("disableStrategyByOrg() adminOrgIds is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("disableStrategyByOrg() orgIdList:{}", orgIdList);
        Object[] orgStrategyByOrgList = StrategyServiceHelper.getOrgStrategyByOrgList(orgIdList);
        if (!ObjectUtils.isEmpty((Object[])orgStrategyByOrgList)) {
            Stream.of(orgStrategyByOrgList).forEach(dy -> {
                dy.set("status", (Object)"C");
                dy.set("enable", (Object)"0");
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set(FIELD_ENTRY_ENABLE, (Object)"0");
                    dynamicObject.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
                }
                dy.set(FIELD_ENTRYENTITY, (Object)dynamicObjectCollection);
            });
            ORG_STRATEGY_HELPER.save((DynamicObject[])orgStrategyByOrgList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyHandleServiceHelper.disableStrategyByOrg.org", () -> StrategyServiceHelper.lambda$disableStrategyByOrg$19((DynamicObject[])orgStrategyByOrgList));
        } else {
            result.setMessage("disableStrategyByOrg() orgStrategyByOrgList is empty.");
        }
        Object[] empStrategyByOrgList = StrategyServiceHelper.getEmpStrategyByOrgList(orgIdList);
        if (!ObjectUtils.isEmpty((Object[])empStrategyByOrgList)) {
            Stream.of(empStrategyByOrgList).forEach(dy -> {
                dy.set("status", (Object)"C");
                dy.set("enable", (Object)"0");
                DynamicObjectCollection dynamicObjectCollection = dy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    dynamicObject.set(FIELD_ENTRY_ENABLE, (Object)"0");
                    dynamicObject.set(FIELD_ENTRY_CHANGE_TYPE, (Object)"0");
                }
                dy.set(FIELD_ENTRYENTITY, (Object)dynamicObjectCollection);
            });
            EMP_STRATEGY_HELPER.save((DynamicObject[])empStrategyByOrgList);
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyHandleServiceHelper.disableStrategyByOrg.emp", () -> StrategyServiceHelper.lambda$disableStrategyByOrg$21((DynamicObject[])empStrategyByOrgList));
        } else {
            result.setMessage("disableStrategyByOrg() empStrategyByOrgList is empty.");
        }
        LOGGER.info("disableStrategyByOrg() result:{}", (Object)result.getMessage());
        return result;
    }

    public static void sysnSubOrgStrategy(DynamicObject oldStrategy, DynamicObject newStrategy, String strategyTye) {
        DynamicObjectCollection newStrategyEntryEntitys = newStrategy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        DynamicObjectCollection oldStrategyEntryEntitys = oldStrategy.getDynamicObjectCollection(FIELD_ENTRYENTITY);
        LOGGER.info("StrategyServiceHelper--sysnSubOrgStrategy(),newStrategy:{},strategyTye:{}", (Object)newStrategy.getLong("id"), (Object)strategyTye);
        Map<Long, DynamicObject> newStrategyDysConvertToMap = StrategyServiceHelper.strategyDysConvertToMap(newStrategyEntryEntitys);
        Map<Long, DynamicObject> oldStrategyDysConvertToMap = StrategyServiceHelper.strategyDysConvertToMap(oldStrategyEntryEntitys);
        HashMap businessFieldChangeListMap = Maps.newHashMapWithExpectedSize((int)newStrategyEntryEntitys.size());
        ArrayList hrbuChangedStrategyEntities = Lists.newArrayListWithCapacity((int)oldStrategyDysConvertToMap.size());
        HashMap changeInfoList = Maps.newHashMapWithExpectedSize((int)oldStrategyDysConvertToMap.size());
        StrategyHandleServiceHelper.getChangeStrategyEntitys(oldStrategyDysConvertToMap, newStrategyDysConvertToMap, businessFieldChangeListMap, hrbuChangedStrategyEntities, strategyTye, changeInfoList);
        HashMap bussinessfieldOrgListMap2 = Maps.newHashMapWithExpectedSize((int)hrbuChangedStrategyEntities.size());
        for (DynamicObject strategyEntity : hrbuChangedStrategyEntities) {
            Long bussinessFieldRealId = strategyEntity.getLong(FIELD_BUSSINESSFIELD_ID);
            Long bussinessFieldId = strategyEntity.getLong("bussinessfield.bussinesstype.id");
            boolean isSourceOrgChange = ((List)businessFieldChangeListMap.get(bussinessFieldRealId)).contains("entrysourceorg");
            List<DynamicObject> childStrategyEntrysDys = StrategyHandleServiceHelper.getChildStrategyEntrysDys(strategyTye, oldStrategyDysConvertToMap.get(bussinessFieldRealId), bussinessFieldRealId);
            if (ObjectUtils.isEmpty(childStrategyEntrysDys)) {
                childStrategyEntrysDys.add(strategyEntity);
                bussinessfieldOrgListMap2.put(bussinessFieldId, childStrategyEntrysDys);
                continue;
            }
            childStrategyEntrysDys.forEach(dy -> {
                DynamicObject newDynamicObjectTemp = (DynamicObject)newStrategyDysConvertToMap.get(bussinessFieldRealId);
                dy.set("hrbu", newDynamicObjectTemp.get("entryhrbu"));
                if (isSourceOrgChange) {
                    dy.set("sourceorg", newDynamicObjectTemp.get("entrysourceorg.id"));
                }
                dy.set("effdt", (Object)new Date());
            });
            if (strategyTye.equals("emp")) {
                new HRBaseServiceHelper("hrcs_empstrentry").save(childStrategyEntrysDys.toArray(new DynamicObject[0]));
            } else {
                new HRBaseServiceHelper("hrcs_orgstrentry").save(childStrategyEntrysDys.toArray(new DynamicObject[0]));
            }
            childStrategyEntrysDys.add(strategyEntity);
            bussinessfieldOrgListMap2.put(bussinessFieldId, childStrategyEntrysDys);
        }
        ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.publishMsg", () -> StrategyChangeServiceHelper.batchPublishMsg(changeInfoList));
        LOGGER.info("StrategyServiceHelper--sysnSubOrgStrategy(),bussinessfieldOrgListMap2:{}", (Object)bussinessfieldOrgListMap2.size());
        bussinessfieldOrgListMap2.forEach((key, value) -> StrategyServiceHelper.handleProjChildStrategyEntities(strategyTye, key, value));
    }

    public static void handleProjChildStrategyEntities(String strategyTye, Table<Long, Long, Long> changedHROrg) {
        String projteamStrategyNum;
        HRBaseServiceHelper projHRBaseServiceHelper;
        ArrayList projChildStrategyEntrysDys = Lists.newArrayListWithCapacity((int)changedHROrg.size());
        if (strategyTye.equals("emp")) {
            projHRBaseServiceHelper = new HRBaseServiceHelper("hrcs_projempstrentry");
            projteamStrategyNum = "hrcs_projempstrategy";
        } else {
            projHRBaseServiceHelper = new HRBaseServiceHelper("hrcs_projorgstrentry");
            projteamStrategyNum = "hrcs_projorgstrategy";
        }
        HashBasedTable btToChangeInfo = HashBasedTable.create();
        changedHROrg.cellSet().forEach(arg_0 -> StrategyServiceHelper.lambda$handleProjChildStrategyEntities$25(projChildStrategyEntrysDys, projHRBaseServiceHelper, strategyTye, (Table)btToChangeInfo, arg_0));
        Set oldEntryIds = projChildStrategyEntrysDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] oldDy = projHRBaseServiceHelper.query("parent,strategy,hrbu.name,inheritedorg,effdt,bussinessfield", new QFilter[]{new QFilter("id", "in", oldEntryIds)});
        DynamicObject[] saveDy = projChildStrategyEntrysDys.toArray(new DynamicObject[0]);
        projHRBaseServiceHelper.save(saveDy);
        if (saveDy.length > 0) {
            String finalProjteamStrategyNum = projteamStrategyNum;
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.handleProjChildStrategyEntities", () -> StrategyLogServiceHelper.writeLog(saveDy, oldDy, StrategyLogServiceHelper.StrategyLogEnum.INHERITEDORG_MODIFY, true, new DynamicObjectType(finalProjteamStrategyNum)));
            btToChangeInfo.rowMap().forEach((orgId, map) -> map.forEach((key, value) -> ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.publishMsg", () -> StrategyChangeServiceHelper.publishMsg(key, value))));
        }
    }

    public static void handleProjChildStrategyEntities(String strategyTye, Long bussinessFieldId, List<DynamicObject> hrbuChangedStrategyEntities) {
        String projteamStrategyNum;
        HRBaseServiceHelper projHRBaseServiceHelper;
        ArrayList projChildStrategyEntrysDys = Lists.newArrayListWithCapacity((int)hrbuChangedStrategyEntities.size());
        if (strategyTye.equals("emp")) {
            projHRBaseServiceHelper = new HRBaseServiceHelper("hrcs_projempstrentry");
            projteamStrategyNum = "hrcs_projempstrategy";
        } else {
            projHRBaseServiceHelper = new HRBaseServiceHelper("hrcs_projorgstrentry");
            projteamStrategyNum = "hrcs_projorgstrategy";
        }
        ArrayList changeInfoList = Lists.newArrayListWithExpectedSize((int)hrbuChangedStrategyEntities.size());
        for (DynamicObject dy2 : hrbuChangedStrategyEntities) {
            boolean flag = dy2.getDynamicObjectType() instanceof EntryType;
            if (flag) {
                ProjStrategyServiceHelper.getChildStrategyEntrysDys(0L, bussinessFieldId, Collections.singletonList(dy2.getLong("entryorgteam.id")), dy2.getDynamicObject("entryhrbu"), projChildStrategyEntrysDys, projHRBaseServiceHelper, strategyTye, changeInfoList);
                continue;
            }
            ProjStrategyServiceHelper.getChildStrategyEntrysDys(0L, bussinessFieldId, Collections.singletonList(dy2.getLong(FIELD_ORGTEAM_ID)), dy2.getDynamicObject("hrbu"), projChildStrategyEntrysDys, projHRBaseServiceHelper, strategyTye, changeInfoList);
        }
        Set oldEntryIds = projChildStrategyEntrysDys.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        DynamicObject[] oldDy = projHRBaseServiceHelper.query("parent,strategy,hrbu.name,inheritedorg,effdt,bussinessfield", new QFilter[]{new QFilter("id", "in", oldEntryIds)});
        DynamicObject[] saveDy = projChildStrategyEntrysDys.toArray(new DynamicObject[0]);
        projHRBaseServiceHelper.save(saveDy);
        if (saveDy.length > 0) {
            String finalProjteamStrategyNum = projteamStrategyNum;
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.handleProjChildStrategyEntities", () -> StrategyLogServiceHelper.writeLog(saveDy, oldDy, StrategyLogServiceHelper.StrategyLogEnum.INHERITEDORG_MODIFY, true, new DynamicObjectType(finalProjteamStrategyNum)));
            ThreadPools.executeOnce((String)"kd.hr.hrcs.bussiness.service.StrategyServiceHelper.publishMsg", () -> StrategyChangeServiceHelper.publishMsg(bussinessFieldId, changeInfoList));
        }
    }

    private static Map<Long, DynamicObject> strategyDysConvertToMap(DynamicObjectCollection newStrategyEntitys) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)newStrategyEntitys.size());
        for (DynamicObject entity : newStrategyEntitys) {
            map.put(entity.getLong(FIELD_BUSSINESSFIELD_ID), entity);
        }
        return map;
    }

    public static HRMServiceResult synStrategyAfterOrgChangedPassCompany(List<Map<Long, DynamicObject>> list) {
        HRMServiceResult result = StrategyApiServiceHelper.getResult();
        if (CollectionUtils.isEmpty(list)) {
            result.setSuccess(false);
            result.setMessage("synStrategyAfterOrgChangedPassCompany() list is empty.");
            LOGGER.info(result.getMessage());
            return result;
        }
        LOGGER.info("synStrategyAfterOrgChangedPassCompany() list:{}", list);
        try (TXHandle txHandle = TX.required();){
            for (Map<Long, DynamicObject> map : list) {
                StrategyHandleServiceHelper.copyStrategyByOrg(map);
                StrategyHandleServiceHelper.disableStrategyCrossByOrg(map);
            }
        }
        LOGGER.info("synStrategyAfterOrgChangedPassCompany() result:{}", (Object)result.getMessage());
        return result;
    }

    public static DynamicObject[] getOrgStrategyAllFieldsByOrgList(List<Object> orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return ORG_STRATEGY_HELPER.query(STRATEGYBYORGS_ALL_FEILDS, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject[] getEmpStrategyAllFieldsByOrgList(List<Object> orgIds) {
        QFilter orgFilter = new QFilter("orgteam", "in", orgIds);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        return EMP_STRATEGY_HELPER.query(STRATEGYBYORGS_ALL_FEILDS, new QFilter[]{orgFilter, enableFilter});
    }

    public static DynamicObject getStrategyTypeByBussinessfieldAndNumber(Long bussinessObjectId, String strategyType) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hrcs_strategy");
        QFilter filter = new QFilter(FIELD_BUSSINESSFIELD_ID, "=", (Object)bussinessObjectId);
        QFilter strategyTypeFilter = new QFilter("strategytype", "=", (Object)strategyType);
        return helper.queryOriginalOne("id,bussinessfield,strategytype", new QFilter[]{filter, strategyTypeFilter});
    }

    public static boolean checkIsStrategyIniting(IPageCache pageCache) {
        String orgInitFlag = pageCache.get("InitOrgStrategyService");
        String empInitFlag = pageCache.get("InitEmpStrategyService");
        return HRStringUtils.equals((String)orgInitFlag, (String)"doing") || HRStringUtils.equals((String)empInitFlag, (String)"doing");
    }

    public static void itemClickInitStrategy(IFormView formView, IPageCache pageCache, InitStrategyService service) {
        if (StrategyServiceHelper.checkIsStrategyIniting(pageCache)) {
            String message = ResManager.loadKDString((String)"\u5df2\u6709\u5458\u5de5\u6216\u7ec4\u7ec7\u7ba1\u7406\u5173\u7cfb\u7b56\u7565\u521d\u59cb\u5316\u4e2d\uff0c\u8bf710\u5206\u949f\u540e\u91cd\u8bd5\u6216\u67e5\u770b\u3002", (String)"ManageStrategyQueryPlugin_1", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
            formView.showSuccessNotification(message, Integer.valueOf(3000));
            formView.sendFormAction(formView);
            return;
        }
        service.setPageCache(pageCache);
        service.initStrategy();
        try {
            Thread.sleep(15L);
            if (StrategyServiceHelper.checkIsStrategyIniting(pageCache)) {
                String message = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5df2\u542f\u52a8\uff0c\u8bf7\u7b49\u5f8510\u5206\u949f\u540e\u67e5\u770b\u5217\u8868\u3002", (String)"ManageStrategyQueryPlugin_2", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                formView.showSuccessNotification(message, Integer.valueOf(3000));
                formView.sendFormAction(formView);
            } else {
                String message = ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b8c\u6210\uff01", (String)"ManageStrategyQueryPlugin_3", (String)"hrmp-hrcs-formplugin", (Object[])new Object[0]);
                formView.showSuccessNotification(message, Integer.valueOf(3000));
                formView.sendFormAction(formView);
            }
        }
        catch (InterruptedException exception) {
            throw new KDBizException(exception.getMessage());
        }
    }

    public static void writeOperationLog(String opKey, MultiLangEnumBridge operationName, Exception exception, String entityNum) {
        LOGGER.info("writeOperationLog,operationName:{},description:{},entityNum:{}", new Object[]{operationName, exception, entityNum});
        ArrayList appLogInfoList = Lists.newArrayListWithExpectedSize((int)16);
        OpLogAppInfo appLogInfo = new OpLogAppInfo();
        appLogInfo.setOpName(opKey, operationName);
        appLogInfo.setStatus("0");
        appLogInfo.setOpDesc(new MultiLangEnumBridge("\u7a0b\u5e8f\u9519\u8bef\uff0c\u8bf7\u67e5\u770bmonitor\u65e5\u5fd7\u3002", "StrategyServiceHelper_0", "hrmp-hrcs-business"), new String[0]);
        appLogInfo.setBizObjID(entityNum);
        appLogInfo.setBizAppID(AppMetadataCache.getAppInfo((String)"hrcs").getId());
        appLogInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        appLogInfoList.add(appLogInfo);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        service.addBatchLog((List)appLogInfoList);
    }

    private static /* synthetic */ void lambda$handleProjChildStrategyEntities$25(List projChildStrategyEntrysDys, HRBaseServiceHelper projHRBaseServiceHelper, String strategyTye, Table btToChangeInfo, Table.Cell cell) {
        ArrayList changeInfoList = Lists.newArrayListWithExpectedSize((int)16);
        ProjStrategyServiceHelper.getChildStrategyEntrysDys(0L, (Long)cell.getColumnKey(), Collections.singletonList(cell.getRowKey()), cell.getValue(), projChildStrategyEntrysDys, projHRBaseServiceHelper, strategyTye, changeInfoList);
        btToChangeInfo.put(cell.getRowKey(), cell.getColumnKey(), (Object)changeInfoList);
    }

    private static /* synthetic */ void lambda$disableStrategyByOrg$21(DynamicObject[] empStrategyByOrgList) {
        StrategyLogServiceHelper.writeLog(empStrategyByOrgList, empStrategyByOrgList, StrategyLogServiceHelper.StrategyLogEnum.ORG_DISABLE, false, new DynamicObjectType[0]);
    }

    private static /* synthetic */ void lambda$disableStrategyByOrg$19(DynamicObject[] orgStrategyByOrgList) {
        StrategyLogServiceHelper.writeLog(orgStrategyByOrgList, orgStrategyByOrgList, StrategyLogServiceHelper.StrategyLogEnum.ORG_DISABLE, false, new DynamicObjectType[0]);
    }
}

