/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.EcontractWarnConfigService;

public class ChargeLicGrpServiceHelper {
    public static final Log LOGGER = LogFactory.getLog(ChargeLicGrpServiceHelper.class);
    private static final String HRCS_LICGRPDETAIL = "hrcs_licgrpdetail";
    private static final String HRCS_ECONTRACT_AVAILABLE_SITE_NUM = "hrcs_econtract_available_site_num";
    private static final int ONE_DAY_SECONDS = 86400;
    private static EcontractWarnConfigService warnConfigService = new EcontractWarnConfigService();
    private static final DistributeSessionlessCache APP_CACHE = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("hrcs", true);

    public static Map<String, Object> refreshLicGrpDetail() {
        Map<String, Object> reduceDataMap = ChargeSiteService.getSiteDetail();
        if (!((Boolean)reduceDataMap.get("success")).booleanValue()) {
            LOGGER.info("ChargeLicGrpServiceHelper reduce failuer === " + SerializationUtils.toJsonString(reduceDataMap));
            return reduceDataMap;
        }
        int availableSite = Integer.parseInt(reduceDataMap.get("availabledSite").toString());
        int totalSite = Integer.parseInt(String.valueOf(reduceDataMap.get("totalSite")));
        ChargeLicGrpServiceHelper.setCacheAvailableSite(availableSite);
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper(HRCS_LICGRPDETAIL);
        long chargeServiceId = Long.parseLong(reduceDataMap.get("chargeServiceId").toString());
        DynamicObject dynamicObject = HELPER.queryOne("id,comname,serviceid,servicename,licnum,usedlicnum,buylicnum,chargeregister,refserviceid,modifier,modifytime", new QFilter[]{new QFilter("chargeregister.id", "=", (Object)chargeServiceId)});
        dynamicObject.set("comname", reduceDataMap.get("orgsimplename"));
        dynamicObject.set("serviceid", reduceDataMap.get("cloudServiceId"));
        dynamicObject.set("servicename", reduceDataMap.get("serviceName"));
        dynamicObject.set("licnum", (Object)availableSite);
        dynamicObject.set("usedlicnum", reduceDataMap.get("reduceCount"));
        dynamicObject.set("buylicnum", (Object)totalSite);
        dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
        dynamicObject.set("modifytime", (Object)new Date());
        dynamicObject.set("chargeregister", (Object)chargeServiceId);
        HELPER.updateOne(dynamicObject);
        LOGGER.info("refreshLicGrpDetail refresh success");
        ChargeLicGrpServiceHelper.changewarnConfig(totalSite, availableSite);
        return reduceDataMap;
    }

    private static void changewarnConfig(int totalSite, int availableSite) {
        warnConfigService.addDefaultOrUpdateWarnConfig(totalSite, availableSite);
    }

    public static DynamicObject getLicGrpDetail(Long chargeRegisterId) {
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper(HRCS_LICGRPDETAIL);
        DynamicObject dynamicObject = HELPER.queryOne("id,comname,serviceid,servicename,licnum,usedlicnum,buylicnum,chargeregister,refserviceid,modifier,modifytime", new QFilter[]{new QFilter("chargeregister.id", "=", (Object)chargeRegisterId)});
        return dynamicObject;
    }

    public static Object saveNewDetail(Long chargeRegisterId) {
        HRBaseServiceHelper HELPER = new HRBaseServiceHelper(HRCS_LICGRPDETAIL);
        DynamicObject dynamicObject = HELPER.queryOne("id", new QFilter[]{new QFilter("chargeregister.id", "=", (Object)chargeRegisterId)});
        Object result = null;
        if (dynamicObject == null) {
            dynamicObject = HELPER.generateEmptyDynamicObject();
            dynamicObject.set("chargeregister", (Object)chargeRegisterId);
            result = HELPER.saveOne(dynamicObject);
        }
        return result;
    }

    public static int getCacheAvailableSite() {
        String availableSiteStr = (String)APP_CACHE.get(HRCS_ECONTRACT_AVAILABLE_SITE_NUM);
        int availableSite = -1;
        LOGGER.info("availableSiteStr={}", (Object)availableSiteStr);
        if (availableSiteStr != null) {
            availableSite = Integer.parseInt(availableSiteStr);
        } else {
            Map<String, Object> reduceDataMap = ChargeLicGrpServiceHelper.refreshLicGrpDetail();
            availableSite = (Integer)reduceDataMap.getOrDefault("availabledSite", -1);
        }
        return availableSite;
    }

    public static void setCacheAvailableSite(int availableSite) {
        if (availableSite == -1) {
            return;
        }
        APP_CACHE.put(HRCS_ECONTRACT_AVAILABLE_SITE_NUM, (Object)String.valueOf(availableSite), 86400, TimeUnit.SECONDS);
    }

    public static int incCacheAvailableSite() {
        int newAvailableSite = (int)APP_CACHE.inc(HRCS_ECONTRACT_AVAILABLE_SITE_NUM);
        return newAvailableSite;
    }

    public static int decCacheAvailableSite() {
        int newAvailableSite = (int)APP_CACHE.decr(HRCS_ECONTRACT_AVAILABLE_SITE_NUM);
        return newAvailableSite;
    }
}

