/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.econtract.ChargeLicGrpServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.EContractService;

public class EContLicenseService {
    private static final Log LOGGER = LogFactory.getLog(EContLicenseService.class);

    public static int licenceGetAndCheck() {
        Map<String, Object> reduceCount = ChargeLicGrpServiceHelper.refreshLicGrpDetail();
        boolean success = (Boolean)reduceCount.get("success");
        int availabledSite = 0;
        if (success) {
            availabledSite = Integer.parseInt((String)reduceCount.get("availabledSite"));
        }
        LOGGER.info("e-cont licnese check result{}", (Object)availabledSite);
        if (!success) {
            throw new KDBizException(new ErrorCode("1119", ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[]{ResManager.loadKDString((String)"\u8bbf\u95ee\u8bb8\u53ef\u670d\u52a1\u5931\u8d25\uff0c\u8bf7\u67e5\u770b\u7f51\u7edc\u73af\u5883\u662f\u5426\u901a\u7545\uff0c\u6216\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u8fdb\u884c\u7f51\u7edc\u73af\u5883\u4f9d\u8d56\u68c0\u67e5\uff0c\u53c2\u89c1\u793e\u533a\u5e2e\u52a9\u6587\u6863\u300a\u7535\u5b50\u5408\u540c\u6574\u4f53\u6d41\u7a0b\u8bf4\u660e\u300b\u3002", (String)"EContractSignChartPlugin_0", (String)"hrmp-hrcs-business", (Object[])new Object[0])});
        }
        if (availabledSite <= 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7535\u5b50\u7b7e\u7ae0\u8bb8\u53ef\u6570\u91cf\u5df2\u8d85\u8fc7\u8d2d\u4e70\u6570\u91cf\u4e0a\u9650\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u8865\u5145\u8d2d\u4e70\u8bb8\u53ef\u6570\u91cf", (String)"sign_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return availabledSite;
    }

    public static Map<String, Object> licenceTake(Long fiorg, String contractNo, String signType, DynamicObject signRecordInfo, Date signTime) {
        Map<Object, Object> map = Maps.newHashMapWithExpectedSize((int)2);
        map.put("success", true);
        EContractService eContractService = new EContractService();
        int signflag = signRecordInfo.getInt("signflag");
        LOGGER.info("querySignStatus finish try take license contractno:{}, signflag:{}", (Object)contractNo, (Object)signflag);
        if (eContractService.licenseDesc(signflag)) {
            return map;
        }
        HashMap contractInfo = Maps.newHashMapWithExpectedSize((int)6);
        contractInfo.put("orgnizeid", fiorg);
        contractInfo.put("signtype", signType);
        contractInfo.put("contractnum", contractNo);
        String signstatus = "3";
        if ("3".equals(signType)) {
            signstatus = "2";
        }
        contractInfo.put("signstatus", signstatus);
        contractInfo.put("signtime", signTime);
        contractInfo.put("requestid", signRecordInfo.get("requestid"));
        LOGGER.info("e-cont licnese take {}", (Object)contractInfo);
        map = EContLicenseService.licenceDesc(contractInfo);
        boolean success = (Boolean)map.get("success");
        if (success) {
            LOGGER.info("e-cont licnese record {}", (Object)contractNo);
            eContractService.recordLicenseDesc(signRecordInfo);
        } else {
            LOGGER.info("e-cont licnese take fail{}", map);
        }
        return map;
    }

    private static Map<String, Object> licenceDesc(Map<String, Object> contractInfo) {
        HashMap<String, Object> respMap = new HashMap<String, Object>();
        respMap.put("success", false);
        if (contractInfo == null) {
            return respMap;
        }
        if (EContLicenseService.validateParam(contractInfo.get("orgnizeid")) || EContLicenseService.validateParam(contractInfo.get("contractnum"))) {
            return respMap;
        }
        LOGGER.info("HRLicDescServiceHelper params === " + SerializationUtils.toJsonString(contractInfo));
        Map<String, Object> reduceMap = ChargeSiteService.reduceSite(String.valueOf(contractInfo.get("contractnum")), String.valueOf(contractInfo.get("requestid")));
        LOGGER.info("HRLicDescServiceHelper reduceSite === " + SerializationUtils.toJsonString(reduceMap));
        if (((Boolean)reduceMap.get("success")).booleanValue()) {
            int availableSite = ChargeLicGrpServiceHelper.decCacheAvailableSite();
            respMap.put("success", true);
            respMap.put("orgnizeid", contractInfo.get("orgnizeid"));
            respMap.put("availableSite", availableSite);
        }
        return respMap;
    }

    public static Map<String, Object> resumeSite(String requestId) {
        Map<String, Object> siteMap = ChargeSiteService.resumeSite(requestId);
        if (((Boolean)siteMap.get("success")).booleanValue()) {
            ChargeLicGrpServiceHelper.incCacheAvailableSite();
        }
        return siteMap;
    }

    private static boolean validateParam(Object parms) {
        return parms == null;
    }
}

