/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRBaseUtils;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.EContractSignApiService;
import kd.hr.hrcs.common.model.econtract.SignTypeEnum;
import org.apache.commons.lang.RandomStringUtils;

public class EContractService {
    private short signFlagP = 1;
    private short signFlagC = (short)2;
    private short signFlagAS = (short)4;
    private short signFlagCFirst = (short)8;
    private short companySign = (short)16;
    private short personSign = (short)32;
    private short licenseDesc = (short)64;
    public static final String STATUS_TOUPLOAD = "1";
    public static final String STATUS_UPLOADED = "2";
    public static final String STATUS_FINISH = "3";
    public static final String STATUS_CANCEL = "0";
    private static final String CONTRACTNO_PREX = "XHHREC";
    private HRBaseServiceHelper econtService = new HRBaseServiceHelper("hrcs_signrecord");
    private static final Log LOGGER = LogFactory.getLog(EContractService.class);

    public DynamicObject queryContractInfo(String number) {
        String selectField = "id,econnumber,userid,kdappid,empsingtime,persigntime,econtemplateid,signstatus,signatrueid,templatetype,cloud,appnum,signflag,modifier,modifytime,licdescnum,requestid";
        QFilter qFilter = new QFilter("econnumber", "=", (Object)number);
        return this.econtService.queryOne(selectField, qFilter.toArray());
    }

    public DynamicObject[] querySignRecodeInfo(String year, String signStatus) {
        String selectField = "createtime,econtemplateid,signstatus,signflag";
        QFilter qFilter = null;
        try {
            qFilter = this.getQFilter(year, signStatus);
        }
        catch (ParseException ex) {
            LOGGER.error("time parse error.", (Throwable)ex);
        }
        DynamicObject[] signRecodeInfos = this.econtService.query(selectField, qFilter == null ? null : qFilter.toArray(), "createtime", 100000);
        return signRecodeInfos;
    }

    private QFilter getQFilter(String year, String signStatus) throws ParseException {
        QFilter qFilter = null;
        qFilter = "-1".equals(signStatus) ? new QFilter("signstatus", "in", Arrays.asList(STATUS_UPLOADED, STATUS_FINISH, STATUS_CANCEL)) : new QFilter("signstatus", "=", (Object)signStatus);
        if (HRStringUtils.isEmpty((String)year)) {
            QFilter createTime = new QFilter("createtime", "is not null", null);
            qFilter.and(createTime);
        } else {
            Date yearStartTime = HRDateTimeUtils.parseDate((String)(year + "-01-01 00:00:00"));
            Date yearEndTime = HRDateTimeUtils.parseDate((String)(year + "-12-31 23:59:59"));
            QFilter createStartTime = new QFilter("createtime", ">=", (Object)yearStartTime);
            QFilter createEndTime = new QFilter("createtime", "<=", (Object)yearEndTime);
            createStartTime.addFirstNest(createEndTime, "and");
            qFilter.and(createStartTime);
        }
        return qFilter;
    }

    public boolean companySigned(int signFlag) {
        return this.companySign == (signFlag & this.companySign);
    }

    public boolean licenseDesc(int signFlag) {
        return this.licenseDesc == (signFlag & this.licenseDesc);
    }

    public boolean personSigned(int signFlag) {
        return this.personSign == (signFlag & this.personSign);
    }

    public boolean isAutoCompanyLast(int signFlag) {
        int com = this.signFlagP | this.signFlagC | this.signFlagAS;
        return com == (signFlag & com);
    }

    public void finish(DynamicObject dyo) {
        dyo.set("signstatus", (Object)STATUS_FINISH);
        this.updateDyo(dyo);
    }

    public void updataToSign(String number, String userId) {
        DynamicObject dyo = this.queryContractInfo(number);
        dyo.set("signstatus", (Object)STATUS_UPLOADED);
        dyo.set("userid", (Object)userId);
        this.updateDyo(dyo);
    }

    public void cancle(DynamicObject dynamicObject, boolean siteResume) {
        dynamicObject.set("signstatus", (Object)STATUS_CANCEL);
        if (siteResume) {
            dynamicObject.set("licdescnum", (Object)0);
        }
        this.updateDyo(dynamicObject);
    }

    public void recordLicenseDesc(DynamicObject dyo) {
        int signFlag = dyo.getInt("signflag");
        dyo.set("signflag", (Object)(signFlag | this.licenseDesc));
        dyo.set("licdescnum", (Object)1);
        this.updateDyo(dyo);
    }

    private void updateDyo(DynamicObject dyo) {
        HRBaseUtils.setModifyField((DynamicObject)dyo);
        this.econtService.updateOne(dyo);
    }

    public void recordPersonSign(DynamicObject dyo, Date createTime) {
        boolean needQuery;
        dyo.set("persigntime", (Object)createTime);
        String signtype = dyo.getString("econtemplateid.signtype");
        String cloudSignType = SignTypeEnum.getCloudType((String)signtype);
        int signFlag = dyo.getInt("signflag");
        dyo.set("signflag", (Object)(signFlag | this.personSign));
        boolean bl = needQuery = STATUS_TOUPLOAD.equals(cloudSignType) || this.companySigned(signFlag);
        if (needQuery && this.querySignStatus(dyo)) {
            dyo.set("signstatus", (Object)STATUS_FINISH);
        }
        this.updateDyo(dyo);
    }

    private void resetSignStatus(DynamicObject contractInfo, int signFlag, String cloudSignType) {
        boolean needQuery;
        boolean bl = needQuery = STATUS_TOUPLOAD.equals(cloudSignType) || this.personSigned(signFlag);
        if (needQuery && this.querySignStatus(contractInfo)) {
            contractInfo.set("signstatus", (Object)STATUS_FINISH);
        }
    }

    public void recordCompanySign(String number, String cloudSignType) {
        DynamicObject dyo = this.queryContractInfo(number);
        int signFlag = dyo.getInt("signflag");
        dyo.set("signflag", (Object)(signFlag | this.companySign));
        this.resetSignStatus(dyo, signFlag, cloudSignType);
        this.updateDyo(dyo);
    }

    public void updateCompanySignDate(DynamicObject contractInfo, Date date, String signtype) {
        contractInfo.set("empsingtime", (Object)date);
        int signFlag = contractInfo.getInt("signflag");
        contractInfo.set("signflag", (Object)(signFlag | this.companySign));
        String cloudSignType = SignTypeEnum.getCloudType((String)signtype);
        this.resetSignStatus(contractInfo, signFlag, cloudSignType);
        this.updateDyo(contractInfo);
    }

    private boolean querySignStatus(DynamicObject dyo) {
        long contSubjectId = dyo.getLong("kdappid.id");
        DynamicObject contractSubjectInfo = ContractSubjectService.queryContractByPk(contSubjectId);
        EContractSignApiService signApiService = new EContractSignApiService(contractSubjectInfo);
        return signApiService.querySignStatus(dyo.getString("econnumber"));
    }

    public void save(String number, String signType, SignReqParam signReqParam, String userId, Long contractSubjectId, Long signatrueId, String status) {
        DynamicObject dyo = this.econtService.generateEmptyDynamicObject();
        dyo.set("econnumber", (Object)number);
        if (EContractServiceHelper.longIsEmpty(signReqParam.getTemplateTypeId())) {
            dyo.set("econtemplateid", (Object)signReqParam.getTemplateId());
        } else {
            DynamicObject econtemplatetype = EContractServiceHelper.getSignConfig(signReqParam.getTemplateTypeId());
            dyo.set("econtemplateid", (Object)econtemplatetype.getDynamicObject("template").getLong("id"));
        }
        dyo.set("signstatus", (Object)status);
        dyo.set("cloud", (Object)signReqParam.getCloud());
        dyo.set("appnum", (Object)signReqParam.getAppNum());
        dyo.set("signflag", (Object)this.genSignFlag(signType, signReqParam.isAutoSign(), signReqParam.getSignMode()));
        dyo.set("userid", (Object)userId);
        dyo.set("persigntime", null);
        dyo.set("kdappid", (Object)contractSubjectId);
        dyo.set("empsingtime", null);
        dyo.set("signatrueid", (Object)signatrueId);
        String requestId = UUID.randomUUID() + "-" + number;
        dyo.set("requestid", (Object)requestId);
        this.econtService.saveOne(dyo);
    }

    private int genSignFlag(String signType, boolean autoSign, String signMode) {
        int signFlag = 0;
        if (STATUS_TOUPLOAD.equals(signType)) {
            signFlag |= this.signFlagC;
        } else if (STATUS_UPLOADED.equals(signType)) {
            signFlag |= this.signFlagP;
        } else if (STATUS_FINISH.equals(signType)) {
            signFlag |= this.signFlagC | this.signFlagP;
        }
        if (autoSign) {
            signFlag |= this.signFlagAS;
        }
        if (STATUS_TOUPLOAD.equals(signMode)) {
            signFlag |= this.signFlagCFirst;
        }
        return signFlag;
    }

    public String genContractNo() {
        String dataStr = HRDateTimeUtils.format((Date)new Date(), (String)"yyyyMMdd");
        for (int i = 0; i < 5; ++i) {
            StringBuilder contNumBuilder = new StringBuilder();
            String random = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
            contNumBuilder.append(CONTRACTNO_PREX).append(dataStr).append(random);
            String contNum = contNumBuilder.toString();
            boolean exists = this.econtService.isExists(new QFilter("econnumber", "=", (Object)contNum));
            if (exists) continue;
            return contNum;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u751f\u6210\u6709\u6548\u7684\u5408\u540c\u7f16\u7801\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"EContractService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
    }
}

