/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.param.AppParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class EContractServiceHelper {
    public static final Log LOGGER = LogFactory.getLog(EContractServiceHelper.class);
    private static String DEFAULTSIGNATURE = "defaultsignature";

    public static DynamicObject getSignConfig(Long templateTypeId) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_econtemplatetype");
        DynamicObject econtemplatetype = hrBaseServiceHelper.queryOne((Object)templateTypeId);
        if (econtemplatetype.getDynamicObject("template") == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u4e3a\u7a7a", (String)"EContractSignApiService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return econtemplatetype;
    }

    public static Long getSignatureId(SignReqParam signReqParam) {
        DynamicObject sealTypeDy;
        LOGGER.info("getSignatureId signReqParam={}", (Object)JSON.toJSONString((Object)signReqParam));
        if (EContractServiceHelper.longIsEmpty(signReqParam.getTemplateTypeId())) {
            HRBaseServiceHelper econtemplateHelper = new HRBaseServiceHelper("hrcs_econtemplate");
            DynamicObject hrTemplate = econtemplateHelper.queryOne((Object)signReqParam.getTemplateId());
            DynamicObject sealTypeId = hrTemplate.getDynamicObject("sealtypeid");
            if (sealTypeId == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u7b7e\u7ae0\u7c7b\u578b", (String)"sign_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            DynamicObject dynamicObject = ESignDBServiceUtil.hrSealType.queryOne(sealTypeId.getPkValue());
            sealTypeDy = dynamicObject.getDynamicObject("relbossealtype");
        } else {
            HRBaseServiceHelper econtemplatetypeHelper = new HRBaseServiceHelper("hrcs_econtemplatetype");
            DynamicObject templateTypeDy = econtemplatetypeHelper.queryOne((Object)signReqParam.getTemplateTypeId());
            sealTypeDy = templateTypeDy.getDynamicObject("sealtypeid");
        }
        if (sealTypeDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u7b7e\u7ae0\u7c7b\u578b", (String)"sign_18", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        long sealtypeId = sealTypeDy.getLong("id");
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("bos_ec_seal");
        HRBaseServiceHelper contractsubject = new HRBaseServiceHelper("contractsubject");
        DynamicObject contractsubjectDy = contractsubject.queryOne(new QFilter[]{new QFilter("fiorg", "=", (Object)signReqParam.getFiorg())});
        if (contractsubjectDy == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5408\u540c\u4e3b\u4f53\uff0c\u8bf7\u5148\u81f3\u201c\u7cfb\u7edf\u670d\u52a1\u4e91>\u7b2c\u4e09\u65b9\u670d\u52a1\u8bbe\u7f6e>\u7535\u5b50\u7b7e\u7ae0\u670d\u52a1>\u5408\u540c\u4e3b\u4f53\u201d\u4e2d\u6ce8\u518c\u8ba4\u8bc1\u3002", (String)"EContApiBase_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        DynamicObject[] dynamicObjects = hrBaseServiceHelper.query("signatureid", new QFilter[]{new QFilter("sealtype", "=", (Object)sealtypeId), new QFilter("subjectid", "=", (Object)contractsubjectDy.getLong("id")), new QFilter("subjecttype", "=", (Object)"1")});
        if (dynamicObjects == null || dynamicObjects.length == 0) {
            return EContractServiceHelper.getDefaultSignatureId(contractsubjectDy.getLong("id"), hrBaseServiceHelper);
        }
        if (dynamicObjects.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u7b7e\u7ae0", (String)"sign_16", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String signatureid = dynamicObjects[0].getString("signatureid");
        if (HRStringUtils.isEmpty((String)signatureid)) {
            return EContractServiceHelper.getDefaultSignatureId(contractsubjectDy.getLong("id"), hrBaseServiceHelper);
        }
        return Long.valueOf(signatureid);
    }

    private static Long getDefaultSignatureId(Long subjectId, HRBaseServiceHelper hrBaseServiceHelper) {
        DynamicObject[] defaultSignature = hrBaseServiceHelper.query("signatureid", new QFilter[]{new QFilter("isdefault", "=", (Object)"1"), new QFilter("subjectid", "=", (Object)subjectId), new QFilter("subjecttype", "=", (Object)"1")});
        if (defaultSignature == null || defaultSignature.length == 0) {
            Map paramsMap = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)new AppParam("15NPDX/GJFOO", Long.valueOf(RequestContext.get().getOrgId())));
            if (paramsMap == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540c\u4e3b\u4f53\u548c\u7b7e\u7ae0\u7c7b\u578b\u672a\u627e\u5230\u7b7e\u7ae0\u3002", (String)"sign_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            Object defaultsignature = paramsMap.get(DEFAULTSIGNATURE);
            if (ObjectUtils.isEmpty(defaultsignature)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540c\u4e3b\u4f53\u548c\u7b7e\u7ae0\u7c7b\u578b\u672a\u627e\u5230\u7b7e\u7ae0\u3002", (String)"sign_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            }
            boolean defaultFlag = (Boolean)defaultsignature;
            if (defaultFlag) {
                return -1L;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540c\u4e3b\u4f53\u548c\u7b7e\u7ae0\u7c7b\u578b\u672a\u627e\u5230\u7b7e\u7ae0\u3002", (String)"sign_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (defaultSignature.length > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u627e\u5230\u591a\u4e2a\u9ed8\u8ba4\u7b7e\u7ae0", (String)"sign_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String defaultSignatureid = defaultSignature[0].getString("signatureid");
        if (HRStringUtils.isEmpty((String)defaultSignatureid)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u5408\u540c\u4e3b\u4f53\u548c\u7b7e\u7ae0\u7c7b\u578b\u672a\u627e\u5230\u7b7e\u7ae0\u3002", (String)"sign_15", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        return Long.valueOf(defaultSignatureid);
    }

    public static boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }

    public static DynamicObject[] getRelationEntityList(Long contempid) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_relationentity");
        DynamicObject[] entityMappings = hrBaseServiceHelper.query("entity", new QFilter[]{new QFilter("contempid", "=", (Object)contempid)}, "index asc");
        return entityMappings;
    }

    public static DynamicObject getRelationEntityColl(Long contempid, String formNumber) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("entryentity,entryentity.entityname,entryentity.seq", new QFilter[]{new QFilter("contempid", "=", (Object)contempid), new QFilter("mainentity.number", "=", (Object)formNumber)}, "entryentity.seq asc");
        return dynamicObject;
    }

    public static DynamicObject[] getEntityMappingList(Long contempid) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_entitymapping");
        DynamicObject[] entityMappings = hrBaseServiceHelper.query("entity,index,parententity,entryentity,entryentity.entityfield,entryentity.parententityfield,entryentity.seq", new QFilter[]{new QFilter("contempid", "=", (Object)contempid)}, "index asc");
        return entityMappings;
    }

    public static DynamicObject getRelateEntityByContempid(Long contempid) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("hrcs_relateentity");
        DynamicObject dynamicObject = hrBaseServiceHelper.queryOne("mainentity,entryentity,entryentity.entityname,entryentity.seq", new QFilter[]{new QFilter("contempid", "=", (Object)contempid)}, "entryentity.seq asc");
        return dynamicObject;
    }

    public static String getTimeMask(String entityNumber, String fieldId) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return null;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (ControlAp control : formMeta.getItems()) {
            if (!(control instanceof FieldAp) || !control.getKey().equals(fieldId)) continue;
            return ((FieldAp)control).getMask();
        }
        return null;
    }
}

