/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.EContApiBase;
import kd.hr.hrcs.common.model.econtract.EContTplPosition;
import kd.hr.hrcs.common.model.econtract.Position;
import kd.hr.hrcs.common.model.econtract.SignTypeEnum;

public class EContractTplApiService
extends EContApiBase {
    private static final Log LOGGER = LogFactory.getLog(EContractTplApiService.class);
    private static final String FIELD_CLOUDTEMP = "cloudtemp";

    public EContractTplApiService() {
        super(ContractSubjectService.queryTopFiorg());
    }

    public EContractTplApiService(DynamicObject contractSubject) {
        super(contractSubject);
    }

    public EContractTplApiService(Long fiorg) {
        super(fiorg);
    }

    public String uploadTemplate(DynamicObject conTplInfo) throws KDBizException {
        String name = conTplInfo.getString("name");
        String cloudSignType = SignTypeEnum.getCloudType((String)conTplInfo.getString("signtype"));
        EContTplPosition position = this.genEContTplPosition(conTplInfo);
        String positionJson = SerializationUtils.toJsonString((Object)position);
        Map<String, Object> returnData = this.getApiService().uploadTemplate(name, positionJson, "fadadaV30", cloudSignType);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code != 0) {
            String msg = String.valueOf(returnData.get("msg"));
            LOGGER.error("econt*** upload e-contract hrtemplate number\uff1a{},error msg\uff1a{}", (Object)conTplInfo.getString("number"), (Object)msg);
            throw new KDBizException(msg);
        }
        Map data = (Map)returnData.get("data");
        String templateId = (String)data.get("templateID");
        return templateId;
    }

    private Position getPartyPosition(DynamicObject dyo) {
        String keyword = dyo.getString("keyword");
        String offsetx = this.percentParse(dyo.getLong("offsetx"));
        String offsety = this.percentParse(dyo.getLong("offsety"));
        Position partyPosition = new Position(keyword, offsetx, offsety);
        partyPosition.setRemoveIndexList(new int[0]);
        return partyPosition;
    }

    private Position getLegalPosition(DynamicObject dyo) {
        String legalSealKey = dyo.getString("legalsealkey");
        String offsetx = this.percentParse(dyo.getLong("offsetx"));
        String offsety = this.percentParse(dyo.getLong("offsety"));
        Position partyPosition = new Position(legalSealKey, offsetx, offsety);
        partyPosition.setRemoveIndexList(new int[0]);
        return partyPosition;
    }

    private String percentParse(Long percent) {
        Number parse;
        NumberFormat nf = NumberFormat.getPercentInstance(Locale.ROOT);
        String percentStr = percent + "%";
        try {
            parse = nf.parse(percentStr);
        }
        catch (ParseException e) {
            return "0";
        }
        return String.valueOf(parse.floatValue());
    }

    private Position getPartyBPosition(DynamicObject dyo) {
        String keyword = dyo.getString("keyworddouble");
        String offsetx = this.percentParse(dyo.getLong("offsetxdouble"));
        String offsety = this.percentParse(dyo.getLong("offsetydouble"));
        Position partyBPosition = new Position(keyword, offsetx, offsety);
        partyBPosition.setRemoveIndexList(new int[0]);
        partyBPosition.setIndex("0");
        return partyBPosition;
    }

    private EContTplPosition genEContTplPosition(DynamicObject dyo) {
        EContTplPosition eContTplPosition = new EContTplPosition();
        String signtype = dyo.getString("signtype");
        if ("1".equals(signtype)) {
            eContTplPosition.addSendUserPosition(this.getPartyPosition(dyo));
        } else if ("2".equals(signtype)) {
            eContTplPosition.addReceiveUserPosition(this.getPartyBPosition(dyo));
        } else if ("3".equals(signtype)) {
            eContTplPosition.addSendUserPosition(this.getPartyPosition(dyo));
            eContTplPosition.addReceiveUserPosition(this.getPartyBPosition(dyo));
        }
        return eContTplPosition;
    }
}

