/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.ItemValue;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.LineSeries;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.chart.Position;
import kd.bos.form.control.Vector;
import kd.hr.hrcs.common.model.econtract.SignTypeEnum;

public class EcontractChartService {
    private static final String[] MONTHS = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
    private static final String DEFAULT_LICENSE_NUM = "0";
    private static final String FINISH_COLOR = "#40A9FF";
    private static final String UPLOADED_COLOR = "#45DAD1";
    private static final String CANCEL_COLOR = "#73D13D";
    private static final String ORANGE = "#FF991C";
    private static final String DOUBLE_SPACE = "&nbsp&nbsp";
    private static final String SINGLE_SPACE = "&nbsp";
    private static final String SPLIT_SPACE = "|&nbsp";

    public static void drawSiteUsagePieChart(IFormView view, Map<String, Object> siteMap) {
        PieChart pieChart = (PieChart)view.getControl("siteusagepiechart");
        int totalSite = Integer.parseInt(siteMap.getOrDefault("totalSite", DEFAULT_LICENSE_NUM).toString());
        int reduceCount = Integer.parseInt(siteMap.getOrDefault("reduceCount", DEFAULT_LICENSE_NUM).toString());
        int availabledSite = Integer.parseInt(siteMap.getOrDefault("availabledSite", DEFAULT_LICENSE_NUM).toString());
        int percent = EcontractChartService.getPercent(availabledSite, totalSite);
        String availabledColor = percent <= 10 ? ORANGE : FINISH_COLOR;
        EcontractChartService.drawSiteUsagePieChart(pieChart, reduceCount, availabledSite, availabledColor);
        if (percent > 10) {
            view.updateControlMetadata("availablewarn", Collections.singletonMap("vi", false));
        } else {
            Tips tips = new Tips();
            tips.setShowIcon(false);
            tips.setType("text");
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7528\u8bb8\u53ef\u4f4e\u4e8e10%", (String)"EcontractChartService_18", (String)"hrmp-hrcs-business", (Object[])new Object[0])));
            Vector warn = (Vector)view.getControl("availablewarn");
            warn.addTips(tips);
        }
        EcontractChartService.setLabelText(view, "siteusagelabel", ResManager.loadKDString((String)"\u8bb8\u53ef\u4f7f\u7528", (String)"EcontractChartService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setLabelText(view, "availablesitename", ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7528", (String)"EcontractChartService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setLabelText(view, "totalsitename", ResManager.loadKDString((String)"\u7d2f\u8ba1\u53ef\u7528", (String)"EcontractChartService_14", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setLabelText(view, "reducecountname", ResManager.loadKDString((String)"\u5df2\u4f7f\u7528", (String)"EcontractChartService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setLabelText(view, "availablesite", String.valueOf(availabledSite));
        view.updateControlMetadata("availablesite", Collections.singletonMap("fc", availabledColor));
        EcontractChartService.setLabelText(view, "totalsite", String.valueOf(totalSite));
        EcontractChartService.setLabelText(view, "reducecount", String.valueOf(reduceCount));
    }

    public static void drawSignRecordPieChart(IFormView view, Map<String, Map<String, Integer>> signRecordMap) {
        EcontractChartService.setLabelText(view, "signrecord", ResManager.loadKDString((String)"\u7b7e\u7f72\u8bb0\u5f55", (String)"EcontractChartService_17", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        Map doubleSignMap = signRecordMap.getOrDefault(SignTypeEnum.DOUBLE_SIGN.getHrType(), new HashMap());
        Map companySignMap = signRecordMap.getOrDefault(SignTypeEnum.COMPANY_SINGLE_SIGN.getHrType(), new HashMap());
        Map personalSignMap = signRecordMap.getOrDefault(SignTypeEnum.USER_SINGLE_SIGN.getHrType(), new HashMap());
        int finishNumDouble = doubleSignMap.getOrDefault("3", 0);
        int uploadedNumDouble = doubleSignMap.getOrDefault("2", 0);
        int cancelNumDouble = doubleSignMap.getOrDefault(DEFAULT_LICENSE_NUM, 0);
        int allNumDouble = finishNumDouble + uploadedNumDouble + cancelNumDouble;
        int finishNumCompany = companySignMap.getOrDefault("3", 0);
        int uploadedNumCompany = companySignMap.getOrDefault("2", 0);
        int cancelNumCompany = companySignMap.getOrDefault(DEFAULT_LICENSE_NUM, 0);
        int allNumCompany = finishNumCompany + uploadedNumCompany + cancelNumCompany;
        int finishNumPersonal = personalSignMap.getOrDefault("3", 0);
        int uploadedNumPersonal = personalSignMap.getOrDefault("2", 0);
        int cancelNumPersonal = personalSignMap.getOrDefault(DEFAULT_LICENSE_NUM, 0);
        int allNumPersonal = finishNumPersonal + uploadedNumPersonal + cancelNumPersonal;
        EcontractChartService.drawDoubleSignRecordPieChart(view, finishNumDouble, uploadedNumDouble, cancelNumDouble);
        EcontractChartService.drawCompanySignRecordPieChart(view, finishNumCompany, uploadedNumCompany, cancelNumCompany);
        EcontractChartService.drawPersonSignRecordPieChart(view, finishNumPersonal, uploadedNumPersonal, cancelNumPersonal);
        String timeText = ResManager.loadKDString((String)"\u6b21", (String)"EcontractChartService_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        EcontractChartService.setLabelText(view, "finish", String.format(ResManager.loadKDString((String)"%s\u5df2\u5f52\u6863", (String)"EcontractChartService_4", (String)"hrmp-hrcs-business", (Object[])new Object[0]), DOUBLE_SPACE));
        EcontractChartService.setLabelText(view, "finishdoublesign", finishNumDouble + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "finishdoublesignper", SPLIT_SPACE + EcontractChartService.getPercentStr(finishNumDouble, allNumDouble));
        EcontractChartService.setLabelText(view, "finishcompanysign", finishNumCompany + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "finishcompanysignper", SPLIT_SPACE + EcontractChartService.getPercentStr(finishNumCompany, allNumCompany));
        EcontractChartService.setLabelText(view, "finishpersonalsign", finishNumPersonal + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "finishpersonalsignper", SPLIT_SPACE + EcontractChartService.getPercentStr(finishNumPersonal, allNumPersonal));
        EcontractChartService.setLabelText(view, "uploaded", String.format(ResManager.loadKDString((String)"%s\u7b7e\u7f72\u4e2d", (String)"EcontractChartService_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]), DOUBLE_SPACE));
        EcontractChartService.setLabelText(view, "uploadeddoublesign", uploadedNumDouble + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "uploadeddoublesignper", SPLIT_SPACE + EcontractChartService.getPercentStr(uploadedNumDouble, allNumDouble));
        EcontractChartService.setLabelText(view, "uploadedcompanysign", uploadedNumCompany + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "uploadedcompanysignper", SPLIT_SPACE + EcontractChartService.getPercentStr(uploadedNumCompany, allNumCompany));
        EcontractChartService.setLabelText(view, "uploadedpersonalsign", uploadedNumPersonal + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "uploadedpersonalsignper", SPLIT_SPACE + EcontractChartService.getPercentStr(uploadedNumPersonal, allNumPersonal));
        EcontractChartService.setLabelText(view, "cancel", String.format(ResManager.loadKDString((String)"%s\u5df2\u64a4\u9500", (String)"EcontractChartService_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]), DOUBLE_SPACE));
        EcontractChartService.setLabelText(view, "canceldoublesign", cancelNumDouble + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "canceldoublesignper", SPLIT_SPACE + EcontractChartService.getPercentStr(cancelNumDouble, allNumDouble));
        EcontractChartService.setLabelText(view, "cancelcompanysign", cancelNumCompany + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "cancelcompanysignper", SPLIT_SPACE + EcontractChartService.getPercentStr(cancelNumCompany, allNumCompany));
        EcontractChartService.setLabelText(view, "cancelpersonalsign", cancelNumPersonal + timeText + SINGLE_SPACE);
        EcontractChartService.setLabelText(view, "cancelpersonalsignper", SPLIT_SPACE + EcontractChartService.getPercentStr(cancelNumPersonal, allNumPersonal));
    }

    public static String getPercentStr(int currentNum, int allNum) {
        return EcontractChartService.getPercent(currentNum, allNum) + "%";
    }

    private static int getPercent(int currentNum, int allNum) {
        if (currentNum == 0 || allNum == 0) {
            return 0;
        }
        BigDecimal divideNum = new BigDecimal(currentNum).divide(new BigDecimal(allNum), 2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)).stripTrailingZeros();
        return divideNum.intValue();
    }

    private static void setLabelText(IFormView view, String lableName, String labelText) {
        kd.bos.form.control.Label licenseAll = (kd.bos.form.control.Label)view.getControl(lableName);
        licenseAll.setText(labelText);
    }

    private static void drawDoubleSignRecordPieChart(IFormView view, int finishNum, int uploadedNum, int cancelNum) {
        PieChart pieChart = (PieChart)view.getControl("dsignrecordpiechart");
        EcontractChartService.drawSignRecordPieChart(pieChart, ResManager.loadKDString((String)"\u53cc\u7b7e", (String)"EcontractChartService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), finishNum, uploadedNum, cancelNum);
    }

    private static void drawCompanySignRecordPieChart(IFormView view, int finishNum, int uploadedNum, int cancelNum) {
        PieChart pieChart = (PieChart)view.getControl("csignrecordpiechart");
        EcontractChartService.drawSignRecordPieChart(pieChart, ResManager.loadKDString((String)"\u4f01\u4e1a\u7b7e", (String)"EcontractChartService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]), finishNum, uploadedNum, cancelNum);
    }

    private static void drawPersonSignRecordPieChart(IFormView view, int finishNum, int uploadedNum, int cancelNum) {
        PieChart pieChart = (PieChart)view.getControl("psignrecordpiechart");
        EcontractChartService.drawSignRecordPieChart(pieChart, ResManager.loadKDString((String)"\u4e2a\u4eba\u7b7e", (String)"EcontractChartService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]), finishNum, uploadedNum, cancelNum);
    }

    private static void drawSiteUsagePieChart(PieChart pieChart, int reduceCount, int availabledSite, String availabledColor) {
        String tokenUsage = ResManager.loadKDString((String)"\u8bb8\u53ef\u4f7f\u7528", (String)"EcontractChartService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        pieChart.clearData();
        String useableString = ResManager.loadKDString((String)"\u5269\u4f59\u53ef\u7528", (String)"EcontractChartService_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        pieChart.setTitlePropValue("textStyle", Collections.singletonMap("fontSize", "14px"));
        HashMap<String, String> subtextStyle = new HashMap<String, String>();
        subtextStyle.put("fontSize", "20px");
        subtextStyle.put("color", availabledColor);
        pieChart.setTitlePropValue("subtext", (Object)availabledSite);
        pieChart.setTitlePropValue("subtextStyle", subtextStyle);
        ItemValue[] items = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u5df2\u4f7f\u7528", (String)"EcontractChartService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]), (Number)reduceCount, "#F2F2F2"), new ItemValue(useableString, (Number)availabledSite, availabledColor)};
        PieSeries series = pieChart.createPieSeries(tokenUsage);
        series.setData(items);
        EcontractChartService.setPieChart(pieChart, useableString, series);
    }

    public static void drawSiteUsagePointLineChart(PointLineChart siteUsagePLChart, Map<String, Integer> siteUsageMap) {
        siteUsagePLChart.setShowLegend(false);
        EcontractChartService.createPointLineChart(siteUsagePLChart);
        LineSeries lineSeries = siteUsagePLChart.createSeries(ResManager.loadKDString((String)"\u8bb8\u53ef\u4f7f\u7528", (String)"EcontractChartService_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setPointLineChartSeries(siteUsageMap, lineSeries, FINISH_COLOR);
        siteUsagePLChart.refresh();
    }

    private static void drawSignRecordPieChart(PieChart pieChart, String name, int finishNum, int uploadedNum, int cancelNum) {
        ItemValue[] items = new ItemValue[]{new ItemValue(ResManager.loadKDString((String)"\u5df2\u5f52\u6863", (String)"EcontractChartService_19", (String)"hrmp-hrcs-business", (Object[])new Object[0]), (Number)finishNum, FINISH_COLOR), new ItemValue(ResManager.loadKDString((String)"\u7b7e\u7f72\u4e2d", (String)"EcontractChartService_20", (String)"hrmp-hrcs-business", (Object[])new Object[0]), (Number)uploadedNum, UPLOADED_COLOR), new ItemValue(ResManager.loadKDString((String)"\u5df2\u64a4\u9500", (String)"EcontractChartService_21", (String)"hrmp-hrcs-business", (Object[])new Object[0]), (Number)cancelNum, CANCEL_COLOR)};
        PieSeries series = pieChart.createPieSeries(name);
        series.setData(items);
        pieChart.setTitlePropValue("textStyle", Collections.singletonMap("fontSize", "12px"));
        EcontractChartService.setPieChart(pieChart, name, series);
    }

    private static void setPieChart(PieChart pieChart, String name, PieSeries series) {
        pieChart.setShowTitle(true);
        pieChart.setShowLegend(false);
        pieChart.setTitlePropValue("text", (Object)name);
        pieChart.setTitlePropValue("top", (Object)"center");
        pieChart.setTitlePropValue("left", (Object)"center");
        series.setRadius("34%", "50%");
        series.setPropValue("label", Collections.singletonMap("show", false));
        series.setPropValue("labelLine", Collections.singletonMap("show", false));
        HashMap<String, Serializable> emphasisMap = new HashMap<String, Serializable>();
        emphasisMap.put("scale", Boolean.valueOf(false));
        emphasisMap.put("itemStyle", new HashMap());
        series.setPropValue("emphasis", emphasisMap);
        pieChart.refresh();
    }

    public static void drawSignRecordPointLineChart(PointLineChart signRecordPLChart, Map<String, Map<String, Integer>> signTypeMap) {
        EcontractChartService.createPointLineChart(signRecordPLChart);
        LineSeries dsLineSeries = signRecordPLChart.createSeries(ResManager.loadKDString((String)"\u53cc\u7b7e", (String)"EcontractChartService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setPointLineChartSeries(signTypeMap.getOrDefault(SignTypeEnum.DOUBLE_SIGN.getHrType(), new HashMap()), dsLineSeries, FINISH_COLOR);
        LineSeries psLineSeries = signRecordPLChart.createSeries(ResManager.loadKDString((String)"\u4e2a\u4eba\u7b7e", (String)"EcontractChartService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setPointLineChartSeries(signTypeMap.getOrDefault(SignTypeEnum.USER_SINGLE_SIGN.getHrType(), new HashMap()), psLineSeries, UPLOADED_COLOR);
        LineSeries csLineSeries = signRecordPLChart.createSeries(ResManager.loadKDString((String)"\u4f01\u4e1a\u7b7e", (String)"EcontractChartService_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        EcontractChartService.setPointLineChartSeries(signTypeMap.getOrDefault(SignTypeEnum.COMPANY_SINGLE_SIGN.getHrType(), new HashMap()), csLineSeries, CANCEL_COLOR);
        signRecordPLChart.refresh();
    }

    private static void createPointLineChart(PointLineChart siteUsagePLChart) {
        siteUsagePLChart.clearData();
        siteUsagePLChart.setShowTooltip(true);
        Axis xAxis = siteUsagePLChart.createXAxis(ResManager.loadKDString((String)"\u6708\u4efd", (String)"EcontractChartService_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]), AxisType.category);
        String monthStr = ResManager.loadKDString((String)"\u6708", (String)"EcontractChartService_12", (String)"hrmp-hrcs-business", (Object[])new Object[0]);
        List yearMonth = Arrays.asList(MONTHS).stream().map(ele -> ele + monthStr).collect(Collectors.toList());
        xAxis.setCategorys(yearMonth);
        xAxis.setPosition(Position.bottom);
        xAxis.setPropValue("nameLocation", (Object)"end");
        Axis yAxis = siteUsagePLChart.createYAxis(ResManager.loadKDString((String)"\u6570\u91cf", (String)"EcontractChartService_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]), AxisType.value);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", true);
        yAxis.setPropValue("axisTick", axisTick);
    }

    private static void setPointLineChartSeries(Map<String, Integer> doubleSignMap, LineSeries dsLineSeries, String color) {
        Number[] dsNumbers = new Number[MONTHS.length];
        for (int i = 0; i < MONTHS.length; ++i) {
            dsNumbers[i] = doubleSignMap.getOrDefault(MONTHS[i], 0);
        }
        dsLineSeries.setData(dsNumbers);
        Label label = new Label();
        label.setShow(true);
        label.setPosition(Position.top);
        dsLineSeries.setLabel(label);
        dsLineSeries.setItemColor(color);
    }
}

