/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class EcontractWarnConfigService {
    private static final HRBaseServiceHelper warnConfigService = new HRBaseServiceHelper("hrcs_warnconfigmap");
    String selectFields = "id,seqnumber,warnvalue,warnnumber,sendwarnmsgflag,warnmsgsendtime,desc";
    private static final int WARNMSG_SENT = 1;
    public static final int WARNMSG_UNSENT = 0;

    public DynamicObject queryByFid(long fid) {
        QFilter qFilter = new QFilter("id", "=", (Object)fid);
        return warnConfigService.queryOne(this.selectFields, qFilter.toArray());
    }

    public DynamicObjectCollection queryOriginalAll() {
        return warnConfigService.queryOriginalCollection(this.selectFields, null);
    }

    public DynamicObject[] queryAll() {
        return warnConfigService.query(this.selectFields, null);
    }

    public List<DynamicObject> queryUnHandleWarnConfig(int availableSite) {
        QFilter qFilter = new QFilter("sendwarnmsgflag", "=", (Object)0);
        qFilter.and(new QFilter("warnnumber", "=", (Object)availableSite));
        return Arrays.asList(warnConfigService.query(this.selectFields, qFilter.toArray(), "warnvalue desc"));
    }

    public void saveNew(List<DynamicObject> addEntryList) {
        DynamicObjectCollection collection = new DynamicObjectCollection();
        for (DynamicObject entryEntity : addEntryList) {
            DynamicObject dyo = warnConfigService.generateEmptyDynamicObject();
            dyo.set("id", entryEntity.get("id"));
            dyo.set("seqnumber", entryEntity.get("seq"));
            dyo.set("warnvalue", entryEntity.get("warnvalue"));
            dyo.set("warnnumber", entryEntity.get("warnnumber"));
            collection.add((Object)dyo);
        }
        warnConfigService.save(collection);
    }

    public void addDefaultOrUpdateWarnConfig(int totalSite, int availabledSite) {
        DynamicObject[] allWarnConfigData = this.queryAll();
        if (allWarnConfigData != null && allWarnConfigData.length != 0) {
            for (int i = 0; i < allWarnConfigData.length; ++i) {
                DynamicObject warnConfigData = allWarnConfigData[i];
                int warnNumber = this.calcWarnNumber(warnConfigData.getInt("warnvalue"), totalSite);
                warnConfigData.set("warnnumber", (Object)warnNumber);
                if (warnNumber >= availabledSite) continue;
                warnConfigData.set("sendwarnmsgflag", (Object)0);
                warnConfigData.set("warnmsgsendtime", null);
            }
            warnConfigService.update(allWarnConfigData);
        }
    }

    public int calcWarnNumber(int warnVal, int totalNumber) {
        double warnNumber = (double)totalNumber / 100.0 * (double)warnVal;
        if ((warnNumber = Math.floor(warnNumber)) != 0.0) {
            return (int)warnNumber;
        }
        return totalNumber == 0 ? 0 : 1;
    }

    public void updataToSign(DynamicObject warnConfig) {
        warnConfig.set("warnmsgsendtime", (Object)new Date());
        warnConfig.set("sendwarnmsgflag", (Object)1);
        this.updateDyo(warnConfig);
    }

    private void updateDyo(DynamicObject dyo) {
        warnConfigService.updateOne(dyo);
    }

    public void update(List<DynamicObject> updateList) {
        if (updateList == null || updateList.isEmpty()) {
            return;
        }
        warnConfigService.update(updateList.toArray(new DynamicObject[updateList.size()]));
    }

    public void deleteByFilter(List<Long> idList) {
        QFilter qFilter = new QFilter("id", "in", idList);
        warnConfigService.deleteByFilter(qFilter.toArray());
    }
}

