/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.api.MessageChannels;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.workflow.MessageCenterServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.workflow.engine.msg.info.MessageInfo;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.ChargeSiteService;
import kd.hr.hrcs.bussiness.service.econtract.EcontractWarnConfigService;

public class EcontractWarnMsgService {
    private static final Log LOGGER = LogFactory.getLog(EcontractWarnMsgService.class);
    private static ThreadPool warnMsgSenderThreadPool = ThreadPools.newFixedThreadPool((String)"WarnMsgSender", (int)1);
    private static EcontractWarnConfigService warnConfigService = new EcontractWarnConfigService();

    public void sendWarnMsgAsyn(int availableSite) {
        LOGGER.info("sendWarnMsgAsyn");
        WarnMsgSender warnMsgSender = new WarnMsgSender(availableSite);
        warnMsgSenderThreadPool.execute((Runnable)warnMsgSender, RequestContext.get());
    }

    public void sendWarnMsg(int availableSite) {
        LOGGER.info("sendWarnMsg in");
        List<DynamicObject> warnConfigList = this.getUnHandleWarnConfig(availableSite);
        DynamicObject warnConfig = this.getWarnConfig(warnConfigList, availableSite);
        if (warnConfig == null) {
            LOGGER.info("getWarnConfig null availableSite={}", (Object)availableSite);
            if (availableSite == 0) {
                this.sendWarnMsgNow(null, availableSite, availableSite);
            }
            return;
        }
        if (this.sendWarnMsgNow(warnConfig)) {
            LOGGER.info("sendWarnMsg");
            this.updateWarnMsgSendFlag(warnConfig);
        }
        LOGGER.info("sendWarnMsg out");
    }

    private List<DynamicObject> getUnHandleWarnConfig(int availableSite) {
        return warnConfigService.queryUnHandleWarnConfig(availableSite);
    }

    private DynamicObject getWarnConfig(List<DynamicObject> warnConfigList, int availabledSite) {
        DynamicObject warnConfig = null;
        warnConfig = availabledSite == 0 ? (DynamicObject)warnConfigList.stream().filter(dy -> dy.getInt("warnvalue") == 0).findFirst().orElse(null) : (DynamicObject)warnConfigList.stream().filter(dy -> dy.getInt("sendwarnmsgflag") == 0).filter(dy -> dy.getInt("warnnumber") == availabledSite).findFirst().orElse(null);
        return warnConfig;
    }

    private boolean sendWarnMsgNow(DynamicObject warnConfig) {
        return this.sendWarnMsgNow(warnConfig, warnConfig.getInt("warnvalue"), warnConfig.getInt("warnnumber"));
    }

    private boolean sendWarnMsgNow(DynamicObject warnConfig, int percent, int count) {
        String warnMsg = this.getMsg(percent, count);
        String templateNumber = this.getMsgTemplateNumber(percent, count);
        DynamicObject chargeSite = ChargeSiteService.getDynamicObject();
        this.sendSmsMsg(templateNumber, chargeSite.getString("linkuser.phone"), warnMsg, warnConfig);
        return true;
    }

    private void sendSmsMsg(String messageTemplateNumber, String phone, String content, DynamicObject dynamicObject) {
        try {
            phone = phone.replace("+", "");
            String notifyType = MessageChannels.SMS.getNumber();
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper("msg_template");
            DynamicObject item = serviceHelper.queryOriginalOne("msgchannel", new QFilter("number", "=", (Object)messageTemplateNumber));
            if (null != item) {
                notifyType = item.getString("msgchannel");
            }
            MessageInfo message = new MessageInfo();
            message.setType("message");
            message.setContent(content);
            message.setSendTime(new Date(System.currentTimeMillis()));
            message.setNotifyType(notifyType);
            message.setTemplateNumber(messageTemplateNumber);
            message.setEntityNumber("hrcs_chargeregister");
            if (dynamicObject != null) {
                message.setBizDataId((Long)dynamicObject.getPkValue());
            } else {
                message.setBizDataId(Long.valueOf(1L));
            }
            message.addParam("phone", Collections.singletonList(phone));
            MessageCenterServiceHelper.sendMessage((MessageInfo)message);
        }
        catch (Exception ex) {
            LOGGER.error("invokeMsgServiceError:{}", (Object)ex.getMessage());
        }
    }

    private String getMsgTemplateNumber(int percent, int count) {
        LOGGER.info("getMsgTemplateNumber percent={},count={}", (Object)percent, (Object)count);
        String msg = null;
        msg = percent >= 10 ? "hrcs_charge_lic_percent10" : (percent >= 1 ? "hrcs_charge_lic_percent1" : "hrcs_charge_lic_percent0");
        return "hrcs_charge_lic_percent10";
    }

    private String getMsg(int percent, int count) {
        LOGGER.info("getMsg percent={},count={}", (Object)percent, (Object)count);
        String msg = null;
        msg = percent >= 10 ? String.format(ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u7535\u5b50\u5408\u540c\u8bb8\u53ef\u5269\u4f59%1s%%\uff0c\u5269\u4f59\u5408\u540c\u8bb8\u53ef\u6570%2s\u6b21", (String)"EcontractWarnMsgService_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), percent, count) : (percent >= 1 ? String.format(ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u7535\u5b50\u5408\u540c\u8bb8\u53ef\u4ec5\u5269\u4f59%1s%%\uff0c\u5269\u4f59\u5408\u540c\u8bb8\u53ef\u6570%2s\u6b21\uff0c\u4e3a\u4e0d\u5f71\u54cd\u7535\u5b50\u5408\u540c\u4f7f\u7528\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u7535\u5b50\u5408\u540c\u8bb8\u53ef", (String)"EcontractWarnMsgService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), percent, count) : ResManager.loadKDString((String)"\u4f60\u597d\uff0c\u7535\u5b50\u5408\u540c\u8bb8\u53ef\u4f59\u91cf\u4e3a0%\uff0c\u4e3a\u4e0d\u5f71\u54cd\u7535\u5b50\u5408\u540c\u4f7f\u7528\uff0c\u8bf7\u53ca\u65f6\u8865\u5145\u7535\u5b50\u5408\u540c\u8bb8\u53ef", (String)"EcontractWarnMsgService_2", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        return msg;
    }

    public void updateWarnMsgSendFlag(DynamicObject warnConfig) {
        warnConfigService.updataToSign(warnConfig);
    }

    private class WarnMsgSender
    implements Runnable {
        private int availableSite;

        public WarnMsgSender(int availableSite) {
            this.availableSite = availableSite;
        }

        @Override
        public void run() {
            EcontractWarnMsgService.this.sendWarnMsg(this.availableSite);
        }
    }
}

