/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.ContractView;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ContractSubjectService;
import kd.hr.hrcs.bussiness.service.econtract.ECPersonAuthRecordService;
import kd.hr.hrcs.bussiness.service.econtract.EContLicenseService;
import kd.hr.hrcs.bussiness.service.econtract.EContSkipAuthService;
import kd.hr.hrcs.bussiness.service.econtract.EContractService;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.service.econtract.EcontractWarnMsgService;
import kd.hr.hrcs.bussiness.service.econtract.HRContractApiService;
import kd.hr.hrcs.bussiness.service.econtract.UserAuthApiService;
import kd.hr.hrcs.bussiness.util.ParamsUtil;
import kd.hr.hrcs.common.model.econtract.AuthWayEnum;
import kd.hr.hrcs.common.model.econtract.SignCloudReqParam;
import kd.hr.hrcs.common.model.econtract.SignTypeEnum;
import org.apache.commons.lang.StringUtils;

public abstract class Sign {
    private static final Log LOGGER = LogFactory.getLog(Sign.class);
    private EContractService eContractService = new EContractService();
    private HRContractApiService apiService;
    private SignReqParam signReqParam;
    private boolean needAuth;
    private boolean skipAuth;
    private boolean checkLicense = true;
    private UserAuthApiService authApiService;
    private static final String HAND_SIGN_NOTIFY_URI = "kapi/app/hrcs/hrHandsignNotify?accountId=%1s&";
    protected static final String AGREE = "1";
    private static final String SHOW_SIGN_TIME = "1";
    private static final String NOT_SHOW_SIGN_TIME = "2";

    public Sign(HRContractApiService apiService, SignReqParam signReqParam) {
        this.apiService = apiService;
        this.signReqParam = signReqParam;
        this.authApiService = new UserAuthApiService(signReqParam.getFiorg());
    }

    public SignReqParam getSignReqParam() {
        return this.signReqParam;
    }

    public boolean isNeedAuth() {
        return this.needAuth;
    }

    public void setNeedAuth(boolean needAuth) {
        this.needAuth = needAuth;
    }

    protected String tryGetUserId(DynamicObject contTplDyo, boolean ignoreTplConf) {
        boolean onlyFirstAuth = ignoreTplConf ? contTplDyo.getBoolean("onlyfirstauth") : false;
        this.skipAuth = EContSkipAuthService.skipAuth(this.signReqParam.getCloud(), this.signReqParam.getAppNum(), this.signReqParam.getBusinessId());
        String userId = this.authApiService.tryGetValidUserId(this.signReqParam, this.skipAuth, onlyFirstAuth);
        this.needAuth = StringUtils.isEmpty((String)userId);
        return userId;
    }

    protected abstract SignCloudReqParam genReqParam(String var1, String var2, DynamicObject var3);

    protected abstract Map<String, Object> autoSign(String var1, DynamicObject var2, SignReqParam var3);

    public void uploadContToCLoud(String contractNo, String templateId) {
        FileService service = FileServiceFactory.getAttachmentFileService();
        if (this.signReqParam.getFilePathList().size() > 1) {
            throw new KDBizException(new ErrorCode("1120", ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u7535\u5b50\u7b7e\u4e0d\u652f\u6301\u591a\u6587\u4ef6\u7b7e\u7f72", (String)"sign_20", (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
        }
        try (InputStream ins = service.getInputStream(this.signReqParam.getFilePath());){
            LOGGER.info("econt*** upload contract to cloud contractNo{}", (Object)contractNo);
            this.uploadContract(contractNo, templateId, this.signReqParam.getFileName(), ins);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private void uploadContract(String contractNo, String templateId, String fileName, InputStream inputStream) {
        Map<String, Object> returnData = this.apiService.uploadContract(contractNo, templateId, "fadadaV30", fileName, inputStream);
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code != 0) {
            String msg = String.valueOf(returnData.get("msg"));
            LOGGER.error("econt*** upload contract fail templateid\uff1a{},error msg\uff1a{}", (Object)templateId, (Object)msg);
            throw new KDBizException(msg);
        }
    }

    public final SignRespParam doSign(String contractNo, DynamicObject contTplDyo, boolean first, boolean checkLicense, SignReqParam signReqParam) {
        this.checkLicense = checkLicense;
        this.doParamCheck();
        if (checkLicense) {
            EContLicenseService.licenceGetAndCheck();
        }
        String userId = this.tryGetUserId(contTplDyo, first);
        String signtype = contTplDyo.getString("signtype");
        SignCloudReqParam signCloudReqParam = this.genReqParam(userId, contractNo, contTplDyo);
        signCloudReqParam.setIdentityType(signReqParam.getIdentityType());
        SignRespParam resp = new SignRespParam(contractNo);
        if (first) {
            String templateId = contTplDyo.getString("cloudtemp");
            this.uploadContToCLoud(contractNo, templateId);
            LOGGER.info("econt*** save contract contractNo{}", (Object)contractNo);
            long signatureId = this.authApiService.getCSSignatureId();
            long contractsubjectId = this.authApiService.getCSId();
            this.eContractService.save(contractNo, signtype, signReqParam, userId, contractsubjectId, signatureId, "1");
        }
        if (this.isNeedAuth()) {
            this.toAuth(contractNo, contTplDyo, userId, resp);
        } else {
            DynamicObject signRecordInfo = this.eContractService.queryContractInfo(contractNo);
            this.toHandSign(signCloudReqParam, resp, signRecordInfo, contTplDyo);
            this.eContractService.updataToSign(contractNo, userId);
            Map<String, Object> prviewMap = this.autoSign(contractNo, contTplDyo, signReqParam);
            if (!prviewMap.isEmpty()) {
                resp.setSealInfo(ContractView.mapToContractView(prviewMap));
            }
        }
        return resp;
    }

    private void toAuth(String contractNo, DynamicObject contTplDyo, String userId, SignRespParam resp) {
        DynamicObject dynamicObject = ECPersonAuthRecordService.queryAuthUserInfo(this.signReqParam, NOT_SHOW_SIGN_TIME);
        String authUrl = null;
        if (dynamicObject != null) {
            authUrl = dynamicObject.getString("authurl");
            userId = dynamicObject.getString("userid");
        }
        if (StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)authUrl)) {
            boolean personalauth = contTplDyo.containsProperty("personalauth");
            String cloudAuthType = "0";
            if (personalauth) {
                String personalAuth = contTplDyo.getString("personalauth");
                cloudAuthType = AuthWayEnum.getCloudType((String)personalAuth);
            }
            Map<String, Object> authRst = this.authApiService.auth(cloudAuthType, this.signReqParam);
            userId = (String)authRst.get("userId");
            authUrl = (String)authRst.get("url");
        }
        resp.setAuthUrl(authUrl);
        if (!this.skipAuth && StringUtils.isNotEmpty((String)this.signReqParam.getBusinessId()) && StringUtils.isNotEmpty((String)this.signReqParam.getAppNum())) {
            LOGGER.info("econt*** record skip auth contractno{}, fid{}", (Object)contractNo, (Object)this.signReqParam.getBusinessId());
            EContSkipAuthService.recordSkipAuth(this.signReqParam.getCloud(), this.signReqParam.getAppNum(), this.signReqParam.getBusinessId());
        }
    }

    protected void toHandSign(SignCloudReqParam signCloudReqParam, SignRespParam resp, DynamicObject signRecordInfo, DynamicObject contTplDyo) {
        Map<String, Object> handSignReturnData = this.apiService.toHandSign(signCloudReqParam, "fadadaV30", contTplDyo);
        int handSignCode = Integer.parseInt(String.valueOf(handSignReturnData.get("code")));
        if (handSignCode != 0) {
            String msg = String.valueOf(handSignReturnData.get("msg"));
            LOGGER.error("econt*** handsign fail\uff1a{},error msg\uff1a{}", (Object)signCloudReqParam.getContractNo(), (Object)msg);
            throw new KDBizException(msg);
        }
        Map data = (Map)handSignReturnData.get("data");
        resp.setHandSignUrl((String)data.get("handSignUrl"));
    }

    public Map<String, Object> companySign(String contractNo, DynamicObject contTplInfo, SignReqParam signReqParam) {
        DynamicObject signRecordInfo = this.eContractService.queryContractInfo(contractNo);
        int signflag = signRecordInfo.getInt("signflag");
        String signStatus = signRecordInfo.getString("signstatus");
        if ("0".equals(signStatus)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u5df2\u64a4\u9500\u3002", (String)"sign_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        this.licenceTake(signRecordInfo, contTplInfo);
        Long signatureId = EContractServiceHelper.getSignatureId(signReqParam);
        String signatureShowTime = contTplInfo.getBoolean("isshowdate") ? "1" : NOT_SHOW_SIGN_TIME;
        boolean acrosspageSign = contTplInfo.getBoolean("acrosspagesign");
        Map<String, Object> signReturnData = -1L == signatureId ? this.apiService.defaultSign(contractNo, signatureId, acrosspageSign, signatureShowTime) : this.apiService.sign(contractNo, signatureId, acrosspageSign, signatureShowTime);
        LOGGER.info("signReturnData2 signReturnData={}", (Object)JSON.toJSONString(signReturnData));
        int handSignCode = Integer.parseInt(String.valueOf(signReturnData.get("code")));
        if (handSignCode == 0) {
            List dataList = (List)signReturnData.get("data");
            Map sealInfo = (Map)((Map)dataList.get(0)).get("sealInfo");
            Map nosealInfo = (Map)((Map)dataList.get(0)).get("nosealInfo");
            HashMap map = Maps.newHashMapWithExpectedSize((int)2);
            map.put("sealInfo", sealInfo);
            map.put("nosealInfo", nosealInfo);
            String signtype = contTplInfo.getString("signtype");
            String cloudSignType = SignTypeEnum.getCloudType((String)signtype);
            this.eContractService.recordCompanySign(contractNo, cloudSignType);
            return map;
        }
        String msg = String.valueOf(signReturnData.get("msg"));
        LOGGER.error("econt*** companySign fail\uff1a{},error msg\uff1a{}", (Object)contractNo, (Object)msg);
        throw new KDBizException(msg);
    }

    protected Map<String, Object> licenceTake(DynamicObject signRecordInfo, DynamicObject contTplInfo) {
        int availableSite;
        EcontractWarnMsgService warnMsgService;
        if (!this.checkLicense) {
            return Collections.emptyMap();
        }
        String signtype = contTplInfo.getString("signtype");
        String contractNo = signRecordInfo.getString("econnumber");
        long contSubjectId = signRecordInfo.getLong("kdappid.id");
        DynamicObject contractSubjectInfo = ContractSubjectService.queryContractByPk(contSubjectId);
        Map<String, Object> map = EContLicenseService.licenceTake(((DynamicObject)contractSubjectInfo.get("fiorg")).getLong("id"), contractNo, signtype, signRecordInfo, new Date());
        if (((Boolean)map.get("success")).booleanValue()) {
            warnMsgService = new EcontractWarnMsgService();
            availableSite = (Integer)map.getOrDefault("availableSite", -1);
            if (availableSite == -1) {
                LOGGER.info("available site is negative,do not send warn message.");
                return map;
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bb8\u53ef\u6263\u51cf\u5931\u8d25", (String)"sign_13", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        warnMsgService.sendWarnMsgAsyn(availableSite);
        return map;
    }

    protected final String getSignNotifyUrl() {
        String url = RequestContext.get().getClientFullContextPath() + String.format(HAND_SIGN_NOTIFY_URI, RequestContext.get().getAccountId());
        return url;
    }

    private void doParamCheck() {
        this.commonParamCheck();
        this.personParamCheck();
    }

    protected void commonParamCheck() {
        Long fiorg = this.signReqParam.getFiorg();
        if (this.longIsEmpty(fiorg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u4e3b\u4f53\u4e3a\u7a7a", (String)"sign_3", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Long tempId = this.signReqParam.getTemplateId();
        Long tempTypeId = this.signReqParam.getTemplateTypeId();
        if (this.longIsEmpty(tempTypeId) && this.longIsEmpty(tempId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u548c\u7b7e\u7f72\u7c7b\u578b\u90fd\u4e3a\u7a7a", (String)"EContractSignApiService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String fileName = this.signReqParam.getFileName();
        String filePath = this.signReqParam.getFilePath();
        if (StringUtils.isEmpty((String)fileName) || StringUtils.isEmpty((String)filePath)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u4e3a\u7a7a\u3002", (String)"sign_5", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    protected void personParamCheck() {
        if (this.signReqParam.isAutoSign() && StringUtils.isEmpty((String)this.signReqParam.getSignMode())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u81ea\u52a8\u7b7e\u9700\u6307\u5b9a\u7b7e\u7f72\u987a\u5e8f", (String)"sign_6", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        Long naturalId = this.signReqParam.getNaturalId();
        Long candidateId = this.signReqParam.getCandidateId();
        if (this.longIsEmpty(naturalId) && this.longIsEmpty(candidateId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u81ea\u7136\u4eba\u548c\u5019\u9009\u4eba\u201d\u3002", (String)"sign_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String name = this.signReqParam.getName();
        String identity = this.signReqParam.getIdentity();
        String mobile = this.signReqParam.getMobile();
        String identityType = this.signReqParam.getIdentityType();
        if (StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)identity) || StringUtils.isEmpty((String)mobile)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba4\u8bc1\u4e09\u8981\u7d20\u4e3a\u7a7a", (String)"sign_8", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (!ParamsUtil.isMobileMatch(mobile)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u9519\u8bef\u3002", (String)"sign_10", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (HRStringUtils.isNotEmpty((String)identityType) && "1010".equals(identityType) && !ParamsUtil.isIdentityMatch(identity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8eab\u4efd\u8bc1\u53f7\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u8eab\u4efd\u8bc1\u53f7\u3002", (String)"sign_11", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String cloud = this.signReqParam.getCloud();
        String appNum = this.signReqParam.getAppNum();
        if (StringUtils.isEmpty((String)cloud) || StringUtils.isEmpty((String)appNum)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u4e91\u6216\u5e94\u7528\u7f16\u7801\u3002", (String)"sign_9", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
    }

    protected boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }
}

