/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.econtract;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.ECPersonAuthRecordService;
import kd.hr.hrcs.bussiness.service.econtract.EContApiBase;
import kd.hr.hrcs.common.constants.econtract.CertificateTypeEnum;

public class UserAuthApiService
extends EContApiBase {
    private static final Log LOGGER = LogFactory.getLog(UserAuthApiService.class);
    private static final List CERTIFICATETYPE = Lists.newArrayList((Object[])new Long[]{1010L, 1020L, 1060L, 1070L});

    public UserAuthApiService(Long fiorg) {
        super(fiorg);
    }

    public UserAuthApiService(DynamicObject contractSubject) {
        super(contractSubject);
    }

    public String tryGetValidUserId(SignReqParam signReqParam, boolean skipAuth, boolean authOnSign) {
        String userId = null;
        if (skipAuth || !authOnSign) {
            userId = ECPersonAuthRecordService.queryUserId(signReqParam, "0");
        }
        return userId;
    }

    public Map<String, Object> auth(String verifyedWay, SignReqParam signReqParam) {
        Long aLong;
        Long naturalId = signReqParam.getNaturalId();
        Long candidateId = signReqParam.getCandidateId();
        String name = signReqParam.getName();
        String identity = signReqParam.getIdentity();
        String mobile = signReqParam.getMobile();
        String appId = this.getCSAppid();
        String identityType = signReqParam.getIdentityType();
        Long identityTypeL = HRStringUtils.isEmpty((String)identityType) ? Long.valueOf(1010L) : ((aLong = Long.valueOf(identityType)) == null || aLong == 0L ? Long.valueOf(1010L) : aLong);
        if (!CERTIFICATETYPE.contains(identityTypeL)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u8bc1\u4ef6\u7c7b\u578b", (String)"UserAuthApiService_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        String mapValueIdentityType = CertificateTypeEnum.getMapValueByKey((Long)identityTypeL);
        Map<String, Object> returnData = this.getApiService().mobileAuthUrl(name, mapValueIdentityType, identity, mobile, appId, this.getAuthNotifyUrl(), signReqParam.getAuthFrontUrl(), verifyedWay, "fadadaV30");
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            Map data = (Map)returnData.get("data");
            String userId = (String)data.get("userId");
            String authUrl = (String)data.get("url");
            LOGGER.info("auth save userid={}", (Object)userId);
            ECPersonAuthRecordService.saveAuthRecord(signReqParam, userId, authUrl);
            return data;
        }
        String msg = String.valueOf(returnData.get("msg"));
        LOGGER.error("econt*** user auth fail naturalId{}, candidateId{} error msg\uff1a{}", new Object[]{naturalId, candidateId, msg});
        throw new KDBizException(msg);
    }

    public String getAuthResult(SignReqParam signReqParam) {
        DynamicObject validUser = ECPersonAuthRecordService.queryAuthUserInfo(signReqParam, "0");
        if (validUser != null) {
            return "2";
        }
        DynamicObject authingUser = ECPersonAuthRecordService.queryAuthUserInfo(signReqParam, "2");
        if (authingUser == null) {
            return "0";
        }
        String userId = authingUser.getString("userid");
        Map<String, Object> returnData = this.getApiService().queryAuthResult(userId, "fadadaV30");
        int code = Integer.parseInt(String.valueOf(returnData.get("code")));
        if (code == 0) {
            Map data = (Map)returnData.get("data");
            String resultCode = (String)data.get("resultCode");
            LOGGER.info("econt*** getAuthResult resultCode\uff1a{}", (Object)resultCode);
            if ("1".equals(resultCode)) {
                ECPersonAuthRecordService.authSuccess(authingUser);
                return "2";
            }
            if ("2".equals(resultCode) || "3".equals(resultCode)) {
                return "1";
            }
        } else {
            String msg = String.valueOf(returnData.get("msg"));
            LOGGER.error("econt*** query auth result userId\uff1a{},error msg\uff1a{}", (Object)userId, (Object)msg);
            throw new KDBizException(msg);
        }
        return "0";
    }

    public boolean queryAuthResult(SignReqParam signReqParam) {
        return "2".equals(this.getAuthResult(signReqParam));
    }

    private String getAuthNotifyUrl() {
        StringBuilder url = new StringBuilder();
        url.append(RequestContext.get().getClientFullContextPath());
        url.append("kapi/app/hrcs/hrPersonVerifyNotify");
        url.append("?accountId=").append(RequestContext.get().getAccountId());
        url.append('&');
        return url.toString();
    }
}

