/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.factory;

import java.lang.reflect.ParameterizedType;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.ReflectUtil;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.api.AcrossCorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.api.BaseService;
import kd.hr.hrcs.bussiness.service.esign.api.BatchInitiateSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.CallBackEvent;
import kd.hr.hrcs.bussiness.service.esign.api.CancelSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.Config;
import kd.hr.hrcs.bussiness.service.esign.api.CorpSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealCUD;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealQuery;
import kd.hr.hrcs.bussiness.service.esign.api.DisuseSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.DownLoadSignFile;
import kd.hr.hrcs.bussiness.service.esign.api.InitiateSignTask;
import kd.hr.hrcs.bussiness.service.esign.api.ObtainSignLink;
import kd.hr.hrcs.bussiness.service.esign.api.QuerySignTask;
import kd.hr.hrcs.bussiness.service.esign.api.RemindSignTask;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.enu.ServiceEnum;
import kd.hr.hrcs.bussiness.service.esign.factory.ESignSrvFactory;
import kd.hr.hrcs.bussiness.service.esign.util.ESignSPMgrUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BaseESignSrvFactory
extends ESignSrvFactory {
    private final String spId;
    private final String corporateId;
    private final String appId;
    private final String appSecret;
    private final String serverUrl;
    private final ESignAppInfo eSignAppInfo;
    private final Map<String, String> instanceMap;

    public BaseESignSrvFactory(ESignAppInfo eSignAppInfo, Map<String, String> instanceMap) {
        this.spId = eSignAppInfo.getSpId();
        this.corporateId = eSignAppInfo.getCorporateId();
        this.eSignAppInfo = eSignAppInfo;
        this.appId = eSignAppInfo.getAppId();
        this.appSecret = eSignAppInfo.getAppSecret();
        this.serverUrl = eSignAppInfo.getServerUrl();
        this.instanceMap = instanceMap;
    }

    public BaseESignSrvFactory(String spId, String corporateId) {
        Pair<ESignAppInfo, Map<String, String>> eSignSPAppCfg = ESignSPMgrUtil.fetchESignSPCfg(Long.parseLong(spId), Long.parseLong(corporateId));
        this.spId = spId;
        this.corporateId = corporateId;
        this.eSignAppInfo = (ESignAppInfo)eSignSPAppCfg.getLeft();
        this.appId = this.eSignAppInfo.getAppId();
        this.appSecret = this.eSignAppInfo.getAppSecret();
        this.serverUrl = this.eSignAppInfo.getServerUrl();
        this.instanceMap = (Map)eSignSPAppCfg.getRight();
    }

    @Override
    public Config getConfig() {
        String key = "BaseESignSrvFactory#initConfig";
        Config instance = (Config)this.serviceMap.get(key);
        if (instance == null) {
            InitiateSignTask instanceInitiateSignTask = (InitiateSignTask)this.getInstance(ServiceEnum.INITIATE_SIGN_TASK);
            this.checkService(ServiceEnum.INITIATE_SIGN_TASK, instanceInitiateSignTask);
            Class actualTypeArgument = (Class)((ParameterizedType)instanceInitiateSignTask.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            String serviceName = actualTypeArgument.getName();
            instance = (Config)ReflectUtil.newInstance((String)serviceName, (Object[])new Object[]{this.eSignAppInfo});
            this.serviceMap.put(key, instance);
        }
        return instance;
    }

    @Override
    public AcrossCorporateAuth getAcrossCorporateAuth() {
        return (AcrossCorporateAuth)this.getInstance(ServiceEnum.ACROSS_CORPORATE_AUTH);
    }

    @Override
    public CorporateSealQuery getCorporateSealQuery() {
        return (CorporateSealQuery)this.getInstance(ServiceEnum.CORPORATE_SEAL_QUERY);
    }

    @Override
    public CorporateSealCUD getCorporateSealCUD() {
        return (CorporateSealCUD)this.getInstance(ServiceEnum.CORPORATE_SEAL_CUD);
    }

    @Override
    public CorporateAuth getCorporateAuth() {
        return (CorporateAuth)this.getInstance(ServiceEnum.CORPORATE_AUTH);
    }

    @Override
    public InitiateSignTask getInitiateSignTask() {
        InitiateSignTask instance = (InitiateSignTask)this.getInstance(ServiceEnum.INITIATE_SIGN_TASK);
        this.checkService(ServiceEnum.INITIATE_SIGN_TASK, instance);
        ((BaseService)((Object)instance)).setConfig(this.getConfig());
        return instance;
    }

    @Override
    public ObtainSignLink getObtainSignLink() {
        return (ObtainSignLink)this.getInstance(ServiceEnum.OBTAIN_SIGN_LINK);
    }

    @Override
    public CorpSignTask getCorpSignTask() {
        return (CorpSignTask)this.getInstance(ServiceEnum.CORP_SIGN_TASK);
    }

    @Override
    public QuerySignTask getQuerySignTask() {
        return (QuerySignTask)this.getInstance(ServiceEnum.QUERY_SIGN_TASK);
    }

    @Override
    public RemindSignTask getRemindSignTask() {
        return (RemindSignTask)this.getInstance(ServiceEnum.REMIND_SIGN_TASK);
    }

    @Override
    public DownLoadSignFile getDownLoadSignFile() {
        return (DownLoadSignFile)this.getInstance(ServiceEnum.DOWNLOAD_SIGN_FILE);
    }

    @Override
    public BatchInitiateSignTask getBatchInitiateSignTask() {
        return (BatchInitiateSignTask)this.getInstance(ServiceEnum.BATCH_INITIATE_SIGN_TASK);
    }

    @Override
    public CancelSignTask getCancelSignTask() {
        return (CancelSignTask)this.getInstance(ServiceEnum.CANCEL_SIGN_TASK);
    }

    @Override
    public DisuseSignTask getDisuseSignTask() {
        return (DisuseSignTask)this.getInstance(ServiceEnum.DISUSE_SIGN_TASK);
    }

    @Override
    public CallBackEvent getCallBackEvent() {
        return (CallBackEvent)this.getInstance(ServiceEnum.CALLBACK_EVENT);
    }

    private <T> T getInstance(ServiceEnum serviceEnum) {
        String clazz;
        String interFaceName = serviceEnum.getInterFace();
        Object instance = this.serviceMap.get(interFaceName);
        if (instance == null && StringUtils.isNotBlank((CharSequence)(clazz = this.instanceMap.get(interFaceName)))) {
            instance = ReflectUtil.newInstance((String)clazz);
            this.checkService(serviceEnum, instance);
            if (serviceEnum != ServiceEnum.INITIATE_SIGN_TASK) {
                ((BaseService)instance).setConfig(this.getConfig());
            }
            this.serviceMap.put(interFaceName, instance);
        }
        return (T)instance;
    }

    private void throwClassErrException(ServiceEnum serviceEnum) {
        throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u7b7e\u670d\u52a1\u3010%1$s\u3011\u521d\u59cb\u5316\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u5b9e\u73b0\u7c7b\u3010%2$s\u3011\u662f\u5426\u6b63\u786e\u3002", (String)HrcsBusinessRes.BaseESignSrvFactory_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), serviceEnum.getSrvName(), this.instanceMap.get(serviceEnum.getInterFace())));
    }

    private void throwSrvNotImpl(ServiceEnum serviceEnum) {
        throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524d\u7535\u5b50\u7b7e\u670d\u52a1\u201c%s\u201d\u8fd8\u672a\u7ef4\u62a4\u8be5\u670d\u52a1\u5546\u670d\u52a1\u7c7b\u6ce8\u518c\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u83dc\u5355\u201cHR\u901a\u7528\u670d\u52a1>HR\u7535\u5b50\u7b7e\u7ba1\u7406\u5e73\u53f0>\u7535\u5b50\u7b7e\u670d\u52a1\u5546\u201d\u70b9\u51fb\u76f8\u5e94\u670d\u52a1\u5546\u7f16\u7801\uff0c\u8fdb\u5165\u914d\u7f6e\u9875\u9762\u5b8c\u6210\u7ef4\u62a4\u7535\u5b50\u7b7e\u670d\u52a1\u7c7b\u6ce8\u518c\u914d\u7f6e\u4fe1\u606f\u518d\u8fdb\u884c\u76f8\u5173\u64cd\u4f5c\u3002", (String)HrcsBusinessRes.BaseESignSrvFactory_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]), serviceEnum.getSrvName()));
    }

    private <T> void checkService(ServiceEnum serviceEnum, T instance) {
        if (instance == null) {
            if (serviceEnum.isMust()) {
                this.throwSrvNotImpl(serviceEnum);
            } else {
                this.throwClassErrException(serviceEnum);
            }
        }
    }

    public String getSpId() {
        return this.spId;
    }

    public String getCorporateId() {
        return this.corporateId;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public ESignAppInfo geteSignAppInfo() {
        return this.eSignAppInfo;
    }
}

