/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.factory;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import org.apache.commons.lang3.StringUtils;

public class ESignFactoryPropUtil {
    private static final Log log = LogFactory.getLog(ESignFactoryPropUtil.class);
    private static final String ESIGN_FACTORY_PROP_FILE_PATH = "/esign/eSignFactory.properties";
    private static Properties PROP;

    public static ESignFactoryPropUtil getInstance() {
        return ConfigurationHolder.instance;
    }

    private ESignFactoryPropUtil() {
        PROP = ESignFactoryPropUtil.loadProp(ESIGN_FACTORY_PROP_FILE_PATH);
    }

    public Map<String, String> getProps() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (PROP == null) {
            return props;
        }
        Enumeration<Object> enumeration = PROP.keys();
        while (enumeration.hasMoreElements()) {
            String key = String.valueOf(enumeration.nextElement());
            String value = this.getValue(key);
            if (StringUtils.isBlank((CharSequence)value)) {
                throw new KDBizException(String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5f53\u524dkey\u3010%s\u3011\u672a\u914d\u7f6evalue,\u8bf7\u5230\u6587\u4ef6\u3010/esign/eSignFactory.properties\u3011\u4e0b\u8fdb\u884c\u914d\u7f6e\u3002", (String)"ESignFactoryPropUtil_0", (String)"hrmp-hrcs-business", (Object[])new Object[0]), key));
            }
            props.put(key, value);
        }
        return props;
    }

    public String getValue(String key) {
        if (PROP == null) {
            return null;
        }
        return PROP.getProperty(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties loadProp(String filePath) {
        try (InputStream resourceAsStream = ESignFactoryPropUtil.class.getResourceAsStream(filePath);){
            Properties prop = new Properties();
            prop.clear();
            prop.load(resourceAsStream);
            Properties properties = prop;
            return properties;
        }
        catch (Exception e) {
            log.warn("load properties[{}] fail, errorMsg={}", new Object[]{filePath, e.getMessage(), e});
            return null;
        }
    }

    private static class ConfigurationHolder {
        private static ESignFactoryPropUtil instance = new ESignFactoryPropUtil();

        private ConfigurationHolder() {
        }
    }
}

