/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hrcs.bussiness.service.esign.api.AcrossCorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.bo.SealAuthInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.SealUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.GetSealFreeSignUrlReq;

public class FddAcrossCorporateAuth
extends FddBaseService<FddConfig>
implements AcrossCorporateAuth {
    private static final Log LOGGER = LogFactory.getLog(FddAcrossCorporateAuth.class);

    @Override
    public ResponseData getSealFreeSignUrl(SealAuthInfo sealAuthInfo) {
        OpenApiClient openApiClient = this.getOpenApiClient();
        GetSealFreeSignUrlReq req = new GetSealFreeSignUrlReq();
        req.setAccessToken(this.getAccessToken(openApiClient));
        String openCorpId = sealAuthInfo.getOpenCorpId();
        req.setOpenCorpId(openCorpId);
        Set<Object> sealIds = sealAuthInfo.getSealIds();
        List targetSealIds = sealIds.stream().map(item -> Long.parseLong(String.valueOf(item))).collect(Collectors.toList());
        req.setSealIds(targetSealIds);
        req.setBusinessId(this.getBusinessId());
        req.setClientUserId(sealAuthInfo.getClientUserId());
        return SealUtil.getSealFreeSignUrl(sealAuthInfo, openApiClient, req);
    }

    @Override
    public String getCurBusinessId() {
        return this.getBusinessId();
    }
}

