/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.hr.hbp.common.util.HRAssert;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.BaseService;
import kd.hr.hrcs.bussiness.service.esign.api.Config;
import kd.hr.hrcs.bussiness.service.esign.bo.ESignAppInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.SealUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import org.apache.commons.lang3.StringUtils;

public class FddBaseService<F extends Config>
extends BaseService<FddConfig> {
    private FddConfig config;
    public boolean isDevLocalEnv = SealUtil.IS_DEV_LOCAL_ENV;

    @Override
    public void setConfig(FddConfig config) {
        this.config = config;
    }

    @Override
    public FddConfig getConfig() {
        return this.config;
    }

    public OpenApiClient getOpenApiClient() throws KDBizException {
        try {
            OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
            this.checkOpenApiClient(openApiClient);
            return openApiClient;
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("getOpenApiClientError", ResManager.loadKDString((String)"\u83b7\u53d6\u6cd5\u5927\u5927OpenApiClient\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddBaseService_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    public void checkOpenApiClient(OpenApiClient openApiClient) {
        HRAssert.notBlank((String)openApiClient.getAppId(), (String)"appId must not be blank", (Object[])new Object[0]);
        HRAssert.notBlank((String)openApiClient.getAppSecret(), (String)"appSecret must not be blank", (Object[])new Object[0]);
        HRAssert.notBlank((String)openApiClient.getServerUrl(), (String)"serverUrl must not be blank", (Object[])new Object[0]);
    }

    public String getAccessToken(OpenApiClient openApiClient) throws KDBizException {
        try {
            return FddServiceHelper.getAccessToken(openApiClient);
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("getAccessTokenError", ResManager.loadKDString((String)"\u83b7\u53d6\u6cd5\u5927\u5927AccessToken\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddBaseService_2.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    public String getOpenCorpId() throws KDBizException {
        try {
            return this.getConfig().getThirdCorpId();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("getOpenCorpIdError", ResManager.loadKDString((String)"\u83b7\u53d6\u6cd5\u5927\u5927OpenCorpId\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddBaseService_3.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    public String getBusinessId() throws KDBizException {
        try {
            String businessId = this.getConfig().getExtParam().get("businessId");
            if (StringUtils.isBlank((CharSequence)businessId)) {
                throw new KDBizException(new ErrorCode("getBusinessIdError", ResManager.loadKDString((String)"\u573a\u666f\u7801\u3010businessId\u3011\u672a\u5728\u670d\u52a1\u5546\u96c6\u6210\u5e94\u7528\u81ea\u5b9a\u4e49\u53c2\u6570\u914d\u7f6e\u3002", (String)HrcsBusinessRes.FddBaseService_4.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
            }
            return businessId;
        }
        catch (KDBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("getBusinessIdError", ResManager.loadKDString((String)"\u83b7\u53d6\u6cd5\u5927\u5927businessId\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.FddBaseService_5.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0])), new Object[0]);
        }
    }

    public OpenApiClient getOpenApiClientByConfig(Long configId) {
        ESignAppInfo eSignAppInfo = ESignAppCfgUtil.getESignAppInfo(configId);
        return new OpenApiClient(eSignAppInfo.getAppId(), eSignAppInfo.getAppSecret(), eSignAppInfo.getServerUrl());
    }

    public OpenApiClient getOpenApiClientByContractNo(String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject flowSignDyn = signFlowService.queryOneByNo(contractNo);
        if (flowSignDyn != null && flowSignDyn.getLong("signconfig.id") != 0L) {
            return this.getOpenApiClientByConfig(flowSignDyn.getLong("signconfig.id"));
        }
        return (OpenApiClient)this.getConfig().initConfig();
    }
}

