/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.util.ParamsUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.CorpClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.corp.CorpIdentInfoReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.corp.GetCorpAuthResourceUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.corp.GetCorpReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.common.ECorpAuthUrlRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.corp.CorpRes;

public class FddCorporateAuth
extends FddBaseService<FddConfig>
implements CorporateAuth {
    private static final Log logger = LogFactory.getLog(FddCorporateAuth.class);

    @Override
    public Map<String, Object> corporateAuth(Map<String, Object> param) {
        logger.info("corporateAuth param={}", param);
        GetCorpAuthResourceUrlReq authResourceUrlReq = new GetCorpAuthResourceUrlReq();
        authResourceUrlReq.setClientCorpId((String)param.get("corporateId"));
        String mobile = (String)param.get("mobile");
        if (HRStringUtils.isNotEmpty((String)mobile) && ParamsUtil.isChinaMobileMatch(mobile)) {
            authResourceUrlReq.setAccountName((String)param.get("mobile"));
        }
        CorpIdentInfoReq corpIdentInfoReq = new CorpIdentInfoReq();
        corpIdentInfoReq.setCorpName((String)param.get("corpName"));
        corpIdentInfoReq.setCorpIdentNo((String)param.get("corpIdentNo"));
        corpIdentInfoReq.setLegalRepName((String)param.get("legalRepName"));
        authResourceUrlReq.setCorpIdentInfo(corpIdentInfoReq);
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        authResourceUrlReq.setAccessToken(this.getAccessToken(openApiClient));
        CorpClient client = new CorpClient(openApiClient);
        BaseRes res = client.getCorpAuthUrl(authResourceUrlReq);
        logger.info("corporateAuth res={}", (Object)SerializationUtils.toJsonString((Object)res));
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        if (res.isSuccess()) {
            String authUrl = ((ECorpAuthUrlRes)res.getData()).getAuthUrl();
            HashMap result = Maps.newHashMapWithExpectedSize((int)16);
            result.put("authUrl", authUrl);
            return result;
        }
        throw new KDBizException("corporateAuth error, " + res.getMsg());
    }

    @Override
    public Map<String, Object> queryCorporateAuth(Map<String, Object> param) {
        logger.info("queryCorporateAuth param={}", param);
        GetCorpReq getCorpReq = new GetCorpReq();
        if (param.containsKey("openCorpId")) {
            getCorpReq.setOpenCorpId((String)param.get("openCorpId"));
        }
        if (param.containsKey("clientCorpId")) {
            getCorpReq.setClientCorpId((String)param.get("clientCorpId"));
        }
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        getCorpReq.setAccessToken(this.getAccessToken(openApiClient));
        CorpClient client = new CorpClient(openApiClient);
        try {
            BaseRes res = client.get(getCorpReq);
            logger.info("queryCorporateAuth res={}", (Object)SerializationUtils.toJsonString((Object)res));
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            HashMap result = Maps.newHashMapWithExpectedSize((int)16);
            String code = res.getCode();
            if (res.isSuccess()) {
                CorpRes data = (CorpRes)res.getData();
                String bindingStatus = "";
                String openCorpId = "";
                if (data != null) {
                    bindingStatus = data.getBindingStatus();
                    openCorpId = data.getOpenCorpId();
                }
                result.put("bindingStatus", bindingStatus);
                result.put("openCorpId", openCorpId);
                result.put("code", code);
                return result;
            }
            result.put("code", code);
            result.put("bindingStatus", "");
            logger.info("queryCorporateAuth fail, " + res.getMsg());
            return result;
        }
        catch (Exception exception) {
            logger.error("queryCorporateAuth exception", (Throwable)exception);
            return null;
        }
    }
}

