/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hbp.common.model.econtract.SignRespParam;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hrcs.bussiness.service.econtract.EContemplateService;
import kd.hr.hrcs.bussiness.service.econtract.EContractServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.SignFileService;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.DisuseSignTask;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.bussiness.service.esign.util.ESignAppCfgUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignCOSealMgrUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.bean.common.ActorCorpMember;
import kd.hr.hrcs.esign3rd.fadada.bean.common.Field;
import kd.hr.hrcs.esign3rd.fadada.bean.common.FieldPosition;
import kd.hr.hrcs.esign3rd.fadada.bean.common.Notification;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.DocClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SignTaskClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.FddFileUrl;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.FileProcessReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.doc.GetUploadUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.CancelSignTaskCreateReq;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskActorGetUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.FileId;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.FileProcessRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.doc.GetUploadUrlRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.CancelSignTaskCreateRes;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.SignTaskActorGetUrlRes;

public class FddDisuseSignTask
extends FddBaseService<FddConfig>
implements DisuseSignTask {
    private static final Log logger = LogFactory.getLog(FddDisuseSignTask.class);

    @Override
    public SignRespParam abolish(String preContractNo, SignReqParam signReqParam) {
        SignFileService signFileService = new SignFileService();
        String contractNo = signFileService.saveSignFile(signReqParam, preContractNo);
        SignRespParam signRespParam = new SignRespParam(contractNo);
        HashMap<String, String> fileParams = this.uploadDoc(signReqParam);
        signFileService.saveExtMap(contractNo, fileParams);
        SignFlowService signFlowService = new SignFlowService();
        signFlowService.saveSignFlow(signReqParam, signReqParam.getContractNo());
        HashMap<String, String> flowParams = this.createAbolishSignFlow(signReqParam, fileParams, signRespParam, preContractNo);
        signFlowService.saveExtMap(signReqParam.getContractNo(), flowParams);
        return signRespParam;
    }

    public HashMap<String, String> createAbolishSignFlow(SignReqParam signReqParam, HashMap<String, String> fileParams, SignRespParam signRespParam, String preContractNo) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        DynamicObject contTplDyo = this.getDynamiTplDyo(signReqParam);
        String signType = contTplDyo.getString("signtype");
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        CancelSignTaskCreateReq createSignTaskReq = new CancelSignTaskCreateReq();
        createSignTaskReq.setAccessToken(accessToken);
        this.getPreContractInfo(signReqParam, preContractNo, createSignTaskReq);
        createSignTaskReq.setSignTaskSubject(signReqParam.getFileName());
        createSignTaskReq.setDocSource("selfUpload");
        createSignTaskReq.setExpiresTime(null);
        createSignTaskReq.setAutoStart(Boolean.valueOf(true));
        createSignTaskReq.setBusinessId(this.getBusinessId());
        createSignTaskReq.setCertCAOrg(null);
        createSignTaskReq.setTransReferenceId(signReqParam.getContractNo());
        ArrayList docs = Lists.newArrayListWithCapacity((int)16);
        for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
            int index = i + 1;
            docs.add(this.getDoc(signType, contTplDyo, signReqParam, fileParams, String.valueOf(index), (String)signReqParam.getFileNameList().get(i), fileParams.get("fileId" + index)));
        }
        createSignTaskReq.setDocs((List)docs);
        List<CancelSignTaskCreateReq.CancelSignTaskActor> actors = this.getActors(signType, signReqParam, contTplDyo);
        createSignTaskReq.setActors(actors);
        BaseRes res = signTaskClient.abolishSignTask(createSignTaskReq);
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        if (res.isSuccess()) {
            String signTaskId = ((CancelSignTaskCreateRes)res.getData()).getAbolishedSignTaskId();
            result.put("signTaskId", signTaskId);
            String signUrl = this.getPersonSignUrl(signType, signTaskId, signReqParam);
            if (!HRStringUtils.isEmpty((String)signUrl)) {
                result.put("personSignUrl", signUrl);
                signRespParam.setHandSignUrl(signUrl);
            }
        } else {
            throw new KDBizException("createSignFlow error," + res.getMsg());
        }
        return result;
    }

    private void getPreContractInfo(SignReqParam signReqParam, String preContractNo, CancelSignTaskCreateReq createSignTaskReq) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject flowSignDyn = signFlowService.queryOneByNo(preContractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(flowSignDyn);
        createSignTaskReq.setSignTaskId(signFlowExtMap.get("signTaskId"));
        CancelSignTaskCreateReq.AbolishedInitiator abolishedInitiator = new CancelSignTaskCreateReq.AbolishedInitiator();
        abolishedInitiator.setInitiatorId(this.getOwnerOpenCorpId(signReqParam));
        createSignTaskReq.setAbolishedInitiator(abolishedInitiator);
    }

    private boolean isAutoSign(DynamicObject dynamicObject) {
        return "1".equals(dynamicObject.getString("sealway"));
    }

    private DynamicObject getDynamiTplDyo(SignReqParam signReqParam) {
        DynamicObject contTplDyo;
        if (this.longIsEmpty(signReqParam.getTemplateTypeId()) && this.longIsEmpty(signReqParam.getTemplateId())) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7b7e\u7f72\u914d\u7f6e\u548c\u7b7e\u7f72\u7c7b\u578b\u90fd\u4e3a\u7a7a", (String)"EContractSignApiService_7", (String)"hrmp-hrcs-business", (Object[])new Object[0]));
        }
        if (this.longIsEmpty(signReqParam.getTemplateTypeId())) {
            contTplDyo = EContemplateService.queryEContplInfo(signReqParam.getTemplateId());
        } else {
            DynamicObject econtemplatetype = EContractServiceHelper.getSignConfig(signReqParam.getTemplateTypeId());
            contTplDyo = EContemplateService.queryEContplInfo(econtemplatetype.getDynamicObject("template").getLong("id"));
        }
        return contTplDyo;
    }

    private boolean longIsEmpty(Long naturalId) {
        return naturalId == null || naturalId == 0L;
    }

    private List<CancelSignTaskCreateReq.CancelSignTaskActor> getActors(String signType, SignReqParam signReqParam, DynamicObject contTplDyo) {
        ArrayList<CancelSignTaskCreateReq.CancelSignTaskActor> addActors = new ArrayList<CancelSignTaskCreateReq.CancelSignTaskActor>();
        int order = 10;
        int orderStep = "1".equals(signReqParam.getSignMode()) ? -1 : 1;
        ArrayList<String> verifyMethods = null;
        if ("2".equals(signType) || "3".equals(signType)) {
            String actorId = "person";
            String actorType = "person";
            String actorName = signReqParam.getName();
            String[] permissions = new String[]{"sign"};
            String actorOpenId = null;
            String actorFDDId = null;
            String identNameForMatch = signReqParam.getName();
            String certNoForMatch = signReqParam.getIdentity();
            Notification notification = Notification.getInstance((boolean)false, (String)"mobile", (String)signReqParam.getMobile());
            CancelSignTaskCreateReq.CancelActor person = this.getActor(actorId, actorType, actorName, permissions, actorOpenId, actorFDDId, null, identNameForMatch, certNoForMatch, notification);
            if ("1020".equals(signReqParam.getIdentityType())) {
                person.setCertType("passport");
            } else if ("1040".equals(signReqParam.getIdentityType())) {
                person.setCertType("taiwan");
            } else if ("1060".equals(signReqParam.getIdentityType())) {
                person.setCertType("hk_macao");
            } else {
                person.setCertType("id_card");
            }
            person.setCertNoForMatch(signReqParam.getIdentity());
            ArrayList signFields = Lists.newArrayListWithCapacity((int)16);
            for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
                int index = i + 1;
                CancelSignTaskCreateReq.CancelSignActorField addSignFieldInfo = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "person" + index, null, false);
                signFields.add(addSignFieldInfo);
            }
            Boolean blockHere = false;
            Boolean requestVerifyFree = false;
            Boolean joinByLink = true;
            Boolean readingToEnd = contTplDyo.getBoolean("lastpageflag");
            Boolean readtimeflag = (Boolean)contTplDyo.get("readtimeflag");
            String readingTime = null;
            if (readtimeflag.booleanValue()) {
                String string = readingTime = contTplDyo.getString("readingtime").equals("0") ? null : contTplDyo.getString("readingtime");
            }
            if (!HRStringUtils.isEmpty((String)contTplDyo.getString("signidea"))) {
                String[] split = contTplDyo.getString("signidea").split(",");
                verifyMethods = new ArrayList<String>(Arrays.asList(split));
                verifyMethods.removeIf(method -> HRStringUtils.equals((String)"", (String)method));
            }
            CancelSignTaskCreateReq.CancelSignConfigInfo signConfigInfo = this.getAddSignConfigInfo(order++, blockHere, requestVerifyFree, this.getSignerSignMethod(contTplDyo), true, verifyMethods, joinByLink, readingToEnd, readingTime, false);
            CancelSignTaskCreateReq.CancelSignTaskActor addPerson = new CancelSignTaskCreateReq.CancelSignTaskActor();
            addPerson.setActor(person);
            addPerson.setSignFields((List)signFields);
            addPerson.setSignConfigInfo(signConfigInfo);
            addActors.add(addPerson);
        }
        if ("1".equals(signType) || "3".equals(signType)) {
            ArrayList actorCorpMembers = new ArrayList();
            Notification corpNotification = null;
            String corpName = this.getCorpName(signReqParam);
            String openCorpId = this.getOwnerOpenCorpId(signReqParam);
            CancelSignTaskCreateReq.CancelActor corp = this.getActor("corp", "corp", corpName, new String[]{"sign"}, openCorpId, null, actorCorpMembers.toArray(new ActorCorpMember[actorCorpMembers.size()]), null, null, corpNotification);
            ArrayList signFields1 = Lists.newArrayListWithCapacity((int)16);
            for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
                int index = i + 1;
                Long corpSealId = this.getAutoSignSealId(signReqParam, contTplDyo, contTplDyo.getLong("sealtypeid.id"));
                CancelSignTaskCreateReq.CancelSignActorField addSignFieldInfo1 = this.getAddSignFieldInfo(String.valueOf(i + 1), null, "corp" + index, corpSealId, false);
                signFields1.add(addSignFieldInfo1);
            }
            CancelSignTaskCreateReq.CancelSignConfigInfo signConfigInfo1 = this.getAddSignConfigInfo(order + orderStep, true, this.isAutoSign(contTplDyo), "unlimited", false, verifyMethods, true, false, null, false);
            CancelSignTaskCreateReq.CancelSignTaskActor addCorp = new CancelSignTaskCreateReq.CancelSignTaskActor();
            addCorp.setActor(corp);
            addCorp.setSignFields((List)signFields1);
            addCorp.setSignConfigInfo(signConfigInfo1);
            addActors.add(addCorp);
        }
        return addActors;
    }

    private String getOwnerOpenCorpId(SignReqParam signReqParam) {
        String spId = this.getConfig().getSpId();
        Long corporateId = signReqParam.getLawEntityId();
        logger.info("getOpenCorpId reqParams:spId={}  corporateId={}", (Object)spId, (Object)corporateId);
        return ESignAppCfgUtil.getOwnerOpenCorpId(Long.parseLong(spId), corporateId);
    }

    private String getSignerSignMethod(DynamicObject contTplDyo) {
        String signWay = contTplDyo.getString("personsignway");
        if (!HRStringUtils.isEmpty((String)signWay)) {
            if (signWay.contains("4")) {
                return "unlimited";
            }
            if (signWay.contains("1")) {
                return "hand_write";
            }
            if (signWay.contains("2")) {
                return "standard";
            }
            if (signWay.contains("3")) {
                return "ai_hand_write";
            }
        }
        return "unlimited";
    }

    private String getCorpName(SignReqParam signReqParam) {
        String result = null;
        if (signReqParam.getLawEntityId() != null && signReqParam.getLawEntityId() != 0L) {
            HRBaseServiceHelper lawHelper = new HRBaseServiceHelper("hbss_lawentity");
            DynamicObject dynObj = lawHelper.queryOne((Object)signReqParam.getLawEntityId());
            return dynObj.getString("name");
        }
        return result;
    }

    private Long getAutoSignSealId(SignReqParam signReqParam, DynamicObject contTplDyo, Long sealTypeId) {
        block5: {
            if (!this.isAutoSign(contTplDyo)) {
                return null;
            }
            String signType = contTplDyo.getString("signtype");
            if ("1".equals(signType) || "3".equals(signType)) {
                logger.info("getAutoSignSealId spid={},LawEntityId={},sealtypeid={}", new Object[]{this.getConfig().getSpId(), signReqParam.getLawEntityId(), sealTypeId});
                try {
                    DynamicObject sealDyn = ESignCOSealMgrUtil.querySealBySealType((Object)Long.parseLong(this.getConfig().getSpId()), (Object)signReqParam.getLawEntityId(), sealTypeId);
                    if (sealDyn != null) {
                        return sealDyn.getLong("sealid");
                    }
                }
                catch (Exception exp) {
                    if (!this.isAutoSign(contTplDyo)) break block5;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230%1$s\u7684%2$s\uff0c\u8bf7\u786e\u8ba4\u7cfb\u7edf\u4e2d\u662f\u5426\u5df2\u7ef4\u62a4/\u540c\u6b65\u7535\u5b50\u5370\u7ae0\u3002", (String)"FddInitiateSignTask_1", (String)"hrmp-hrcs-business", (Object[])new Object[0]), this.getCorpName(signReqParam), this.getSealTypeName(sealTypeId)));
                }
            }
        }
        return null;
    }

    private String getSealTypeName(Long sealTypeId) {
        DynamicObject dynamicObject;
        if (sealTypeId != null && (dynamicObject = ESignDBServiceUtil.hrSealType.queryOne((Object)sealTypeId)) != null) {
            return dynamicObject.getString("name");
        }
        return null;
    }

    private CancelSignTaskCreateReq.CancelSignConfigInfo getAddSignConfigInfo(int orderNo, boolean blockHere, boolean requestVerifyFree, String signerSignMethod, Boolean identifiedView, List<String> verifyMethods, Boolean joinByLink, Boolean readingToEnd, String readingTime, Boolean requestMemberSign) {
        CancelSignTaskCreateReq.CancelSignConfigInfo addSignConfigInfo = new CancelSignTaskCreateReq.CancelSignConfigInfo();
        addSignConfigInfo.setRequestVerifyFree(Boolean.valueOf(requestVerifyFree));
        return addSignConfigInfo;
    }

    private CancelSignTaskCreateReq.CancelSignActorField getAddSignFieldInfo(String fieldDocId, String fieldId, String fieldName, Long sealId, Boolean moveable) {
        CancelSignTaskCreateReq.CancelSignActorField addSignFieldInfo = new CancelSignTaskCreateReq.CancelSignActorField();
        addSignFieldInfo.setFieldDocId(fieldDocId);
        addSignFieldInfo.setFieldId(fieldId);
        addSignFieldInfo.setSealId(sealId);
        addSignFieldInfo.setFieldName(fieldName);
        return addSignFieldInfo;
    }

    private CancelSignTaskCreateReq.CancelActor getActor(String actorId, String actorType, String actorName, String[] permissions, String actorOpenId, String actorFDDId, ActorCorpMember[] actorCorpMembers, String identNameForMatch, String certNoForMatch, Notification notification) {
        CancelSignTaskCreateReq.CancelActor actor = new CancelSignTaskCreateReq.CancelActor();
        actor.setActorId(actorId);
        actor.setActorType(actorType);
        actor.setActorName(actorName);
        if (permissions != null) {
            actor.setPermissions(Arrays.asList(permissions));
        }
        actor.setActorOpenId(actorOpenId);
        actor.setActorFDDId(actorFDDId);
        if (actorCorpMembers != null) {
            actor.setActorCorpMembers(Arrays.asList(actorCorpMembers));
        }
        actor.setIdentNameForMatch(identNameForMatch);
        actor.setCertNoForMatch(certNoForMatch);
        actor.setNotification(notification);
        return actor;
    }

    private CancelSignTaskCreateReq.CancelDoc getDoc(String signType, DynamicObject contTplDyo, SignReqParam signReqParam, HashMap<String, String> fileParams, String docId, String fileName, String docFileId) {
        CancelSignTaskCreateReq.CancelDoc docInfo = new CancelSignTaskCreateReq.CancelDoc();
        docInfo.setDocId(docId);
        docInfo.setDocName(fileName);
        docInfo.setDocFileId(docFileId);
        docInfo.setDocFields(this.fields(signType, contTplDyo, signReqParam, docId));
        return docInfo;
    }

    private List<Field> fields(String signType, DynamicObject contTplDyo, SignReqParam signReqParam, String docId) {
        Field field1;
        ArrayList<Field> docFields = new ArrayList<Field>();
        if ("2".equals(signType) || "3".equals(signType)) {
            field1 = new Field();
            field1.setFieldId("person" + docId);
            field1.setFieldName("person" + docId);
            field1.setFieldType("person_sign");
            field1.setPosition(this.getFieldPosition("keyword", null, "100", "100", contTplDyo.getString("keyworddouble")));
            field1.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetxdouble"));
            field1.getPosition().setKeywordOffsetY(contTplDyo.getString("offsetydouble"));
            docFields.add(field1);
        }
        if ("1".equals(signType) || "3".equals(signType)) {
            field1 = new Field();
            field1.setFieldId("corp" + docId);
            field1.setFieldName("corp" + docId);
            String positionMode = "keyword";
            field1.setFieldType("corp_seal");
            field1.setPosition(this.getFieldPosition("keyword", null, "0", "100", contTplDyo.getString("keyword")));
            field1.getPosition().setKeywordOffsetX(contTplDyo.getString("offsetx"));
            field1.getPosition().setKeywordOffsetY(contTplDyo.getString("offsety"));
            docFields.add(field1);
        }
        return docFields;
    }

    public FieldPosition getFieldPosition(String positionMode, Integer positionPageNo, String positionX, String postionY, String positionKeyword) {
        FieldPosition fieldPosition = new FieldPosition();
        fieldPosition.setPositionMode(positionMode);
        fieldPosition.setPositionPageNo(positionPageNo);
        fieldPosition.setPositionX(positionX);
        fieldPosition.setPositionY(postionY);
        fieldPosition.setPositionKeyword(positionKeyword);
        return fieldPosition;
    }

    private String getPersonSignUrl(String signType, String signTaskId, SignReqParam signReqParam) {
        if ("2".equals(signType) || "3".equals(signType)) {
            OpenApiClient openApiClient = this.getOpenApiClientByContractNo(signReqParam.getContractNo());
            SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
            String accessToken = FddServiceHelper.getAccessToken(openApiClient);
            SignTaskActorGetUrlReq signTaskActorGetUrlReq = new SignTaskActorGetUrlReq();
            signTaskActorGetUrlReq.setActorId("person");
            signTaskActorGetUrlReq.setRedirectUrl(signReqParam.getHandSignFrontUrl());
            signTaskActorGetUrlReq.setSignTaskId(signTaskId);
            signTaskActorGetUrlReq.setAccessToken(accessToken);
            BaseRes res = signTaskClient.signTaskActorGetUrl(signTaskActorGetUrlReq);
            ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
            if (res.isSuccess()) {
                return ((SignTaskActorGetUrlRes)res.getData()).getActorSignTaskUrl();
            }
            throw new KDBizException("get getHandSignUrl error, " + res.getMsg());
        }
        return null;
    }

    public HashMap<String, String> uploadDoc(SignReqParam signReqParam) {
        HashMap<String, String> result = new HashMap<String, String>(16);
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        DocClient docClient = new DocClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        for (int i = 0; i < signReqParam.getFileNameList().size(); ++i) {
            BaseRes<FileProcessRes> fileProcessRes;
            GetUploadUrlReq req = new GetUploadUrlReq();
            req.setAccessToken(accessToken);
            req.setFileType("doc");
            BaseRes uploadUrlRes = docClient.getUploadFileUrl(req);
            logger.info("uploadUrlRes={}", (Object)JSON.toJSONString((Object)uploadUrlRes));
            int index = i + 1;
            result.put("fddFileUrl" + index, ((GetUploadUrlRes)uploadUrlRes.getData()).getFddFileUrl());
            ResultUtil.printLog((BaseRes)uploadUrlRes, (JsonStrategy)openApiClient.getJsonStrategy());
            if (uploadUrlRes.isSuccess()) {
                this.updateFile2Url((String)signReqParam.getFilePathList().get(i), ((GetUploadUrlRes)uploadUrlRes.getData()).getUploadUrl());
                fileProcessRes = this.fileProcess(docClient, (String)signReqParam.getFileNameList().get(i), ((GetUploadUrlRes)uploadUrlRes.getData()).getFddFileUrl(), accessToken);
                ResultUtil.printLog(fileProcessRes, (JsonStrategy)openApiClient.getJsonStrategy());
                if (!fileProcessRes.isSuccess() || ((FileProcessRes)fileProcessRes.getData()).getFileIdList().size() <= 0) {
                    logger.error("uploadDoc error:{}", (Object)fileProcessRes.getMsg());
                    throw new KDBizException("upload doc file error : " + fileProcessRes.getMsg());
                }
            } else {
                logger.error("uploadDoc error:{}", (Object)uploadUrlRes.getMsg());
                throw new KDBizException("upload doc file exception");
            }
            result.put("fileId" + index, ((FileId)((FileProcessRes)fileProcessRes.getData()).getFileIdList().get(0)).getFileId());
        }
        return result;
    }

    private void updateFile2Url(String filePath, String fadadaUploadUrl) {
        FilterOutputStream bos = null;
        BufferedInputStream bis = null;
        try {
            int readByte;
            FileService service = FileServiceFactory.getAttachmentFileService();
            InputStream ins = service.getInputStream(filePath);
            URL uploadUrl = new URL(fadadaUploadUrl);
            HttpURLConnection connection = (HttpURLConnection)uploadUrl.openConnection();
            connection.setRequestMethod("PUT");
            connection.setDoOutput(true);
            bos = new BufferedOutputStream(connection.getOutputStream());
            bis = new BufferedInputStream(ins);
            while ((readByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(readByte);
                ((BufferedOutputStream)bos).flush();
            }
            bos.close();
            int responseCode = connection.getResponseCode();
            logger.info("responseCode:{},getResponseMessage: {} ", (Object)(responseCode + ":"), (Object)connection.getResponseMessage());
            if (responseCode != 200) {
                throw new KDBizException("uploadFile2Url error,responseCode:" + responseCode);
            }
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
        }
    }

    private BaseRes<FileProcessRes> fileProcess(DocClient docClient, String fileName, String fadadaFileUrl, String accessToken) {
        FileProcessReq req = new FileProcessReq();
        req.setAccessToken(accessToken);
        ArrayList<FddFileUrl> list = new ArrayList<FddFileUrl>();
        FddFileUrl fddFileUrl = new FddFileUrl();
        fddFileUrl.setFileType("doc");
        fddFileUrl.setFddFileUrl(fadadaFileUrl);
        fddFileUrl.setFileName(fileName + ".pdf");
        list.add(fddFileUrl);
        req.setFddFileUrlList(list);
        return docClient.process(req);
    }
}

