/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.model.econtract.SignReqParam;
import kd.hr.hrcs.bussiness.service.esign.SignFlowService;
import kd.hr.hrcs.bussiness.service.esign.api.QuerySignTask;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddBaseService;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddConfig;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddServiceHelper;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.stratey.JsonStrategy;
import kd.hr.hrcs.esign3rd.fadada.utils.ResultUtil;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SignTaskClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.signtask.SignTaskBaseReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.signtask.SignTaskDetailRes;

public class FddQuerySignTask
extends FddBaseService<FddConfig>
implements QuerySignTask {
    private static final Log logger = LogFactory.getLog(FddQuerySignTask.class);
    private SignFlowService signFlowService = new SignFlowService();

    @Override
    public boolean signStatus(SignReqParam signReqParam, String contractNo) {
        DynamicObject flowSignDyn = this.signFlowService.queryOneByNo(contractNo);
        if (flowSignDyn == null) {
            return false;
        }
        DynamicObjectCollection personDynColl = flowSignDyn.getDynamicObjectCollection("entryentityperson");
        for (DynamicObject person : personDynColl) {
            if (!(signReqParam.getNaturalId() != null && signReqParam.getNaturalId() != 0L ? signReqParam.getNaturalId().longValue() == person.getLong("naturalid.id") && ("signed".equals(person.getString("personsignstatus")) || "sign_rejected".equals(person.getString("personsignstatus"))) : signReqParam.getCandidateId() != null && signReqParam.getCandidateId() != 0L && signReqParam.getCandidateId().longValue() == person.getLong("candidateid.id") && ("signed".equals(person.getString("personsignstatus")) || "sign_rejected".equals(person.getString("personsignstatus"))))) continue;
            return true;
        }
        Map res = this.getSignTaskStatus(signReqParam, contractNo);
        HashMap hashMap = (HashMap)res.get("data");
        ArrayList actors = (ArrayList)hashMap.get("actors");
        for (HashMap actor : actors) {
            String signStatus = (String)actor.get("signStatus");
            for (DynamicObject person : personDynColl) {
                person.set("personsignstatus", (Object)signStatus);
            }
            HashMap actinfo = (HashMap)actor.get("actorInfo");
            String actorType = (String)actinfo.get("actorType");
            if (!"person".equals(actorType) || !"signed".equals(signStatus) && !"sign_rejected".equals(signStatus)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean contractSignStatus(SignReqParam signReqParam, String contractNo) {
        DynamicObject flowSignDyn = this.signFlowService.queryOneByNo(contractNo);
        if (flowSignDyn == null) {
            return false;
        }
        boolean signStatus = "signed".equals(flowSignDyn.getString("signstatus"));
        if (signStatus) {
            return signStatus;
        }
        BaseRes<SignTaskDetailRes> res = this.getRes(signReqParam, contractNo);
        if (res.isSuccess()) {
            return "signed".equals(((SignTaskDetailRes)res.getData()).getSignTaskStatus()) || "sign_rejected".equals(((SignTaskDetailRes)res.getData()).getSignTaskStatus());
        }
        throw new KDBizException("get contractSignStatus error, " + res.getMsg());
    }

    private BaseRes<SignTaskDetailRes> getRes(SignReqParam signReqParam, String contractNo) {
        OpenApiClient openApiClient = (OpenApiClient)this.getConfig().initConfig();
        SignTaskClient signTaskClient = new SignTaskClient(openApiClient);
        String accessToken = FddServiceHelper.getAccessToken(openApiClient);
        SignTaskBaseReq signTaskBaseReq = new SignTaskBaseReq();
        signTaskBaseReq.setAccessToken(accessToken);
        Map<String, String> extMap = this.getExtMap(contractNo);
        String signTaskId = extMap.get("signTaskId");
        signTaskBaseReq.setSignTaskId(signTaskId);
        BaseRes res = signTaskClient.getDetail(signTaskBaseReq);
        logger.info("getRes res={}", (Object)SerializationUtils.toJsonString((Object)res));
        ResultUtil.printLog((BaseRes)res, (JsonStrategy)openApiClient.getJsonStrategy());
        return res;
    }

    private Map getSignTaskStatus(SignReqParam signReqParam, String contractNo) {
        BaseRes<SignTaskDetailRes> res = this.getRes(signReqParam, contractNo);
        if (res.isSuccess()) {
            Map result = (Map)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(res), Map.class);
            return result;
        }
        throw new KDBizException("getSignTaskStatus error, " + res.getMsg());
    }

    private Map<String, String> getExtMap(String contractNo) {
        SignFlowService signFlowService = new SignFlowService();
        DynamicObject signFlowDyn = signFlowService.queryOneByNo(contractNo);
        Map<String, String> signFlowExtMap = signFlowService.getExtMap(signFlowDyn);
        return signFlowExtMap;
    }
}

