/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada.enu;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;

public enum CallBackEventType {
    SIGN_TASK_SIGNED("sign-task-signed", CallBackEventType::getSignTaskSignedCallBackKey),
    SIGN_TASK_SIGN_FAILED("sign-task-sign-failed", CallBackEventType::getSignTaskSignFailedCallBackKey),
    SIGN_TASK_SIGN_REJECTED("sign-task-sign-rejected", CallBackEventType::getSignTaskSignRejectedCallBackKey),
    SIGN_TASK_FINISHED("sign-task-finished", CallBackEventType::getSignTaskFinishedCallBackKey),
    SEAL_VERIFY_SUCCESSED("seal-verify-successed", CallBackEventType::getSealCreateCallBackKey),
    SEAL_VERIFY_FAILED("seal-verify-failed", null),
    CORP_AUTHORIZE("corp-authorize", null),
    SEAL_AUTHORIZE_FREE_SIGN("seal-authorize-free-sign", CallBackEventType::getSealAuthorizeFreeSignCallBackKey),
    SIGN_TASK_CANCELED("sign-task-canceled", null),
    SIGN_TASK_ABOLISH("sign-task-abolish", null);

    final String x_FASC_Event;
    final Function<Map<String, String>, String> callBackKeyFunction;
    private static final Map<String, CallBackEventType> cacheMap;

    private CallBackEventType(String x_FASC_Event, Function<Map<String, String>, String> callBackKeyFunction) {
        this.x_FASC_Event = x_FASC_Event;
        this.callBackKeyFunction = callBackKeyFunction;
    }

    public String getX_FASC_Event() {
        return this.x_FASC_Event;
    }

    public Function<Map<String, String>, String> getCallBackKeyFunction() {
        return this.callBackKeyFunction;
    }

    public static CallBackEventType tranEnum(String xFASCEvent) {
        return cacheMap.get(xFASCEvent);
    }

    private static String getSealCreateCallBackKey(Map<String, String> paramMap) {
        JSONObject reqParam = CallBackUtil.getReqParamJsonObject(paramMap);
        String createSerialNo = reqParam.getString("createSerialNo");
        if (createSerialNo == null) {
            createSerialNo = "";
        }
        Long verifyId = reqParam.getLong("verifyId");
        return CallBackUtil.getSealCreateCallBackKey(verifyId, createSerialNo);
    }

    private static String getSignTaskSignedCallBackKey(Map<String, String> paramMap) {
        return CallBackEventType.getSignTaskId(paramMap);
    }

    private static String getSignTaskSignFailedCallBackKey(Map<String, String> paramMap) {
        return CallBackEventType.getSignTaskId(paramMap);
    }

    private static String getSignTaskSignRejectedCallBackKey(Map<String, String> paramMap) {
        return CallBackEventType.getSignTaskId(paramMap);
    }

    private static String getSignTaskFinishedCallBackKey(Map<String, String> paramMap) {
        return CallBackEventType.getSignTaskId(paramMap);
    }

    private static String getSignTaskId(Map<String, String> paramMap) {
        JSONObject reqParam = CallBackUtil.getReqParamJsonObject(paramMap);
        return reqParam.getString("signTaskId");
    }

    private static String getSealAuthorizeFreeSignCallBackKey(Map<String, String> paramMap) {
        JSONObject reqParam = CallBackUtil.getReqParamJsonObject(paramMap);
        return CallBackUtil.getSealAuthorizeFreeSignCallBackKey2(reqParam);
    }

    static {
        cacheMap = Arrays.stream(CallBackEventType.values()).collect(Collectors.toMap(CallBackEventType::getX_FASC_Event, item -> item));
    }
}

