/*
 * Decompiled with CFR 0.152.
 */
package kd.hr.hrcs.bussiness.service.esign.impl.fadada.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hrcs.bussiness.common.HrcsBusinessRes;
import kd.hr.hrcs.bussiness.service.esign.api.CorporateSealQuery;
import kd.hr.hrcs.bussiness.service.esign.bo.SealAuthInfo;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.FddAcrossCorporateAuth;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.mock.FddSealMock;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.DealUtil;
import kd.hr.hrcs.bussiness.service.esign.impl.fadada.util.ResponseUtil;
import kd.hr.hrcs.bussiness.service.esign.res.ResponseData;
import kd.hr.hrcs.bussiness.service.esign.util.CallBackUtil;
import kd.hr.hrcs.bussiness.service.esign.util.ESignDBServiceUtil;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseReq;
import kd.hr.hrcs.esign3rd.fadada.bean.base.BaseRes;
import kd.hr.hrcs.esign3rd.fadada.v51.client.OpenApiClient;
import kd.hr.hrcs.esign3rd.fadada.v51.client.SealClient;
import kd.hr.hrcs.esign3rd.fadada.v51.req.seal.GetSealFreeSignUrlReq;
import kd.hr.hrcs.esign3rd.fadada.v51.res.seal.GetSealFreeSignUrlRes;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.Triple;

public class SealUtil {
    private static final Log LOGGER = LogFactory.getLog(FddAcrossCorporateAuth.class);
    public static boolean IS_DEV_LOCAL_ENV = "dev".equals(System.getProperty("env"));
    public static HRBaseServiceHelper eSignCOAuthService = new HRBaseServiceHelper("hrcs_esigncoauth");

    public static ResponseData getSealFreeSignUrl(SealAuthInfo sealAuthInfo, OpenApiClient openApiClient, GetSealFreeSignUrlReq req) {
        LOGGER.info("getSealFreeSignUrl reqParam: sealAuthInfo={}", (Object)SerializationUtils.toJsonString((Object)sealAuthInfo));
        SealClient sealClient = new SealClient(openApiClient);
        try {
            ResponseData responseData = IS_DEV_LOCAL_ENV ? FddSealMock.getSealFreeSignUrl((BaseReq)req, openApiClient) : DealUtil.execute("getSealFreeSignUrl", req, () -> sealClient.getSealFreeSignUrl(req), openApiClient);
            if (responseData.isFail()) {
                return responseData;
            }
            BaseRes res = (BaseRes)responseData.getData();
            responseData.setData(((GetSealFreeSignUrlRes)res.getData()).getFreeSignUrl());
            Map<String, Long> sealIdMappingPkId = sealAuthInfo.getSealIdMappingPkId();
            if (MapUtils.isNotEmpty(sealIdMappingPkId)) {
                Set<Object> sealIds = sealAuthInfo.getSealIds();
                LOGGER.info("sealIds:{} targetSealIds:{}", sealIds, sealIdMappingPkId.keySet());
                String openCorpId = sealAuthInfo.getOpenCorpId();
                String businessId = req.getBusinessId();
                for (Object sealId : sealIds) {
                    String sealIdStr = (String)sealId;
                    String callBackKey = CallBackUtil.getSealAuthorizeFreeSignCallBackKey2(openCorpId, sealIdStr, businessId);
                    DynamicObject callBackDyn = CallBackUtil.getDynByCallBackKey(callBackKey);
                    if (!ObjectUtils.isEmpty((Object)callBackDyn)) continue;
                    String callBackKeyDetail = String.format("openCorpId=%s, sealId=%s, businessId=%s", openCorpId, sealIdStr, businessId);
                    try {
                        CallBackUtil.insert(callBackKey, callBackKeyDetail, sealIdMappingPkId.get(sealIdStr));
                    }
                    catch (Exception ex) {
                        LOGGER.warn("CallBackUtil.insert execution occurred exception", (Object)ex.getMessage(), (Object)ex);
                    }
                }
            }
            return responseData;
        }
        catch (Exception e) {
            ResponseData responseData = ResponseData.invokeFail(ResManager.loadKDString((String)"\u83b7\u53d6\u514d\u9a8c\u8bc1\u7b7eURL\u5931\u8d25\uff0c\u5177\u4f53\u9519\u8bef\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)HrcsBusinessRes.SealUtil_1.resId(), (String)"hrmp-hrcs-business", (Object[])new Object[0]));
            LOGGER.warn("invoke fdd getSealFreeSignUrl execution occurred exception", (Object)e.getMessage(), (Object)e);
            return responseData;
        }
    }

    public static Set<String> checkCOSealAuth(Long spId, Long mainCorpId, Set<String> rpcCheckSealIds, Long corporateId, String openCorpId, CorporateSealQuery corporateSealQuery, boolean isAuthPage) {
        ResponseData sealListResponseData = corporateSealQuery.getSealList(null, openCorpId);
        if (ResponseUtil.invokeFail(sealListResponseData)) {
            LOGGER.warn("CorporateSealQuery().getSealList(null) fail");
            throw new KDBizException(sealListResponseData.getMsg());
        }
        Triple<List<DynamicObject>, Set<String>, List<DynamicObject>> checkCOSealAuthTriple = corporateSealQuery.checkCOSealAuth(sealListResponseData, spId, corporateId, mainCorpId, openCorpId, rpcCheckSealIds);
        List authSealUpdDateDyns = (List)checkCOSealAuthTriple.getLeft();
        List authSealNonuseDyns = (List)checkCOSealAuthTriple.getRight();
        ArrayList authSealUpdDyns = new ArrayList(6);
        if (CollectionUtils.isNotEmpty((Collection)authSealUpdDateDyns)) {
            authSealUpdDyns.addAll(authSealUpdDateDyns);
            LOGGER.info("\u66f4\u65b0\u6388\u6743\u7684authSealUpdDateDyns\u5370\u7ae0\u4fe1\u606f\uff1a{}", authSealUpdDyns.stream().map(item -> item.get("seal.sealid")).collect(Collectors.toSet()));
        }
        if (isAuthPage && CollectionUtils.isNotEmpty((Collection)authSealNonuseDyns)) {
            authSealUpdDyns.addAll(authSealNonuseDyns);
            LOGGER.info("\u66f4\u65b0\u6388\u6743\u7684authSealNonuseDyns\u5370\u7ae0\u4fe1\u606f\uff1a{}", authSealUpdDyns.stream().map(item -> item.get("seal.sealid")).collect(Collectors.toSet()));
        }
        if (CollectionUtils.isNotEmpty(authSealUpdDyns)) {
            LOGGER.info("\u66f4\u65b0\u6388\u6743\u7684\u5370\u7ae0\u4fe1\u606f\uff1a{}", authSealUpdDyns.stream().map(item -> item.get("seal.sealid")).collect(Collectors.toSet()));
            ESignDBServiceUtil.eSignSealAuthService.update(authSealUpdDyns.toArray(new DynamicObject[0]));
        }
        return (Set)checkCOSealAuthTriple.getMiddle();
    }
}

